/*
 * Decompiled with CFR 0.152.
 */
package ice.ri.common.search.swing;

import ice.ri.common.search.SearchHelper;
import ice.ri.common.search.SearchStatusEventListener;
import ice.storm.Viewport;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.IllegalComponentStateException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public final class SearchPanel
extends JPanel
implements ActionListener,
ItemListener,
DocumentListener,
SearchStatusEventListener {
    private static final Color BACKGROUND_NOTFOUND = new Color(255, 102, 102);
    private static final Color FOREGROUND_NOTFOUND = Color.white;
    private static final int FIND_NEXT_KEY_MODIFIER = 0;
    private static final int FIND_NEXT_KEY_CODE = 114;
    private static final int FIND_PREVIOUS_KEY_MODIFIER = 1;
    private static final int FIND_PREVIOUS_KEY_CODE = 114;
    private boolean isInitialized = false;
    private JTextField searchText;
    private JButton findNextButton;
    private JButton findPrevButton;
    private JButton closeButton;
    private JToggleButton highlightButton;
    private JCheckBox caseSensitiveCB;
    private JCheckBox wholeWordCB;
    private SearchHelper searchHelper;
    private static final int KEY_STROKE_DELAY = 300;
    private Timer setSearchTextTimer;

    public SearchPanel(Viewport viewport) {
        super.setVisible(false);
        this.searchHelper = new SearchHelper(viewport);
    }

    private void buildPanel(ResourceBundle res) {
        this.setLayout(new BoxLayout(this, 0));
        this.searchText = new JTextField();
        this.searchText.setColumns(20);
        this.searchText.setHorizontalAlignment(2);
        this.searchText.setAlignmentY(0.5f);
        Dimension preferredSize = new Dimension(this.searchText.getPreferredSize().width, this.searchText.getMinimumSize().height);
        this.searchText.setMaximumSize(preferredSize);
        String toolTipText = res.getString("searchbar.search");
        this.findNextButton = new JButton(toolTipText);
        this.findNextButton.setToolTipText(toolTipText);
        this.findNextButton.setEnabled(false);
        toolTipText = res.getString("searchbar.searchPrev");
        this.findPrevButton = new JButton(toolTipText);
        this.findPrevButton.setToolTipText(toolTipText);
        this.findPrevButton.setEnabled(false);
        toolTipText = res.getString("searchbar.highlight");
        this.highlightButton = new JToggleButton(toolTipText);
        this.highlightButton.setToolTipText(toolTipText);
        this.highlightButton.setEnabled(false);
        this.closeButton = new JButton();
        this.closeButton.setIcon(new ImageIcon(this.getClass().getResource("/ice/ri/common/search/resources/close_n.gif")));
        this.closeButton.setPressedIcon(new ImageIcon(this.getClass().getResource("/ice/ri/common/search/resources/close_d.gif")));
        this.closeButton.setRolloverIcon(new ImageIcon(this.getClass().getResource("/ice/ri/common/search/resources/close_r.gif")));
        this.closeButton.setToolTipText(res.getString("searchbar.close"));
        this.closeButton.setRolloverEnabled(true);
        this.closeButton.setBorder(BorderFactory.createEmptyBorder());
        this.closeButton.setBorderPainted(false);
        this.closeButton.setContentAreaFilled(false);
        this.caseSensitiveCB = new JCheckBox(res.getString("searchbar.caseSensitive"), false);
        this.caseSensitiveCB.setEnabled(false);
        this.wholeWordCB = new JCheckBox(res.getString("searchbar.wholeWord"), false);
        this.wholeWordCB.setEnabled(false);
        Dimension space = new Dimension(4, 0);
        this.add(Box.createRigidArea(space));
        this.add(this.closeButton);
        this.add(Box.createRigidArea(space));
        this.add(new JLabel(res.getString("searchbar.whattosearch")));
        this.add(Box.createRigidArea(space));
        this.add(this.searchText);
        this.add(Box.createRigidArea(space));
        this.add(this.findNextButton);
        this.add(Box.createRigidArea(space));
        this.add(this.findPrevButton);
        this.add(Box.createRigidArea(space));
        this.add(this.highlightButton);
        this.add(Box.createRigidArea(space));
        this.add(this.caseSensitiveCB);
        this.add(Box.createRigidArea(space));
        this.add(this.wholeWordCB);
        this.add(Box.createHorizontalGlue());
        Border border = BorderFactory.createEtchedBorder();
        this.setBorder(border);
    }

    private void addListeners() {
        this.findNextButton.addActionListener(this);
        this.findPrevButton.addActionListener(this);
        this.closeButton.addActionListener(this);
        this.searchText.getDocument().addDocumentListener(this);
        this.searchText.addActionListener(this);
        this.highlightButton.addItemListener(this);
        this.caseSensitiveCB.addItemListener(this);
        this.wholeWordCB.addItemListener(this);
        this.addESCKeyListener();
        this.addFindNextKeyListener();
        this.addFindPreviousKeyListener();
        this.searchHelper.addSearchStatusEventListener(this);
    }

    private void addESCKeyListener() {
        KeyListener escKeyListener = new KeyListener(){

            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 27) {
                    SearchPanel.this.setVisible(false);
                }
            }

            public void keyReleased(KeyEvent e) {
            }

            public void keyTyped(KeyEvent e) {
            }
        };
        this.searchText.addKeyListener(escKeyListener);
        this.findNextButton.addKeyListener(escKeyListener);
        this.findPrevButton.addKeyListener(escKeyListener);
        this.highlightButton.addKeyListener(escKeyListener);
        this.caseSensitiveCB.addKeyListener(escKeyListener);
        this.wholeWordCB.addKeyListener(escKeyListener);
    }

    private void addFindNextKeyListener() {
        String FIND_NEXT_ACTION_KEY = "FIND_NEXT_ACTION_KEY";
        KeyStroke findNextKeyStroke = KeyStroke.getKeyStroke(114, 0, false);
        InputMap inputMap = this.getRootPane().getInputMap(1);
        inputMap.put(findNextKeyStroke, FIND_NEXT_ACTION_KEY);
        AbstractAction findNextAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                if (SearchPanel.this.findNextButton.isEnabled() && SearchPanel.this.searchText.getText().length() != 0) {
                    SearchPanel.this.searchHelper.findNext();
                }
            }
        };
        this.getRootPane().getActionMap().put(FIND_NEXT_ACTION_KEY, findNextAction);
    }

    private void addFindPreviousKeyListener() {
        String FIND_PREVIOUS_ACTION_KEY = "FIND_PREVIOUS_ACTION_KEY";
        KeyStroke findPreviousKeyStroke = KeyStroke.getKeyStroke(114, 1, false);
        InputMap inputMap = this.getRootPane().getInputMap(1);
        inputMap.put(findPreviousKeyStroke, FIND_PREVIOUS_ACTION_KEY);
        AbstractAction findPreviousAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                if (SearchPanel.this.findPrevButton.isEnabled() && SearchPanel.this.searchText.getText().length() != 0) {
                    SearchPanel.this.searchHelper.findPrevious();
                }
            }
        };
        this.getRootPane().getActionMap().put(FIND_PREVIOUS_ACTION_KEY, findPreviousAction);
    }

    public void dispose() {
        this.searchHelper.dispose();
    }

    public void actionPerformed(ActionEvent ev) {
        Object source = ev.getSource();
        if (source == this.findNextButton) {
            this.searchHelper.findNext();
        } else if (source == this.findPrevButton) {
            this.searchHelper.findPrevious();
        } else if (source == this.closeButton) {
            this.setVisible(false);
        } else if (source == this.searchText) {
            this.setSearchText(true);
        }
    }

    public void itemStateChanged(ItemEvent ev) {
        Object source = ev.getSource();
        if (source == this.caseSensitiveCB) {
            this.searchHelper.setCaseSensitiveEnabled(this.caseSensitiveCB.isSelected());
        } else if (source == this.wholeWordCB) {
            this.searchHelper.setWordSearchEnabled(this.wholeWordCB.isSelected());
        } else if (source == this.highlightButton) {
            this.searchHelper.setHighlighted(this.highlightButton.isSelected());
        }
    }

    public void setVisible(boolean isVisible) {
        if (isVisible && !this.isVisible()) {
            this.init();
        }
        super.setVisible(isVisible);
        if (isVisible) {
            this.searchText.requestFocus();
        }
    }

    private void init() {
        if (!this.isInitialized) {
            this.isInitialized = true;
            Locale locale = null;
            try {
                locale = this.getLocale();
            }
            catch (IllegalComponentStateException e) {
                // empty catch block
            }
            ResourceBundle res = null;
            res = locale == null ? ResourceBundle.getBundle("ice.ri.common.search.resources.MessageBundleSearch") : ResourceBundle.getBundle("ice.ri.common.search.resources.MessageBundleSearch", locale);
            this.buildPanel(res);
            this.addListeners();
            this.searchHelper.init();
            ActionListener setTextAction = new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    SearchPanel.this.searchHelper.setSearchText(SearchPanel.this.searchText.getText());
                }
            };
            this.setSearchTextTimer = new Timer(300, setTextAction);
            this.setSearchTextTimer.setRepeats(false);
        }
    }

    public void addSearchStatusEventListener(SearchStatusEventListener l) {
        this.searchHelper.addSearchStatusEventListener(l);
    }

    public void removeSearchStatusEventListener(SearchStatusEventListener l) {
        this.searchHelper.removeSearchStatusEventListener(l);
    }

    public void setFindNextEnabled(boolean b) {
        this.findNextButton.setEnabled(b);
    }

    public void setFindPreviousEnabled(boolean b) {
        this.findPrevButton.setEnabled(b);
    }

    public void setSearchEnabled(final boolean b) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.enableSearch(b);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    SearchPanel.this.enableSearch(b);
                }
            });
        }
    }

    private void enableSearch(boolean b) {
        this.searchText.setEnabled(b);
        if (!b || this.searchText.getText().length() != 0) {
            this.findNextButton.setEnabled(b);
            this.findPrevButton.setEnabled(b);
            this.highlightButton.setEnabled(b);
            this.caseSensitiveCB.setEnabled(b);
            this.wholeWordCB.setEnabled(b);
        }
    }

    public void setSearchStatusMessage(int status, int nMatches) {
        if (status == SearchHelper.NO_MATCH_FOUND) {
            this.setWarningColor();
        } else if (this.searchText.getBackground().equals(BACKGROUND_NOTFOUND)) {
            this.clearWarningColor();
        }
    }

    private void clearWarningColor() {
        Color defaultBGround = UIManager.getColor("TextField.background");
        Color defaultFGround = UIManager.getColor("TextField.foreground");
        if (defaultBGround == null) {
            defaultBGround = Color.white;
        }
        if (defaultFGround == null) {
            defaultFGround = Color.black;
        }
        this.searchText.setBackground(defaultBGround);
        this.searchText.setForeground(defaultFGround);
    }

    private void setWarningColor() {
        this.searchText.setBackground(BACKGROUND_NOTFOUND);
        this.searchText.setForeground(FOREGROUND_NOTFOUND);
    }

    public void reset(int signal) {
        if (signal == SearchHelper.RESET_HIGHLIGHT && this.highlightButton.isSelected()) {
            this.highlightButton.setSelected(false);
        }
        if (signal == SearchHelper.RESET_ALL) {
            if (this.highlightButton.isSelected()) {
                this.highlightButton.setSelected(false);
            }
            if (this.caseSensitiveCB.isSelected()) {
                this.caseSensitiveCB.setSelected(false);
            }
            if (this.wholeWordCB.isSelected()) {
                this.wholeWordCB.setSelected(false);
            }
        }
    }

    public void changedUpdate(DocumentEvent e) {
    }

    public void insertUpdate(DocumentEvent e) {
        if (this.searchHelper.isSearchReady()) {
            this.findNextButton.setEnabled(true);
            this.findPrevButton.setEnabled(true);
            this.highlightButton.setEnabled(true);
            this.caseSensitiveCB.setEnabled(true);
            this.wholeWordCB.setEnabled(true);
        }
        this.setSearchText(false);
    }

    public void removeUpdate(DocumentEvent e) {
        String text = this.searchText.getText();
        if (text.length() == 0) {
            if (this.searchText.getBackground().equals(BACKGROUND_NOTFOUND)) {
                this.clearWarningColor();
            }
            this.findNextButton.setEnabled(false);
            this.findPrevButton.setEnabled(false);
            this.highlightButton.setEnabled(false);
            this.caseSensitiveCB.setEnabled(false);
            this.wholeWordCB.setEnabled(false);
        }
        this.setSearchText(false);
    }

    private void setSearchText(boolean instantAction) {
        if (instantAction) {
            this.setSearchTextTimer.setInitialDelay(0);
        }
        if (this.setSearchTextTimer.isRunning()) {
            this.setSearchTextTimer.restart();
        } else {
            this.setSearchTextTimer.start();
        }
        if (instantAction) {
            this.setSearchTextTimer.setInitialDelay(300);
        }
    }
}

