/*
 * Decompiled with CFR 0.152.
 */
package ice.ri.common.print.swing;

import ice.pilots.html4.DDocument;
import ice.pilots.text.ThePilot;
import ice.ri.common.dialog.swing.AbstractJSettingsDialog;
import ice.ri.common.dialog.swing.AbstractJSettingsDialogPanel;
import ice.ri.common.dialog.swing.DecimalJTextField;
import ice.ri.common.dialog.swing.JDefaultSettingsDialog;
import ice.ri.common.dialog.swing.JTabbedSettingsDialog;
import ice.ri.common.dialog.swing.JTreeSettingsDialog;
import ice.ri.common.dialog.swing.WholeNumberJTextField;
import ice.ri.common.print.PrintUtilities;
import ice.storm.Pilot;
import ice.storm.Viewport;
import ice.storm.print.AbstractPageDecoration;
import ice.storm.print.PageNumberPageDecoration;
import ice.storm.print.StormPageFormat;
import ice.storm.print.StringPageDecoration;
import ice.util.unit.InchUnit;
import ice.util.unit.MmUnit;
import ice.util.unit.PointUnit;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class PageSetupDialog {
    public static final int TABBED_LAYOUT = 1;
    public static final int BUTTON_LAYOUT = 2;
    public static final int TREE_LAYOUT = 3;
    private static StormPageFormat stormPageFormat;
    private static Locale locale;
    private JPanel marginPanel;
    private AbstractJSettingsDialog settingsDialog;
    private DecimalJTextField leftMarginTextField;
    private DecimalJTextField topMarginTextField;
    private DecimalJTextField rightMarginTextField;
    private DecimalJTextField bottomMarginTextField;
    private static ResourceBundle messages;
    private static String[][] units;
    public static final String DECORATION_BLANK = "blank";
    public static final String DECORATION_TITLE = "title";
    public static final String DECORATION_URL = "url";
    public static final String DECORATION_DATE_TIME = "dateTime";
    public static final String DECORATION_PAGE_NUMBER = "pageNumber";
    private static String[][] decorationList;
    private int defaultUnit = 0;
    private Vector viewports;
    private Viewport mainViewport;
    private Viewport currentViewPort;

    public PageSetupDialog(JFrame parent, Viewport viewport, StormPageFormat stormPageFormat) {
        this(parent, viewport, stormPageFormat, 1);
    }

    public PageSetupDialog(JFrame parent, Viewport viewport, StormPageFormat stormPageFormat, int view) {
        messages = parent != null ? ResourceBundle.getBundle("ice.ri.common.print.resources.MessageBundlePrint", parent.getLocale()) : ResourceBundle.getBundle("ice.ri.common.print.resources.MessageBundlePrint");
        String[][] units = new String[][]{{"points", messages.getString("pageSetup.options.units.points")}, {"mm", messages.getString("pageSetup.options.units.milimeters")}, {"inch", messages.getString("pageSetup.options.units.inches")}};
        PageSetupDialog.units = units;
        String[][] decorationList = new String[][]{{DECORATION_BLANK, messages.getString("pageSetup.decoration.blank")}, {DECORATION_TITLE, messages.getString("pageSetup.decoration.title")}, {DECORATION_URL, messages.getString("pageSetup.decoration.url")}, {DECORATION_DATE_TIME, messages.getString("pageSetup.decoration.dateTime")}, {DECORATION_PAGE_NUMBER, messages.getString("pageSetup.decoration.pageNumber")}};
        PageSetupDialog.decorationList = decorationList;
        PageSetupDialog.stormPageFormat = (StormPageFormat)stormPageFormat.clone();
        this.mainViewport = viewport;
        this.viewports = new Vector(4, 2);
        this.mainViewport.getViewAndAllChildren(this.viewports);
        this.currentViewPort = this.mainViewport;
        locale = parent.getLocale();
        this.settingsDialog = view == 2 ? new JDefaultSettingsDialog(parent, messages.getString("pagesetup.title"), 450, 450) : (view == 3 ? new JTreeSettingsDialog(parent, messages.getString("pagesetup.title"), 500, 450) : new JTabbedSettingsDialog(parent, messages.getString("pagesetup.title"), 450, 450));
        this.settingsDialog.setButtonDisplay(2);
        this.settingsDialog.add(new PageSettingsPanel(this.settingsDialog));
        this.settingsDialog.add(new AdvancedPageSettingsPanel(this.settingsDialog));
    }

    public StormPageFormat showDialog() {
        this.settingsDialog.setVisible(true);
        return stormPageFormat;
    }

    private static String getDocumentTitle(Viewport viewport) {
        Pilot tmp = viewport.getPilot();
        if (tmp instanceof ice.pilots.html4.ThePilot) {
            ice.pilots.html4.ThePilot pilot = (ice.pilots.html4.ThePilot)tmp;
            DDocument doc = pilot.getDDocument();
            return doc.getTitle();
        }
        if (tmp instanceof ThePilot) {
            return messages.getString("pageSetup.decoration.textPilot");
        }
        if (tmp instanceof ice.pilots.image.ThePilot) {
            return messages.getString("pageSetup.decoration.imagePilot");
        }
        return "";
    }

    public static String getDecorationTitle(String name) {
        String decorationTitle = null;
        for (int i = 0; i < decorationList.length; ++i) {
            if (!name.equals(decorationList[i][0])) continue;
            decorationTitle = decorationList[i][1];
        }
        return decorationTitle;
    }

    public static void refreshPageDecoration(Viewport viewport, StormPageFormat stormPageFormat) {
        Vector decorations = stormPageFormat.getDecoration();
        for (int j = 0; j < decorations.size(); ++j) {
            Object tmp = decorations.elementAt(j);
            if (!(tmp instanceof AbstractPageDecoration)) continue;
            AbstractPageDecoration decoration = (AbstractPageDecoration)decorations.elementAt(j);
            if (decoration.getName() == DECORATION_TITLE) {
                decorations.set(j, new StringPageDecoration(DECORATION_TITLE, PageSetupDialog.getDocumentTitle(viewport), decoration.getVerticalAlignment(), decoration.getHorizontalAlignment()));
                continue;
            }
            if (decoration.getName() == DECORATION_URL) {
                decorations.set(j, new StringPageDecoration(DECORATION_URL, viewport.getLocation(), decoration.getVerticalAlignment(), decoration.getHorizontalAlignment()));
                continue;
            }
            if (decoration.getName() != DECORATION_DATE_TIME) continue;
            SimpleDateFormat formatter = new SimpleDateFormat("EEE, d MMM yyyy hh:mm:ss a");
            String s = formatter.format((Object)new Date());
            decorations.set(j, new StringPageDecoration(DECORATION_DATE_TIME, s, decoration.getVerticalAlignment(), decoration.getHorizontalAlignment()));
        }
    }

    private void updateMarginUnits() {
        if (this.defaultUnit == 0) {
            PointUnit unit = new PointUnit();
            unit.setPoints(stormPageFormat.getMargin(2));
            this.leftMarginTextField.setText((double)Math.round(unit.getUnits() * 100.0) / 100.0 + "");
            unit.setPoints(stormPageFormat.getMargin(1));
            this.topMarginTextField.setText((double)Math.round(unit.getUnits() * 100.0) / 100.0 + "");
            unit.setPoints(stormPageFormat.getMargin(4));
            this.rightMarginTextField.setText((double)Math.round(unit.getUnits() * 100.0) / 100.0 + "");
            unit.setPoints(stormPageFormat.getMargin(3));
            this.bottomMarginTextField.setText((double)Math.round(unit.getUnits() * 100.0) / 100.0 + "");
        } else if (this.defaultUnit == 1) {
            MmUnit unit = new MmUnit();
            unit.setPoints(stormPageFormat.getMargin(2));
            this.leftMarginTextField.setText((double)Math.round(unit.getUnits() * 100.0) / 100.0 + "");
            unit.setPoints(stormPageFormat.getMargin(1));
            this.topMarginTextField.setText((double)Math.round(unit.getUnits() * 100.0) / 100.0 + "");
            unit.setPoints(stormPageFormat.getMargin(4));
            this.rightMarginTextField.setText((double)Math.round(unit.getUnits() * 100.0) / 100.0 + "");
            unit.setPoints(stormPageFormat.getMargin(3));
            this.bottomMarginTextField.setText((double)Math.round(unit.getUnits() * 100.0) / 100.0 + "");
        } else if (this.defaultUnit == 2) {
            InchUnit unit = new InchUnit();
            unit.setPoints(stormPageFormat.getMargin(2));
            this.leftMarginTextField.setText((double)Math.round(unit.getUnits() * 100.0) / 100.0 + "");
            unit.setPoints(stormPageFormat.getMargin(1));
            this.topMarginTextField.setText((double)Math.round(unit.getUnits() * 100.0) / 100.0 + "");
            unit.setPoints(stormPageFormat.getMargin(4));
            this.rightMarginTextField.setText((double)Math.round(unit.getUnits() * 100.0) / 100.0 + "");
            unit.setPoints(stormPageFormat.getMargin(3));
            this.bottomMarginTextField.setText((double)Math.round(unit.getUnits() * 100.0) / 100.0 + "");
        }
    }

    static {
        messages = ResourceBundle.getBundle("ice.ri.common.print.resources.MessageBundlePrint");
        units = null;
        decorationList = new String[][]{{DECORATION_BLANK, messages.getString("pageSetup.decoration.blank")}, {DECORATION_TITLE, messages.getString("pageSetup.decoration.title")}, {DECORATION_URL, messages.getString("pageSetup.decoration.url")}, {DECORATION_DATE_TIME, messages.getString("pageSetup.decoration.dateTime")}, {DECORATION_PAGE_NUMBER, messages.getString("pageSetup.decoration.pageNumber")}};
    }

    public class AdvancedPageSettingsPanel
    extends AbstractJSettingsDialogPanel {
        private GridBagConstraints constraints;
        private JCheckBox printBackgroundCheckBox;
        private JComboBox unitsComboBox;
        private JCheckBox smartPagingOnCheckBox;
        private JRadioButton seperateFramesRadioButton;
        private JRadioButton selectedFramesRadioButton;

        public AdvancedPageSettingsPanel(AbstractJSettingsDialog controlPanel) {
            super(messages.getString("pageSetup.advanced"), controlPanel);
            this.setGui();
        }

        private void setGui() {
            GridBagLayout layout = new GridBagLayout();
            this.constraints = new GridBagConstraints();
            this.constraints.fill = 1;
            this.constraints.weightx = 1.0;
            this.constraints.insets = new Insets(2, 2, 2, 2);
            this.setLayout(layout);
            this.printBackgroundCheckBox = new JCheckBox(messages.getString("pageSetup.options.printBackground"));
            this.printBackgroundCheckBox.setMaximumSize(this.printBackgroundCheckBox.getPreferredSize());
            this.unitsComboBox = new JComboBox();
            for (int i = 0; i < units.length; ++i) {
                this.unitsComboBox.addItem(units[i][1]);
            }
            this.unitsComboBox.addActionListener(this);
            this.unitsComboBox.setMaximumSize(this.unitsComboBox.getPreferredSize());
            JLabel unitsLabel = new JLabel(" " + messages.getString("pageSetup.options.units") + " ");
            unitsLabel.setMaximumSize(unitsLabel.getPreferredSize());
            JPanel optionsPanel = new JPanel(new BorderLayout());
            optionsPanel.setAlignmentX(0.0f);
            optionsPanel.setBorder(new TitledBorder(messages.getString("pageSetup.options")));
            Box hBox1 = Box.createHorizontalBox();
            hBox1.add(this.printBackgroundCheckBox);
            Box hBox2 = Box.createHorizontalBox();
            hBox2.add(unitsLabel);
            hBox2.add(Box.createHorizontalStrut(10));
            hBox2.add(this.unitsComboBox);
            hBox2.add(Box.createHorizontalGlue());
            Box vBox = Box.createVerticalBox();
            vBox.add(hBox1);
            vBox.add(hBox2);
            optionsPanel.add((Component)vBox, "West");
            this.addGB(optionsPanel, 0, 0, 1, 1);
            this.smartPagingOnCheckBox = new JCheckBox(messages.getString("pageSetup.smartbreaks"));
            JPanel pagingPanel = new JPanel(new GridLayout(1, 1, 0, 0));
            pagingPanel.setBorder(new TitledBorder(messages.getString("pageSetup.htmlPaging")));
            pagingPanel.add(this.smartPagingOnCheckBox);
            this.addGB(pagingPanel, 0, 2, 1, 1);
            this.seperateFramesRadioButton = new JRadioButton(messages.getString("pageSetup.frames.allFrames"));
            this.seperateFramesRadioButton.setMaximumSize(this.seperateFramesRadioButton.getPreferredSize());
            this.selectedFramesRadioButton = new JRadioButton(messages.getString("pageSetup.frames.asLaidOut"));
            this.selectedFramesRadioButton.setMaximumSize(this.selectedFramesRadioButton.getPreferredSize());
            ButtonGroup group3 = new ButtonGroup();
            group3.add(this.seperateFramesRadioButton);
            group3.add(this.selectedFramesRadioButton);
            JPanel framesPanel = new JPanel(new BorderLayout());
            framesPanel.setAlignmentX(0.0f);
            framesPanel.setBorder(new TitledBorder(" " + messages.getString("pageSetup.frames") + " "));
            Box hBox3 = Box.createHorizontalBox();
            hBox3.add(this.seperateFramesRadioButton);
            hBox3.add(Box.createHorizontalGlue());
            Box hBox4 = Box.createHorizontalBox();
            hBox4.add(this.selectedFramesRadioButton);
            hBox4.add(Box.createHorizontalGlue());
            Box vBox1 = Box.createVerticalBox();
            vBox1.add(hBox4);
            vBox1.add(hBox3);
            framesPanel.add((Component)vBox1, "West");
            this.addGB(framesPanel, 0, 3, 1, 1);
            this.constraints.weighty = 1.0;
            this.addGB(new JPanel(), 0, 4, 1, 1);
            this.getPreferenceElements();
            this.printBackgroundCheckBox.addActionListener(this);
            this.unitsComboBox.addActionListener(this);
            this.smartPagingOnCheckBox.addActionListener(this);
            this.seperateFramesRadioButton.addActionListener(this);
            this.selectedFramesRadioButton.addActionListener(this);
        }

        public void getPreferenceElements() {
            if (stormPageFormat.isBackgroundVisible()) {
                this.printBackgroundCheckBox.setSelected(true);
            } else {
                this.printBackgroundCheckBox.setSelected(false);
            }
            this.unitsComboBox.setSelectedIndex(stormPageFormat.getPageSetupDialogUnit());
            if (stormPageFormat.isHtmlSmartPagingEnabled()) {
                this.smartPagingOnCheckBox.setSelected(true);
            } else {
                this.smartPagingOnCheckBox.setSelected(false);
            }
            if (PrintUtilities.isFrameset(PageSetupDialog.this.mainViewport)) {
                this.seperateFramesRadioButton.setEnabled(true);
                this.selectedFramesRadioButton.setEnabled(true);
            } else {
                this.seperateFramesRadioButton.setEnabled(false);
                this.selectedFramesRadioButton.setEnabled(false);
            }
            if (stormPageFormat.getFramePrintFormat() == 3) {
                this.selectedFramesRadioButton.setSelected(true);
            } else if (stormPageFormat.getFramePrintFormat() == 1) {
                this.seperateFramesRadioButton.setSelected(true);
            }
        }

        public synchronized void setPreferenceElements() {
            if (this.printBackgroundCheckBox.isSelected()) {
                stormPageFormat.setBackgroundVisible(true);
            } else {
                stormPageFormat.setBackgroundVisible(false);
            }
            if (this.selectedFramesRadioButton.isSelected()) {
                stormPageFormat.setFramePrintFormat(3);
            } else {
                stormPageFormat.setFramePrintFormat(1);
            }
            stormPageFormat.setPageSetupDialogUnit(this.unitsComboBox.getSelectedIndex());
            if (this.smartPagingOnCheckBox.isSelected()) {
                stormPageFormat.setHtmlSmartPaging(true);
            } else {
                stormPageFormat.setHtmlSmartPaging(false);
            }
        }

        public boolean save() {
            this.setPreferenceElements();
            this.setHasChanged(false);
            return false;
        }

        public boolean cancel() {
            this.getPreferenceElements();
            return false;
        }

        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == this.unitsComboBox) {
                int index = this.unitsComboBox.getSelectedIndex();
                PageSetupDialog.this.defaultUnit = index;
                PageSetupDialog.this.updateMarginUnits();
                PageSetupDialog.this.marginPanel.setBorder(new TitledBorder(messages.getString("pageSetup.margins") + " (" + units[PageSetupDialog.this.defaultUnit][1] + ")"));
                this.setHasChanged(true);
            } else {
                this.setHasChanged(true);
            }
        }

        private void addGB(Component component, int x, int y, int rowSpan, int colSpan) {
            this.constraints.gridx = x;
            this.constraints.gridy = y;
            this.constraints.gridwidth = rowSpan;
            this.constraints.gridheight = colSpan;
            this.add(component, this.constraints);
        }
    }

    public class PageSettingsPanel
    extends AbstractJSettingsDialogPanel
    implements DocumentListener {
        private GridBagConstraints constraints;
        private JComboBox paperSizesComboBox;
        private JCheckBox shrinkToFitCheckBox;
        private WholeNumberJTextField scaleFactorTextField;
        private JRadioButton portraitRadioButton;
        private JRadioButton landscapeRadioButton;
        private JComboBox leftHeaderComboBox;
        private JComboBox middleHeaderComboBox;
        private JComboBox rightHeaderComboBox;
        private JComboBox leftFooterComboBox;
        private JComboBox middleFooterComboBox;
        private JComboBox rightFooterComboBox;
        private String[] fontList;
        private JComboBox fontComboBox;
        private String[] fontSizeList;
        private JComboBox fontSizeComboBox;

        public PageSettingsPanel(AbstractJSettingsDialog controlPanel) {
            super(messages.getString("pageSetup.settings"), controlPanel);
            this.fontSizeList = new String[]{"4", "6", "8", "10", "12", "14"};
            this.setGui();
        }

        private void setGui() {
            GridBagLayout layout = new GridBagLayout();
            this.constraints = new GridBagConstraints();
            this.constraints.fill = 1;
            this.constraints.weightx = 1.0;
            this.constraints.insets = new Insets(2, 2, 2, 2);
            this.setLayout(layout);
            JPanel paperPanel = new JPanel(new BorderLayout());
            JLabel paperLabel = new JLabel("  " + messages.getString("pageSetup.paperSize") + " ");
            paperLabel.setMaximumSize(paperLabel.getPreferredSize());
            this.paperSizesComboBox = new JComboBox<String>(StormPageFormat.PAPER_DISPLAY_NAMES);
            this.paperSizesComboBox.setMaximumSize(this.paperSizesComboBox.getPreferredSize());
            Box paperHorizontalBox = Box.createHorizontalBox();
            paperHorizontalBox.add(paperLabel);
            paperHorizontalBox.add(this.paperSizesComboBox);
            Box paperVerticalBox = Box.createVerticalBox();
            paperVerticalBox.add(paperHorizontalBox);
            paperPanel.add((Component)paperVerticalBox, "West");
            this.addGB(paperPanel, 0, 0, 3, 1);
            this.portraitRadioButton = new JRadioButton(messages.getString("pageSetup.orientation.portrait"));
            this.portraitRadioButton.setMaximumSize(this.portraitRadioButton.getPreferredSize());
            this.landscapeRadioButton = new JRadioButton(messages.getString("pageSetup.orientation.landscape"));
            this.landscapeRadioButton.setMaximumSize(this.landscapeRadioButton.getPreferredSize());
            ButtonGroup orientationGroup = new ButtonGroup();
            orientationGroup.add(this.portraitRadioButton);
            orientationGroup.add(this.landscapeRadioButton);
            JPanel orientationPanel = new JPanel(new GridLayout(2, 1, 0, 0));
            orientationPanel.setBorder(new TitledBorder(messages.getString("pageSetup.orientation")));
            orientationPanel.add(this.portraitRadioButton);
            orientationPanel.add(this.landscapeRadioButton);
            this.addGB(orientationPanel, 0, 1, 1, 1);
            this.shrinkToFitCheckBox = new JCheckBox(messages.getString("pageSetup.scale.shrinkToFit"));
            this.shrinkToFitCheckBox.setMaximumSize(this.shrinkToFitCheckBox.getPreferredSize());
            this.scaleFactorTextField = new WholeNumberJTextField(100, 3, 3);
            this.scaleFactorTextField.setMaximumSize(new Dimension(8, this.scaleFactorTextField.getPreferredSize().height));
            JLabel scaleLabel = new JLabel("  " + messages.getString("pageSetup.scale.scale") + " ");
            JLabel percentLabel = new JLabel(" " + messages.getString("pageSetup.scale.percent"));
            JPanel scalePanel = new JPanel(new BorderLayout());
            Box scaleHorizontalBox = Box.createHorizontalBox();
            scaleHorizontalBox.add(scaleLabel);
            scaleHorizontalBox.add(this.scaleFactorTextField);
            scaleHorizontalBox.add(percentLabel);
            scaleHorizontalBox.add(Box.createHorizontalGlue());
            Box scaleHorizontalBox2 = Box.createHorizontalBox();
            scaleHorizontalBox2.add(this.shrinkToFitCheckBox);
            scaleHorizontalBox2.add(Box.createHorizontalGlue());
            Box scaleVerticalBox = Box.createVerticalBox();
            scaleVerticalBox.add(scaleHorizontalBox);
            scaleVerticalBox.add(scaleHorizontalBox2);
            scalePanel.add((Component)scaleVerticalBox, "West");
            scalePanel.setBorder(new TitledBorder(messages.getString("pageSetup.scale")));
            this.addGB(scalePanel, 2, 1, 1, 1);
            PageSetupDialog.this.marginPanel = new JPanel();
            PageSetupDialog.this.marginPanel.setBorder(new TitledBorder(messages.getString("pageSetup.margins") + " (" + units[PageSetupDialog.this.defaultUnit][1] + ")"));
            PageSetupDialog.this.leftMarginTextField = new DecimalJTextField(0.0, 6, 6);
            PageSetupDialog.this.leftMarginTextField.setMaximumSize(PageSetupDialog.this.leftMarginTextField.getPreferredSize());
            PageSetupDialog.this.topMarginTextField = new DecimalJTextField(0.0, 6, 6);
            PageSetupDialog.this.topMarginTextField.setMaximumSize(PageSetupDialog.this.topMarginTextField.getPreferredSize());
            PageSetupDialog.this.rightMarginTextField = new DecimalJTextField(0.0, 6, 6);
            PageSetupDialog.this.rightMarginTextField.setMaximumSize(PageSetupDialog.this.rightMarginTextField.getPreferredSize());
            PageSetupDialog.this.bottomMarginTextField = new DecimalJTextField(0.0, 6, 6);
            PageSetupDialog.this.bottomMarginTextField.setMaximumSize(PageSetupDialog.this.bottomMarginTextField.getPreferredSize());
            JLabel topMarginLabel = new JLabel(messages.getString("pageSetup.margins.top") + "  ");
            topMarginLabel.setMaximumSize(topMarginLabel.getPreferredSize());
            JLabel leftMarginLabel = new JLabel(messages.getString("pageSetup.margins.left") + "  ");
            leftMarginLabel.setMaximumSize(leftMarginLabel.getPreferredSize());
            JLabel rightMarginLabel = new JLabel(messages.getString("pageSetup.margins.right") + "  ");
            rightMarginLabel.setMaximumSize(rightMarginLabel.getPreferredSize());
            JLabel bottomMarginLabel = new JLabel(messages.getString("pageSetup.margins.bottom") + "  ", 2);
            bottomMarginLabel.setMaximumSize(bottomMarginLabel.getPreferredSize());
            int spacer = 5;
            Box marginVeticalBox1 = Box.createVerticalBox();
            marginVeticalBox1.add(topMarginLabel);
            marginVeticalBox1.add(Box.createVerticalStrut(spacer));
            marginVeticalBox1.add(leftMarginLabel);
            Box marginVeticalBox3 = Box.createVerticalBox();
            marginVeticalBox3.add(PageSetupDialog.this.topMarginTextField);
            marginVeticalBox3.add(Box.createVerticalStrut(spacer));
            marginVeticalBox3.add(PageSetupDialog.this.leftMarginTextField);
            Box marginVeticalBox2 = Box.createVerticalBox();
            marginVeticalBox2.add(bottomMarginLabel);
            marginVeticalBox2.add(Box.createVerticalStrut(spacer));
            marginVeticalBox2.add(rightMarginLabel);
            Box marginVeticalBox4 = Box.createVerticalBox();
            marginVeticalBox4.add(PageSetupDialog.this.bottomMarginTextField);
            marginVeticalBox4.add(Box.createVerticalStrut(spacer));
            marginVeticalBox4.add(PageSetupDialog.this.rightMarginTextField);
            Box marginHorizontalBox = Box.createHorizontalBox();
            marginHorizontalBox.add(marginVeticalBox1);
            marginHorizontalBox.add(marginVeticalBox3);
            marginHorizontalBox.add(Box.createHorizontalStrut(120));
            marginHorizontalBox.add(marginVeticalBox2);
            marginHorizontalBox.add(marginVeticalBox4);
            PageSetupDialog.this.marginPanel.add((Component)marginHorizontalBox, "Center");
            this.addGB(PageSetupDialog.this.marginPanel, 0, 2, 3, 1);
            JPanel decorationPanel = new JPanel(new BorderLayout());
            decorationPanel.setBorder(new TitledBorder(messages.getString("pageSetup.headerFooters")));
            String[] pageDecorations = new String[5];
            for (int i = 0; i < decorationList.length; ++i) {
                pageDecorations[i] = decorationList[i][1];
            }
            this.leftHeaderComboBox = new JComboBox<String>(pageDecorations);
            this.leftHeaderComboBox.setMaximumSize(this.leftHeaderComboBox.getPreferredSize());
            this.middleHeaderComboBox = new JComboBox<String>(pageDecorations);
            this.middleHeaderComboBox.setMaximumSize(this.middleHeaderComboBox.getPreferredSize());
            this.rightHeaderComboBox = new JComboBox<String>(pageDecorations);
            this.rightHeaderComboBox.setMaximumSize(this.rightHeaderComboBox.getPreferredSize());
            this.leftFooterComboBox = new JComboBox<String>(pageDecorations);
            this.leftFooterComboBox.setMaximumSize(this.leftFooterComboBox.getPreferredSize());
            this.middleFooterComboBox = new JComboBox<String>(pageDecorations);
            this.middleFooterComboBox.setMaximumSize(this.middleFooterComboBox.getPreferredSize());
            this.rightFooterComboBox = new JComboBox<String>(pageDecorations);
            this.rightFooterComboBox.setMaximumSize(this.rightFooterComboBox.getPreferredSize());
            this.fontList = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
            this.fontComboBox = new JComboBox<String>(this.fontList);
            this.fontComboBox.setMaximumSize(this.fontComboBox.getPreferredSize());
            this.fontSizeComboBox = new JComboBox<String>(this.fontSizeList);
            this.fontSizeComboBox.setMaximumSize(this.fontSizeComboBox.getPreferredSize());
            JLabel leftLabel = new JLabel(messages.getString("pageSetup.headerFooters.left") + " ");
            leftLabel.setMaximumSize(leftLabel.getPreferredSize());
            JLabel centerLabel = new JLabel(messages.getString("pageSetup.headerFooters.center") + " ");
            centerLabel.setMaximumSize(centerLabel.getPreferredSize());
            JLabel rightLabel = new JLabel(messages.getString("pageSetup.headerFooters.right") + " ");
            rightLabel.setMaximumSize(rightLabel.getPreferredSize());
            JLabel fontLabel = new JLabel("   " + messages.getString("pageSetup.headerFooters.font"));
            fontLabel.setMaximumSize(fontLabel.getPreferredSize());
            spacer = 1;
            Box decoartionVeticalBox1 = Box.createVerticalBox();
            decoartionVeticalBox1.add(this.leftHeaderComboBox);
            decoartionVeticalBox1.add(Box.createVerticalStrut(spacer));
            decoartionVeticalBox1.add(leftLabel);
            decoartionVeticalBox1.add(Box.createVerticalStrut(spacer));
            decoartionVeticalBox1.add(this.leftFooterComboBox);
            Box decoartionVeticalBox2 = Box.createVerticalBox();
            decoartionVeticalBox2.add(this.middleHeaderComboBox);
            decoartionVeticalBox2.add(Box.createVerticalStrut(spacer));
            decoartionVeticalBox2.add(centerLabel);
            decoartionVeticalBox2.add(Box.createVerticalStrut(spacer));
            decoartionVeticalBox2.add(this.middleFooterComboBox);
            Box decoartionVeticalBox3 = Box.createVerticalBox();
            decoartionVeticalBox3.add(this.rightHeaderComboBox);
            decoartionVeticalBox3.add(Box.createVerticalStrut(spacer));
            decoartionVeticalBox3.add(rightLabel);
            decoartionVeticalBox3.add(Box.createVerticalStrut(spacer));
            decoartionVeticalBox3.add(this.rightFooterComboBox);
            Box decorationHorizontalBox = Box.createHorizontalBox();
            decorationHorizontalBox.add(decoartionVeticalBox1);
            decorationHorizontalBox.add(Box.createHorizontalStrut(20));
            decorationHorizontalBox.add(decoartionVeticalBox2);
            decorationHorizontalBox.add(Box.createHorizontalStrut(20));
            decorationHorizontalBox.add(decoartionVeticalBox3);
            Box fontHorizontalBox = Box.createHorizontalBox();
            fontHorizontalBox.add(fontLabel);
            fontHorizontalBox.add(Box.createHorizontalStrut(3));
            fontHorizontalBox.add(this.fontComboBox);
            fontHorizontalBox.add(Box.createHorizontalStrut(3));
            fontHorizontalBox.add(this.fontSizeComboBox);
            fontHorizontalBox.add(Box.createHorizontalGlue());
            Box decorationVerticalBox = Box.createVerticalBox();
            decorationVerticalBox.add(fontHorizontalBox);
            decorationVerticalBox.add(Box.createVerticalStrut(10));
            decorationVerticalBox.add(decorationHorizontalBox);
            decorationVerticalBox.add(Box.createVerticalStrut(5));
            decorationPanel.add((Component)decorationVerticalBox, "Center");
            this.addGB(decorationPanel, 0, 3, 3, 1);
            this.constraints.weighty = 1.0;
            this.addGB(new JPanel(), 0, 4, 3, 1);
            this.getPreferenceElements();
            PageSetupDialog.this.leftMarginTextField.getDocument().addDocumentListener(this);
            PageSetupDialog.this.rightMarginTextField.getDocument().addDocumentListener(this);
            PageSetupDialog.this.topMarginTextField.getDocument().addDocumentListener(this);
            PageSetupDialog.this.bottomMarginTextField.getDocument().addDocumentListener(this);
            this.scaleFactorTextField.getDocument().addDocumentListener(this);
            this.shrinkToFitCheckBox.addActionListener(this);
            this.paperSizesComboBox.addActionListener(this);
            this.portraitRadioButton.addActionListener(this);
            this.landscapeRadioButton.addActionListener(this);
            this.leftHeaderComboBox.addActionListener(this);
            this.middleHeaderComboBox.addActionListener(this);
            this.rightHeaderComboBox.addActionListener(this);
            this.leftFooterComboBox.addActionListener(this);
            this.middleFooterComboBox.addActionListener(this);
            this.rightFooterComboBox.addActionListener(this);
            this.fontComboBox.addActionListener(this);
            this.fontSizeComboBox.addActionListener(this);
        }

        public void changedUpdate(DocumentEvent e) {
        }

        public void removeUpdate(DocumentEvent e) {
            this.setHasChanged(true);
        }

        public void insertUpdate(DocumentEvent e) {
            this.setHasChanged(true);
        }

        private void getPreferenceElements() {
            int i;
            int index = StormPageFormat.findPageSize(new Dimension((int)stormPageFormat.getPageWidth(), (int)stormPageFormat.getPageHeight()));
            this.paperSizesComboBox.setSelectedIndex(index);
            if (stormPageFormat.isScaleToFitEnabled()) {
                this.scaleFactorTextField.setEnabled(false);
                this.shrinkToFitCheckBox.setSelected(true);
            }
            this.scaleFactorTextField.setValue((int)(stormPageFormat.getScale() * 100.0));
            if (stormPageFormat.getOrientation() == 1) {
                this.portraitRadioButton.setSelected(true);
            } else {
                this.landscapeRadioButton.setSelected(true);
            }
            PageSetupDialog.this.updateMarginUnits();
            for (i = 0; i < this.fontList.length; ++i) {
                if (!this.fontList[i].equals(stormPageFormat.getHeaderFooterFont().getName())) continue;
                this.fontComboBox.setSelectedIndex(i);
                break;
            }
            for (i = 0; i < this.fontSizeList.length; ++i) {
                if (!this.fontSizeList[i].equals(stormPageFormat.getHeaderFooterFont().getSize() + "")) continue;
                this.fontSizeComboBox.setSelectedIndex(i);
                break;
            }
            Enumeration decorations = stormPageFormat.getDecoration().elements();
            while (decorations.hasMoreElements()) {
                Object tmp = decorations.nextElement();
                if (!(tmp instanceof AbstractPageDecoration)) continue;
                AbstractPageDecoration decoration = (AbstractPageDecoration)tmp;
                if (decoration.getVerticalAlignment() == AbstractPageDecoration.TOP) {
                    if (decoration.getHorizontalAlignment() == AbstractPageDecoration.LEFT) {
                        this.leftHeaderComboBox.setSelectedIndex(this.selectDecorationComboBoxIndex(decoration.getName()));
                        continue;
                    }
                    if (decoration.getHorizontalAlignment() == AbstractPageDecoration.CENTER) {
                        this.middleHeaderComboBox.setSelectedIndex(this.selectDecorationComboBoxIndex(decoration.getName()));
                        continue;
                    }
                    if (decoration.getHorizontalAlignment() != AbstractPageDecoration.RIGHT) continue;
                    this.rightHeaderComboBox.setSelectedIndex(this.selectDecorationComboBoxIndex(decoration.getName()));
                    continue;
                }
                if (decoration.getVerticalAlignment() != AbstractPageDecoration.BOTTOM) continue;
                if (decoration.getHorizontalAlignment() == AbstractPageDecoration.LEFT) {
                    this.leftFooterComboBox.setSelectedIndex(this.selectDecorationComboBoxIndex(decoration.getName()));
                    continue;
                }
                if (decoration.getHorizontalAlignment() == AbstractPageDecoration.CENTER) {
                    this.middleFooterComboBox.setSelectedIndex(this.selectDecorationComboBoxIndex(decoration.getName()));
                    continue;
                }
                if (decoration.getHorizontalAlignment() != AbstractPageDecoration.RIGHT) continue;
                this.rightFooterComboBox.setSelectedIndex(this.selectDecorationComboBoxIndex(decoration.getName()));
            }
        }

        private int selectDecorationComboBoxIndex(String decorationName) {
            int index = 0;
            for (int i = 0; i < decorationList.length; ++i) {
                if (!decorationList[i][0].equalsIgnoreCase(decorationName)) continue;
                index = i;
                break;
            }
            return index;
        }

        private void setPreferenceElements() {
            double tmp;
            stormPageFormat.setOrientation(1);
            int index = this.paperSizesComboBox.getSelectedIndex();
            stormPageFormat.setPageSize(index);
            if (this.landscapeRadioButton.isSelected()) {
                stormPageFormat.setOrientation(0);
            }
            if (this.shrinkToFitCheckBox.isSelected()) {
                stormPageFormat.setScaleToFitEnabled(true);
            } else {
                stormPageFormat.setScaleToFitEnabled(false);
                try {
                    tmp = Double.parseDouble(this.scaleFactorTextField.getText());
                    stormPageFormat.setScale(tmp / 100.0);
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
            }
            try {
                if (PageSetupDialog.this.defaultUnit == 0) {
                    tmp = Double.parseDouble(PageSetupDialog.this.leftMarginTextField.getText());
                    stormPageFormat.setMargin(new PointUnit(tmp), 2);
                    tmp = Double.parseDouble(PageSetupDialog.this.rightMarginTextField.getText());
                    stormPageFormat.setMargin(new PointUnit(tmp), 4);
                    tmp = Double.parseDouble(PageSetupDialog.this.topMarginTextField.getText());
                    stormPageFormat.setMargin(new PointUnit(tmp), 1);
                    tmp = Double.parseDouble(PageSetupDialog.this.bottomMarginTextField.getText());
                    stormPageFormat.setMargin(new PointUnit(tmp), 3);
                } else if (PageSetupDialog.this.defaultUnit == 1) {
                    tmp = Double.parseDouble(PageSetupDialog.this.leftMarginTextField.getText());
                    stormPageFormat.setMargin(new MmUnit(tmp), 2);
                    tmp = Double.parseDouble(PageSetupDialog.this.rightMarginTextField.getText());
                    stormPageFormat.setMargin(new MmUnit(tmp), 4);
                    tmp = Double.parseDouble(PageSetupDialog.this.topMarginTextField.getText());
                    stormPageFormat.setMargin(new MmUnit(tmp), 1);
                    tmp = Double.parseDouble(PageSetupDialog.this.bottomMarginTextField.getText());
                    stormPageFormat.setMargin(new MmUnit(tmp), 3);
                } else if (PageSetupDialog.this.defaultUnit == 2) {
                    tmp = Double.parseDouble(PageSetupDialog.this.leftMarginTextField.getText());
                    stormPageFormat.setMargin(new InchUnit(tmp), 2);
                    tmp = Double.parseDouble(PageSetupDialog.this.rightMarginTextField.getText());
                    stormPageFormat.setMargin(new InchUnit(tmp), 4);
                    tmp = Double.parseDouble(PageSetupDialog.this.topMarginTextField.getText());
                    stormPageFormat.setMargin(new InchUnit(tmp), 1);
                    tmp = Double.parseDouble(PageSetupDialog.this.bottomMarginTextField.getText());
                    stormPageFormat.setMargin(new InchUnit(tmp), 3);
                }
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
            stormPageFormat.setHeaderFooterFont(new Font(this.fontList[this.fontComboBox.getSelectedIndex()], 0, Integer.parseInt(this.fontSizeList[this.fontSizeComboBox.getSelectedIndex()])));
            Vector decorations = stormPageFormat.getDecoration();
            block4: for (int j = 0; j < decorations.size(); ++j) {
                Object tmp2 = decorations.elementAt(j);
                if (!(tmp2 instanceof AbstractPageDecoration)) continue;
                AbstractPageDecoration decoration = (AbstractPageDecoration)decorations.elementAt(j);
                for (int i = 0; i < decorationList.length; ++i) {
                    if (!decorationList[i][0].equalsIgnoreCase(decoration.getName())) continue;
                    decorations.removeElementAt(j);
                    --j;
                    continue block4;
                }
            }
            int selectedIndex = this.leftHeaderComboBox.getSelectedIndex();
            this.addDecoration(AbstractPageDecoration.TOP, AbstractPageDecoration.LEFT, selectedIndex);
            selectedIndex = this.middleHeaderComboBox.getSelectedIndex();
            this.addDecoration(AbstractPageDecoration.TOP, AbstractPageDecoration.CENTER, selectedIndex);
            selectedIndex = this.rightHeaderComboBox.getSelectedIndex();
            this.addDecoration(AbstractPageDecoration.TOP, AbstractPageDecoration.RIGHT, selectedIndex);
            selectedIndex = this.leftFooterComboBox.getSelectedIndex();
            this.addDecoration(AbstractPageDecoration.BOTTOM, AbstractPageDecoration.LEFT, selectedIndex);
            selectedIndex = this.middleFooterComboBox.getSelectedIndex();
            this.addDecoration(AbstractPageDecoration.BOTTOM, AbstractPageDecoration.CENTER, selectedIndex);
            selectedIndex = this.rightFooterComboBox.getSelectedIndex();
            this.addDecoration(AbstractPageDecoration.BOTTOM, AbstractPageDecoration.RIGHT, selectedIndex);
        }

        private void addDecoration(int vert, int hor, int index) {
            if (index == 1) {
                stormPageFormat.addDecoration(new StringPageDecoration(PageSetupDialog.DECORATION_TITLE, PageSetupDialog.getDocumentTitle(PageSetupDialog.this.currentViewPort), vert, hor));
            } else if (index == 2) {
                stormPageFormat.addDecoration(new StringPageDecoration(PageSetupDialog.DECORATION_URL, PageSetupDialog.this.mainViewport.getLocation(), vert, hor));
            } else if (index == 3) {
                SimpleDateFormat formatter = new SimpleDateFormat("EEE, d MMM yyyy hh:mm:ss a", locale);
                String s = formatter.format((Object)new Date());
                stormPageFormat.addDecoration(new StringPageDecoration(PageSetupDialog.DECORATION_DATE_TIME, s, vert, hor));
            } else if (index == 4) {
                stormPageFormat.addDecoration(new PageNumberPageDecoration(PageSetupDialog.DECORATION_PAGE_NUMBER, vert, hor));
            }
        }

        public boolean save() {
            this.setPreferenceElements();
            this.setHasChanged(false);
            return false;
        }

        public boolean cancel() {
            this.getPreferenceElements();
            return false;
        }

        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == this.shrinkToFitCheckBox) {
                if (this.shrinkToFitCheckBox.isSelected()) {
                    this.scaleFactorTextField.setEnabled(false);
                    this.setHasChanged(true);
                } else {
                    this.scaleFactorTextField.setEnabled(true);
                    this.setHasChanged(true);
                }
            } else {
                this.setHasChanged(true);
            }
        }

        private void addGB(Component component, int x, int y, int rowSpan, int colSpan) {
            this.constraints.gridx = x;
            this.constraints.gridy = y;
            this.constraints.gridwidth = rowSpan;
            this.constraints.gridheight = colSpan;
            this.add(component, this.constraints);
        }
    }
}

