/*
 * Decompiled with CFR 0.152.
 */
package ice.ri.common.print;

import ice.pilots.html4.DNode;
import ice.pilots.html4.ThePilot;
import ice.ri.common.print.PrintHelper;
import ice.ri.common.print.jdk11.PrintHelper11;
import ice.ri.common.print.jdk13.PrintHelper13;
import ice.ri.common.print.swing.PageSetupDialog;
import ice.storm.Pilot;
import ice.storm.StormBase;
import ice.storm.Viewport;
import ice.storm.print.StormPageFormat;
import ice.util.Defs;
import org.w3c.dom.Node;

public final class PrintUtilities {
    private PrintUtilities() {
    }

    public static void adjustScale(StormPageFormat stormpageformat, double layout_width) {
        if (stormpageformat.isScaleToFitEnabled()) {
            if (layout_width > stormpageformat.getImageableWidth()) {
                double scale = 1.0 / layout_width * stormpageformat.getImageableWidth();
                stormpageformat.setScaleToFitEnabled(true);
                stormpageformat.setScale(scale);
            } else {
                stormpageformat.setScale(1.0);
            }
        }
    }

    public static PrintHelper getPrintHelper(Viewport viewport, StormPageFormat stormpageformat) {
        if (Defs.getClass("java.awt.JobAttributes") != null) {
            return new PrintHelper13(viewport, stormpageformat);
        }
        return new PrintHelper11(viewport, stormpageformat);
    }

    public static boolean isFrameset(Viewport viewport) {
        ThePilot pp;
        Node n;
        boolean isFrameset = false;
        Pilot p = viewport.getPilot();
        if (p instanceof ThePilot && (n = (pp = (ThePilot)p).getDDocument().getDocumentDElement()) != null) {
            int nameId;
            for (n = n.getFirstChild(); n != null && (nameId = ((DNode)n).getNameId()) != 13; n = n.getNextSibling()) {
                if (nameId != 34) continue;
                isFrameset = true;
                break;
            }
        }
        return isFrameset;
    }

    public static void refreshPageDecoration(Viewport viewport, StormPageFormat stormPageFormat) {
        StormBase sb = viewport.getPilot().getStorm();
        String toolkit = sb.getComponentToolkitName();
        if (toolkit.equals("awt")) {
            ice.ri.common.print.awt.PageSetupDialog.refreshPageDecoration(viewport, stormPageFormat);
        } else {
            PageSetupDialog.refreshPageDecoration(viewport, stormPageFormat);
        }
    }
}

