/*
 * Decompiled with CFR 0.152.
 */
package ice.pilots.html4.swing;

import ice.pilots.html4.CSSAttribs;
import ice.pilots.html4.DAttr;
import ice.pilots.html4.DElement;
import ice.pilots.html4.DOptionElement;
import ice.pilots.html4.DSelectElement;
import ice.pilots.html4.ObjectBox;
import ice.pilots.html4.swing.DocView;
import ice.pilots.html4.swing.Movable;
import ice.pilots.html4.swing.MyList;
import ice.pilots.html4.swing.OptionListModel;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import javax.swing.JList;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

class FormSelectList
extends JScrollPane
implements DSelectElement.SelectPainter,
ListSelectionListener,
Movable {
    private DocView docView;
    int count;
    boolean boxChange;
    private DSelectElement sel;
    private ObjectBox box;
    private JList list;
    private boolean ignoreItemChange;
    private Border _originalBorder = this.getBorder();
    private boolean drawWidgetBorder = true;

    FormSelectList(DocView docView, DElement e, int numRows) {
        this.docView = docView;
        this.sel = (DSelectElement)e;
        this.list = new MyList(docView);
        this.list.setVisibleRowCount(numRows);
        int selMode = 0;
        if (this.sel.getMultiple()) {
            selMode = 2;
        }
        this.list.setSelectionMode(selMode);
        this.copyOptionsToView();
        this.setViewportView(this.list);
        this.list.addListSelectionListener(this);
    }

    public void paintComponent(Graphics g) {
        if (this.isShowing() || !this.drawWidgetBorder) {
            super.paintComponent(g);
        } else {
            try {
                g.translate(1, 1);
                Dimension size = this.getSize();
                Color bg = UIManager.getColor("List.background");
                Color fg = UIManager.getColor("List.foreground");
                Color hlitbg = UIManager.getColor("List.selectionBackground");
                Color hlitfg = UIManager.getColor("List.selectionForeground");
                g.setColor(bg);
                g.setClip(0, 0, size.width - 2, size.height - 2);
                g.fillRect(0, 0, size.width - 2, size.height - 2);
                g.setColor(fg);
                g.drawRect(0, 0, size.width - 2, size.height - 2);
                FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
                int spacing = size.height / this.list.getVisibleRowCount();
                int newSpace = spacing - fontMetrics.getDescent() - 2;
                for (int i = 0; i < this.list.getVisibleRowCount(); ++i) {
                    String text = (String)this.list.getModel().getElementAt(i);
                    if (i == this.list.getSelectedIndex()) {
                        g.setColor(hlitbg);
                        g.fillRect(0, i * spacing, size.width - 2, spacing);
                        g.setColor(hlitfg);
                    } else {
                        g.setColor(fg);
                    }
                    g.drawString(text, 2, newSpace);
                    newSpace += spacing;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void setListCellHeight() {
        if (this.sel == null) {
            return;
        }
        DOptionElement option = this.sel.getDOption(0);
        if (option != null && option.getText() != null) {
            return;
        }
        Font font = this.list.getFont();
        FontMetrics metrics = this.list.getFontMetrics(font);
        this.list.setFixedCellHeight(metrics.getHeight());
    }

    private void copyOptionsToView() {
        ListModel lm = this.list.getModel();
        if (lm != null) {
            int i;
            int n = lm.getSize();
            DOptionElement opt = this.sel.firstDOption();
            for (i = 0; i < n && opt != null; ++i) {
                String s1 = (String)lm.getElementAt(i);
                String s2 = opt.getTextOrEmptyString();
                if (s1.length() != s2.length() || !s1.equals(s2)) break;
                opt = this.sel.nextDOption(opt);
            }
            if (i == n && opt == null) {
                return;
            }
        }
        this.ignoreItemChange = true;
        this.list.setModel(new OptionListModel(this.sel));
        this.checkAttributes();
        this.ignoreItemChange = false;
        this.updateSelection();
    }

    private void updateSelection() {
        this.ignoreItemChange = true;
        this.list.clearSelection();
        if (this.list.getSelectionMode() == 0) {
            int index = this.sel.getSelectedIndex();
            if (index >= 0) {
                this.list.addSelectionInterval(index, index);
            }
        } else {
            DOptionElement opt = this.sel.firstDOption();
            int i = 0;
            while (opt != null) {
                if (opt.getSelected()) {
                    this.list.addSelectionInterval(i, i);
                }
                opt = this.sel.nextDOption(opt);
                ++i;
            }
        }
        final int i = this.list.getSelectedIndex();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                FormSelectList.this.list.ensureIndexIsVisible(i);
            }
        });
        this.ignoreItemChange = false;
    }

    private void checkAttributes() {
        this.list.setEnabled(!this.sel.getDisabled());
        this.setListCellHeight();
    }

    public void valueChanged(ListSelectionEvent e) {
        if (!this.ignoreItemChange) {
            DOptionElement opt = this.sel.firstDOption();
            int i = 0;
            while (opt != null) {
                if (opt.getSelected() != this.list.isSelectedIndex(i)) {
                    this.sel.setSelectedIndexByUser(i);
                }
                opt = this.sel.nextDOption(opt);
                ++i;
            }
        }
        this.updateFont();
    }

    public void onElementAttrChange(DElement elem, DAttr attr) {
        this.checkAttributes();
    }

    public void onOptionStructChange() {
        this.copyOptionsToView();
    }

    public void onOptionSelectionChange() {
        this.updateSelection();
    }

    public void onOptionAttrChange(DOptionElement opt, DAttr attr) {
    }

    public void setFont(Font f) {
        super.setFont(f);
        if (this.list != null) {
            this.list.setFont(f);
        }
        this.setListCellHeight();
    }

    public void setFontHints(CSSAttribs css) {
        this.updateFont();
    }

    private void updateFont() {
        if (this.list == null) {
            return;
        }
        if (this.box != null) {
            StringBuffer sb = new StringBuffer();
            ListModel lm = this.list.getModel();
            for (int idx = 0; idx < lm.getSize(); ++idx) {
                sb.append(lm.getElementAt(idx).toString());
            }
            CSSAttribs css = this.box.getCSSAttribs();
            Font f = css.getTestedFont(sb.toString());
            if (!f.equals(this.getFont())) {
                this.setFont(f);
            }
        }
    }

    public void setBackground(Color c) {
        super.setBackground(c);
        if (this.list != null) {
            this.list.setBackground(c);
        }
    }

    public void setForeground(Color c) {
        super.setForeground(c);
        if (this.list != null) {
            this.list.setForeground(c);
        }
    }

    public void dispose() {
        Container c = this.getParent();
        if (c != null) {
            c.remove(this);
        }
    }

    public void setBox(ObjectBox box) {
        this.box = box;
        this.docView.checkAwtTree(box, this);
        if (box != null) {
            this.copyOptionsToView();
        }
    }

    public ObjectBox getBox() {
        return this.box;
    }

    public int getPrefWidth() {
        return this.getPreferredSize().width;
    }

    public int getPrefHeight() {
        return this.getPreferredSize().height;
    }

    public void setPainterSize(int w, int h) {
        this.setSize(w, h);
    }

    public boolean getFocusTraversalKeysEnabled() {
        return false;
    }

    public boolean isFocusable() {
        return true;
    }

    public boolean isFocusTraversable() {
        return false;
    }

    public boolean isManagingFocus() {
        return true;
    }

    public void draw(Graphics g) {
    }

    public void syncDom(int x, int y, boolean visible) {
        this.setLocation(x, y);
        this.setVisible(visible);
    }

    public void setBorderVisible(boolean aDrawBorder) {
        if (!aDrawBorder) {
            this.setBorder(null);
            this.drawWidgetBorder = false;
        } else {
            this.setBorder(this._originalBorder);
            this.drawWidgetBorder = true;
        }
    }

    public int getClientHeight() {
        int barheight = 0;
        JScrollBar b = this.horizontalScrollBar;
        if (b != null && b.isVisible()) {
            barheight = b.getHeight();
        }
        return this.getHeight() - barheight;
    }

    public int getClientWidth() {
        int barwidth = 0;
        JScrollBar b = this.verticalScrollBar;
        if (b != null && b.isVisible()) {
            barwidth = b.getWidth();
        }
        return this.getWidth() - barwidth;
    }
}

