/*
 * Decompiled with CFR 0.152.
 */
package ice.pilots.html4.awt;

import ice.pilots.html4.CSSAttribs;
import ice.pilots.html4.DAttr;
import ice.pilots.html4.DElement;
import ice.pilots.html4.DInputElement;
import ice.pilots.html4.ObjectBox;
import ice.pilots.html4.ObjectPainter;
import ice.pilots.html4.awt.DocView;
import ice.pilots.html4.awt.Movable;
import java.awt.AWTEvent;
import java.awt.Button;
import java.awt.Color;
import java.awt.Container;
import java.awt.Font;
import java.awt.Graphics;

class FormInputButton
extends Button
implements ObjectPainter,
Movable {
    private DocView docView;
    private DInputElement element;
    private ObjectBox box;

    FormInputButton(DocView docView, DElement e, String type) {
        super(type);
        this.docView = docView;
        this.element = (DInputElement)e;
        String v = this.element.getValue();
        if (v != null) {
            this.setLabel(v);
        }
        this.checkAttributes();
        this.enableEvents(28L);
    }

    private void checkAttributes() {
        this.setEnabled(!this.element.getDisabled());
    }

    public void onElementAttrChange(DElement elem, DAttr attr) {
        String s = this.element.getValue();
        if (s != null && !s.equals(this.getLabel())) {
            this.setLabel(s);
            this.box.invalidate();
            this.box.reqReflow();
        } else {
            this.checkAttributes();
        }
    }

    public void dispose() {
        Container c = this.getParent();
        if (c != null) {
            c.remove(this);
        }
    }

    public boolean getFocusTraversalKeysEnabled() {
        return false;
    }

    public boolean isFocusable() {
        return true;
    }

    public boolean isFocusTraversable() {
        return false;
    }

    public void setBox(ObjectBox box) {
        this.box = box;
        this.docView.checkAwtTree(box, this);
    }

    public ObjectBox getBox() {
        return this.box;
    }

    public int getPrefWidth() {
        return this.getPreferredSize().width;
    }

    public int getPrefHeight() {
        return this.getPreferredSize().height;
    }

    public void setPainterSize(int w, int h) {
        this.setSize(w, h);
    }

    public void draw(Graphics g) {
        if (this.isVisible()) {
            return;
        }
        g.setColor(Color.lightGray);
        g.drawRect(0, 0, this.getSize().width - 1, this.getSize().height - 1);
    }

    public void syncDom(int x, int y, boolean visible) {
        this.setLocation(x, y);
        this.setVisible(visible);
    }

    protected void processEvent(AWTEvent e) {
        if (this.docView.onComponentEvent(this, e)) {
            super.processEvent(e);
        }
    }

    public void setBorderVisible(boolean aDrawBorder) {
    }

    public void setFontHints(CSSAttribs css) {
        Font f = css.getFont();
        if (!f.equals(this.getFont())) {
            Container parent = this.getParent();
            parent.remove(this);
            super.setFont(f);
            parent.add(this);
        }
    }

    public int getClientHeight() {
        return this.getSize().height;
    }

    public int getClientWidth() {
        return this.getSize().width;
    }
}

