/*
 * Decompiled with CFR 0.152.
 */
package ice.pilots.html4;

import ice.pilots.html4.CSSDecl;
import ice.pilots.html4.CSSInlineBuilder;
import ice.pilots.html4.CSSLex;
import ice.pilots.html4.CSSLookup;
import ice.pilots.html4.DCSSRule;
import ice.pilots.html4.DElement;
import ice.pilots.html4.DMutationEvent;
import ice.pilots.html4.DOM;
import ice.pilots.html4.StormData;
import ice.storm.DynEnv;
import ice.storm.DynamicList;
import org.w3c.dom.css.CSSRule;
import org.w3c.dom.css.CSSStyleDeclaration;
import org.w3c.dom.css.CSSValue;

public class DStyleDeclaration
extends DynamicList
implements CSSStyleDeclaration {
    private StormData sdata;
    private DElement element;
    private DCSSRule parentRule;
    private int num = 0;
    CSSDecl firstDecl;
    private static final int Field_cssText = 1;
    private static final int Field_parentRule = 2;
    private static final int Method_getPropertyValue = -1;
    private static final int Method_getPropertyCSSValue = -2;
    private static final int Method_removeProperty = -3;
    private static final int Method_getPropertyPriority = -4;
    private static final int Method_setProperty = -5;

    protected DStyleDeclaration(DOM dom, DCSSRule parentRule, DElement e) {
        this.sdata = dom.getStormData();
        this.parentRule = parentRule;
        this.element = e;
    }

    public String getCssText() {
        StringBuffer sb = new StringBuffer();
        CSSDecl d = this.firstDecl;
        while (d != null) {
            sb.append(CSSLookup.getPropName(d.id));
            sb.append(": ");
            sb.append(d.toString());
            sb.append("; ");
            d = d.next;
        }
        return sb.toString();
    }

    public void setCssText(String cssText) {
        CSSInlineBuilder inlineBuilder = new CSSInlineBuilder(this.sdata);
        CSSLex inlineLex = new CSSLex();
        inlineLex.setLexCallback(inlineBuilder);
        inlineLex.parseInlineDeclaration(cssText);
        CSSDecl d = inlineBuilder.getDeclarations();
        if (d != null) {
            this.appendOrReplaceDecls(d);
        }
    }

    public String getPropertyValue(String propertyName) {
        CSSDecl d = this.getCSSDeclFromPropName(propertyName);
        return d == null ? null : d.toString();
    }

    public CSSValue getPropertyCSSValue(String propertyName) {
        return null;
    }

    private CSSDecl getCSSDeclFromPropName(String propName) {
        int id = CSSLookup.getPropNameId(propName);
        if (id < 0) {
            return null;
        }
        return this.getCSSDeclFromPropId(id);
    }

    private CSSDecl getCSSDeclFromPropId(int id) {
        CSSDecl d = this.firstDecl;
        while (d != null) {
            if (d.id == id) {
                return d;
            }
            d = d.next;
        }
        return null;
    }

    protected Object[] getCSSDeclFields(String propName) {
        CSSDecl d = this.getCSSDeclFromPropName(propName);
        if (d != null) {
            Object[] rtrn = new Object[]{d.toString(), new Integer(d.type), d.value};
            return rtrn;
        }
        return null;
    }

    protected void updateCSSDecl(String propName, Object value, int type) {
        CSSDecl d = this.getCSSDeclFromPropName(propName);
        d.value = value;
        d.type = type;
    }

    public String removeProperty(String propertyName) {
        if (this.firstDecl == null) {
            return "";
        }
        char[] cc = propertyName.toCharArray();
        int id = CSSLookup.getPropNameId(cc, 0, cc.length);
        if (id < 0) {
            return "";
        }
        CSSDecl d = this.firstDecl;
        if (d.id == id) {
            this.firstDecl = d.next;
            d.next = null;
            --this.num;
            this.dispatchDOMEvent((short)3, propertyName, null);
            return propertyName;
        }
        while (d.next != null) {
            if (d.next.id == id) {
                CSSDecl n = d.next;
                d.next = n.next;
                n.next = null;
                --this.num;
                this.dispatchDOMEvent((short)3, propertyName, null);
                return propertyName;
            }
            d = d.next;
        }
        return "";
    }

    public String getPropertyPriority(String propertyName) {
        return "";
    }

    public void setProperty(String propertyName, String value, String priority) {
        this.setPropertyImpl(propertyName, value, priority);
    }

    boolean setPropertyImpl(String propertyName, String value, String priority) {
        if (value == null || value.length() == 0) {
            this.removeProperty(propertyName);
            return true;
        }
        int len = propertyName.length();
        char[] cc = new char[len + value.length()];
        propertyName.getChars(0, len, cc, 0);
        value.getChars(0, value.length(), cc, len);
        CSSDecl d = CSSLookup.parseDeclaration(this.sdata, cc, 0, len, len, cc.length - len);
        if (d == null) {
            return false;
        }
        return this.appendOrReplaceDecls(d);
    }

    public int getLength() {
        return this.num;
    }

    public String item(int idx) {
        CSSDecl d = this.firstDecl;
        while (d != null) {
            if (idx == 0) {
                return CSSLookup.getPropName(d.id);
            }
            --idx;
            d = d.next;
        }
        return null;
    }

    protected Object script_item(int index, DynEnv env) {
        return this.item(index);
    }

    public CSSRule getParentRule() {
        return this.parentRule;
    }

    void setFirstDecl(CSSDecl d) {
        this.firstDecl = d;
        this.num = 0;
        while (d != null) {
            ++this.num;
            d = d.next;
        }
    }

    private final void signalChange(short type, CSSDecl d) {
        String name = CSSLookup.getPropName(d.id);
        String value = d.toString();
        this.dispatchDOMEvent(type, name, value);
    }

    private boolean appendOrReplaceDecls(CSSDecl d) {
        boolean retval = false;
        if (this.firstDecl == null) {
            this.firstDecl = d;
            while (d != null) {
                ++this.num;
                this.signalChange((short)2, d);
                retval = true;
                d = d.next;
            }
        } else {
            CSSDecl last = this.firstDecl;
            while (last.next != null) {
                last = last.next;
            }
            while (d != null) {
                CSSDecl t = this.firstDecl;
                boolean newProperty = true;
                while (t != null) {
                    if (t.sameId(d)) {
                        newProperty = false;
                        if (!t.copyDataFrom(d)) break;
                        this.signalChange((short)1, d);
                        break;
                    }
                    t = t.next;
                }
                if (newProperty) {
                    ++this.num;
                    last.next = d;
                    last = d;
                    this.signalChange((short)2, d);
                }
                d = d.next;
            }
        }
        return retval;
    }

    private String propertyNameConvertion(String name) {
        char c;
        int pos;
        int length = name.length();
        for (pos = 0; pos != length && ('A' > (c = name.charAt(pos)) || c > 'Z'); ++pos) {
        }
        if (pos != length) {
            char[] buffer = new char[length * 2];
            int cursor = 0;
            if (pos != 5 || !name.regionMatches(0, "pixel", 0, 5)) {
                name.getChars(0, pos, buffer, 0);
                cursor += pos;
            }
            while (pos != length) {
                int c2 = name.charAt(pos);
                if (65 <= c2 && c2 <= 90) {
                    if (cursor != 0) {
                        buffer[cursor++] = 45;
                    }
                    c2 += 32;
                }
                buffer[cursor++] = (char)c2;
                ++pos;
            }
            name = new String(buffer, 0, cursor);
        }
        return name;
    }

    protected Object script_namedItem(String name, DynEnv env) {
        int id = -1;
        boolean pixel_type = false;
        String guess = null;
        switch (name.length()) {
            case 6: {
                guess = "posTop";
                id = 94;
                break;
            }
            case 7: {
                guess = "posLeft";
                id = 52;
                break;
            }
            case 8: {
                char c = name.charAt(5);
                if (c == 'T') {
                    guess = "pixelTop";
                    id = 94;
                    break;
                }
                if (c == 'd') {
                    guess = "posWidth";
                    id = 100;
                    break;
                }
                if (c != 'g') break;
                guess = "posRight";
                id = 86;
                break;
            }
            case 9: {
                char c = name.charAt(7);
                if (c == 'f') {
                    guess = "pixelLeft";
                    id = 52;
                    break;
                }
                if (c == 'h') {
                    guess = "posHeight";
                    id = 51;
                    break;
                }
                if (c != 'o') break;
                guess = "posBottom";
                id = 29;
                break;
            }
            case 10: {
                char c = name.charAt(5);
                if (c == 'R') {
                    guess = "pixelRight";
                    id = 86;
                    break;
                }
                if (c != 'W') break;
                guess = "pixelWidth";
                id = 100;
                break;
            }
            case 11: {
                char c = name.charAt(5);
                if (c == 'B') {
                    guess = "pixelBottom";
                    id = 29;
                    break;
                }
                if (c != 'H') break;
                guess = "pixelHeight";
                id = 51;
            }
        }
        if (guess != null && guess.equals(name)) {
            pixel_type = true;
        } else {
            String propName = this.propertyNameConvertion(name);
            id = CSSLookup.getPropNameId(propName);
            if (id < 0) {
                return null;
            }
        }
        CSSDecl decl = this.getCSSDeclFromPropId(id);
        Object result = pixel_type ? (decl == null || decl.value == null ? env.wrapInt(0) : env.wrapDoubleOrString(decl.value.toString())) : (decl == null ? "" : decl.toString());
        return result;
    }

    public void setSlot(String name, Object value, DynEnv env) {
        String propertyValue;
        String propName = this.propertyNameConvertion(name);
        if (this.setPropertyImpl(propName, propertyValue = env.toStr(value), "")) {
            return;
        }
        super.setSlot(name, value, env);
    }

    public String toString() {
        return "CssStyleDeclaration";
    }

    protected final void dispatchDOMEvent(short type, String name, String value) {
        if (this.element != null) {
            DMutationEvent event = (DMutationEvent)this.element.doc.createDOMEvent(29, this.element);
            event.setMutationData(null, null, value, name, type);
            this.element.dispatchEvent(event);
        } else {
            this.parentRule.dispatchDOMEvent(type, name, value);
        }
    }

    final void mutate() {
        if (this.element != null) {
            this.element.doc.mutate();
        } else {
            this.parentRule.mutate();
        }
    }

    public Object getDynamicValue(String name, DynEnv env) {
        int id = DStyleDeclaration.toDynamicId(name);
        if (id < 0) {
            return env.wrapMethod(this, name);
        }
        if (id > 0) {
            return this.getDynamicValue(id, env);
        }
        return super.getDynamicValue(name, env);
    }

    public int setDynamicValue(String name, Object value, DynEnv env) {
        int id = DStyleDeclaration.toDynamicId(name);
        if (id < 0) {
            return 2;
        }
        if (id > 0) {
            return this.setDynamicValue(id, value, env);
        }
        return super.setDynamicValue(name, value, env);
    }

    public Object execDynamicMethod(String name, Object[] args, DynEnv env) {
        int id = DStyleDeclaration.toDynamicId(name);
        if (id < 0) {
            return this.execDynamicMethod(id, args, env);
        }
        return super.execDynamicMethod(name, args, env);
    }

    private Object getDynamicValue(int key_id, DynEnv env) {
        if (key_id == 1) {
            return this.getCssText();
        }
        if (key_id == 2) {
            return this.getParentRule();
        }
        return null;
    }

    private int setDynamicValue(int key_id, Object value, DynEnv env) {
        return 2;
    }

    private Object execDynamicMethod(int key_id, Object[] args, DynEnv env) {
        switch (key_id) {
            case -1: {
                return this.getPropertyValue(env.toStr(args, 0));
            }
            case -2: {
                return this.getPropertyCSSValue(env.toStr(args, 0));
            }
            case -3: {
                return this.removeProperty(env.toStr(args, 0));
            }
            case -4: {
                return this.getPropertyPriority(env.toStr(args, 0));
            }
            case -5: {
                String propertyName = env.toStr(args, 0);
                String value = env.toStr(args, 1);
                String priority = env.toStr(args, 2);
                this.setProperty(propertyName, value, priority);
                break;
            }
        }
        return env.wrapVoid();
    }

    private static int toDynamicId(String s) {
        int id = 0;
        String guess = null;
        switch (s.length()) {
            case 7: {
                guess = "cssText";
                id = 1;
                break;
            }
            case 10: {
                guess = "parentRule";
                id = 2;
                break;
            }
            case 11: {
                guess = "setProperty";
                id = -5;
                break;
            }
            case 14: {
                guess = "removeProperty";
                id = -3;
                break;
            }
            case 16: {
                guess = "getPropertyValue";
                id = -1;
                break;
            }
            case 19: {
                char c = s.charAt(11);
                if (c == 'C') {
                    guess = "getPropertyCSSValue";
                    id = -2;
                    break;
                }
                if (c != 'P') break;
                guess = "getPropertyPriority";
                id = -4;
                break;
            }
        }
        if (guess != null && (guess == s || guess.equals(s))) {
            return id;
        }
        return 0;
    }
}

