/*
 * Decompiled with CFR 0.152.
 */
package ice.pilots.html4;

import ice.pilots.html4.DAttr;
import ice.pilots.html4.DElement;
import ice.pilots.html4.DFlatList;
import ice.pilots.html4.DNode;
import ice.pilots.html4.DNodeList;
import ice.pilots.html4.Names;
import ice.storm.DynEnv;
import ice.storm.DynamicList;
import ice.util.Defs;
import ice.util.Emulation;
import ice.util.alg.CharKit;
import ice.util.alg.HashArray;
import java.util.Vector;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DAllList
extends DynamicList {
    private DNode startNode;
    private boolean writeSourceIndex = false;
    private HashArray names;
    private HashArray ids;
    private HashArray both;
    private Vector indexes;
    private int mutation = 0;
    private boolean _ieEmulation;

    DAllList(DNode startNode) {
        this(startNode, false);
    }

    DAllList(DNode startNode, boolean writeSourceIndex) {
        this.startNode = startNode;
        this.writeSourceIndex = writeSourceIndex;
        this._ieEmulation = Emulation.getEmulationMode().startsWith("ie");
        this.record();
    }

    private void record() {
        HashArray names = new HashArray(Defs.NO_SYNCHRONIZATION);
        HashArray ids = new HashArray(Defs.NO_SYNCHRONIZATION);
        HashArray both = new HashArray(Defs.NO_SYNCHRONIZATION);
        Vector indexes = new Vector();
        this.record_r(this.startNode, names, ids, both, indexes);
        names.sealObject();
        ids.sealObject();
        both.sealObject();
        this.names = names;
        this.ids = ids;
        this.both = both;
        this.indexes = indexes;
        this.mutation = this.startNode.doc.getMutation();
    }

    private void record_r(DNode n, HashArray names, HashArray ids, HashArray both, Vector indexes) {
        if (n instanceof DElement) {
            DElement e = (DElement)n;
            indexes.addElement(e);
            if (this.writeSourceIndex) {
                e.sourceIndex = indexes.size() - 1;
            }
            String id = DAllList.getIdValue(e);
            String name = e.getAttribute(63);
            if (id != null) {
                ids.put(id, (Object)e);
            }
            if (name != null) {
                DAllList.recordEntry(names, name, e);
            }
            if (id != null && name != null && id.equals(name)) {
                name = null;
            }
            if (id != null) {
                DAllList.recordEntry(both, id, e);
            }
            if (name != null) {
                DAllList.recordEntry(both, name, e);
            }
        }
        n = n.getFirstDChild();
        while (n != null) {
            this.record_r(n, names, ids, both, indexes);
            n = n.next;
        }
    }

    static String getIdValue(DNode node) {
        Names names = node.doc.names;
        DAttr cursor = node.getDAttrListHead();
        while (cursor != null) {
            if (DAllList.isIdAttribute(cursor, names)) {
                return cursor.getValue();
            }
            cursor = cursor.next;
        }
        return null;
    }

    private static boolean isIdAttribute(DAttr attr, Names names) {
        boolean result = false;
        int attrId = attr.nameId;
        if (attrId == 50) {
            result = true;
        } else if (attrId >= 124) {
            String name = attr.getLocalName();
            int namesapce = names.getAttrNamespaceId(attrId);
            if (namesapce == 5) {
                if (CharKit.equalsIgnoreAsciiCase(name, "id")) {
                    result = true;
                }
            } else if (name.equals("id")) {
                result = true;
            }
        }
        return result;
    }

    static void recordEntry(HashArray h, String name, DElement e) {
        HashArray.Entry entry = h.ensureEntry(name);
        Object o = entry.value;
        if (o == null) {
            entry.value = e;
        } else if (o instanceof DNode) {
            if (o != e) {
                DFlatList v = new DFlatList();
                v.append((DNode)o);
                v.append(e);
                entry.value = v;
            }
        } else {
            DFlatList v = (DFlatList)o;
            if (v.indexOf(e) < 0) {
                v.append(e);
            }
        }
    }

    public Node item(int idx) {
        if (this.startNode.doc.getMutation() != this.mutation) {
            this.record();
        }
        if (0 <= idx && idx < this.indexes.size()) {
            return (Node)this.indexes.elementAt(idx);
        }
        return null;
    }

    protected Object script_item(int index, DynEnv env) {
        return this.item(index);
    }

    public int getLength() {
        if (this.startNode.doc.getMutation() != this.mutation) {
            this.record();
        }
        return this.indexes.size();
    }

    public Node namedItem(String name) {
        Object o;
        if (this.startNode.doc.getMutation() != this.mutation) {
            this.record();
        }
        if ((o = this.both.get(name)) instanceof DFlatList) {
            o = ((DFlatList)o).item(0);
        }
        return (Node)o;
    }

    protected Object script_namedItem(String name, DynEnv env) {
        if (this.startNode.doc.getMutation() != this.mutation) {
            this.record();
        }
        return this.both.get(name);
    }

    protected Object script_tags(String tagName, DynEnv env) {
        return new DNodeList(this.startNode, tagName);
    }

    NodeList getElementsByName(String name) {
        if (this.startNode.doc.getMutation() != this.mutation) {
            this.record();
        }
        Object o = null;
        o = this._ieEmulation ? this.both.get(name) : this.names.get(name);
        if (o == null) {
            return null;
        }
        if (o instanceof DFlatList) {
            return (NodeList)o;
        }
        DFlatList v = new DFlatList();
        v.append((DNode)o);
        return v;
    }

    Element getElementById(String id) {
        if (this.startNode.doc.getMutation() != this.mutation) {
            this.record();
        }
        Element elem = null;
        if (this._ieEmulation) {
            Object o = this.both.get(id);
            if (o == null) {
                return null;
            }
            if (o instanceof Element) {
                elem = (Element)o;
            } else if (o instanceof DFlatList) {
                NodeList nList = (NodeList)o;
                elem = (Element)nList.item(0);
            }
        } else {
            elem = (Element)this.ids.get(id);
        }
        return elem;
    }
}

