/*
 * Decompiled with CFR 0.152.
 */
package ice.pilots.html4;

import ice.debug.Debug;
import ice.pilots.html4.BlockBox;
import ice.pilots.html4.BreakBox;
import ice.pilots.html4.BulletBox;
import ice.pilots.html4.ButtonBox;
import ice.pilots.html4.CSSAttribs;
import ice.pilots.html4.CSSBox;
import ice.pilots.html4.CSSDecl;
import ice.pilots.html4.CSSLayout;
import ice.pilots.html4.CSSLookup;
import ice.pilots.html4.CSSManager;
import ice.pilots.html4.CSSUtil;
import ice.pilots.html4.DAnchorElement;
import ice.pilots.html4.DCSSRule;
import ice.pilots.html4.DDocument;
import ice.pilots.html4.DElement;
import ice.pilots.html4.DStyleDeclaration;
import ice.pilots.html4.DStyleSheet;
import ice.pilots.html4.DTextNode;
import ice.pilots.html4.FloatBox;
import ice.pilots.html4.HtmlToCss;
import ice.pilots.html4.InlineBox;
import ice.pilots.html4.PositionedBox;
import ice.pilots.html4.ScrollBox;
import ice.pilots.html4.Selector;
import ice.pilots.html4.SimpleSelector;
import ice.pilots.html4.StormData;
import ice.pilots.html4.TableBox;
import ice.pilots.html4.TableCellBox;
import ice.pilots.html4.TableColBox;
import ice.pilots.html4.TableRowBox;
import ice.pilots.html4.TableRowGroupBox;
import ice.pilots.html4.TextBox;
import ice.pilots.html4.ThePilot;
import ice.storm.StormBase;
import ice.storm.Viewport;
import ice.util.Defs;
import java.awt.Color;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.WeakHashMap;
import javax.swing.Timer;
import javax.swing.UIManager;
import org.w3c.dom.css.CSSRuleList;
import org.w3c.dom.stylesheets.StyleSheetList;

class CSSMatcher {
    private String media;
    private DDocument doc;
    private StormData sdata;
    private DCSSRule[] curSelectors;
    private Hashtable universalSelectorsByClass;
    private CSSDecl[] blocks = new CSSDecl[50];
    private byte[] pseudo_value = new byte[50];
    private int numBlocks = 0;
    private DCSSRule htmlProxy;
    private Vector countersToInc = null;
    private Vector countersToReset = null;
    private static final String _ICE_HIGH_CONTRAST_SYSTEM_PROPERTY = "ice.pilots.html4.highContrast";
    private static final String _WIN_HIGH_CONTRAST_DESKTOP_PROPERTY = "win.highContrast.on";
    private HighContrastPropertySupport _highContrastPropertySupport = null;
    private static WeakHashMap _highContrastSupportCache = new WeakHashMap();

    CSSMatcher(String media, StormData sdata, DDocument doc) {
        this.media = media;
        this.sdata = sdata;
        this.doc = doc;
        this.htmlProxy = new DCSSRule(1, null, null);
        this.htmlProxy.sel = new Selector();
        this.htmlProxy.sel.weight = 20000;
        this.htmlProxy.sel.addSimpleSelector(new SimpleSelector(sdata.names, 0));
        this.htmlProxy.decl = doc.getDom().createDStyleDeclaration(this.htmlProxy, null);
        this.htmlProxy.decl.firstDecl = new CSSDecl(1000, 0, null);
        StormBase stormBase = doc.getPilot().getStorm();
        this._highContrastPropertySupport = (HighContrastPropertySupport)_highContrastSupportCache.get(stormBase);
        if (this._highContrastPropertySupport == null) {
            this._highContrastPropertySupport = new HighContrastPropertySupport(stormBase, Toolkit.getDefaultToolkit());
            _highContrastSupportCache.put(stormBase, this._highContrastPropertySupport);
        }
        this.build();
    }

    final void build() {
        this.htmlProxy._next = null;
        this.htmlProxy.decl.firstDecl.next = null;
        this.curSelectors = new DCSSRule[this.sdata.names.getNumTags()];
        this.universalSelectorsByClass = new Hashtable();
        DStyleSheet ss = CSSManager.getUaStyle(this.doc);
        if (ss != null) {
            this.build_ss(ss, 0);
        }
        if ((ss = CSSManager.getUserStyle(this.sdata)) != null) {
            this.build_ss(ss, 10000);
        }
        this.insertHtmlProxyStyle();
        StyleSheetList list = this.doc.getStyleSheets();
        for (int i = 0; i < list.getLength(); ++i) {
            this.build_ss((DStyleSheet)list.item(i), 20000);
        }
    }

    private final void insertHtmlProxyStyle() {
        DCSSRule r = this.htmlProxy;
        Selector s = this.htmlProxy.sel;
        int key = 0;
        DCSSRule t = this.curSelectors[0];
        if (t == null || s.weight < t.sel.weight) {
            this.curSelectors[key] = r;
            r._next = t;
        } else {
            while (t._next != null && t._next.sel.weight <= s.weight) {
                t = t._next;
            }
            r._next = t._next;
            t._next = r;
        }
    }

    private final void build_ss(DStyleSheet ss, int origin) {
        if (ss.getDisabled()) {
            return;
        }
        if (!ss.mediaList.worksWith(this.media)) {
            return;
        }
        this.build_rlist(ss.getCssRules(), origin);
    }

    private final void build_rlist(CSSRuleList rules, int origin) {
        block5: for (int i = 0; i < rules.getLength(); ++i) {
            DCSSRule r = (DCSSRule)rules.item(i);
            switch (r.getType()) {
                case 1: {
                    String cn;
                    int key;
                    if (origin == 0) {
                        DCSSRule r1 = new DCSSRule(1, null, null);
                        r1.sel = r.sel;
                        r1.decl = r.decl;
                        r = r1;
                    }
                    Selector s = r.sel;
                    if (s.weight < 10000 && origin > 0) {
                        s.weight += origin;
                    }
                    if ((key = s.getSelectorKey()) < 0 || key >= this.curSelectors.length) continue block5;
                    if (key == 0 && (cn = s.getUniversalClassKey()) != null) {
                        DCSSRule t = (DCSSRule)this.universalSelectorsByClass.get(cn);
                        if (t == null || s.weight < t.sel.weight) {
                            this.universalSelectorsByClass.put(cn, r);
                            r._next = t;
                            continue block5;
                        }
                        while (t._next != null && t._next.sel.weight <= s.weight) {
                            t = t._next;
                        }
                        r._next = t._next;
                        t._next = r;
                        continue block5;
                    }
                    DCSSRule t = this.curSelectors[key];
                    if (t == null || s.weight < t.sel.weight) {
                        this.curSelectors[key] = r;
                        r._next = t;
                        continue block5;
                    }
                    while (t._next != null && t._next.sel.weight <= s.weight) {
                        t = t._next;
                    }
                    r._next = t._next;
                    t._next = r;
                    continue block5;
                }
                case 3: {
                    if (r.importedStyleSheet == null) continue block5;
                    this.build_ss(r.importedStyleSheet, origin);
                    continue block5;
                }
                case 4: {
                    if (!r.mediaList.worksWith(this.media)) continue block5;
                    this.build_rlist(r.ruleList, origin);
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    CSSBox createCSSBox(DElement e, CSSBox parentBox, CSSLayout cssLayout) {
        CSSAttribs css;
        CSSBox box;
        block171: {
            void var20_97;
            void var20_93;
            CSSDecl d;
            byte pv;
            CSSAttribs pcss;
            byte pseudo;
            block176: {
                void var20_91;
                void var20_87;
                block172: {
                    void var20_85;
                    void var20_81;
                    byte dynamic;
                    block160: {
                        void var20_79;
                        EnumeratedText[] tokens;
                        String stemp;
                        CSSAttribs c;
                        String content;
                        int listStyle;
                        CSSAttribs parentCss;
                        block159: {
                            EnumeratedText[] enumeratedTextArray;
                            CSSDecl d2;
                            int i;
                            pseudo = this.makeStyleBlocks(e);
                            this.makeInlineStyle(e);
                            dynamic = (byte)(pseudo & 7);
                            box = null;
                            parentCss = null;
                            if (parentBox != null) {
                                parentCss = parentBox.css;
                                css = new CSSAttribs(this.sdata, parentCss);
                                if (parentBox.dynamic > 0 && dynamic == 0) {
                                    dynamic = parentBox.dynamic;
                                    pseudo = (byte)(pseudo | dynamic);
                                }
                            } else {
                                css = new CSSAttribs(this.sdata, cssLayout.zoom);
                                if (e == cssLayout.doc.getDocumentElement()) {
                                    css.misc = (short)(css.misc | 1);
                                }
                            }
                            int font_size = css.font_size;
                            for (i = 0; i < this.numBlocks; ++i) {
                                if (this.pseudo_value[i] != 0) continue;
                                d2 = this.blocks[i];
                                while (d2 != null) {
                                    if (d2.id == 46) {
                                        font_size = CSSLookup.computeFontSize(this.sdata, d2, css, cssLayout.zoom);
                                    }
                                    d2 = d2.next;
                                }
                            }
                            css.font_size = font_size;
                            i = 0;
                            while (true) {
                                block162: {
                                    block163: {
                                        block161: {
                                            if (i >= this.numBlocks) break block161;
                                            if (this.pseudo_value[i] != 0) break block162;
                                            d2 = this.blocks[i];
                                            break block163;
                                        }
                                        this.checkCounters(e, cssLayout);
                                        if (css.border_top_width > 0 && css.border_top_style == 8) {
                                            css.border_top_width = 0;
                                        }
                                        if (css.border_left_width > 0 && css.border_left_style == 8) {
                                            css.border_left_width = 0;
                                        }
                                        if (css.border_right_width > 0 && css.border_right_style == 8) {
                                            css.border_right_width = 0;
                                        }
                                        if (css.border_bottom_width > 0 && css.border_bottom_style == 8) {
                                            css.border_bottom_width = 0;
                                        }
                                        this.checkOutline(css, cssLayout);
                                        if (css.color != Color.black && !cssLayout.getPrintBack() && Color.white.equals(css.color)) {
                                            css.color = Color.black;
                                        }
                                        if (css.display != 41 && css.display != 46 && e == cssLayout.doc.getDocumentElement()) {
                                            css.display = 41;
                                        } else if (e.getNameId() == 79 && css.display == 40) {
                                            css.display = 47;
                                        }
                                        boolean tableReq = false;
                                        if (ThePilot.viewNoframes & (58 == e.getNameId() || 34 == e.getNameId())) {
                                            css.display = 41;
                                        }
                                        if (css.directionFlag == 1) {
                                            if (css.text_align == 15) {
                                                css.text_align = 3;
                                            } else if (css.text_align == 130) {
                                                css.text_align = 3;
                                            }
                                            int tmp = css.margin_left;
                                            css.margin_left = css.margin_right;
                                            css.margin_right = tmp;
                                            tmp = css.padding_left;
                                            css.padding_left = css.padding_right;
                                            css.padding_right = tmp;
                                        } else if (css.directionFlag == 2 && css.text_align == 3) {
                                            css.text_align = 1;
                                            int tmp = css.margin_right;
                                            css.margin_right = css.margin_left;
                                            css.margin_left = tmp;
                                            tmp = css.padding_right;
                                            css.padding_right = css.padding_left;
                                            css.padding_left = tmp;
                                        }
                                        if ((css.position == 6 || css.position == 126 || css.position == 125) && e.getNameId() == 87) {
                                            css.position = 124;
                                        }
                                        if (this._highContrastPropertySupport.isHighContrastEnabled()) {
                                            DAnchorElement ae;
                                            Color highContrastTextColor = Color.white;
                                            Color highContrastBackground = Color.black;
                                            if (this._highContrastPropertySupport.useLookAndFeelColors()) {
                                                try {
                                                    highContrastTextColor = (Color)UIManager.get("EditorPane.foreground");
                                                    highContrastBackground = (Color)UIManager.get("EditorPane.background");
                                                }
                                                catch (Throwable t) {
                                                    highContrastTextColor = Color.white;
                                                    highContrastBackground = Color.black;
                                                }
                                            }
                                            css.background_color = highContrastBackground;
                                            css.background_image = null;
                                            css.background_image_url = null;
                                            css.color = e instanceof DAnchorElement ? ((ae = (DAnchorElement)e).getVisited() ? new Color(0x800080) : Color.blue) : highContrastTextColor;
                                        }
                                        switch (css.display) {
                                            case 41: {
                                                if (css.position == 126 || css.position == 6) {
                                                    css.do_floats = 0;
                                                    box = new PositionedBox(e, css, cssLayout, dynamic, parentBox.getLast());
                                                    break;
                                                }
                                                box = new BlockBox(e, css, cssLayout, dynamic);
                                                break;
                                            }
                                            case 8: {
                                                return null;
                                            }
                                            case 46: 
                                            case 47: {
                                                box = new TableBox(e, css, cssLayout);
                                                break;
                                            }
                                            case 55: {
                                                box = new TableCellBox(e, css, cssLayout);
                                                tableReq = true;
                                                break;
                                            }
                                            case 52: {
                                                box = new TableColBox(e, css, cssLayout, true);
                                                tableReq = true;
                                                break;
                                            }
                                            case 53: {
                                                box = new TableColBox(e, css, cssLayout, false);
                                                tableReq = true;
                                                break;
                                            }
                                            case 48: 
                                            case 49: 
                                            case 50: {
                                                box = new TableRowGroupBox(e, css, cssLayout);
                                                tableReq = true;
                                                break;
                                            }
                                            case 51: {
                                                box = new TableRowBox(e, css, cssLayout);
                                                tableReq = true;
                                                break;
                                            }
                                            case 54: {
                                                box = new TableCellBox(e, css, cssLayout);
                                                tableReq = true;
                                                break;
                                            }
                                            default: {
                                                if (css.position == 126 || css.position == 6) {
                                                    css.do_floats = 0;
                                                    box = new PositionedBox(e, css, cssLayout, dynamic, parentBox.getLast());
                                                    break;
                                                }
                                                box = (css.do_floats & 3) != 0 ? new BlockBox(e, css, cssLayout, dynamic) : (e.tagId == 15 ? new ButtonBox(e, css, cssLayout, dynamic) : new InlineBox(e, css, cssLayout, dynamic));
                                            }
                                        }
                                        if (css.position == 126) {
                                            cssLayout.addAbsoluteBox(box, parentBox);
                                        } else if ((css.do_floats & 3) != 0) {
                                            FloatBox floatPlaceholder = new FloatBox(e, box);
                                            if (parentBox != null) {
                                                parentBox = parentBox.addChild(floatPlaceholder);
                                            }
                                        } else if (css.position == 124 || css.position == 125) {
                                            if (parentBox != null) {
                                                if (tableReq && parentBox instanceof BlockBox) {
                                                    CSSAttribs a = new CSSAttribs(this.sdata, css);
                                                    a.display = 46;
                                                    TableBox tb = new TableBox(null, a, cssLayout);
                                                    parentBox.addChild(tb);
                                                    parentBox = tb.addChild(box);
                                                } else {
                                                    parentBox = parentBox.addChild(box);
                                                }
                                            }
                                        } else if (css.position == 6) {
                                            cssLayout.addFixedBox(box);
                                        }
                                        if (css.position == 125) {
                                            cssLayout.addRelativeBox(box, parentBox);
                                        }
                                        listStyle = 0;
                                        Object var15_22 = null;
                                        if ((pseudo & 8) != 0) {
                                            break;
                                        }
                                        break block159;
                                    }
                                    while (d2 != null) {
                                        if (d2.id == 36) {
                                            if (d2.type == -13) {
                                                this.countersToReset = (Vector)d2.value;
                                            }
                                        } else if (d2.id == 35) {
                                            if (d2.type == -13) {
                                                this.countersToInc = (Vector)d2.value;
                                            }
                                        } else if (d2.id == 1000) {
                                            HtmlToCss.apply(e, css, parentBox, cssLayout.zoom);
                                        } else {
                                            CSSLookup.apply(css, d2, cssLayout.zoom, parentCss);
                                        }
                                        d2 = d2.next;
                                    }
                                }
                                ++i;
                            }
                            content = null;
                            c = new CSSAttribs(this.sdata, css);
                            boolean bl = false;
                            while (true) {
                                void var19_38;
                                block165: {
                                    CSSDecl d3;
                                    block166: {
                                        block164: {
                                            if (var19_38 >= this.numBlocks) break block164;
                                            if ((this.pseudo_value[var19_38] & 8) == 0) break block165;
                                            d3 = this.blocks[var19_38];
                                            break block166;
                                        }
                                        this.checkCounters(e, cssLayout);
                                        if (content != null) {
                                            enumeratedTextArray = this.parseContentTokens(content);
                                            break;
                                        }
                                        break block159;
                                    }
                                    while (d3 != null) {
                                        if (d3.id == 36) {
                                            if (d3.type == -13) {
                                                this.countersToReset = (Vector)d3.value;
                                            }
                                        } else if (d3.id == 35) {
                                            if (d3.type == -13) {
                                                this.countersToInc = (Vector)d3.value;
                                            }
                                        } else if (d3.id == 34) {
                                            if (d3.type == -1) {
                                                content = (String)d3.value;
                                            }
                                        } else {
                                            CSSLookup.apply(c, d3, cssLayout.zoom, parentCss);
                                        }
                                        d3 = d3.next;
                                    }
                                }
                                ++var19_38;
                            }
                            block39: for (int idx = 0; idx < enumeratedTextArray.length; ++idx) {
                                void var15_29;
                                String string = enumeratedTextArray[idx].getContent();
                                Object var15_24 = null;
                                switch (enumeratedTextArray[idx].getType()) {
                                    case 1: {
                                        String string2 = string.substring(string.indexOf(40) + 1, string.indexOf(41));
                                        stemp = e.getAttribute(string2);
                                        DTextNode tn = e.getOwnerDDocument().createDTextNode(stemp);
                                        TextBox textBox = new TextBox(tn, cssLayout);
                                        break;
                                    }
                                    case 2: {
                                        void var20_73;
                                        String counterName = null;
                                        int tmp1 = string.indexOf(44);
                                        if (tmp1 > 8) {
                                            counterName = string.substring(8, tmp1).trim();
                                            String style = string.substring(tmp1 + 1, string.length() - 1).trim();
                                            listStyle = CSSLookup.getListStyle(style);
                                        } else {
                                            counterName = string.substring(8, string.length() - 1).trim();
                                            listStyle = css.listStyleType;
                                        }
                                        if (listStyle == 97 || listStyle == 98 || listStyle == 99 || listStyle == 8) {
                                            Object var20_71 = null;
                                        } else {
                                            String string3 = cssLayout.getCounterValue(counterName, false, null, listStyle) + ".";
                                        }
                                        this.doList((String)var20_73, listStyle, e, cssLayout, c, css, box, true);
                                        continue block39;
                                    }
                                    case 3: {
                                        void var20_75;
                                        String listStyleType = "disc";
                                        int tmp1 = string.indexOf(44);
                                        if (tmp1 <= 9) continue block39;
                                        String counterName = string.substring(9, tmp1).trim();
                                        String sep = null;
                                        int tmp2 = string.indexOf(tmp1 + 1, 44);
                                        if (tmp2 > 0) {
                                            sep = string.substring(tmp1 + 1, tmp2).trim();
                                            listStyleType = string.substring(tmp2 + 1, string.length() - 1).trim();
                                        } else {
                                            sep = string.substring(tmp1 + 1, string.length() - 1).trim();
                                        }
                                        if (counterName != null) {
                                            String string4 = cssLayout.getCounterValue(counterName, true, ".", 100);
                                        }
                                        this.doList((String)var20_75, listStyle, e, cssLayout, c, css, box, true);
                                        continue block39;
                                    }
                                    case 9: {
                                        cssLayout.pseudoBefore = new BreakBox(e, c, cssLayout);
                                        Object var15_26 = null;
                                        break;
                                    }
                                    case 0: {
                                        DTextNode tn = e.getOwnerDDocument().createDTextNode(string);
                                        TextBox textBox = new TextBox(tn, cssLayout);
                                        break;
                                    }
                                    case 4: {
                                        int spos = string.indexOf("(");
                                        int epos = string.indexOf(")");
                                        if (spos <= 0 || epos <= 0) break;
                                        String string5 = string.substring(spos + 1, epos);
                                        break;
                                    }
                                    case 5: 
                                    case 6: {
                                        DTextNode tn = e.getOwnerDDocument().createDTextNode("\"");
                                        TextBox textBox = new TextBox(tn, cssLayout);
                                        break;
                                    }
                                    case 7: 
                                    case 8: {
                                        break;
                                    }
                                    default: {
                                        Debug.p("Unknown start tag: " + enumeratedTextArray[idx].getType() + ", -> " + enumeratedTextArray[idx].getContent());
                                    }
                                }
                                if (var15_29 == null) continue;
                                if (cssLayout.pseudoBefore == null) {
                                    cssLayout.pseudoBefore = new InlineBox(e, c, cssLayout, 0);
                                }
                                cssLayout.pseudoBefore.addChild((CSSBox)var15_29);
                            }
                        }
                        if ((pseudo & 0x10) == 0) break block160;
                        content = null;
                        c = new CSSAttribs(this.sdata, css);
                        int i = 0;
                        while (true) {
                            block168: {
                                void var19_41;
                                block169: {
                                    block167: {
                                        if (i >= this.numBlocks) break block167;
                                        if ((this.pseudo_value[i] & 0x10) == 0) break block168;
                                        CSSDecl cSSDecl = this.blocks[i];
                                        break block169;
                                    }
                                    if (content != null) {
                                        tokens = this.parseContentTokens(content);
                                        boolean bl = false;
                                        break;
                                    }
                                    break block160;
                                }
                                while (var19_41 != null) {
                                    if (var19_41.id == 34) {
                                        if (var19_41.type == -1) {
                                            content = (String)var19_41.value;
                                        }
                                    } else {
                                        CSSLookup.apply(c, (CSSDecl)var19_41, cssLayout.zoom, parentCss);
                                    }
                                    CSSDecl cSSDecl = var19_41.next;
                                }
                            }
                            ++i;
                        }
                        while (var20_79 < tokens.length) {
                            block170: {
                                void var15_30;
                                String string = tokens[var20_79].getContent();
                                switch (tokens[var20_79].getType()) {
                                    case 1: {
                                        String string6 = string.substring(string.indexOf(40) + 1, string.indexOf(41));
                                        stemp = e.getAttribute(string6).trim();
                                        DTextNode tn = e.getOwnerDDocument().createDTextNode(stemp);
                                        TextBox textBox = new TextBox(tn, cssLayout);
                                        break;
                                    }
                                    case 2: {
                                        void var19_47;
                                        String counterName = null;
                                        int tmp1 = string.indexOf(44);
                                        if (tmp1 > 8) {
                                            counterName = string.substring(8, tmp1).trim();
                                            String style = string.substring(tmp1 + 1, string.length() - 1).trim();
                                            listStyle = CSSLookup.getListStyle(style);
                                        } else {
                                            counterName = string.substring(8, string.length() - 1).trim();
                                            listStyle = css.listStyleType;
                                        }
                                        if (listStyle == 97 || listStyle == 98 || listStyle == 99 || listStyle == 8) {
                                            Object var19_45 = null;
                                        } else {
                                            String string7 = cssLayout.getCounterValue(counterName, false, null, listStyle) + ".";
                                        }
                                        this.doList((String)var19_47, listStyle, e, cssLayout, c, css, box, false);
                                        break block170;
                                    }
                                    case 3: {
                                        String counterName;
                                        String listStyleType = "disc";
                                        int tmp1 = string.indexOf(44);
                                        if (tmp1 > 9) {
                                            void var19_49;
                                            counterName = string.substring(9, tmp1).trim();
                                            String sep = null;
                                            int tmp2 = string.indexOf(tmp1 + 1, 44);
                                            if (tmp2 > 0) {
                                                sep = string.substring(tmp1 + 1, tmp2).trim();
                                                listStyleType = string.substring(tmp2 + 1, string.length() - 1).trim();
                                            } else {
                                                sep = string.substring(tmp1 + 1, string.length() - 1).trim();
                                            }
                                            if (counterName != null) {
                                                String string8 = cssLayout.getCounterValue(counterName, true, ".", 100);
                                            }
                                            this.doList((String)var19_49, listStyle, e, cssLayout, c, css, box, false);
                                        }
                                        break block170;
                                    }
                                    case 9: {
                                        BreakBox breakBox = new BreakBox(e, c, cssLayout);
                                        break;
                                    }
                                    case 0: {
                                        DTextNode tn = e.getOwnerDDocument().createDTextNode(string);
                                        TextBox textBox = new TextBox(tn, cssLayout);
                                        break;
                                    }
                                    case 4: {
                                        int spos = string.indexOf("(");
                                        int epos = string.indexOf(")");
                                        if (spos <= 0 || epos <= 0) break;
                                        String string9 = string.substring(spos + 1, epos);
                                        break;
                                    }
                                    case 5: 
                                    case 6: {
                                        DTextNode tn = e.getOwnerDDocument().createDTextNode("\"");
                                        TextBox textBox = new TextBox(tn, cssLayout);
                                        break;
                                    }
                                    case 7: 
                                    case 8: 
                                }
                                if (var15_30 != null) {
                                    if (cssLayout.pseudoAfter == null) {
                                        cssLayout.pseudoAfter = new InlineBox(e, c, cssLayout, 0);
                                    }
                                    cssLayout.pseudoAfter.addChild((CSSBox)var15_30);
                                }
                            }
                            ++var20_79;
                        }
                    }
                    if (dynamic <= 0) break block171;
                    box.dynamic = dynamic;
                    CSSAttribs[] atrs = new CSSAttribs[4];
                    atrs[0] = css;
                    cssLayout.dynamicStyles.put(e, atrs);
                    if ((pseudo & 1) == 0) break block172;
                    pcss = css;
                    boolean fromParent = false;
                    if (parentBox != null) {
                        pcss = cssLayout.getDynamicStyle(parentBox, 1);
                        if (pcss == null) {
                            pcss = css;
                        } else {
                            fromParent = true;
                        }
                    }
                    CSSAttribs cSSAttribs = new CSSAttribs(this.sdata, pcss);
                    boolean bl = false;
                    while (var20_81 < this.numBlocks) {
                        pv = this.pseudo_value[var20_81];
                        if ((pv & 1) != 0 || fromParent && pv == 0) {
                            this.updateFontSize(cSSAttribs, this.blocks[var20_81], cssLayout);
                        }
                        ++var20_81;
                    }
                    boolean bl2 = false;
                    while (true) {
                        void var20_83;
                        block174: {
                            block175: {
                                block173: {
                                    if (var20_83 >= this.numBlocks) break block173;
                                    pv = this.pseudo_value[var20_83];
                                    if (pv != 0) break block174;
                                    d = this.blocks[var20_83];
                                    break block175;
                                }
                                boolean bl3 = false;
                                break;
                            }
                            while (d != null) {
                                if (d.id == 1000) {
                                    HtmlToCss.apply(e, cSSAttribs, parentBox, cssLayout.zoom);
                                } else {
                                    CSSLookup.apply(cSSAttribs, d, cssLayout.zoom, pcss);
                                }
                                d = d.next;
                            }
                        }
                        ++var20_83;
                    }
                    while (var20_85 < this.numBlocks) {
                        pv = this.pseudo_value[var20_85];
                        if ((pv & 1) != 0) {
                            d = this.blocks[var20_85];
                            while (d != null) {
                                CSSLookup.apply(cSSAttribs, d, cssLayout.zoom, pcss);
                                d = d.next;
                            }
                        }
                        ++var20_85;
                    }
                    atrs[1] = cSSAttribs;
                    this.checkOutline(cSSAttribs, cssLayout);
                }
                if ((pseudo & 2) == 0) break block176;
                pcss = css;
                boolean fromParent = false;
                if (parentBox != null) {
                    pcss = cssLayout.getDynamicStyle(parentBox, 2);
                    if (pcss == null) {
                        pcss = css;
                    } else {
                        fromParent = true;
                    }
                }
                CSSAttribs cSSAttribs = new CSSAttribs(this.sdata, pcss);
                boolean bl = false;
                while (var20_87 < this.numBlocks) {
                    pv = this.pseudo_value[var20_87];
                    if ((pv & 3) != 0 || fromParent && pv == 0) {
                        this.updateFontSize(cSSAttribs, this.blocks[var20_87], cssLayout);
                    }
                    ++var20_87;
                }
                boolean bl4 = false;
                while (true) {
                    void var20_89;
                    block178: {
                        block179: {
                            block177: {
                                if (var20_89 >= this.numBlocks) break block177;
                                pv = this.pseudo_value[var20_89];
                                if (pv != 0) break block178;
                                d = this.blocks[var20_89];
                                break block179;
                            }
                            boolean bl5 = false;
                            break;
                        }
                        while (d != null) {
                            if (d.id == 1000) {
                                HtmlToCss.apply(e, cSSAttribs, parentBox, cssLayout.zoom);
                            } else {
                                CSSLookup.apply(cSSAttribs, d, cssLayout.zoom, pcss);
                            }
                            d = d.next;
                        }
                    }
                    ++var20_89;
                }
                while (var20_91 < this.numBlocks) {
                    pv = this.pseudo_value[var20_91];
                    if ((pv & 3) != 0) {
                        d = this.blocks[var20_91];
                        while (d != null) {
                            CSSLookup.apply(cSSAttribs, d, cssLayout.zoom, pcss);
                            d = d.next;
                        }
                    }
                    ++var20_91;
                }
                atrs[2] = cSSAttribs;
                this.checkOutline(cSSAttribs, cssLayout);
            }
            if ((pseudo & 4) == 0) break block171;
            pcss = css;
            boolean fromParent = false;
            if (parentBox != null) {
                pcss = cssLayout.getDynamicStyle(parentBox, 3);
                if (pcss == null) {
                    pcss = css;
                } else {
                    fromParent = true;
                }
            }
            CSSAttribs cSSAttribs = new CSSAttribs(this.sdata, pcss);
            boolean bl = false;
            while (var20_93 < this.numBlocks) {
                pv = this.pseudo_value[var20_93];
                if ((pv & 4) != 0 || fromParent && pv == 0) {
                    this.updateFontSize(cSSAttribs, this.blocks[var20_93], cssLayout);
                }
                ++var20_93;
            }
            boolean bl6 = false;
            while (true) {
                void var20_95;
                block181: {
                    block182: {
                        block180: {
                            if (var20_95 >= this.numBlocks) break block180;
                            pv = this.pseudo_value[var20_95];
                            if (pv != 0) break block181;
                            d = this.blocks[var20_95];
                            break block182;
                        }
                        boolean bl7 = false;
                        break;
                    }
                    while (d != null) {
                        if (d.id == 1000) {
                            HtmlToCss.apply(e, cSSAttribs, parentBox, cssLayout.zoom);
                        } else {
                            CSSLookup.apply(cSSAttribs, d, cssLayout.zoom, pcss);
                        }
                        d = d.next;
                    }
                }
                ++var20_95;
            }
            while (var20_97 < this.numBlocks) {
                pv = this.pseudo_value[var20_97];
                if ((pv & 4) != 0) {
                    d = this.blocks[var20_97];
                    while (d != null) {
                        CSSLookup.apply(cSSAttribs, d, cssLayout.zoom, pcss);
                        d = d.next;
                    }
                }
                ++var20_97;
            }
            atrs[3] = cSSAttribs;
            this.checkOutline(cSSAttribs, cssLayout);
        }
        if (!cssLayout.getPrintBack() && css.background_color != null) {
            css.background_color = Color.white;
        }
        if ((css.misc & 0x10) == 0) return box;
        if (!(box instanceof BlockBox)) return box;
        CSSAttribs a = new CSSAttribs(this.sdata, css);
        a.display = 41;
        a.percentage_flag |= 0x100008;
        a.width = 100;
        a.height = 100;
        a.stealBackgroundFrom(css);
        ScrollBox b = new ScrollBox(e, a, cssLayout, 0);
        box.addChild(b);
        return b;
    }

    private void doList(String token, int listStyle, DElement e, CSSLayout cssLayout, CSSAttribs c, CSSAttribs css, CSSBox box, boolean toBeforeHierarchy) {
        if (token != null && token.length() == 0) {
            token = null;
        }
        CSSBox b = null;
        CSSBox b2 = null;
        if (token != null || listStyle != 0) {
            if (token != null) {
                DTextNode tn = e.getOwnerDDocument().createDTextNode(token);
                b = new TextBox(tn, cssLayout);
            } else {
                b = new BulletBox(e, c, listStyle, cssLayout);
            }
            b2 = !(c.display != 41 && c.display != 45 || css.text_align != 1 && css.text_align != 15 && css.directionFlag != 1) ? new BlockBox(e, c, cssLayout, 0) : new InlineBox(e, c, cssLayout, 0);
            b2 = b2.addChild(b);
            if (c.display == 45 && (css.text_align == 1 || css.text_align == 15 || css.directionFlag == 1)) {
                if (box instanceof BlockBox) {
                    ((BlockBox)box).markerBefore = (BlockBox)b2;
                    b2.setParentBox(box);
                }
            } else if (toBeforeHierarchy) {
                if (cssLayout.pseudoBefore == null) {
                    cssLayout.pseudoBefore = b2;
                } else {
                    cssLayout.pseudoBefore.addChild(b2);
                }
            } else if (cssLayout.pseudoAfter == null) {
                cssLayout.pseudoAfter = b2;
            } else {
                cssLayout.pseudoAfter.addChild(b2);
            }
        }
    }

    private EnumeratedText[] parseContentTokens(String content) {
        Vector<EnumeratedText> v = new Vector<EnumeratedText>();
        int spos = 0;
        int epos = 0;
        if (content.equalsIgnoreCase("\\A")) {
            EnumeratedText et = new EnumeratedText();
            et.setContent("\\A");
            et.setType(9);
            v.addElement(et);
        } else {
            char[] buf = content.toCharArray();
            block0: while (true) {
                EnumeratedText et = new EnumeratedText();
                epos = this.findStartAndEndToken(buf, spos, "\"", '\"');
                if (epos > 0) {
                    ++spos;
                    --epos;
                    et.setType(0);
                } else {
                    epos = this.findStartAndEndToken(buf, spos, "'", '\'');
                    if (epos > 0) {
                        ++spos;
                        --epos;
                        et.setType(0);
                    } else {
                        epos = this.findStartAndEndToken(buf, spos, "url", ')');
                        if (epos > 0) {
                            et.setType(4);
                        } else {
                            epos = this.findStartAndEndToken(buf, spos, "counters", ')');
                            if (epos > 0) {
                                et.setType(3);
                            } else {
                                epos = this.findStartAndEndToken(buf, spos, "counter", ')');
                                if (epos > 0) {
                                    et.setType(2);
                                } else {
                                    epos = this.findStartAndEndToken(buf, spos, "attr", ')');
                                    if (epos > 0) {
                                        et.setType(1);
                                    } else {
                                        epos = this.findStartAndEndToken(buf, spos, "open-quote", '\u0000');
                                        if (epos > 0) {
                                            et.setType(5);
                                        } else {
                                            epos = this.findStartAndEndToken(buf, spos, "close-quote", '\u0000');
                                            if (epos > 0) {
                                                et.setType(6);
                                            } else {
                                                epos = this.findStartAndEndToken(buf, spos, "no-open-quote", '\u0000');
                                                if (epos > 0) {
                                                    et.setType(7);
                                                } else {
                                                    epos = this.findStartAndEndToken(buf, spos, "no-close-quote", '\u0000');
                                                    if (epos > 0) {
                                                        et.setType(8);
                                                    } else {
                                                        et.setType(0);
                                                        epos = content.indexOf(34, spos);
                                                        if (epos <= 0) {
                                                            et.setContent(content.substring(spos));
                                                            v.addElement(et);
                                                            break;
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
                if (spos < 0 || epos <= 0) break;
                String token = content.substring(spos, epos).trim();
                if (!token.equalsIgnoreCase("")) {
                    et.setContent(token);
                    v.addElement(et);
                }
                if (epos >= content.length() - 1) break;
                spos = epos + 1;
                while (true) {
                    if (spos >= buf.length || buf[spos] != ' ') continue block0;
                    ++spos;
                }
                break;
            }
        }
        Object[] returnVal = new EnumeratedText[v.size()];
        v.copyInto(returnVal);
        return returnVal;
    }

    private int findStartAndEndToken(char[] buf, int spos, String token, char endToken) {
        if (spos + token.length() > buf.length) {
            return -1;
        }
        int pos = spos;
        for (int idx = 0; idx < token.length(); ++idx) {
            char c2;
            char c = token.charAt(idx);
            if (c >= 'a' && c <= 'z') {
                c = (char)(c - 32);
            }
            if ((c2 = buf[spos + idx]) >= 'a' && c2 <= 'z') {
                c2 = (char)(c2 - 32);
            }
            if (c2 != c) {
                return -1;
            }
            ++pos;
        }
        if (endToken == '\u0000') {
            return pos;
        }
        ++pos;
        while (pos < buf.length) {
            if (buf[pos] == endToken) {
                return ++pos;
            }
            ++pos;
        }
        return -1;
    }

    private final void checkCounters(DElement e, CSSLayout cssLayout) {
        int t;
        String s;
        if (this.countersToReset != null) {
            if (e.tagId == 61 && (s = e.getAttribute(104)) != null && 0 <= (t = CSSUtil.parseInt(s, -1))) {
                Vector<Object> v = new Vector<Object>();
                v.addElement("_hcount");
                v.addElement(new Integer(t - 1));
                cssLayout.resetCounters(v);
                this.countersToReset = null;
                return;
            }
            cssLayout.resetCounters(this.countersToReset);
            this.countersToReset = null;
        }
        if (this.countersToInc != null) {
            if (e.tagId == 53 && (s = e.getAttribute(114)) != null && 0 <= (t = CSSUtil.parseInt(s, -1))) {
                Vector<Object> v = new Vector<Object>();
                v.addElement("_hcount");
                v.addElement(new Integer(t));
                cssLayout.updateCounters(v);
                this.countersToInc = null;
                return;
            }
            cssLayout.incCounters(this.countersToInc);
            this.countersToInc = null;
        }
    }

    private final void checkOutline(CSSAttribs c, CSSLayout cssLayout) {
        if (c.outline_width > 0) {
            if (c.outline_style == 8) {
                c.outline_width = 0;
            } else {
                c.misc = (short)(c.misc | 2);
                if (c.outline_width > cssLayout.maxOutlineWidth) {
                    cssLayout.maxOutlineWidth = c.outline_width;
                }
            }
        }
    }

    private final void updateFontSize(CSSAttribs c, CSSDecl d, CSSLayout cl) {
        while (d != null) {
            if (d.id == 46) {
                c.font_size = CSSLookup.computeFontSize(this.sdata, d, c, cl.zoom);
            }
            d = d.next;
        }
    }

    private final byte makeStyleBlocks(DElement e) {
        String classes;
        this.numBlocks = 0;
        DCSSRule universalRule = this.curSelectors[0];
        DCSSRule tagRule = null;
        if (e.tagId < this.curSelectors.length) {
            tagRule = this.curSelectors[e.tagId];
        }
        if ((classes = e.getAttribute(21)) != null && classes.length() > 0) {
            byte pseudo = 0;
            StringTokenizer tokenizer = new StringTokenizer(classes);
            while (tokenizer.hasMoreTokens()) {
                String cn = tokenizer.nextToken();
                DCSSRule classRule = !DDocument.STRICT ? (DCSSRule)this.universalSelectorsByClass.get(cn.toLowerCase()) : (DCSSRule)this.universalSelectorsByClass.get(cn);
                pseudo = (byte)(pseudo | this.sortCascadingStyles(universalRule, tagRule, classRule, e));
            }
            return pseudo;
        }
        return this.sortCascadingStyles(universalRule, tagRule, null, e);
    }

    private byte sortCascadingStyles(DCSSRule universalRule, DCSSRule tagRule, DCSSRule classRule, DElement e) {
        byte pseudo = 0;
        while (universalRule != null || tagRule != null || classRule != null) {
            int toupdate;
            int classRuleWeight = 99999999;
            int tagRuleWeight = 99999999;
            int universalRuleWeight = 99999999;
            int next_change = 99999999;
            if (universalRule != null) {
                universalRuleWeight = universalRule.sel.weight;
            }
            if (tagRule != null) {
                tagRuleWeight = tagRule.sel.weight;
            }
            if (classRule != null) {
                classRuleWeight = classRule.sel.weight;
            }
            DCSSRule r = null;
            if (universalRuleWeight <= tagRuleWeight) {
                if (universalRuleWeight <= classRuleWeight) {
                    r = universalRule;
                    toupdate = 0;
                    next_change = tagRuleWeight <= classRuleWeight ? tagRuleWeight : classRuleWeight;
                } else {
                    r = classRule;
                    toupdate = 2;
                    next_change = universalRuleWeight;
                }
            } else if (tagRuleWeight <= classRuleWeight) {
                r = tagRule;
                toupdate = 1;
                next_change = universalRuleWeight <= classRuleWeight ? universalRuleWeight : classRuleWeight;
            } else {
                r = classRule;
                toupdate = 2;
                next_change = tagRuleWeight;
            }
            while (r != null && r.sel.weight <= next_change) {
                if (r.sel.match(e)) {
                    this.appendBlock(r.decl.firstDecl);
                    this.pseudo_value[this.numBlocks - 1] = r.sel.pseudo;
                    pseudo = (byte)(pseudo | r.sel.pseudo);
                }
                r = r._next;
            }
            if (toupdate == 0) {
                universalRule = r;
                continue;
            }
            if (toupdate == 1) {
                tagRule = r;
                continue;
            }
            if (toupdate != 2) continue;
            classRule = r;
        }
        return pseudo;
    }

    private void makeInlineStyle(DElement e) {
        CSSDecl d;
        DStyleDeclaration s = e.inlineStyle;
        if (s != null && (d = s.firstDecl) != null) {
            this.appendBlock(d);
            this.pseudo_value[this.numBlocks - 1] = 0;
        }
    }

    private final void appendBlock(CSSDecl d) {
        if (this.numBlocks >= this.blocks.length) {
            CSSDecl[] tmp = new CSSDecl[this.blocks.length * 2];
            System.arraycopy(this.blocks, 0, tmp, 0, this.blocks.length);
            this.blocks = tmp;
            byte[] tmp1 = new byte[this.pseudo_value.length * 2];
            System.arraycopy(this.pseudo_value, 0, tmp1, 0, this.pseudo_value.length);
            this.pseudo_value = tmp1;
        }
        this.blocks[this.numBlocks++] = d;
    }

    private static class HighContrastPropertySupport
    implements PropertyChangeListener {
        private volatile boolean _highContrastModeEnabled = false;
        private volatile boolean _setViaWindowsProperty = false;
        private final StormBase _stormBase;

        public HighContrastPropertySupport(StormBase stormBase, Toolkit toolkit) {
            this._stormBase = stormBase;
            this._init();
            toolkit.addPropertyChangeListener(CSSMatcher._WIN_HIGH_CONTRAST_DESKTOP_PROPERTY, this);
        }

        public boolean isHighContrastEnabled() {
            return this._highContrastModeEnabled;
        }

        public boolean useLookAndFeelColors() {
            return this._setViaWindowsProperty;
        }

        public void propertyChange(PropertyChangeEvent evt) {
            if (this._setViaWindowsProperty && CSSMatcher._WIN_HIGH_CONTRAST_DESKTOP_PROPERTY.equals(evt.getPropertyName())) {
                this._highContrastModeEnabled = this._getWindowsHighContrastProperty();
                ActionListener refreshTask = new ActionListener(){

                    public void actionPerformed(ActionEvent evt) {
                        Viewport activeViewport = HighContrastPropertySupport.this._stormBase.getActiveViewport();
                        if (activeViewport != null) {
                            HighContrastPropertySupport.this._stormBase.getHistoryManager().reload(activeViewport.getId());
                        }
                    }
                };
                Timer swingTimer = new Timer(2000, refreshTask);
                swingTimer.setRepeats(false);
                swingTimer.start();
            }
        }

        private void _init() {
            String iceSystemProperty = Defs.property(CSSMatcher._ICE_HIGH_CONTRAST_SYSTEM_PROPERTY, "default");
            if ("true".equals(iceSystemProperty)) {
                this._highContrastModeEnabled = true;
            } else if ("false".equals(iceSystemProperty)) {
                this._highContrastModeEnabled = false;
            } else {
                this._highContrastModeEnabled = this._getWindowsHighContrastProperty();
                this._setViaWindowsProperty = true;
            }
        }

        private boolean _getWindowsHighContrastProperty() {
            Object desktopProperty = null;
            try {
                desktopProperty = Toolkit.getDefaultToolkit().getDesktopProperty(CSSMatcher._WIN_HIGH_CONTRAST_DESKTOP_PROPERTY);
            }
            catch (Throwable t) {
                desktopProperty = null;
            }
            if (desktopProperty instanceof Boolean) {
                return (Boolean)desktopProperty;
            }
            return false;
        }
    }

    class EnumeratedText {
        static final int TEXT = 0;
        static final int ATTR = 1;
        static final int COUNTER = 2;
        static final int COUNTERS = 3;
        static final int URL = 4;
        static final int OPEN_QUOTE = 5;
        static final int CLOSE_QUOTE = 6;
        static final int NO_OPEN_QUOTE = 7;
        static final int NO_CLOSE_QUOTE = 8;
        static final int BREAK = 9;
        String text;
        int key;

        EnumeratedText() {
        }

        public void setContent(String content) {
            this.text = content;
        }

        public void setType(int type) {
            this.key = type;
        }

        public String getContent() {
            return this.text;
        }

        public int getType() {
            return this.key;
        }
    }
}

