/*
 * Decompiled with CFR 0.152.
 */
package ice.mozilla.javascript;

import ice.mozilla.javascript.Node;

public final class PreorderNodeIterator {
    private Node start;
    private Node[] stack;
    private int stackTop;
    private Node current;
    private Node cachedPrev;

    public PreorderNodeIterator(Node n) {
        this.start = n;
    }

    public Node currentNode() {
        return this.current;
    }

    public Node getCurrentParent() {
        return this.stack[this.stackTop - 1];
    }

    public Node nextNode() {
        if (this.current == null) {
            this.current = this.start;
        } else {
            Node first = this.current.getFirstChild();
            if (first != null) {
                this.stackPush(this.current);
                this.cachedPrev = null;
                this.current = first;
            } else {
                while (true) {
                    this.cachedPrev = this.current;
                    this.current = this.current.next;
                    if (this.current != null) break;
                    if (this.stackTop == 0) {
                        this.cachedPrev = null;
                        break;
                    }
                    --this.stackTop;
                    this.current = this.stack[this.stackTop];
                    this.stack[this.stackTop] = null;
                }
            }
        }
        return this.current;
    }

    public void replaceCurrent(Node newNode) {
        Node parent = this.stack[this.stackTop - 1];
        if (this.cachedPrev != null && this.cachedPrev.next == this.current) {
            parent.replaceChildAfter(this.cachedPrev, newNode);
        } else {
            parent.replaceChild(this.current, newNode);
        }
        this.current = newNode;
    }

    public void addBeforeCurrent(Node newNode) {
        Node parent = this.stack[this.stackTop - 1];
        if (this.cachedPrev != null && this.cachedPrev.next == this.current) {
            parent.addChildAfter(newNode, this.cachedPrev);
        } else {
            parent.addChildBefore(newNode, this.current);
        }
        this.cachedPrev = newNode;
    }

    private void stackPush(Node n) {
        int N = this.stackTop;
        if (N == 0) {
            this.stack = new Node[16];
        } else if (N == this.stack.length) {
            Node[] tmp = new Node[N * 2];
            System.arraycopy(this.stack, 0, tmp, 0, N);
            this.stack = tmp;
        }
        this.stack[N] = n;
        this.stackTop = N + 1;
    }
}

