/*
 * Decompiled with CFR 0.152.
 */
package ice.mozilla.javascript;

import ice.mozilla.javascript.Context;
import ice.mozilla.javascript.IdFunction;
import ice.mozilla.javascript.IdScriptable;
import ice.mozilla.javascript.JavaScriptException;
import ice.mozilla.javascript.ScriptRuntime;
import ice.mozilla.javascript.Scriptable;

final class NativeBoolean
extends IdScriptable {
    private static final int Id_constructor = 1;
    private static final int Id_toString = 2;
    private static final int Id_valueOf = 3;
    private static final int MAX_PROTOTYPE_ID = 3;
    private boolean booleanValue;
    private boolean prototypeFlag;

    static void init(Context cx, Scriptable scope, boolean sealed) {
        NativeBoolean obj = new NativeBoolean(false);
        obj.prototypeFlag = true;
        obj.addAsPrototype(3, cx, scope, sealed);
    }

    private NativeBoolean(boolean b) {
        this.booleanValue = b;
    }

    public String getClassName() {
        return "Boolean";
    }

    public Object getDefaultValue(Class typeHint) {
        if (typeHint == ScriptRuntime.BooleanClass) {
            return this.wrap_boolean(this.booleanValue);
        }
        return super.getDefaultValue(typeHint);
    }

    public int methodArity(int methodId) {
        if (this.prototypeFlag) {
            if (methodId == 1) {
                return 1;
            }
            if (methodId == 2) {
                return 0;
            }
            if (methodId == 3) {
                return 0;
            }
        }
        return super.methodArity(methodId);
    }

    public Object execMethod(int methodId, IdFunction f, Context cx, Scriptable scope, Scriptable thisObj, Object[] args) throws JavaScriptException {
        if (this.prototypeFlag) {
            if (methodId == 1) {
                boolean b = ScriptRuntime.toBoolean(args, 0);
                if (thisObj == null) {
                    return new NativeBoolean(b);
                }
                return this.wrap_boolean(b);
            }
            if (methodId == 2) {
                return this.realThis((Scriptable)thisObj, (IdFunction)f).booleanValue ? "true" : "false";
            }
            if (methodId == 3) {
                return this.wrap_boolean(this.realThis((Scriptable)thisObj, (IdFunction)f).booleanValue);
            }
        }
        return super.execMethod(methodId, f, cx, scope, thisObj, args);
    }

    private NativeBoolean realThis(Scriptable thisObj, IdFunction f) {
        while (!(thisObj instanceof NativeBoolean)) {
            thisObj = this.nextInstanceCheck(thisObj, f, true);
        }
        return (NativeBoolean)thisObj;
    }

    protected String getIdName(int id) {
        if (this.prototypeFlag) {
            if (id == 1) {
                return "constructor";
            }
            if (id == 2) {
                return "toString";
            }
            if (id == 3) {
                return "valueOf";
            }
        }
        return null;
    }

    protected int mapNameToId(String s) {
        if (!this.prototypeFlag) {
            return 0;
        }
        int id = 0;
        String X = null;
        int s_length = s.length();
        if (s_length == 7) {
            X = "valueOf";
            id = 3;
        } else if (s_length == 8) {
            X = "toString";
            id = 2;
        } else if (s_length == 11) {
            X = "constructor";
            id = 1;
        }
        if (X != null && X != s && !X.equals(s)) {
            id = 0;
        }
        return id;
    }
}

