/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.olaf2;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.AccessController;
import java.text.Collator;
import java.text.DateFormat;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.EventObject;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.AbstractListModel;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.KeyStroke;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.RowSorterEvent;
import javax.swing.event.RowSorterListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileSystemView;
import javax.swing.plaf.ActionMapUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicFileChooserUI;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import javax.swing.text.Position;
import oracle.bali.share.nls.StringUtils;
import sun.awt.shell.ShellFolder;
import sun.security.action.GetPropertyAction;

public class OracleFileChooserUI
extends BasicFileChooserUI {
    private JPanel centerPanel;
    private JLabel lookInLabel;
    private JComboBox directoryComboBox;
    private DirectoryComboBoxModel directoryComboBoxModel;
    private Action directoryComboBoxAction = new DirectoryComboBoxAction();
    private FilterComboBoxModel filterComboBoxModel;
    private JTextField fileNameTextField;
    private JToggleButton listViewButton;
    private JToggleButton detailsViewButton;
    private JPanel listViewPanel;
    private JPanel detailsViewPanel;
    private JPanel currentViewPanel;
    private FocusListener editorFocusListener = new FocusAdapter(){

        @Override
        public void focusLost(FocusEvent e) {
            if (!e.isTemporary()) {
                OracleFileChooserUI.this.applyEdit();
            }
        }
    };
    private boolean useShellFolder;
    private ListSelectionModel listSelectionModel;
    private JList list;
    private JTable detailsTable;
    private JButton approveButton;
    private JButton cancelButton;
    private JPanel buttonPanel;
    private JPanel bottomPanel;
    private JComboBox filterComboBox;
    private static final Dimension hstrut5 = new Dimension(5, 1);
    private static final Dimension hstrut11 = new Dimension(11, 1);
    private static final Dimension vstrut5 = new Dimension(1, 5);
    private static final Insets shrinkwrap = new Insets(0, 0, 0, 0);
    private static int PREF_WIDTH = 500;
    private static int PREF_HEIGHT = 326;
    private static Dimension PREF_SIZE = new Dimension(PREF_WIDTH, PREF_HEIGHT);
    private static int MIN_WIDTH = 500;
    private static int MIN_HEIGHT = 326;
    private static Dimension MIN_SIZE = new Dimension(MIN_WIDTH, MIN_HEIGHT);
    private static int LIST_PREF_WIDTH = 405;
    private static int LIST_PREF_HEIGHT = 135;
    private static Dimension LIST_PREF_SIZE = new Dimension(LIST_PREF_WIDTH, LIST_PREF_HEIGHT);
    private static final int COLUMN_FILENAME = 0;
    private static final int COLUMN_FILESIZE = 1;
    private static final int COLUMN_FILETYPE = 2;
    private static final int COLUMN_FILEDATE = 3;
    private static final int COLUMN_FILEATTR = 4;
    private static final int COLUMN_COLCOUNT = 5;
    private int[] COLUMN_WIDTHS = new int[]{150, 75, 130, 130, 40};
    private int lookInLabelMnemonic = 0;
    private String lookInLabelText = null;
    private String saveInLabelText = null;
    private int fileNameLabelMnemonic = 0;
    private String fileNameLabelText = null;
    private int filesOfTypeLabelMnemonic = 0;
    private String filesOfTypeLabelText = null;
    private String upFolderToolTipText = null;
    private String upFolderAccessibleName = null;
    private String homeFolderToolTipText = null;
    private String homeFolderAccessibleName = null;
    private String newFolderToolTipText = null;
    private String newFolderAccessibleName = null;
    private String listViewButtonToolTipText = null;
    private String listViewButtonAccessibleName = null;
    private String detailsViewButtonToolTipText = null;
    private String detailsViewButtonAccessibleName = null;
    private String fileNameHeaderText = null;
    private String fileSizeHeaderText = null;
    private String fileTypeHeaderText = null;
    private String fileDateHeaderText = null;
    private String fileAttrHeaderText = null;
    private DetailsTableModel detailsTableModel = null;
    private TableRowSorter detailsTableRowSorter = null;
    private String listViewAccessibleName;
    int lastIndex = -1;
    File editFile = null;
    int editX = 20;
    JTextField editCell = null;
    static final int space = 10;
    private static boolean disableFileChooserSpeedFixProperty = false;
    private static final String _BUNDLE = "oracle.bali.ewt.olaf2.OLAFBundle";
    private static final String _KEY_NAME = "FILECHOOSER.NAME";
    private static final String _KEY_SIZE = "FILECHOOSER.SIZE";
    private static final String _KEY_TYPE = "FILECHOOSER.TYPE";
    private static final String _KEY_DATE = "FILECHOOSER.DATE";
    private static final String _KEY_ATTR = "FILECHOOSER.ATTR";
    private static final String _KEY_OPEN = "FILECHOOSER.OPEN";
    private static final String _KEY_SAVE = "FILECHOOSER.SAVE";
    private static final String _KEY_HELP = "COMMON.HELP";
    private static final String _KEY_CANCEL = "COMMON.CANCEL";
    private static final String _KEY_LOOKIN = "FILECHOOSER.LOOKIN";
    private static final String _KEY_FILETYPES = "FILECHOOSER.FILETYPES";
    private static final String _KEY_UP = "FILECHOOSER.UP";
    private static final String _KEY_HOME = "FILECHOOSER.HOME";
    private static final String _KEY_FOLDER = "FILECHOOSER.FOLDER";
    private static final String _KEY_PREVIEW = "FILECHOOSER.PREVIEW";
    private static final String _KEY_LIST = "FILECHOOSER.LIST";
    private static final String _KEY_DETAILS = "FILECHOOSER.DETAILS";
    private static final String _KEY_FILENAME = "FILECHOOSER.FILENAME";
    private static final String _KEY_FILES = "FILECHOOSER.FILES";
    private static final String _KEY_PREVIEW_LABEL = "FILECHOOSER.PREVIEW_LABEL";
    private static final String _KEY_READONLY = "FILECHOOSER.READONLY";
    private static final String _KEY_HIDDEN = "FILECHOOSER.HIDDEN";
    private static final String _KEY_READONLY_AND_HIDDEN = "FILECHOOSER.READONLY_AND_HIDDEN";
    private KeyListener _keyHandler;

    public static ComponentUI createUI(JComponent c) {
        return new OracleFileChooserUI((JFileChooser)c);
    }

    public OracleFileChooserUI(JFileChooser filechooser) {
        super(filechooser);
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
    }

    @Override
    public void uninstallComponents(JFileChooser fc) {
        fc.removeAll();
        this.bottomPanel = null;
        this.buttonPanel = null;
    }

    @Override
    public void installComponents(JFileChooser fc) {
        File[] cbFolders;
        FileSystemView fsv = fc.getFileSystemView();
        fc.setBorder(new EmptyBorder(12, 12, 11, 11));
        fc.setLayout(new BorderLayout(0, 11));
        JPanel topPanel = new JPanel(new BorderLayout(11, 0));
        JPanel topButtonPanel = new JPanel();
        topButtonPanel.setLayout(new BoxLayout(topButtonPanel, 2));
        topPanel.add((Component)topButtonPanel, "After");
        fc.add((Component)topPanel, "North");
        this.lookInLabel = new JLabel(this.lookInLabelText);
        this.lookInLabel.setDisplayedMnemonic(this.lookInLabelMnemonic);
        topPanel.add((Component)this.lookInLabel, "Before");
        this.directoryComboBox = new JComboBox();
        this.directoryComboBox.getAccessibleContext().setAccessibleDescription(this.lookInLabelText);
        this.directoryComboBox.putClientProperty("JComboBox.lightweightKeyboardNavigation", "Lightweight");
        this.lookInLabel.setLabelFor(this.directoryComboBox);
        this.directoryComboBoxModel = this.createDirectoryComboBoxModel(fc);
        this.directoryComboBox.setModel(this.directoryComboBoxModel);
        this.directoryComboBox.addActionListener(this.directoryComboBoxAction);
        this.directoryComboBox.setRenderer(this.createDirectoryComboBoxRenderer(fc));
        this.directoryComboBox.setAlignmentX(0.0f);
        this.directoryComboBox.setAlignmentY(0.0f);
        this.directoryComboBox.setMaximumRowCount(8);
        topPanel.add((Component)this.directoryComboBox, "Center");
        JButton upFolderButton = new JButton(this.getChangeToParentDirectoryAction());
        upFolderButton.setText(null);
        upFolderButton.setIcon(this.upFolderIcon);
        upFolderButton.setToolTipText(this.upFolderToolTipText);
        upFolderButton.getAccessibleContext().setAccessibleName(this.upFolderAccessibleName);
        upFolderButton.setAlignmentX(0.0f);
        upFolderButton.setAlignmentY(0.5f);
        upFolderButton.setMargin(shrinkwrap);
        topButtonPanel.add(upFolderButton);
        topButtonPanel.add(Box.createRigidArea(hstrut5));
        File homeDir = fsv.getHomeDirectory();
        String toolTipText = this.homeFolderToolTipText;
        if (fsv.isRoot(homeDir)) {
            toolTipText = this.getFileView(fc).getName(homeDir);
        }
        JButton b = new JButton(this.homeFolderIcon);
        b.setToolTipText(toolTipText);
        b.getAccessibleContext().setAccessibleName(this.homeFolderAccessibleName);
        b.setAlignmentX(0.0f);
        b.setAlignmentY(0.5f);
        b.setMargin(shrinkwrap);
        b.addActionListener(this.getGoHomeAction());
        topButtonPanel.add(b);
        topButtonPanel.add(Box.createRigidArea(hstrut5));
        b = new JButton(this.getNewFolderAction());
        b.setText(null);
        b.setIcon(this.newFolderIcon);
        b.setToolTipText(this.newFolderToolTipText);
        b.getAccessibleContext().setAccessibleName(this.newFolderAccessibleName);
        b.setAlignmentX(0.0f);
        b.setAlignmentY(0.5f);
        b.setMargin(shrinkwrap);
        topButtonPanel.add(b);
        topButtonPanel.add(Box.createRigidArea(hstrut5));
        ButtonGroup viewButtonGroup = new ButtonGroup();
        class ViewButtonListener
        implements ActionListener {
            JFileChooser fc;

            ViewButtonListener(JFileChooser fc) {
                this.fc = fc;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                JToggleButton b = (JToggleButton)e.getSource();
                JPanel oldViewPanel = OracleFileChooserUI.this.currentViewPanel;
                if (b == OracleFileChooserUI.this.detailsViewButton) {
                    if (OracleFileChooserUI.this.detailsViewPanel == null) {
                        OracleFileChooserUI.this.detailsViewPanel = OracleFileChooserUI.this.createDetailsView(this.fc);
                        OracleFileChooserUI.this.detailsViewPanel.setPreferredSize(LIST_PREF_SIZE);
                    }
                    OracleFileChooserUI.this.currentViewPanel = OracleFileChooserUI.this.detailsViewPanel;
                } else {
                    OracleFileChooserUI.this.currentViewPanel = OracleFileChooserUI.this.listViewPanel;
                }
                if (OracleFileChooserUI.this.currentViewPanel != oldViewPanel) {
                    OracleFileChooserUI.this.centerPanel.remove(oldViewPanel);
                    OracleFileChooserUI.this.centerPanel.add((Component)OracleFileChooserUI.this.currentViewPanel, "Center");
                    OracleFileChooserUI.this.centerPanel.revalidate();
                    OracleFileChooserUI.this.centerPanel.repaint();
                }
            }
        }
        ViewButtonListener viewButtonListener = new ViewButtonListener(fc);
        this.listViewButton = new JToggleButton(this.listViewIcon);
        this.listViewButton.setToolTipText(this.listViewButtonToolTipText);
        this.listViewButton.getAccessibleContext().setAccessibleName(this.listViewButtonAccessibleName);
        this.listViewButton.setSelected(true);
        this.listViewButton.setAlignmentX(0.0f);
        this.listViewButton.setAlignmentY(0.5f);
        this.listViewButton.setMargin(shrinkwrap);
        this.listViewButton.addActionListener(viewButtonListener);
        topButtonPanel.add(this.listViewButton);
        viewButtonGroup.add(this.listViewButton);
        this.detailsViewButton = new JToggleButton(this.detailsViewIcon);
        this.detailsViewButton.setToolTipText(this.detailsViewButtonToolTipText);
        this.detailsViewButton.getAccessibleContext().setAccessibleName(this.detailsViewButtonAccessibleName);
        this.detailsViewButton.setAlignmentX(0.0f);
        this.detailsViewButton.setAlignmentY(0.5f);
        this.detailsViewButton.setMargin(shrinkwrap);
        this.detailsViewButton.addActionListener(viewButtonListener);
        topButtonPanel.add(this.detailsViewButton);
        viewButtonGroup.add(this.detailsViewButton);
        this.useShellFolder = false;
        File[] roots = fsv.getRoots();
        if (roots != null && roots.length == 1 && (cbFolders = (File[])ShellFolder.get("fileChooserComboBoxFolders")) != null && cbFolders.length > 0 && roots[0] == cbFolders[0]) {
            this.useShellFolder = true;
        }
        this.detailsTableModel = new DetailsTableModel(fc);
        this.detailsTableRowSorter = new DetailsTableRowSorter(this.detailsTableModel);
        this.centerPanel = new JPanel(new BorderLayout());
        this._keyHandler = new KeyEventHandler();
        this.listViewPanel = this.createList(fc);
        this.listSelectionModel = this.list.getSelectionModel();
        this.listViewPanel.setPreferredSize(LIST_PREF_SIZE);
        this.centerPanel.add((Component)this.listViewPanel, "Center");
        this.currentViewPanel = this.listViewPanel;
        this.centerPanel.add((Component)this.getAccessoryPanel(), "After");
        JComponent accessory = fc.getAccessory();
        if (accessory != null) {
            this.getAccessoryPanel().add(accessory);
        }
        fc.add((Component)this.centerPanel, "Center");
        JPanel bottomPanel = this.getBottomPanel();
        bottomPanel.setLayout(new BoxLayout(bottomPanel, 1));
        fc.add((Component)bottomPanel, "South");
        JPanel fileNamePanel = new JPanel();
        fileNamePanel.setLayout(new BoxLayout(fileNamePanel, 2));
        bottomPanel.add(fileNamePanel);
        bottomPanel.add(Box.createRigidArea(vstrut5));
        AlignedLabel fileNameLabel = new AlignedLabel(this.fileNameLabelText);
        fileNameLabel.setDisplayedMnemonic(this.fileNameLabelMnemonic);
        fileNamePanel.add(fileNameLabel);
        this.fileNameTextField = new JTextField(35){

            @Override
            public Dimension getMaximumSize() {
                return new Dimension(Short.MAX_VALUE, super.getPreferredSize().height);
            }
        };
        fileNamePanel.add(this.fileNameTextField);
        fileNameLabel.setLabelFor(this.fileNameTextField);
        this.fileNameTextField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                if (!OracleFileChooserUI.this.getFileChooser().isMultiSelectionEnabled()) {
                    OracleFileChooserUI.this.listSelectionModel.clearSelection();
                }
            }
        });
        if (fc.isMultiSelectionEnabled()) {
            this.setFileName(this.fileNameString(fc.getSelectedFiles()));
        } else {
            this.setFileName(this.fileNameString(fc.getSelectedFile()));
        }
        JPanel filesOfTypePanel = new JPanel();
        filesOfTypePanel.setLayout(new BoxLayout(filesOfTypePanel, 2));
        bottomPanel.add(filesOfTypePanel);
        AlignedLabel filesOfTypeLabel = new AlignedLabel(this.filesOfTypeLabelText);
        filesOfTypeLabel.setDisplayedMnemonic(this.filesOfTypeLabelMnemonic);
        filesOfTypePanel.add(filesOfTypeLabel);
        this.filterComboBoxModel = this.createFilterComboBoxModel();
        fc.addPropertyChangeListener(this.filterComboBoxModel);
        this.filterComboBox = new JComboBox(this.filterComboBoxModel);
        this.filterComboBox.getAccessibleContext().setAccessibleDescription(this.filesOfTypeLabelText);
        filesOfTypeLabel.setLabelFor(this.filterComboBox);
        this.filterComboBox.setRenderer(this.createFilterComboBoxRenderer());
        filesOfTypePanel.add(this.filterComboBox);
        this.getButtonPanel().setLayout(new ButtonAreaLayout());
        this.approveButton = new JButton(this.getApproveButtonText(fc));
        this.approveButton.addActionListener(this.getApproveSelectionAction());
        this.approveButton.setToolTipText(this.getApproveButtonToolTipText(fc));
        this.getButtonPanel().add(this.approveButton);
        this.approveButton.setMnemonic(this.getApproveButtonMnemonic(fc));
        this.cancelButton = new JButton(this.cancelButtonText);
        this.cancelButton.setToolTipText(this.cancelButtonToolTipText);
        this.cancelButton.addActionListener(this.getCancelSelectionAction());
        this.getButtonPanel().add(this.cancelButton);
        if (fc.getControlButtonsAreShown()) {
            this.addControlButtons();
        }
        OracleFileChooserUI.groupLabels(new AlignedLabel[]{fileNameLabel, filesOfTypeLabel});
    }

    protected JPanel getButtonPanel() {
        if (this.buttonPanel == null) {
            this.buttonPanel = new JPanel();
        }
        return this.buttonPanel;
    }

    protected JPanel getBottomPanel() {
        if (this.bottomPanel == null) {
            this.bottomPanel = new JPanel();
        }
        return this.bottomPanel;
    }

    @Override
    protected void installStrings(JFileChooser fc) {
        super.installStrings(fc);
        Locale l = fc.getLocale();
        ResourceBundle b = ResourceBundle.getBundle(_BUNDLE, l);
        this.listViewAccessibleName = StringUtils.stripMnemonic((String)b.getString(_KEY_FILES));
        String saveText = b.getString(_KEY_SAVE);
        String openText = b.getString(_KEY_OPEN);
        String cancelText = b.getString(_KEY_CANCEL);
        String helpText = b.getString(_KEY_HELP);
        this.saveButtonText = StringUtils.stripMnemonic((String)saveText);
        this.openButtonText = StringUtils.stripMnemonic((String)openText);
        this.cancelButtonText = StringUtils.stripMnemonic((String)cancelText);
        this.helpButtonText = StringUtils.stripMnemonic((String)helpText);
        this.directoryOpenButtonText = this.openButtonText;
        this.saveButtonMnemonic = StringUtils.getMnemonicKeyCode((String)saveText);
        this.openButtonMnemonic = StringUtils.getMnemonicKeyCode((String)openText);
        this.cancelButtonMnemonic = StringUtils.getMnemonicKeyCode((String)cancelText);
        this.helpButtonMnemonic = StringUtils.getMnemonicKeyCode((String)helpText);
        this.directoryOpenButtonMnemonic = this.openButtonMnemonic;
        this.saveButtonToolTipText = null;
        this.openButtonToolTipText = null;
        this.cancelButtonToolTipText = null;
        this.helpButtonToolTipText = null;
        this.directoryOpenButtonToolTipText = this.openButtonToolTipText;
        String lookText = b.getString(_KEY_LOOKIN);
        this.lookInLabelMnemonic = StringUtils.getMnemonicKeyCode((String)lookText);
        this.saveInLabelText = this.lookInLabelText = StringUtils.stripMnemonic((String)lookText);
        String fileNameText = b.getString(_KEY_FILENAME);
        this.fileNameLabelMnemonic = StringUtils.getMnemonicKeyCode((String)fileNameText);
        this.fileNameLabelText = StringUtils.stripMnemonic((String)fileNameText);
        String fileTypeText = b.getString(_KEY_FILETYPES);
        this.filesOfTypeLabelMnemonic = StringUtils.getMnemonicKeyCode((String)fileTypeText);
        this.filesOfTypeLabelText = StringUtils.stripMnemonic((String)fileTypeText);
        this.upFolderAccessibleName = this.upFolderToolTipText = b.getString(_KEY_UP);
        this.homeFolderAccessibleName = this.homeFolderToolTipText = b.getString(_KEY_HOME);
        this.newFolderAccessibleName = this.newFolderToolTipText = b.getString(_KEY_FOLDER);
        this.listViewButtonAccessibleName = this.listViewButtonToolTipText = b.getString(_KEY_LIST);
        this.detailsViewButtonAccessibleName = this.detailsViewButtonToolTipText = b.getString(_KEY_DETAILS);
        this.fileNameHeaderText = b.getString(_KEY_NAME);
        this.fileSizeHeaderText = b.getString(_KEY_SIZE);
        this.fileTypeHeaderText = b.getString(_KEY_TYPE);
        this.fileDateHeaderText = b.getString(_KEY_DATE);
        this.fileAttrHeaderText = b.getString(_KEY_ATTR);
    }

    @Override
    protected void installListeners(JFileChooser fc) {
        super.installListeners(fc);
        ActionMap actionMap = this.getActionMap();
        SwingUtilities.replaceUIActionMap(fc, actionMap);
    }

    protected ActionMap getActionMap() {
        return this.createActionMap();
    }

    protected ActionMap createActionMap() {
        AbstractAction escAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (OracleFileChooserUI.this.editFile != null) {
                    OracleFileChooserUI.this.cancelEdit();
                } else {
                    OracleFileChooserUI.this.getFileChooser().cancelSelection();
                }
            }

            @Override
            public boolean isEnabled() {
                return OracleFileChooserUI.this.getFileChooser().isEnabled();
            }
        };
        ActionMapUIResource map = new ActionMapUIResource();
        map.put("approveSelection", this.getApproveSelectionAction());
        map.put("cancelSelection", escAction);
        map.put("Go Up", this.getChangeToParentDirectoryAction());
        map.put("editFileName", this.getEditAction());
        return map;
    }

    private Action getEditAction() {
        return new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                JFileChooser fc = OracleFileChooserUI.this.getFileChooser();
                int index = OracleFileChooserUI.this.list.getSelectionModel().getMinSelectionIndex();
                if (!(index < 0 || OracleFileChooserUI.this.editFile != null || fc.isMultiSelectionEnabled() && fc.getSelectedFiles().length > 1)) {
                    OracleFileChooserUI.this.editFileName(index);
                }
            }
        };
    }

    protected JPanel createList(JFileChooser fc) {
        JPanel p = new JPanel(new BorderLayout());
        final JFileChooser fileChooser = fc;
        this.list = new JList(){

            @Override
            public int getNextMatch(String prefix, int startIndex, Position.Bias bias) {
                ListModel model = this.getModel();
                int max = model.getSize();
                if (prefix == null || startIndex < 0 || startIndex >= max) {
                    throw new IllegalArgumentException();
                }
                boolean backwards = bias == Position.Bias.Backward;
                int i = startIndex;
                while (backwards ? i >= 0 : i < max) {
                    String filename = fileChooser.getName((File)model.getElementAt(i));
                    if (filename.regionMatches(true, 0, prefix, 0, prefix.length())) {
                        return i;
                    }
                    i += backwards ? -1 : 1;
                }
                return -1;
            }
        };
        this.list.setCellRenderer(new FileRenderer());
        this.list.setLayoutOrientation(1);
        this.list.setVisibleRowCount(-1);
        this.list.addKeyListener(this._keyHandler);
        this.list.getAccessibleContext().setAccessibleName(this.listViewAccessibleName);
        if (fc.isMultiSelectionEnabled()) {
            this.list.setSelectionMode(2);
        } else {
            this.list.setSelectionMode(0);
        }
        this.list.setModel(new SortableListModel());
        this.list.addListSelectionListener(this.createListSelectionListener(fc));
        this.list.addMouseListener(this.createDoubleClickListener(fc, this.list));
        this.list.addMouseListener(this.createSingleClickListener(fc, this.list));
        this.getModel().addListDataListener(new ListDataListener(){

            @Override
            public void contentsChanged(ListDataEvent e) {
                new DelayedSelectionUpdater();
            }

            @Override
            public void intervalAdded(ListDataEvent e) {
                int i1;
                int i0 = e.getIndex0();
                if (i0 == (i1 = e.getIndex1())) {
                    File file = (File)OracleFileChooserUI.this.getModel().getElementAt(i0);
                    new DelayedSelectionUpdater(file);
                } else {
                    new DelayedSelectionUpdater();
                }
            }

            @Override
            public void intervalRemoved(ListDataEvent e) {
            }
        });
        JScrollPane scrollpane = new JScrollPane(this.list);
        p.add((Component)scrollpane, "Center");
        return p;
    }

    protected JPanel createDetailsView(JFileChooser fc) {
        final JFileChooser chooser = fc;
        JPanel p = new JPanel(new BorderLayout());
        this.detailsTable = new JTable(this.detailsTableModel){

            @Override
            protected boolean processKeyBinding(KeyStroke ks, KeyEvent e, int condition, boolean pressed) {
                if (e.getKeyCode() == 27 && this.getCellEditor() == null) {
                    chooser.dispatchEvent(e);
                    return true;
                }
                return super.processKeyBinding(ks, e, condition, pressed);
            }
        };
        this.detailsTable.setRowSorter(this.detailsTableRowSorter);
        this.detailsTable.setComponentOrientation(chooser.getComponentOrientation());
        this.detailsTable.setAutoResizeMode(0);
        this.detailsTable.setShowGrid(false);
        this.detailsTable.setSelectionModel(this.listSelectionModel);
        this.detailsTable.putClientProperty("JTable.autoStartsEdit", Boolean.FALSE);
        KeyStroke ks = KeyStroke.getKeyStroke(10, 0);
        this.detailsTable.getInputMap(1).put(ks, "NONE");
        this.detailsTable.addKeyListener(this._keyHandler);
        Font font = this.detailsTable.getFont();
        FontMetrics metrics = this.detailsTable.getFontMetrics(font);
        this.detailsTable.setRowHeight(metrics.getHeight() + metrics.getDescent());
        TableColumnModel columnModel = this.detailsTable.getColumnModel();
        TableColumn[] columns = new TableColumn[5];
        for (int i = 0; i < 5; ++i) {
            columns[i] = columnModel.getColumn(i);
            columns[i].setPreferredWidth(this.COLUMN_WIDTHS[i]);
        }
        if (!System.getProperty("os.name").startsWith("Windows")) {
            columnModel.removeColumn(columns[2]);
            columnModel.removeColumn(columns[4]);
        }
        DetailsTableCellRenderer cellRenderer = new DetailsTableCellRenderer(chooser);
        this.detailsTable.setDefaultRenderer(File.class, cellRenderer);
        this.detailsTable.setDefaultRenderer(Date.class, cellRenderer);
        this.detailsTable.setDefaultRenderer(Object.class, cellRenderer);
        final JTextField tf = new JTextField();
        tf.addFocusListener(this.editorFocusListener);
        columns[0].setCellEditor(new DefaultCellEditor(tf){

            @Override
            public boolean isCellEditable(EventObject e) {
                if (e instanceof MouseEvent) {
                    MouseEvent me = (MouseEvent)e;
                    int index = OracleFileChooserUI.this.detailsTable.rowAtPoint(me.getPoint());
                    return me.getClickCount() == 1 && OracleFileChooserUI.this.detailsTable.isRowSelected(index);
                }
                return super.isCellEditable(e);
            }

            @Override
            public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
                Component comp = super.getTableCellEditorComponent(table, value, isSelected, row, column);
                if (value instanceof File) {
                    tf.setText(chooser.getName((File)value));
                    tf.requestFocus();
                    tf.selectAll();
                }
                return comp;
            }
        });
        JList fakeList = new JList(this.detailsTableModel.listModel){
            JTable table;
            {
                this.table = OracleFileChooserUI.this.detailsTable;
            }

            @Override
            public int locationToIndex(Point location) {
                return this.table.convertRowIndexToModel(this.table.rowAtPoint(location));
            }

            @Override
            public Rectangle getCellBounds(int index0, int index1) {
                Rectangle r0 = this.table.getCellRect(index0, 0, false);
                Rectangle r1 = this.table.getCellRect(index1, 0, false);
                return r0.union(r1);
            }

            public Object getSelectedValue() {
                return this.table.getValueAt(this.table.convertRowIndexToModel(this.table.getSelectedRow()), 0);
            }

            @Override
            public Component add(Component comp) {
                if (comp instanceof JTextField) {
                    return this.table.add(comp);
                }
                return super.add(comp);
            }

            @Override
            public void repaint() {
                if (this.table != null) {
                    this.table.repaint();
                }
            }

            @Override
            public TransferHandler getTransferHandler() {
                if (this.table != null) {
                    return this.table.getTransferHandler();
                }
                return super.getTransferHandler();
            }

            @Override
            public void setTransferHandler(TransferHandler newHandler) {
                if (this.table != null) {
                    this.table.setTransferHandler(newHandler);
                } else {
                    super.setTransferHandler(newHandler);
                }
            }

            @Override
            public boolean getDragEnabled() {
                if (this.table != null) {
                    return this.table.getDragEnabled();
                }
                return super.getDragEnabled();
            }

            @Override
            public void setDragEnabled(boolean b) {
                if (this.table != null) {
                    this.table.setDragEnabled(b);
                } else {
                    super.setDragEnabled(b);
                }
            }
        };
        fakeList.setSelectionModel(this.listSelectionModel);
        this.detailsTable.addMouseListener(this.createDoubleClickListener(chooser, fakeList));
        this.detailsTable.getAccessibleContext().setAccessibleName(this.listViewAccessibleName);
        JScrollPane scrollpane = new JScrollPane(this.detailsTable);
        scrollpane.setComponentOrientation(chooser.getComponentOrientation());
        LookAndFeel.installColors(scrollpane.getViewport(), "Table.background", "Table.foreground");
        scrollpane.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                JScrollPane sp = (JScrollPane)e.getComponent();
                OracleFileChooserUI.this.fixNameColumnWidth(sp.getViewport().getSize().width);
                sp.removeComponentListener(this);
            }
        });
        p.add((Component)scrollpane, "Center");
        return p;
    }

    private void fixNameColumnWidth(int viewWidth) {
        TableColumn nameCol = this.detailsTable.getColumnModel().getColumn(0);
        int tableWidth = this.detailsTable.getPreferredSize().width;
        if (tableWidth < viewWidth) {
            nameCol.setPreferredWidth(nameCol.getPreferredWidth() + viewWidth - tableWidth);
        }
    }

    @Override
    public ListSelectionListener createListSelectionListener(JFileChooser fc) {
        return new BasicFileChooserUI.SelectionListener(){

            /*
             * Enabled aggressive block sorting
             */
            @Override
            public void valueChanged(ListSelectionEvent e) {
                File[] files;
                JFileChooser chooser;
                block7: {
                    int j;
                    Object[] objects;
                    FileSystemView fsv;
                    block9: {
                        JList list;
                        block6: {
                            block8: {
                                if (e.getValueIsAdjusting()) return;
                                chooser = OracleFileChooserUI.this.getFileChooser();
                                fsv = chooser.getFileSystemView();
                                list = (JList)e.getSource();
                                if (!chooser.isMultiSelectionEnabled()) break block6;
                                files = null;
                                objects = list.getSelectedValues();
                                if (objects == null) break block7;
                                if (objects.length != 1 || !((File)objects[0]).isDirectory() || !chooser.isTraversable((File)objects[0])) break block8;
                                if (chooser.getFileSelectionMode() != 0 && fsv.isFileSystem((File)objects[0])) break block8;
                                OracleFileChooserUI.this.setDirectorySelected(true);
                                OracleFileChooserUI.this.setDirectory((File)objects[0]);
                                break block7;
                            }
                            files = new File[objects.length];
                            j = 0;
                            break block9;
                        }
                        File file = (File)list.getSelectedValue();
                        if (file != null && file.isDirectory() && chooser.isTraversable(file)) {
                            if (chooser.getFileSelectionMode() == 0 || !fsv.isFileSystem(file)) {
                                OracleFileChooserUI.this.setDirectorySelected(true);
                                OracleFileChooserUI.this.setDirectory(file);
                                chooser.setSelectedFile(null);
                                return;
                            }
                        }
                        OracleFileChooserUI.this.setDirectorySelected(false);
                        if (file == null) return;
                        chooser.setSelectedFile(file);
                        return;
                    }
                    for (int i = 0; i < objects.length; ++i) {
                        boolean isFile;
                        File f = (File)objects[i];
                        boolean isDir = f.isDirectory();
                        boolean bl = disableFileChooserSpeedFixProperty ? f.isFile() : (isFile = !isDir);
                        if ((!chooser.isFileSelectionEnabled() || !isFile) && (!chooser.isDirectorySelectionEnabled() || !fsv.isFileSystem(f) || !isDir)) continue;
                        files[j++] = f;
                    }
                    if (j == 0) {
                        files = null;
                    } else if (j < objects.length) {
                        File[] tmpFiles = new File[j];
                        System.arraycopy(files, 0, tmpFiles, 0, j);
                        files = tmpFiles;
                    }
                    OracleFileChooserUI.this.setDirectorySelected(false);
                }
                chooser.setSelectedFiles(files);
            }
        };
    }

    private MouseListener createSingleClickListener(JFileChooser fc, JList list) {
        return new SingleClickListener(list);
    }

    private int getEditIndex() {
        return this.lastIndex;
    }

    private void setEditIndex(int i) {
        this.lastIndex = i;
    }

    private void resetEditIndex() {
        this.lastIndex = -1;
    }

    private void cancelEdit() {
        if (this.editFile != null) {
            this.editFile = null;
            this.list.remove(this.editCell);
            this.centerPanel.repaint();
        } else if (this.detailsTable != null && this.detailsTable.isEditing()) {
            this.detailsTable.getCellEditor().cancelCellEditing();
        }
    }

    private void editFileName(int index) {
        this.ensureIndexIsVisible(index);
        if (this.listViewPanel.isVisible()) {
            this.editFile = (File)this.getModel().getElementAt(this.detailsTableRowSorter.convertRowIndexToModel(index));
            Rectangle r = this.list.getCellBounds(index, index);
            if (this.editCell == null) {
                this.editCell = new JTextField();
                this.editCell.addActionListener(new EditActionListener());
                this.editCell.addFocusListener(this.editorFocusListener);
                this.editCell.setNextFocusableComponent(this.list);
            }
            this.list.add(this.editCell);
            this.editCell.setText(this.getFileChooser().getName(this.editFile));
            if (this.list.getComponentOrientation().isLeftToRight()) {
                this.editCell.setBounds(this.editX + r.x, r.y, r.width - this.editX, r.height);
            } else {
                this.editCell.setBounds(r.x, r.y, r.width - this.editX, r.height);
            }
            this.editCell.requestFocus();
            this.editCell.selectAll();
        } else if (this.detailsViewPanel.isVisible()) {
            this.detailsTable.editCellAt(index, 0);
        }
    }

    private void applyEdit() {
        if (this.editFile != null && this.editFile.exists()) {
            JFileChooser chooser = this.getFileChooser();
            String oldDisplayName = chooser.getName(this.editFile);
            String oldFileName = this.editFile.getName();
            String newDisplayName = this.editCell.getText().trim();
            if (!newDisplayName.equals(oldDisplayName)) {
                FileSystemView fsv;
                File f2;
                int i2;
                String newFileName = newDisplayName;
                int i1 = oldFileName.length();
                if (i1 > (i2 = oldDisplayName.length()) && oldFileName.charAt(i2) == '.') {
                    newFileName = newDisplayName + oldFileName.substring(i2);
                }
                if (!(f2 = (fsv = chooser.getFileSystemView()).createFileObject(this.editFile.getParentFile(), newFileName)).exists() && this.getModel().renameFile(this.editFile, f2) && fsv.isParent(chooser.getCurrentDirectory(), f2)) {
                    if (chooser.isMultiSelectionEnabled()) {
                        chooser.setSelectedFiles(new File[]{f2});
                    } else {
                        chooser.setSelectedFile(f2);
                    }
                }
            }
        }
        if (this.detailsTable != null && this.detailsTable.isEditing()) {
            this.detailsTable.getCellEditor().stopCellEditing();
        }
        this.cancelEdit();
    }

    @Override
    public void uninstallUI(JComponent c) {
        c.removePropertyChangeListener(this.filterComboBoxModel);
        this.cancelButton.removeActionListener(this.getCancelSelectionAction());
        this.approveButton.removeActionListener(this.getApproveSelectionAction());
        this.fileNameTextField.removeActionListener(this.getApproveSelectionAction());
        this.list.removeKeyListener(this._keyHandler);
        if (this.detailsTable != null) {
            this.detailsTable.removeKeyListener(this._keyHandler);
        }
        super.uninstallUI(c);
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        int prefWidth = OracleFileChooserUI.PREF_SIZE.width;
        Dimension d = c.getLayout().preferredLayoutSize(c);
        if (d != null) {
            return new Dimension(d.width < prefWidth ? prefWidth : d.width, d.height < OracleFileChooserUI.PREF_SIZE.height ? OracleFileChooserUI.PREF_SIZE.height : d.height);
        }
        return new Dimension(prefWidth, OracleFileChooserUI.PREF_SIZE.height);
    }

    @Override
    public Dimension getMinimumSize(JComponent c) {
        return MIN_SIZE;
    }

    @Override
    public Dimension getMaximumSize(JComponent c) {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setFileSelected() {
        if (this.getFileChooser().isMultiSelectionEnabled() && !this.isDirectorySelected()) {
            Object[] files = this.getFileChooser().getSelectedFiles();
            Object[] selectedObjects = this.list.getSelectedValues();
            if (disableFileChooserSpeedFixProperty) {
                int viewIndex;
                int index;
                boolean found;
                for (int j = 0; j < selectedObjects.length; ++j) {
                    found = false;
                    for (int i = 0; i < files.length; ++i) {
                        if (!((File)files[i]).equals(selectedObjects[j])) continue;
                        found = true;
                        break;
                    }
                    if (found || (index = this.getModel().indexOf(selectedObjects[j])) < 0) continue;
                    viewIndex = this.detailsTableRowSorter.convertRowIndexToView(index);
                    this.listSelectionModel.removeSelectionInterval(viewIndex, viewIndex);
                }
                for (int i = 0; i < files.length; ++i) {
                    found = false;
                    for (int j = 0; j < selectedObjects.length; ++j) {
                        if (!((File)files[i]).equals(selectedObjects[j])) continue;
                        found = true;
                        break;
                    }
                    if (found || (index = this.getModel().indexOf(files[i])) < 0) continue;
                    viewIndex = this.detailsTableRowSorter.convertRowIndexToView(index);
                    this.listSelectionModel.addSelectionInterval(viewIndex, viewIndex);
                }
            } else {
                this.listSelectionModel.setValueIsAdjusting(true);
                try {
                    int viewIndex;
                    int index;
                    Arrays.sort(files);
                    Arrays.sort(selectedObjects);
                    int shouldIndex = 0;
                    int actuallyIndex = 0;
                    while (shouldIndex < files.length && actuallyIndex < selectedObjects.length) {
                        int viewIndex2;
                        int index2;
                        int comparison = ((File)files[shouldIndex]).compareTo((File)selectedObjects[actuallyIndex]);
                        if (comparison < 0) {
                            index2 = this.getModel().indexOf(files[shouldIndex]);
                            if (index2 >= 0) {
                                viewIndex2 = this.detailsTableRowSorter.convertRowIndexToView(index2);
                                this.listSelectionModel.addSelectionInterval(viewIndex2, viewIndex2);
                            }
                            ++shouldIndex;
                            continue;
                        }
                        if (comparison > 0) {
                            index2 = this.getModel().indexOf(selectedObjects[actuallyIndex]);
                            if (index2 >= 0) {
                                viewIndex2 = this.detailsTableRowSorter.convertRowIndexToView(index2);
                                this.listSelectionModel.removeSelectionInterval(viewIndex2, viewIndex2);
                            }
                            ++actuallyIndex;
                            continue;
                        }
                        ++shouldIndex;
                        ++actuallyIndex;
                    }
                    while (shouldIndex < files.length) {
                        index = this.getModel().indexOf(files[shouldIndex]);
                        if (index >= 0) {
                            viewIndex = this.detailsTableRowSorter.convertRowIndexToView(index);
                            this.listSelectionModel.addSelectionInterval(viewIndex, viewIndex);
                        }
                        ++shouldIndex;
                    }
                    while (actuallyIndex < selectedObjects.length) {
                        index = this.getModel().indexOf(selectedObjects[actuallyIndex]);
                        if (index >= 0) {
                            viewIndex = this.detailsTableRowSorter.convertRowIndexToView(index);
                            this.listSelectionModel.removeSelectionInterval(viewIndex, viewIndex);
                        }
                        ++actuallyIndex;
                    }
                }
                finally {
                    this.listSelectionModel.setValueIsAdjusting(false);
                }
            }
        } else {
            int i;
            JFileChooser chooser = this.getFileChooser();
            File f = null;
            f = this.isDirectorySelected() ? this.getDirectory() : chooser.getSelectedFile();
            if (f != null && (i = this.getModel().indexOf(f)) >= 0) {
                int viewIndex = this.detailsTableRowSorter.convertRowIndexToView(i);
                this.listSelectionModel.setSelectionInterval(viewIndex, viewIndex);
                this.ensureIndexIsVisible(viewIndex);
            } else {
                this.listSelectionModel.clearSelection();
            }
        }
    }

    private String fileNameString(File file) {
        if (file == null) {
            return null;
        }
        JFileChooser fc = this.getFileChooser();
        if (fc.isDirectorySelectionEnabled() && !fc.isFileSelectionEnabled()) {
            return file.getPath();
        }
        return file.getName();
    }

    private String fileNameString(File[] files) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; files != null && i < files.length; ++i) {
            if (i > 0) {
                buf.append(" ");
            }
            if (files.length > 1) {
                buf.append("\"");
            }
            buf.append(this.fileNameString(files[i]));
            if (files.length <= 1) continue;
            buf.append("\"");
        }
        return buf.toString();
    }

    private void doSelectedFileChanged(PropertyChangeEvent e) {
        this.applyEdit();
        File f = (File)e.getNewValue();
        JFileChooser fc = this.getFileChooser();
        if (f != null && (fc.isFileSelectionEnabled() && !f.isDirectory() || f.isDirectory() && fc.isDirectorySelectionEnabled())) {
            this.setFileName(this.fileNameString(f));
            this.setFileSelected();
        }
    }

    private void doSelectedFilesChanged(PropertyChangeEvent e) {
        this.applyEdit();
        File[] files = (File[])e.getNewValue();
        JFileChooser fc = this.getFileChooser();
        if (files != null && files.length > 0 && (files.length > 1 || fc.isDirectorySelectionEnabled() || !files[0].isDirectory())) {
            this.setFileName(this.fileNameString(files));
            this.setFileSelected();
        }
    }

    private void doDirectoryChanged(PropertyChangeEvent e) {
        JFileChooser fc = this.getFileChooser();
        FileSystemView fsv = fc.getFileSystemView();
        this.applyEdit();
        this.resetEditIndex();
        this.clearIconCache();
        this.listSelectionModel.clearSelection();
        this.ensureIndexIsVisible(0);
        File currentDirectory = fc.getCurrentDirectory();
        if (currentDirectory != null) {
            this.directoryComboBoxModel.addItem(currentDirectory);
            this.getNewFolderAction().setEnabled(currentDirectory.canWrite());
            this.getChangeToParentDirectoryAction().setEnabled(!fsv.isRoot(currentDirectory));
            if (fc.isDirectorySelectionEnabled() && !fc.isFileSelectionEnabled()) {
                if (fsv.isFileSystem(currentDirectory)) {
                    this.setFileName(currentDirectory.getPath());
                } else {
                    this.setFileName(null);
                }
            }
        }
    }

    private void doFilterChanged(PropertyChangeEvent e) {
        this.applyEdit();
        this.resetEditIndex();
        this.clearIconCache();
        this.listSelectionModel.clearSelection();
    }

    private void doFileSelectionModeChanged(PropertyChangeEvent e) {
        this.applyEdit();
        this.resetEditIndex();
        this.clearIconCache();
        this.listSelectionModel.clearSelection();
        JFileChooser fc = this.getFileChooser();
        File currentDirectory = fc.getCurrentDirectory();
        if (currentDirectory != null && fc.isDirectorySelectionEnabled() && !fc.isFileSelectionEnabled() && fc.getFileSystemView().isFileSystem(currentDirectory)) {
            this.setFileName(currentDirectory.getPath());
        } else {
            this.setFileName(null);
        }
    }

    private void doMultiSelectionChanged(PropertyChangeEvent e) {
        if (this.getFileChooser().isMultiSelectionEnabled()) {
            this.listSelectionModel.setSelectionMode(2);
        } else {
            this.listSelectionModel.setSelectionMode(0);
            this.listSelectionModel.clearSelection();
            this.getFileChooser().setSelectedFiles(null);
        }
    }

    private void doAccessoryChanged(PropertyChangeEvent e) {
        if (this.getAccessoryPanel() != null) {
            JComponent accessory;
            if (e.getOldValue() != null) {
                this.getAccessoryPanel().remove((JComponent)e.getOldValue());
            }
            if ((accessory = (JComponent)e.getNewValue()) != null) {
                this.getAccessoryPanel().add((Component)accessory, "Center");
            }
        }
    }

    private void doApproveButtonTextChanged(PropertyChangeEvent e) {
        JFileChooser chooser = this.getFileChooser();
        this.approveButton.setText(this.getApproveButtonText(chooser));
        this.approveButton.setToolTipText(this.getApproveButtonToolTipText(chooser));
    }

    private void doDialogTypeChanged(PropertyChangeEvent e) {
        JFileChooser chooser = this.getFileChooser();
        this.approveButton.setText(this.getApproveButtonText(chooser));
        this.approveButton.setToolTipText(this.getApproveButtonToolTipText(chooser));
        if (chooser.getDialogType() == 1) {
            this.lookInLabel.setText(this.saveInLabelText);
        } else {
            this.lookInLabel.setText(this.lookInLabelText);
        }
    }

    private void doApproveButtonMnemonicChanged(PropertyChangeEvent e) {
    }

    private void doControlButtonsChanged(PropertyChangeEvent e) {
        if (this.getFileChooser().getControlButtonsAreShown()) {
            this.addControlButtons();
        } else {
            this.removeControlButtons();
        }
    }

    @Override
    public PropertyChangeListener createPropertyChangeListener(JFileChooser fc) {
        return new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                String s = e.getPropertyName();
                if (s.equals("SelectedFileChangedProperty")) {
                    OracleFileChooserUI.this.doSelectedFileChanged(e);
                } else if (s.equals("SelectedFilesChangedProperty")) {
                    OracleFileChooserUI.this.doSelectedFilesChanged(e);
                } else if (s.equals("directoryChanged")) {
                    OracleFileChooserUI.this.doDirectoryChanged(e);
                } else if (s.equals("fileFilterChanged")) {
                    OracleFileChooserUI.this.doFilterChanged(e);
                } else if (s.equals("fileSelectionChanged")) {
                    OracleFileChooserUI.this.doFileSelectionModeChanged(e);
                } else if (s.equals("MultiSelectionEnabledChangedProperty")) {
                    OracleFileChooserUI.this.doMultiSelectionChanged(e);
                } else if (s.equals("AccessoryChangedProperty")) {
                    OracleFileChooserUI.this.doAccessoryChanged(e);
                } else if (s.equals("ApproveButtonTextChangedProperty") || s.equals("ApproveButtonToolTipTextChangedProperty")) {
                    OracleFileChooserUI.this.doApproveButtonTextChanged(e);
                } else if (s.equals("DialogTypeChangedProperty")) {
                    OracleFileChooserUI.this.doDialogTypeChanged(e);
                } else if (s.equals("ApproveButtonMnemonicChangedProperty")) {
                    OracleFileChooserUI.this.doApproveButtonMnemonicChanged(e);
                } else if (s.equals("ControlButtonsAreShownChangedProperty")) {
                    OracleFileChooserUI.this.doControlButtonsChanged(e);
                } else if (s.equals("CancelSelection")) {
                    OracleFileChooserUI.this.applyEdit();
                } else if (s.equals("componentOrientation")) {
                    ComponentOrientation o = (ComponentOrientation)e.getNewValue();
                    JFileChooser cc = (JFileChooser)e.getSource();
                    if (o != (ComponentOrientation)e.getOldValue()) {
                        cc.applyComponentOrientation(o);
                    }
                    if (OracleFileChooserUI.this.detailsTable != null) {
                        OracleFileChooserUI.this.detailsTable.setComponentOrientation(o);
                        OracleFileChooserUI.this.detailsTable.getParent().getParent().setComponentOrientation(o);
                    }
                } else if (s.equals("ancestor") && e.getOldValue() == null && e.getNewValue() != null) {
                    OracleFileChooserUI.this.fileNameTextField.selectAll();
                    OracleFileChooserUI.this.fileNameTextField.requestFocus();
                }
            }
        };
    }

    protected void removeControlButtons() {
        this.getBottomPanel().remove(this.getButtonPanel());
    }

    protected void addControlButtons() {
        this.getBottomPanel().add(this.getButtonPanel());
    }

    private void ensureIndexIsVisible(int i) {
        if (i >= 0) {
            this.list.ensureIndexIsVisible(i);
            if (this.detailsTable != null) {
                this.detailsTable.scrollRectToVisible(this.detailsTable.getCellRect(i, 0, true));
            }
        }
    }

    @Override
    public void ensureFileIsVisible(JFileChooser fc, File f) {
        int modelIndex = this.getModel().indexOf(f);
        if (modelIndex >= 0) {
            this.ensureIndexIsVisible(this.detailsTableRowSorter.convertRowIndexToView(modelIndex));
        }
    }

    @Override
    public void rescanCurrentDirectory(JFileChooser fc) {
        this.getModel().validateFileCache();
    }

    @Override
    public String getFileName() {
        if (this.fileNameTextField != null) {
            return this.fileNameTextField.getText();
        }
        return null;
    }

    @Override
    public void setFileName(String filename) {
        if (this.fileNameTextField != null) {
            this.fileNameTextField.setText(filename);
        }
    }

    @Override
    protected void setDirectorySelected(boolean directorySelected) {
        super.setDirectorySelected(directorySelected);
        JFileChooser chooser = this.getFileChooser();
        if (directorySelected) {
            this.approveButton.setText(this.directoryOpenButtonText);
            this.approveButton.setToolTipText(this.directoryOpenButtonToolTipText);
        } else {
            this.approveButton.setText(this.getApproveButtonText(chooser));
            this.approveButton.setToolTipText(this.getApproveButtonToolTipText(chooser));
        }
    }

    @Override
    public String getDirectoryName() {
        return null;
    }

    @Override
    public void setDirectoryName(String dirname) {
    }

    protected DirectoryComboBoxRenderer createDirectoryComboBoxRenderer(JFileChooser fc) {
        return new DirectoryComboBoxRenderer();
    }

    protected DirectoryComboBoxModel createDirectoryComboBoxModel(JFileChooser fc) {
        return new DirectoryComboBoxModel();
    }

    protected FilterComboBoxRenderer createFilterComboBoxRenderer() {
        return new FilterComboBoxRenderer();
    }

    protected FilterComboBoxModel createFilterComboBoxModel() {
        return new FilterComboBoxModel();
    }

    public void valueChanged(ListSelectionEvent e) {
        JFileChooser fc = this.getFileChooser();
        File f = fc.getSelectedFile();
        if (!e.getValueIsAdjusting() && f != null && !this.getFileChooser().isTraversable(f)) {
            this.setFileName(this.fileNameString(f));
        }
    }

    @Override
    protected JButton getApproveButton(JFileChooser fc) {
        return this.approveButton;
    }

    private static void groupLabels(AlignedLabel[] group) {
        for (int i = 0; i < group.length; ++i) {
            AlignedLabel.access$4302(group[i], group);
        }
    }

    static {
        try {
            String version = System.getProperty("java.version");
            if (version != null && version.startsWith("1.4")) {
                String prop = AccessController.doPrivileged(new GetPropertyAction("swing.disableFileChooserSpeedFix"));
                disableFileChooserSpeedFixProperty = prop != null && !prop.equalsIgnoreCase("false");
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private class DirectoriesFirstComparatorWrapper
    implements Comparator<File> {
        private Comparator comparator;

        public DirectoriesFirstComparatorWrapper(Comparator comparator) {
            this.comparator = comparator;
        }

        @Override
        public int compare(File f1, File f2) {
            if (f1 != null && f2 != null) {
                boolean traversable1 = OracleFileChooserUI.this.getFileChooser().isTraversable(f1);
                boolean traversable2 = OracleFileChooserUI.this.getFileChooser().isTraversable(f2);
                if (traversable1 && !traversable2) {
                    return -1;
                }
                if (!traversable1 && traversable2) {
                    return 1;
                }
            }
            return this.comparator.compare(f1, f2);
        }
    }

    private class FileAttrComparator
    implements Comparator {
        private FileAttrComparator() {
        }

        public int compare(Object o1, Object o2) {
            File f;
            String s1 = null;
            String s2 = null;
            if (o1 != null && (f = (File)o1).exists() && !OracleFileChooserUI.this.getFileChooser().getFileSystemView().isFileSystemRoot(f)) {
                s1 = "";
                if (!f.canWrite()) {
                    s1 = s1 + "R";
                }
                if (f.isHidden()) {
                    s1 = s1 + "H";
                }
            }
            if (o2 != null && (f = (File)o2).exists() && !OracleFileChooserUI.this.getFileChooser().getFileSystemView().isFileSystemRoot(f)) {
                s2 = "";
                if (!f.canWrite()) {
                    s2 = s2 + "R";
                }
                if (f.isHidden()) {
                    s2 = s2 + "H";
                }
            }
            int gt = s1 == null && s2 == null ? 0 : (s1 != null && s2 == null ? 1 : (s1 == null && s2 != null ? -1 : Collator.getInstance().compare(s1, s2)));
            return gt;
        }
    }

    private class FileTypeComparator
    implements Comparator {
        private FileTypeComparator() {
        }

        public int compare(Object o1, Object o2) {
            File f;
            String s1 = null;
            String s2 = null;
            if (o1 != null && (f = (File)o1).exists()) {
                s1 = OracleFileChooserUI.this.getFileChooser().getFileSystemView().getSystemTypeDescription(f);
            }
            if (o2 != null && (f = (File)o2).exists()) {
                s2 = OracleFileChooserUI.this.getFileChooser().getFileSystemView().getSystemTypeDescription(f);
            }
            int gt = s1 == null && s2 == null ? 0 : (s1 != null && s2 == null ? 1 : (s1 == null && s2 != null ? -1 : Collator.getInstance().compare(s1, s2)));
            return gt;
        }
    }

    private class FileDateComparator
    implements Comparator {
        private FileDateComparator() {
        }

        public int compare(Object o1, Object o2) {
            long time;
            File f;
            Date d1 = null;
            Date d2 = null;
            if (o1 != null && (f = (File)o1).exists() && !OracleFileChooserUI.this.getFileChooser().getFileSystemView().isFileSystemRoot(f)) {
                time = f.lastModified();
                Date date = d1 = time == 0L ? null : new Date(time);
            }
            if (o2 != null && (f = (File)o2).exists() && !OracleFileChooserUI.this.getFileChooser().getFileSystemView().isFileSystemRoot(f)) {
                time = f.lastModified();
                Date date = d2 = time == 0L ? null : new Date(time);
            }
            int gt = d1 == null && d2 == null ? 0 : (d1 != null && d2 == null ? 1 : (d1 == null && d2 != null ? -1 : d1.compareTo(d2)));
            return gt;
        }
    }

    public class FileSizeComparator
    implements Comparator {
        public int compare(Object o1, Object o2) {
            File f;
            Long i1 = null;
            Long i2 = null;
            if (o1 != null && (f = (File)o1).exists() && !f.isDirectory()) {
                i1 = f.length();
            }
            if (o2 != null && (f = (File)o2).exists() && !f.isDirectory()) {
                i2 = f.length();
            }
            int gt = i1 == null && i2 == null ? 0 : (i1 != null && i2 == null ? 1 : (i1 == null && i2 != null ? -1 : i1.compareTo(i2)));
            return gt;
        }
    }

    private class DetailsTableRowSorter
    extends TableRowSorter {
        public DetailsTableRowSorter(TableModel m) {
            super(m);
            this.updateComparators();
        }

        public void updateComparators() {
            this.setComparator(1, new FileSizeComparator());
            this.setComparator(3, new FileDateComparator());
            this.setComparator(2, new FileTypeComparator());
            this.setComparator(4, new FileAttrComparator());
            int colCount = OracleFileChooserUI.this.detailsTableModel.getColumnCount();
            for (int i = 0; i < colCount; ++i) {
                DirectoriesFirstComparatorWrapper c = super.getComparator(i);
                if (c != null) {
                    c = new DirectoriesFirstComparatorWrapper(c);
                }
                this.setComparator(i, c);
            }
        }

        @Override
        public void modelStructureChanged() {
            super.modelStructureChanged();
            this.updateComparators();
        }
    }

    private class SortableListModel
    extends AbstractListModel
    implements TableModelListener,
    RowSorterListener {
        public SortableListModel() {
            OracleFileChooserUI.this.detailsTableModel.addTableModelListener(this);
            OracleFileChooserUI.this.detailsTableRowSorter.addRowSorterListener(this);
        }

        @Override
        public int getSize() {
            return OracleFileChooserUI.this.getModel().getSize();
        }

        @Override
        public Object getElementAt(int index) {
            return OracleFileChooserUI.this.getModel().getElementAt(OracleFileChooserUI.this.detailsTableRowSorter.convertRowIndexToModel(index));
        }

        @Override
        public void tableChanged(TableModelEvent e) {
            this.fireContentsChanged(this, 0, this.getSize());
        }

        @Override
        public void sorterChanged(RowSorterEvent e) {
            this.fireContentsChanged(this, 0, this.getSize());
        }
    }

    private class KeyEventHandler
    extends KeyAdapter {
        private KeyEventHandler() {
        }

        @Override
        public void keyPressed(KeyEvent ke) {
            if (ke.getKeyCode() == 10) {
                File dir;
                if (ke.getModifiers() != 2) {
                    return;
                }
                JFileChooser fc = OracleFileChooserUI.this.getFileChooser();
                if (fc.isDirectorySelectionEnabled() && (dir = (File)OracleFileChooserUI.this.list.getSelectedValue()) != null) {
                    if (dir.isDirectory()) {
                        fc.setCurrentDirectory(dir);
                    }
                    ke.consume();
                }
            }
        }
    }

    private class AlignedLabel
    extends JLabel {
        private AlignedLabel[] group;
        private int maxWidth;

        AlignedLabel(String text) {
            super(text);
            this.maxWidth = 0;
            this.setAlignmentX(0.0f);
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension d = super.getPreferredSize();
            return new Dimension(this.getMaxWidth() + 11, d.height);
        }

        private int getMaxWidth() {
            if (this.maxWidth == 0 && this.group != null) {
                int i;
                int max = 0;
                for (i = 0; i < this.group.length; ++i) {
                    max = Math.max(this.group[i].getSuperPreferredWidth(), max);
                }
                for (i = 0; i < this.group.length; ++i) {
                    this.group[i].maxWidth = max;
                }
            }
            return this.maxWidth;
        }

        private int getSuperPreferredWidth() {
            return super.getPreferredSize().width;
        }

        static /* synthetic */ AlignedLabel[] access$4302(AlignedLabel x0, AlignedLabel[] x1) {
            x0.group = x1;
            return x1;
        }
    }

    private static class ButtonAreaLayout
    implements LayoutManager {
        private int hGap = 5;
        private int topMargin = 17;

        private ButtonAreaLayout() {
        }

        @Override
        public void addLayoutComponent(String string, Component comp) {
        }

        @Override
        public void layoutContainer(Container container) {
            Component[] children = container.getComponents();
            if (children != null && children.length > 0) {
                int xOffset;
                int xLocation;
                int numChildren = children.length;
                Dimension[] sizes = new Dimension[numChildren];
                Insets insets = container.getInsets();
                int yLocation = insets.top + this.topMargin;
                int maxWidth = 0;
                for (int counter = 0; counter < numChildren; ++counter) {
                    sizes[counter] = children[counter].getPreferredSize();
                    maxWidth = Math.max(maxWidth, sizes[counter].width);
                }
                if (container.getComponentOrientation().isLeftToRight()) {
                    xLocation = container.getSize().width - insets.left - maxWidth;
                    xOffset = this.hGap + maxWidth;
                } else {
                    xLocation = insets.left;
                    xOffset = -(this.hGap + maxWidth);
                }
                for (int counter = numChildren - 1; counter >= 0; --counter) {
                    children[counter].setBounds(xLocation, yLocation, maxWidth, sizes[counter].height);
                    xLocation -= xOffset;
                }
            }
        }

        @Override
        public Dimension minimumLayoutSize(Container c) {
            Component[] children;
            if (c != null && (children = c.getComponents()) != null && children.length > 0) {
                int numChildren = children.length;
                int height = 0;
                Insets cInsets = c.getInsets();
                int extraHeight = this.topMargin + cInsets.top + cInsets.bottom;
                int extraWidth = cInsets.left + cInsets.right;
                int maxWidth = 0;
                for (int counter = 0; counter < numChildren; ++counter) {
                    Dimension aSize = children[counter].getPreferredSize();
                    height = Math.max(height, aSize.height);
                    maxWidth = Math.max(maxWidth, aSize.width);
                }
                return new Dimension(extraWidth + numChildren * maxWidth + (numChildren - 1) * this.hGap, extraHeight + height);
            }
            return new Dimension(0, 0);
        }

        @Override
        public Dimension preferredLayoutSize(Container c) {
            return this.minimumLayoutSize(c);
        }

        @Override
        public void removeLayoutComponent(Component c) {
        }
    }

    protected class DirectoryComboBoxAction
    extends AbstractAction {
        protected DirectoryComboBoxAction() {
            super("DirectoryComboBoxAction");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            File f = (File)OracleFileChooserUI.this.directoryComboBox.getSelectedItem();
            OracleFileChooserUI.this.getFileChooser().setCurrentDirectory(f);
        }
    }

    protected class FilterComboBoxModel
    extends AbstractListModel
    implements ComboBoxModel,
    PropertyChangeListener {
        protected FileFilter[] filters;

        protected FilterComboBoxModel() {
            this.filters = OracleFileChooserUI.this.getFileChooser().getChoosableFileFilters();
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            String prop = e.getPropertyName();
            if (prop == "ChoosableFileFilterChangedProperty") {
                this.filters = (FileFilter[])e.getNewValue();
                this.fireContentsChanged(this, -1, -1);
            } else if (prop == "fileFilterChanged") {
                this.fireContentsChanged(this, -1, -1);
            }
        }

        @Override
        public void setSelectedItem(Object filter) {
            if (filter != null) {
                OracleFileChooserUI.this.getFileChooser().setFileFilter((FileFilter)filter);
                OracleFileChooserUI.this.setFileName(null);
                this.fireContentsChanged(this, -1, -1);
            }
        }

        @Override
        public Object getSelectedItem() {
            FileFilter currentFilter = OracleFileChooserUI.this.getFileChooser().getFileFilter();
            boolean found = false;
            if (currentFilter != null) {
                for (int i = 0; i < this.filters.length; ++i) {
                    if (this.filters[i] != currentFilter) continue;
                    found = true;
                }
                if (!found) {
                    OracleFileChooserUI.this.getFileChooser().addChoosableFileFilter(currentFilter);
                }
            }
            return OracleFileChooserUI.this.getFileChooser().getFileFilter();
        }

        @Override
        public int getSize() {
            if (this.filters != null) {
                return this.filters.length;
            }
            return 0;
        }

        @Override
        public Object getElementAt(int index) {
            if (index > this.getSize() - 1) {
                return OracleFileChooserUI.this.getFileChooser().getFileFilter();
            }
            if (this.filters != null) {
                return this.filters[index];
            }
            return null;
        }
    }

    public class FilterComboBoxRenderer
    extends DefaultListCellRenderer {
        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (value != null && value instanceof FileFilter) {
                this.setText(((FileFilter)value).getDescription());
            }
            return this;
        }
    }

    protected class DirectoryComboBoxModel
    extends AbstractListModel
    implements ComboBoxModel {
        Vector directories = new Vector();
        int[] depths = null;
        File selectedDirectory = null;
        JFileChooser chooser = OracleFileChooserUI.this.getFileChooser();
        FileSystemView fsv = this.chooser.getFileSystemView();

        public DirectoryComboBoxModel() {
            File dir = OracleFileChooserUI.this.getFileChooser().getCurrentDirectory();
            if (dir != null) {
                this.addItem(dir);
            }
        }

        private void addItem(File directory) {
            if (directory == null) {
                return;
            }
            this.directories.clear();
            File[] baseFolders = OracleFileChooserUI.this.useShellFolder ? (File[])ShellFolder.get("fileChooserComboBoxFolders") : this.fsv.getRoots();
            this.directories.addAll(Arrays.asList(baseFolders));
            File canonical = null;
            try {
                canonical = directory.getCanonicalFile();
            }
            catch (IOException e) {
                canonical = directory;
            }
            try {
                ShellFolder sf;
                File f = sf = ShellFolder.getShellFolder(canonical);
                Vector<ShellFolder> path = new Vector<ShellFolder>(10);
                do {
                    path.addElement((ShellFolder)f);
                } while ((f = ((File)f).getParentFile()) != null);
                int pathCount = path.size();
                for (int i = 0; i < pathCount; ++i) {
                    f = (File)path.get(i);
                    if (!this.directories.contains(f)) continue;
                    int topIndex = this.directories.indexOf(f);
                    for (int j = i - 1; j >= 0; --j) {
                        this.directories.insertElementAt(path.get(j), topIndex + i - j);
                    }
                    break;
                }
                this.calculateDepths();
                this.setSelectedItem(sf);
            }
            catch (FileNotFoundException ex) {
                this.calculateDepths();
            }
        }

        private void calculateDepths() {
            this.depths = new int[this.directories.size()];
            block0: for (int i = 0; i < this.depths.length; ++i) {
                File dir = (File)this.directories.get(i);
                File parent = dir.getParentFile();
                this.depths[i] = 0;
                if (parent == null) continue;
                for (int j = i - 1; j >= 0; --j) {
                    if (!parent.equals((File)this.directories.get(j))) continue;
                    this.depths[i] = this.depths[j] + 1;
                    continue block0;
                }
            }
        }

        public int getDepth(int i) {
            return this.depths != null && i >= 0 && i < this.depths.length ? this.depths[i] : 0;
        }

        @Override
        public void setSelectedItem(Object selectedDirectory) {
            this.selectedDirectory = (File)selectedDirectory;
            this.fireContentsChanged(this, -1, -1);
        }

        @Override
        public Object getSelectedItem() {
            return this.selectedDirectory;
        }

        @Override
        public int getSize() {
            return this.directories.size();
        }

        @Override
        public Object getElementAt(int index) {
            return this.directories.elementAt(index);
        }
    }

    class IndentIcon
    implements Icon {
        Icon icon = null;
        int depth = 0;

        IndentIcon() {
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            if (c.getComponentOrientation().isLeftToRight()) {
                this.icon.paintIcon(c, g, x + this.depth * 10, y);
            } else {
                this.icon.paintIcon(c, g, x, y);
            }
        }

        @Override
        public int getIconWidth() {
            return this.icon.getIconWidth() + this.depth * 10;
        }

        @Override
        public int getIconHeight() {
            return this.icon.getIconHeight();
        }
    }

    class DirectoryComboBoxRenderer
    extends DefaultListCellRenderer {
        IndentIcon ii;

        DirectoryComboBoxRenderer() {
            this.ii = new IndentIcon();
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Icon icon;
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (value == null) {
                this.setText("");
                return this;
            }
            File directory = (File)value;
            this.setText(OracleFileChooserUI.this.getFileChooser().getName(directory));
            this.ii.icon = icon = OracleFileChooserUI.this.getFileChooser().getIcon(directory);
            this.ii.depth = OracleFileChooserUI.this.directoryComboBoxModel.getDepth(index);
            this.setIcon(this.ii);
            return this;
        }
    }

    protected class FileRenderer
    extends DefaultListCellRenderer {
        protected FileRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            File file = (File)value;
            String fileName = OracleFileChooserUI.this.getFileChooser().getName(file);
            this.setText(fileName);
            Icon icon = OracleFileChooserUI.this.getFileChooser().getIcon(file);
            this.setIcon(icon);
            if (isSelected) {
                OracleFileChooserUI.this.editX = icon.getIconWidth() + 4;
            }
            return this;
        }
    }

    class EditActionListener
    implements ActionListener {
        EditActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            OracleFileChooserUI.this.applyEdit();
        }
    }

    protected class SingleClickListener
    extends MouseAdapter {
        JList list;

        public SingleClickListener(JList list) {
            this.list = list;
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (SwingUtilities.isLeftMouseButton(e)) {
                if (e.getClickCount() == 1) {
                    JFileChooser fc = OracleFileChooserUI.this.getFileChooser();
                    int index = this.list.locationToIndex(e.getPoint());
                    if ((!fc.isMultiSelectionEnabled() || fc.getSelectedFiles().length <= 1) && index >= 0 && this.list.isSelectedIndex(index) && OracleFileChooserUI.this.getEditIndex() == index && OracleFileChooserUI.this.editFile == null) {
                        OracleFileChooserUI.this.editFileName(index);
                    } else if (index >= 0) {
                        OracleFileChooserUI.this.setEditIndex(index);
                    } else {
                        OracleFileChooserUI.this.resetEditIndex();
                    }
                } else {
                    OracleFileChooserUI.this.resetEditIndex();
                }
            }
        }
    }

    private class DelayedSelectionUpdater
    implements Runnable {
        private File editFile;

        DelayedSelectionUpdater() {
            this(null);
        }

        DelayedSelectionUpdater(File editFile) {
            this.editFile = editFile;
            SwingUtilities.invokeLater(this);
        }

        @Override
        public void run() {
            OracleFileChooserUI.this.setFileSelected();
            if (this.editFile == null) {
                return;
            }
            int index = OracleFileChooserUI.this.getModel().indexOf(this.editFile);
            if (index != -1) {
                JFileChooser chooser = OracleFileChooserUI.this.getFileChooser();
                OracleFileChooserUI.this.listSelectionModel.setValueIsAdjusting(true);
                OracleFileChooserUI.this.listSelectionModel.clearSelection();
                index = OracleFileChooserUI.this.detailsTableRowSorter.convertRowIndexToView(index);
                OracleFileChooserUI.this.listSelectionModel.addSelectionInterval(index, index);
                OracleFileChooserUI.this.listSelectionModel.setValueIsAdjusting(false);
                OracleFileChooserUI.this.ensureFileIsVisible(chooser, this.editFile);
            }
        }
    }

    class DetailsTableCellRenderer
    extends DefaultTableCellRenderer {
        JFileChooser chooser;
        DateFormat df;

        DetailsTableCellRenderer(JFileChooser chooser) {
            this.chooser = chooser;
            this.df = DateFormat.getDateTimeInstance(3, 3, chooser.getLocale());
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            int originalColumn = column;
            column = table.convertColumnIndexToModel(column);
            if (!System.getProperty("os.name").startsWith("Windows") && column == 2) {
                column = 3;
            }
            if (column == 1 || column == 4) {
                this.setHorizontalAlignment(11);
            } else {
                this.setHorizontalAlignment(10);
            }
            Object newValue = null;
            if (value != null) {
                File f = (File)value;
                switch (column) {
                    case 0: {
                        newValue = f;
                        break;
                    }
                    case 1: {
                        if (!f.exists() || f.isDirectory()) break;
                        long len = f.length() / 1024L;
                        if (len < 1024L) {
                            newValue = (len == 0L ? 1L : len) + " KB";
                            break;
                        }
                        if ((len /= 1024L) < 1024L) {
                            newValue = len + " MB";
                            break;
                        }
                        newValue = (len /= 1024L) + " GB";
                        break;
                    }
                    case 2: {
                        if (!f.exists()) break;
                        newValue = this.chooser.getFileSystemView().getSystemTypeDescription(f);
                        break;
                    }
                    case 3: {
                        if (!f.exists() || this.chooser.getFileSystemView().isFileSystemRoot(f)) break;
                        long time = f.lastModified();
                        newValue = time == 0L ? null : new Date(time);
                        break;
                    }
                    case 4: {
                        if (!f.exists() || this.chooser.getFileSystemView().isFileSystemRoot(f)) break;
                        String strValue = "";
                        if (!f.canWrite()) {
                            strValue = strValue + "R";
                        }
                        if (f.isHidden()) {
                            strValue = strValue + "H";
                        }
                        newValue = strValue;
                        break;
                    }
                }
            }
            return super.getTableCellRendererComponent(table, newValue, isSelected, hasFocus, row, originalColumn);
        }

        @Override
        public void setValue(Object value) {
            this.setIcon(null);
            if (value instanceof File) {
                File file = (File)value;
                String fileName = this.chooser.getName(file);
                this.setText(fileName);
                Icon icon = this.chooser.getIcon(file);
                this.setIcon(icon);
            } else if (value instanceof Date) {
                this.setText(value == null ? "" : this.df.format((Date)value));
            } else {
                super.setValue(value);
            }
        }
    }

    class DetailsTableModel
    extends AbstractTableModel
    implements ListDataListener {
        String[] columnNames;
        JFileChooser chooser;
        ListModel listModel;

        DetailsTableModel(JFileChooser fc) {
            this.columnNames = new String[]{OracleFileChooserUI.this.fileNameHeaderText, OracleFileChooserUI.this.fileSizeHeaderText, OracleFileChooserUI.this.fileTypeHeaderText, OracleFileChooserUI.this.fileDateHeaderText, OracleFileChooserUI.this.fileAttrHeaderText};
            this.chooser = fc;
            this.listModel = OracleFileChooserUI.this.getModel();
            this.listModel.addListDataListener(this);
        }

        @Override
        public int getRowCount() {
            return this.listModel.getSize();
        }

        @Override
        public int getColumnCount() {
            return 5;
        }

        @Override
        public String getColumnName(int column) {
            return this.columnNames[column];
        }

        public Class getColumnClass(int column) {
            return File.class;
        }

        @Override
        public Object getValueAt(int row, int col) {
            File f = (File)this.listModel.getElementAt(row);
            return f;
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            if (col == 0) {
                JFileChooser chooser = OracleFileChooserUI.this.getFileChooser();
                File f = (File)this.getValueAt(row, col);
                if (f != null) {
                    String oldDisplayName = chooser.getName(f);
                    String oldFileName = f.getName();
                    String newDisplayName = ((String)value).trim();
                    if (!newDisplayName.equals(oldDisplayName)) {
                        FileSystemView fsv;
                        File f2;
                        int i2;
                        String newFileName = newDisplayName;
                        int i1 = oldFileName.length();
                        if (i1 > (i2 = oldDisplayName.length()) && oldFileName.charAt(i2) == '.') {
                            newFileName = newDisplayName + oldFileName.substring(i2);
                        }
                        if (!(f2 = (fsv = chooser.getFileSystemView()).createFileObject(f.getParentFile(), newFileName)).exists() && OracleFileChooserUI.this.getModel().renameFile(f, f2) && fsv.isParent(chooser.getCurrentDirectory(), f2)) {
                            if (chooser.isMultiSelectionEnabled()) {
                                chooser.setSelectedFiles(new File[]{f2});
                            } else {
                                chooser.setSelectedFile(f2);
                            }
                        }
                    }
                }
            }
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return column == 0;
        }

        @Override
        public void contentsChanged(ListDataEvent e) {
            this.fireTableDataChanged();
        }

        @Override
        public void intervalAdded(ListDataEvent e) {
            this.fireTableDataChanged();
        }

        @Override
        public void intervalRemoved(ListDataEvent e) {
            this.fireTableDataChanged();
        }
    }
}

