/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.json.objects;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.util.Date;
import java.util.Iterator;
import javax.inject.Inject;
import oracle.dbtools.common.immutables.Immutables;
import oracle.dbtools.common.util.PrimitiveTypes;
import oracle.dbtools.json.JSONStreamsProvider;
import oracle.dbtools.json.objects.JSONArrayBuilder;
import oracle.dbtools.json.objects.JSONObjectBuilder;
import oracle.dbtools.objects.IterableContainer;
import oracle.dbtools.objects.MapContainer;
import oracle.dbtools.objects.ObjectGraphs;
import oracle.dbtools.objects.impl.ObjectGraphsProvider;
import oracle.dbtools.plugin.api.di.annotations.Provides;
import oracle.dbtools.plugin.api.json.JSONIOException;
import oracle.dbtools.plugin.api.json.JSONReader;
import oracle.dbtools.plugin.api.json.JSONStreams;
import oracle.dbtools.plugin.api.json.JSONToken;
import oracle.dbtools.plugin.api.json.JSONWriter;
import oracle.dbtools.plugin.api.json.objects.JSONArray;
import oracle.dbtools.plugin.api.json.objects.JSONNode;
import oracle.dbtools.plugin.api.json.objects.JSONObject;
import oracle.dbtools.plugin.api.json.objects.JSONObjects;

@Provides
public class JSONObjectsProvider
implements JSONObjects {
    private final ObjectGraphs objects;
    private final JSONStreams streams;
    private static final ObjectGraphs OBJECTS = new ObjectGraphsProvider(Immutables.maps());
    private static final JSONStreams STREAMS = new JSONStreamsProvider();

    public JSONObjectsProvider() {
        this(STREAMS, OBJECTS);
    }

    @Inject
    JSONObjectsProvider(JSONStreams streams, ObjectGraphs objects) {
        this.streams = streams;
        this.objects = objects;
    }

    public JSONArray.Builder array() {
        return new JSONArrayBuilder(this);
    }

    public JSONObject.Builder object() {
        return new JSONObjectBuilder(this);
    }

    public JSONNode read(CharSequence text) {
        JSONReader reader = this.streams.jsonReader(text);
        return this.read((Iterator<JSONToken>)reader);
    }

    public JSONNode read(InputStream stream) throws JSONIOException {
        JSONReader reader = this.streams.jsonReader(stream);
        return this.read((Iterator<JSONToken>)reader);
    }

    public JSONNode read(Iterator<JSONToken> json) {
        JSONObject node = null;
        if (json.hasNext()) {
            JSONToken event = json.next();
            if (JSONToken.Type.START_OBJECT == event.type()) {
                node = this.parseObject(json);
            } else if (JSONToken.Type.START_ARRAY == event.type()) {
                node = this.parseArray(json);
            } else {
                throw this.error(event.toString(), "{", "[");
            }
        }
        return node;
    }

    public JSONNode read(Reader stream) throws JSONIOException {
        JSONReader reader = this.streams.jsonReader((Readable)stream);
        return this.read((Iterator<JSONToken>)reader);
    }

    public void write(Appendable stream, JSONNode node) throws JSONIOException {
        JSONWriter writer = this.streams.jsonWriter(stream);
        this.write(writer, node);
    }

    public void write(Appendable stream, Object objectGraph) throws JSONIOException {
        JSONWriter writer = this.streams.jsonWriter(stream);
        this.write(writer, objectGraph);
    }

    public void write(JSONWriter writer, JSONNode node) {
        switch (node.type()) {
            case ARRAY: {
                this.write(writer, (JSONArray)node);
                break;
            }
            case OBJECT: {
                this.write(writer, (JSONObject)node);
            }
        }
    }

    public void write(JSONWriter writer, Object value) {
        if ((value = this.adapt(value)) == null) {
            writer.nullValue();
        } else if (value instanceof CharSequence) {
            writer.value((CharSequence)value);
        } else if (value instanceof Number) {
            writer.value((Number)value);
        } else if (value instanceof Boolean) {
            writer.value((Boolean)value);
        } else if (value instanceof Date) {
            String text = (String)PrimitiveTypes.valueOf((Date)((Date)value), String.class);
            writer.value((CharSequence)text);
        } else if (value instanceof JSONObject) {
            this.write(writer, (JSONObject)value);
        } else if (value instanceof JSONArray) {
            this.write(writer, (JSONArray)value);
        } else if (value instanceof MapContainer) {
            this.write(writer, (MapContainer)value);
        } else if (value instanceof IterableContainer) {
            this.write(writer, (IterableContainer)value);
        } else {
            throw new IllegalArgumentException(value.getClass().getName());
        }
    }

    public void write(OutputStream stream, JSONNode node) throws JSONIOException {
        JSONWriter writer = this.streams.jsonWriter(stream);
        this.write(writer, node);
    }

    public void write(OutputStream stream, Object objectGraph) throws JSONIOException {
        JSONWriter writer = this.streams.jsonWriter(stream);
        this.write(writer, objectGraph);
    }

    boolean isValidType(Object value) {
        boolean valid = value instanceof CharSequence || value instanceof Number || value instanceof Boolean || value instanceof JSONNode || this.objects.isLegal(value.getClass());
        return valid;
    }

    private Object adapt(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof JSONNode) {
            return value;
        }
        return this.objects.adapt(value);
    }

    private IllegalStateException eof(CharSequence ... expected) {
        return this.error("EOF", expected);
    }

    private IllegalStateException error(CharSequence actual, CharSequence ... expected) {
        StringBuilder b = new StringBuilder("Expected one of: <<");
        for (int i = 0; i < expected.length; ++i) {
            b.append(expected[i]);
            if (i >= expected.length - 1) continue;
            b.append(",");
        }
        b.append(">> but got: <<");
        b.append(actual);
        b.append(">>");
        return new IllegalStateException(b.toString());
    }

    private JSONArray parseArray(Iterator<JSONToken> json) {
        JSONArray.Builder values = this.array();
        block9: while (json.hasNext()) {
            JSONToken value = json.next();
            switch (value.type()) {
                case STRING_VALUE: {
                    values.add((CharSequence)value.stringValue());
                    continue block9;
                }
                case NUMERIC_VALUE: {
                    values.add(value.numberValue());
                    continue block9;
                }
                case BOOLEAN_VALUE: {
                    values.add(Boolean.valueOf(value.booleanValue()));
                    continue block9;
                }
                case NULL_VALUE: {
                    values.addNull();
                    continue block9;
                }
                case START_OBJECT: {
                    values.add((JSONNode)this.parseObject(json));
                    continue block9;
                }
                case START_ARRAY: {
                    values.add((JSONNode)this.parseArray(json));
                    continue block9;
                }
                case END_ARRAY: {
                    return values.build();
                }
            }
            throw this.error(value.toString(), "value", "]");
        }
        throw this.eof("]");
    }

    private JSONObject parseObject(Iterator<JSONToken> json) {
        JSONObject.Builder b = this.object();
        block12: while (json.hasNext()) {
            JSONToken event = json.next();
            switch (event.type()) {
                case PROPERTY_NAME: {
                    JSONToken value = json.next();
                    switch (value.type()) {
                        case STRING_VALUE: {
                            b.add(event.propertyName(), (CharSequence)value.stringValue());
                            continue block12;
                        }
                        case NUMERIC_VALUE: {
                            b.add(event.propertyName(), value.numberValue());
                            continue block12;
                        }
                        case BOOLEAN_VALUE: {
                            b.add(event.propertyName(), Boolean.valueOf(value.booleanValue()));
                            continue block12;
                        }
                        case NULL_VALUE: {
                            b.addNull(event.propertyName());
                            continue block12;
                        }
                        case START_OBJECT: {
                            b.add(event.propertyName(), (JSONNode)this.parseObject(json));
                            continue block12;
                        }
                        case START_ARRAY: {
                            b.add(event.propertyName(), (JSONNode)this.parseArray(json));
                            continue block12;
                        }
                    }
                    throw this.error(event.toString(), "value");
                }
                case END_OBJECT: {
                    return b.build();
                }
            }
            throw this.error(event.toString(), "value", "}");
        }
        throw this.eof("}");
    }

    private void write(JSONWriter writer, IterableContainer iterable) {
        writer.startArray();
        for (Object value : iterable.elements()) {
            this.write(writer, value);
        }
        writer.endArray();
    }

    private void write(JSONWriter writer, JSONArray array) {
        writer.startArray();
        for (Object value : array.values()) {
            this.write(writer, value);
        }
        writer.endArray();
    }

    private void write(JSONWriter writer, JSONObject object) {
        writer.startObject();
        for (String propertyName : object.propertyNames()) {
            writer.propertyName(propertyName);
            Object value = object.get(propertyName);
            this.write(writer, value);
        }
        writer.endObject();
    }

    private void write(JSONWriter writer, MapContainer map) {
        writer.startObject();
        for (String propertyName : map.keySet()) {
            writer.propertyName(propertyName);
            Object value = map.get((CharSequence)propertyName);
            this.write(writer, value);
        }
        writer.endObject();
    }
}

