/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.json.objects;

import java.util.LinkedHashMap;
import java.util.Map;
import oracle.dbtools.json.objects.JSONObjectImpl;
import oracle.dbtools.json.objects.JSONObjectsProvider;
import oracle.dbtools.plugin.api.json.objects.JSONNode;
import oracle.dbtools.plugin.api.json.objects.JSONObject;

class JSONObjectBuilder
implements JSONObject.Builder {
    private final JSONObjectsProvider json;
    private final Map<String, Object> properties = new LinkedHashMap<String, Object>();

    JSONObjectBuilder(JSONObjectsProvider json) {
        this.json = json;
    }

    public JSONObjectBuilder add(JSONObject existing) {
        for (String propertyName : existing.propertyNames()) {
            this._add(propertyName, existing.get(propertyName));
        }
        return this;
    }

    public JSONObjectBuilder add(String propertyName, Boolean value) {
        return this._add(propertyName, value);
    }

    public JSONObjectBuilder add(String propertyName, CharSequence value) {
        return this._add(propertyName, value);
    }

    public JSONObjectBuilder add(String propertyName, JSONNode value) {
        return this._add(propertyName, value);
    }

    public JSONObjectBuilder add(String propertyName, Number value) {
        return this._add(propertyName, value);
    }

    public JSONObjectBuilder add(String propertyName, Object value) {
        if (value == null) {
            return this.addNull(propertyName);
        }
        if (this.json.isValidType(value)) {
            return this._add(propertyName, value);
        }
        throw new IllegalArgumentException();
    }

    public JSONObjectBuilder addNull(String propertyName) {
        return this._add(propertyName, null);
    }

    public JSONObject build() {
        return new JSONObjectImpl(this.json, this.properties);
    }

    public JSONObjectBuilder remove(String propertyName) {
        this.properties.remove(propertyName);
        return this;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("JSONObjectBuilder [properties=");
        builder.append(this.properties);
        builder.append("]");
        return builder.toString();
    }

    private JSONObjectBuilder _add(String propertyName, Object value) {
        this.properties.put(propertyName, value);
        return this;
    }
}

