/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.json;

import java.math.BigDecimal;
import oracle.dbtools.common.util.PrimitiveTypes;
import oracle.dbtools.plugin.api.json.JSONToken;

public class JSONTokenImpl
implements JSONToken {
    private final JSONToken.Type type;
    private final Object value;
    private static final JSONToken END_ARRAY_EVENT = JSONTokenImpl.event(JSONToken.Type.END_ARRAY);
    private static final JSONToken END_OBJECT_EVENT = JSONTokenImpl.event(JSONToken.Type.END_OBJECT);
    private static final JSONToken FALSE_VALUE_EVENT = new JSONTokenImpl(JSONToken.Type.BOOLEAN_VALUE, Boolean.FALSE);
    private static final JSONToken NULL_VALUE_EVENT = JSONTokenImpl.event(JSONToken.Type.NULL_VALUE);
    private static final JSONToken START_ARRAY_EVENT = JSONTokenImpl.event(JSONToken.Type.START_ARRAY);
    private static final JSONToken START_OBJECT_EVENT = JSONTokenImpl.event(JSONToken.Type.START_OBJECT);
    private static final JSONToken TRUE_VALUE_EVENT = new JSONTokenImpl(JSONToken.Type.BOOLEAN_VALUE, Boolean.TRUE);

    private JSONTokenImpl(JSONToken.Type type, Object value) {
        this.type = type;
        this.value = value;
    }

    public boolean booleanValue() {
        return (Boolean)this.value;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        JSONTokenImpl other = (JSONTokenImpl)obj;
        if (this.type == null ? other.type != null : !this.type.equals((Object)other.type)) {
            return false;
        }
        if (this.value == null) {
            return other.value == null;
        }
        if (this.value instanceof CharSequence && other.value instanceof CharSequence) {
            return this.equals((CharSequence)this.value, (CharSequence)other.value);
        }
        return this.value.equals(other.value);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    public Number numberValue() {
        return (Number)this.value;
    }

    public String propertyName() {
        return this.value.toString();
    }

    public String stringValue() {
        return (String)this.value;
    }

    public String toString() {
        return "JSONEvent [type=" + this.type + ", value=" + this.value + "]";
    }

    public JSONToken.Type type() {
        return this.type;
    }

    private boolean equals(CharSequence value, CharSequence otherValue) {
        return value.toString().equals(otherValue.toString());
    }

    public static JSONToken endArray() {
        return END_ARRAY_EVENT;
    }

    public static JSONToken endObject() {
        return END_OBJECT_EVENT;
    }

    public static JSONToken falseValue() {
        return FALSE_VALUE_EVENT;
    }

    public static JSONToken nullValue() {
        return NULL_VALUE_EVENT;
    }

    public static JSONToken numericValue(Number value) {
        BigDecimal number = (BigDecimal)PrimitiveTypes.valueOf((Number)value, BigDecimal.class);
        return new JSONTokenImpl(JSONToken.Type.NUMERIC_VALUE, number);
    }

    public static JSONToken propertyName(CharSequence name) {
        return new JSONTokenImpl(JSONToken.Type.PROPERTY_NAME, name);
    }

    public static JSONToken startArray() {
        return START_ARRAY_EVENT;
    }

    public static JSONToken startObject() {
        return START_OBJECT_EVENT;
    }

    public static JSONToken stringValue(CharSequence value) {
        return new JSONTokenImpl(JSONToken.Type.STRING_VALUE, value.toString());
    }

    public static JSONToken trueValue() {
        return TRUE_VALUE_EVENT;
    }

    private static JSONToken event(JSONToken.Type type) {
        return new JSONTokenImpl(type, null);
    }
}

