/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.json;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import javax.inject.Inject;
import oracle.dbtools.common.util.Readers;
import oracle.dbtools.common.util.Text;
import oracle.dbtools.json.JSONReaderImpl;
import oracle.dbtools.json.JSONWriterImpl;
import oracle.dbtools.plugin.api.di.annotations.Provides;
import oracle.dbtools.plugin.api.json.JSONReader;
import oracle.dbtools.plugin.api.json.JSONStreams;
import oracle.dbtools.plugin.api.json.JSONWriter;

@Provides
public class JSONStreamsProvider
implements JSONStreams {
    @Inject
    public JSONStreamsProvider() {
    }

    public JSONReader jsonReader(CharSequence text) {
        return this.jsonReader(Readers.reader((CharSequence)text));
    }

    public JSONReader jsonReader(InputStream stream) {
        return this.jsonReader(new InputStreamReader(stream, Text.defaultCharset()));
    }

    public JSONReader jsonReader(Readable stream) {
        return new JSONReaderImpl(stream);
    }

    public JSONWriter jsonWriter(Appendable stream) {
        return new JSONWriterImpl(stream);
    }

    public JSONWriter jsonWriter(OutputStream stream) {
        return this.jsonWriter(new OutputStreamWriter(stream, Text.defaultCharset()));
    }
}

