/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.json;

import oracle.dbtools.common.util.AssociativeArray;
import oracle.dbtools.common.util.AssociativeArrays;

public class JSONOptions {
    private final NullValues nullHandling;
    public static final JSONOptions DEFAULT_JSON_OPTIONS = JSONOptions.configure((AssociativeArray<CharSequence, CharSequence>)AssociativeArrays.empty());

    private JSONOptions(NullValues nullHandling) {
        this.nullHandling = nullHandling;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        JSONOptions other = (JSONOptions)obj;
        return this.nullHandling == other.nullHandling;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.nullHandling == null ? 0 : this.nullHandling.hashCode());
        return result;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("JSONOptions [nullHandling=");
        builder.append((Object)this.nullHandling);
        builder.append("]");
        return builder.toString();
    }

    boolean excludeNulls() {
        return NullValues.EXCLUDE == this.nullHandling;
    }

    boolean includeNulls() {
        return NullValues.INCLUDE == this.nullHandling;
    }

    public static JSONOptions configure(AssociativeArray<CharSequence, CharSequence> parameters) {
        CharSequence value = (CharSequence)parameters.get((Object)"json-nulls");
        NullValues nullHandling = NullValues.value(value);
        return new JSONOptions(nullHandling);
    }

    static enum NullValues {
        EXCLUDE,
        INCLUDE;


        static NullValues value(CharSequence text) {
            NullValues handling = EXCLUDE;
            if (text != null) {
                handling = NullValues.valueOf(text.toString().toUpperCase());
            }
            return handling;
        }
    }
}

