#!/bin/bash

if [[ -z "$(which POST)" ]]; then
    echo "POST command not found, please install libwww-perl"
    exit 1;
fi

if [[ -z "$1" || -z "$2" ]]; then
    echo "usage: run-function <path.of.object> <methodName> [param1=value1 param2=value2 ...]"
fi

OBJECT=$1
METHOD=$2
shift
shift
CONTENT_TYPE="application/x-sah-ws-4-call+json"
HOST=${HOST:=localhost}
PORT=${PORT:=7000}
RQPATH=ws

BODY="{\"service\": \"${OBJECT}\", \"method\": \"${METHOD}\", \"parameters\": {  "

for i in "$@"; do
    P="${i%=*}"
    V="${i#*=}"
    BODY="${BODY}\"${P}\": \"${V}\", "
done

BODY="${BODY:0:-2}}}"

echo "${BODY}" | POST -c "${CONTENT_TYPE}" "http://${HOST}:${PORT}/${RQPATH}"
