/****************************************************************************
**
** Copyright (C) 2011 SoftAtHome. All rights reserved.
**
** SoftAtHome reserves all rights not expressly granted herein.
**
** - DISCLAIMER OF WARRANTY -
**
** THIS FILE IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND, EITHER
** EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO, THE IMPLIED
** WARRANTIES OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR
** PURPOSE.
**
** THE ENTIRE RISK AS TO THE QUALITY AND PERFORMANCE OF THE SOURCE
** CODE IS WITH YOU. SHOULD THE SOURCE CODE PROVE DEFECTIVE, YOU
** ASSUME THE COST OF ALL NECESSARY SERVICING, REPAIR OR CORRECTION.
**
** - LIMITATION OF LIABILITY -
**
** IN NO EVENT UNLESS REQUIRED BY APPLICABLE LAW OR AGREED TO IN
** WRITING WILL ANY COPYRIGHT HOLDER, OR ANY OTHER PARTY WHO MODIFIES
** AND/OR DISTRIBUTES THE SOURCE CODE, BE LIABLE TO YOU FOR DAMAGES,
** INCLUDING ANY GENERAL, SPECIAL, INCIDENTAL OR CONSEQUENTIAL DAMAGES
** ARISING OUT OF THE USE OR INABILITY TO USE THE SOURCE CODE
** (INCLUDING BUT NOT LIMITED TO LOSS OF DATA OR DATA BEING RENDERED
** INACCURATE OR LOSSES SUSTAINED BY YOU OR THIRD PARTIES OR A FAILURE
** OF THE SOURCE CODE TO OPERATE WITH ANY OTHER PROGRAM), EVEN IF SUCH
** HOLDER OR OTHER PARTY HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH
** DAMAGES.
**
****************************************************************************/

#include <stdlib.h>
#include <pcb/pcb_client.h>
#include "common.h"

void print_parameters(object_t *object) {
    // print all parameters
    if (object_hasParameters(object)) {
        printf("\n    Parameters\n");
        printf("    ==========\n");
        parameter_t *parameter = NULL;
        char *value = NULL;
        object_for_each_parameter(parameter, object) {
            value = variant_char(parameter_getValue(parameter));
            printf("        %s Parameter %s = %s\n",parameter_typeName(parameter), parameter_name(parameter), value);
            free(value);
        }
    }
}

void print_functions(object_t *object) {
    // print all functions
    if (object_hasFunctions(object)) {
        printf("\n    Functions\n");
        printf("    ==========\n");
        function_t *function = NULL;
        function_argument_t *argument = NULL;
        const char *sep = "";
        object_for_each_function(function, object) {
            printf("        %s %s(",function_typeName(function),function_name(function));
            // print all arguments of the function
            argument = function_firstArgument(function);
            while(argument) {
                printf("%s %s %s",sep,argument_typeName(argument), argument_name(argument));
                argument = function_nextArgument(argument);
                sep = ",";
            }
            if (function_isVariadic(function)) {
                printf("%s ...",sep);
            }
            printf(" )\n");
            sep = "";
        }
    }
}

void print_object(object_t *object) {
    SAH_TRACE_IN();
    char *path = NULL;

    printf("Object:\n");
    // print index path
    path = object_pathChar(object, path_attr_default);
    printf("    Index path = %s\n",path);
    free(path);

    // print key path
    path = object_pathChar(object, path_attr_key_notation);
    printf("    Key path = %s\n",path);
    free(path);

    // print all parameters
    print_parameters(object);

    // print all functions
    print_functions(object);

    printf("\n");
    SAH_TRACE_OUT();
}

void print_notification(notification_t *notify) {
    // print notification name
    printf("Notification: %s (%d)\n",notification_name(notify),notification_type(notify));
    printf("\n    Parameters\n");
    printf("    ==========\n");
    notification_parameter_t *parameter = notification_firstParameter(notify);
    while(parameter) {
        printf("        %s = %s\n",notification_parameter_name(parameter),notification_parameter_value(parameter));
        parameter = notification_nextParameter(parameter);
    }
    printf("\n");
}
