/****************************************************************************
**
** Copyright (C) 2011 SoftAtHome. All rights reserved.
**
** SoftAtHome reserves all rights not expressly granted herein.
**
** - DISCLAIMER OF WARRANTY -
**
** THIS FILE IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND, EITHER
** EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO, THE IMPLIED
** WARRANTIES OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR
** PURPOSE.
**
** THE ENTIRE RISK AS TO THE QUALITY AND PERFORMANCE OF THE SOURCE
** CODE IS WITH YOU. SHOULD THE SOURCE CODE PROVE DEFECTIVE, YOU
** ASSUME THE COST OF ALL NECESSARY SERVICING, REPAIR OR CORRECTION.
**
** - LIMITATION OF LIABILITY -
**
** IN NO EVENT UNLESS REQUIRED BY APPLICABLE LAW OR AGREED TO IN
** WRITING WILL ANY COPYRIGHT HOLDER, OR ANY OTHER PARTY WHO MODIFIES
** AND/OR DISTRIBUTES THE SOURCE CODE, BE LIABLE TO YOU FOR DAMAGES,
** INCLUDING ANY GENERAL, SPECIAL, INCIDENTAL OR CONSEQUENTIAL DAMAGES
** ARISING OUT OF THE USE OR INABILITY TO USE THE SOURCE CODE
** (INCLUDING BUT NOT LIMITED TO LOSS OF DATA OR DATA BEING RENDERED
** INACCURATE OR LOSSES SUSTAINED BY YOU OR THIRD PARTIES OR A FAILURE
** OF THE SOURCE CODE TO OPERATE WITH ANY OTHER PROGRAM), EVEN IF SUCH
** HOLDER OR OTHER PARTY HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH
** DAMAGES.
**
****************************************************************************/

#if !defined(PCB_CIRCULAR_BUFFER_H)
#define PCB_CIRCULAR_BUFFER_H

#ifdef __cplusplus
extern "C"
{
#endif

#include <unistd.h>
#include <stdio.h>
#include <stdbool.h>

/**
@ingroup pcb_utils_buffers
@file
@brief
Header file with circular buffer type definitions and circular buffer functions
*/

/**
@ingroup pcb_utils_buffers
@defgroup pcb_utils_buffers_circbuf Circular Buffer
@{

@brief
Circular Buffer handling functions.

@details
A circular buffer allows one to read an write to an in memory buffer, acting as a stream
and growing as needed. It expect reads and writes to be interlaced so that it will not
expand indefinitely
*/

//---------------------------------------------------------------------------------------------
/**
@brief
Circular buffer structure

@details
The circular buffer structure
*/
typedef struct _circbuf {
    FILE *stream;   /**< Stream that can be used to read from or write to */
    char *buffer;   /**< Memory buffer */
    size_t size;    /**< Size of the memory buffer */
    char *read;     /**< The read pointer */
    size_t toRead;  /**< Number of bytes that can be read */
    char *write;    /**< The write pointer */
    size_t toWrite; /**< Number of bytes that can be written */
    char seekMode;  /**< The seek mode */
} circbuf_t;

/**
@}
*/

bool circbuf_initialize(circbuf_t *circbuf, size_t size);
void circbuf_cleanup(circbuf_t *circbuf);
void circbuf_reset(circbuf_t *circbuf, size_t size);
FILE *circbuf_stream(circbuf_t *circbuf);
ssize_t circbuf_size(circbuf_t *circbuf);
ssize_t circbuf_availableForRead(circbuf_t *circbuf);
void *circbuf_readBuffer(circbuf_t *circbuf);
ssize_t circbuf_read(circbuf_t *circbuf, char *buffer, size_t size);
ssize_t circbuf_writeBuffer(circbuf_t *circbuf, const char *buffer, size_t size);
ssize_t circbuf_markAsRead(circbuf_t *circbuf, size_t size);
FILE *circbuf_fopen(circbuf_t *circbuf, const char *opentype);

// needs to be deprecated
static inline ssize_t circbuf_readCBuffer(circbuf_t *circbuf, char *buffer, size_t size)
{
   return circbuf_read(circbuf, buffer, size);
}

#ifdef __cplusplus
}
#endif

#endif // PCB_CIRCULAR_BUFFER_H
