/****************************************************************************
**
** Copyright (C) 2011 SoftAtHome. All rights reserved.
**
** SoftAtHome reserves all rights not expressly granted herein.
**
** - DISCLAIMER OF WARRANTY -
**
** THIS FILE IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND, EITHER
** EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO, THE IMPLIED
** WARRANTIES OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR
** PURPOSE.
**
** THE ENTIRE RISK AS TO THE QUALITY AND PERFORMANCE OF THE SOURCE
** CODE IS WITH YOU. SHOULD THE SOURCE CODE PROVE DEFECTIVE, YOU
** ASSUME THE COST OF ALL NECESSARY SERVICING, REPAIR OR CORRECTION.
**
** - LIMITATION OF LIABILITY -
**
** IN NO EVENT UNLESS REQUIRED BY APPLICABLE LAW OR AGREED TO IN
** WRITING WILL ANY COPYRIGHT HOLDER, OR ANY OTHER PARTY WHO MODIFIES
** AND/OR DISTRIBUTES THE SOURCE CODE, BE LIABLE TO YOU FOR DAMAGES,
** INCLUDING ANY GENERAL, SPECIAL, INCIDENTAL OR CONSEQUENTIAL DAMAGES
** ARISING OUT OF THE USE OR INABILITY TO USE THE SOURCE CODE
** (INCLUDING BUT NOT LIMITED TO LOSS OF DATA OR DATA BEING RENDERED
** INACCURATE OR LOSSES SUSTAINED BY YOU OR THIRD PARTIES OR A FAILURE
** OF THE SOURCE CODE TO OPERATE WITH ANY OTHER PROGRAM), EVEN IF SUCH
** HOLDER OR OTHER PARTY HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH
** DAMAGES.
**
****************************************************************************/

/**
@file
@brief
Header file that includes all utility header files
*/

/**
@defgroup pcb_utils Utilities
@{
@brief
Collection of utilities.

@details
The pcb utilities is a collection of functions intended to make development of common tasks easier.\n
The uitilities includes:
    - @ref pcb_utils_containers
    - @ref pcb_utils_buffers
    - @ref pcb_utils_uri
@}
*/

/**
@ingroup pcb_utils
@defgroup pcb_utils_buffers Buffering
@{
@brief
Collection of buffering utilities.

@details
Buffering methods, helps in allocating dynamic buffers and managing the buffers
@}
*/
#include <pcb/utils/circular_buffer.h>

/**
@ingroup pcb_utils
@defgroup pcb_utils_containers Containers
@{
@brief
Implementation of some simple containers.

@details
Implementation of some simple containers. The following containers are implemented:
    - doubly linked list: @ref pcb_utils_linked_list
    - string: string helper functions: @ref pcb_utils_string
    - string list: linked list contaning strings: @ref pcb_utils_string_list
    - variant: a container that contain a lot of different data types: @ref pcb_utils_variant
    - variant list: linked list of variants: @ref pcb_utils_variant_list
    - variant map: linked list of key-value pairs, where the value is represented by a variant: @ref pcb_utils_variant_map
@}
*/
#include <pcb/utils/linked_list.h>
#include <pcb/utils/string.h>
#include <pcb/utils/string_list.h>
#include <pcb/utils/tree.h>
#include <pcb/utils/variant.h>
#include <pcb/utils/variant_list.h>
#include <pcb/utils/variant_map.h>

/**
@ingroup pcb_utils
@defgroup pcb_utils_uri URI Parsing
@{
@brief
Helper functions to parse a URI.\n

@details
A set of functions to parse a URI from a string.\n
@}
*/
#include <pcb/utils/uri.h>

/**
@defgroup pcb_utils_socket_events Sockets, Files, Processes and Eventing
@{
@brief
Filed descriptor and event handling

@details
Collection of functions to help in creating and managing sockets and file descriptors, dispatch events and
building event loops.\n
This includes:
    - Timers: @ref pcb_utils_timers
    - Socket creation and event handling: @ref pcb_socket_layer_connections
    - Managing sockets and file descriptors: @ref pcb_socket_layer_peer
    - Managing child processes: @ref pcb_process_layer
@}
*/
#include <pcb/utils/connection.h>
#include <pcb/utils/peer.h>
#include <pcb/utils/timer.h>
#include <pcb/utils/process.h>
