/****************************************************************************
**
** Copyright (C) 2011 SoftAtHome. All rights reserved.
**
** SoftAtHome reserves all rights not expressly granted herein.
**
** - DISCLAIMER OF WARRANTY -
**
** THIS FILE IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND, EITHER
** EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO, THE IMPLIED
** WARRANTIES OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR
** PURPOSE.
**
** THE ENTIRE RISK AS TO THE QUALITY AND PERFORMANCE OF THE SOURCE
** CODE IS WITH YOU. SHOULD THE SOURCE CODE PROVE DEFECTIVE, YOU
** ASSUME THE COST OF ALL NECESSARY SERVICING, REPAIR OR CORRECTION.
**
** - LIMITATION OF LIABILITY -
**
** IN NO EVENT UNLESS REQUIRED BY APPLICABLE LAW OR AGREED TO IN
** WRITING WILL ANY COPYRIGHT HOLDER, OR ANY OTHER PARTY WHO MODIFIES
** AND/OR DISTRIBUTES THE SOURCE CODE, BE LIABLE TO YOU FOR DAMAGES,
** INCLUDING ANY GENERAL, SPECIAL, INCIDENTAL OR CONSEQUENTIAL DAMAGES
** ARISING OUT OF THE USE OR INABILITY TO USE THE SOURCE CODE
** (INCLUDING BUT NOT LIMITED TO LOSS OF DATA OR DATA BEING RENDERED
** INACCURATE OR LOSSES SUSTAINED BY YOU OR THIRD PARTIES OR A FAILURE
** OF THE SOURCE CODE TO OPERATE WITH ANY OTHER PROGRAM), EVEN IF SUCH
** HOLDER OR OTHER PARTY HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH
** DAMAGES.
**
****************************************************************************/

#if !defined(PCB_REQUESTHANDLERS_H)
#define PCB_REQUESTHANDLERS_H

#ifdef __cplusplus
extern "C"
{
#endif

#include <pcb/core/types.h>

bool default_sendErrorList(peer_info_t *peer, request_t *req);

bool default_getObject(peer_info_t *peer, object_t *object, uint32_t depth, uint32_t attributes, request_t *req);
bool default_replyParameters(peer_info_t *peer, object_t *object, request_t *req);
bool default_reply_object(peer_info_t *peer, object_t *object, uint32_t depth, uint32_t attributes, request_t *req, llist_t *parameters);

bool default_getObjectHandler(peer_info_t *peer, datamodel_t *datamodel, request_t *req);
bool default_setObjectHandler(peer_info_t *peer, datamodel_t *datamodel, request_t *req);
bool default_createInstanceHandler(peer_info_t *peer, datamodel_t *datamodel, request_t *req);
bool default_deleteInstanceHandler(peer_info_t *peer, datamodel_t *datamodel, request_t *req);
bool default_executeFunctionHandler(peer_info_t *peer, datamodel_t *datamodel, request_t *req);
bool default_findObjectsHandler(peer_info_t *peer, datamodel_t *datamodel, request_t *req);

bool default_closeRequestHandler(peer_info_t *peer, request_t *req);

bool default_openSessionRequestHandler(peer_info_t *peer, request_t *req);

#ifdef __cplusplus
}
#endif

#endif
