/****************************************************************************
**
** Copyright (C) 2011 SoftAtHome. All rights reserved.
**
** SoftAtHome reserves all rights not expressly granted herein.
**
** - DISCLAIMER OF WARRANTY -
**
** THIS FILE IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND, EITHER
** EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO, THE IMPLIED
** WARRANTIES OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR
** PURPOSE.
**
** THE ENTIRE RISK AS TO THE QUALITY AND PERFORMANCE OF THE SOURCE
** CODE IS WITH YOU. SHOULD THE SOURCE CODE PROVE DEFECTIVE, YOU
** ASSUME THE COST OF ALL NECESSARY SERVICING, REPAIR OR CORRECTION.
**
** - LIMITATION OF LIABILITY -
**
** IN NO EVENT UNLESS REQUIRED BY APPLICABLE LAW OR AGREED TO IN
** WRITING WILL ANY COPYRIGHT HOLDER, OR ANY OTHER PARTY WHO MODIFIES
** AND/OR DISTRIBUTES THE SOURCE CODE, BE LIABLE TO YOU FOR DAMAGES,
** INCLUDING ANY GENERAL, SPECIAL, INCIDENTAL OR CONSEQUENTIAL DAMAGES
** ARISING OUT OF THE USE OR INABILITY TO USE THE SOURCE CODE
** (INCLUDING BUT NOT LIMITED TO LOSS OF DATA OR DATA BEING RENDERED
** INACCURATE OR LOSSES SUSTAINED BY YOU OR THIRD PARTIES OR A FAILURE
** OF THE SOURCE CODE TO OPERATE WITH ANY OTHER PROGRAM), EVEN IF SUCH
** HOLDER OR OTHER PARTY HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH
** DAMAGES.
**
****************************************************************************/

#if !defined(PCB_REPLY_H)
#define PCB_REPLY_H

#ifdef __cplusplus
extern "C"
{
#endif

#include <pcb/utils/variant.h>
#include <pcb/core/types.h>

/**
@brief
Definition of a helper macro for iteration through the items of a reply

@details
This <b>helper macro</b> iterates forwards through the items of a reply\n

@param item a pointer to a reply item  that will contain the current item
@param reply the reply
*/
#define reply_for_each_item(item, reply) \
    for(item = reply_firstItem(reply); item; item = reply_nextItem(item))

#if __STDC_VERSION__ >= 199901L
/**
@brief
Definition of a helper macro for iteration through the items of a reply

@details
This <b>helper macro</b> iterates forwards through the items of a reply\n

@param item the name of a pointer to a reply item to be declared that will contain the current item
@param reply the reply
*/
#define reply_for_each_declare_item(item, reply) \
    for(reply_item_t *item = reply_firstItem(reply); item; item = reply_nextItem(item))
#endif

typedef enum _reply_item_type {
    reply_type_invalid = 0,
    reply_type_object,
    reply_type_notification,
    reply_type_error,
    reply_type_function_return,
} reply_item_type_t;

bool reply_initialize(reply_t *reply);
void reply_cleanup(reply_t *reply);
void reply_errorsCleanup(reply_t *reply);
void reply_clear(reply_t *reply);
request_t *reply_request(reply_t *reply);

uint32_t reply_itemCount(reply_t *reply);
reply_item_t *reply_firstItem(reply_t *reply);
reply_item_t *reply_nextItem(reply_item_t *item);

bool reply_itemsAvailable(reply_t *reply);
void reply_setCompleted(reply_t *reply, bool completed);
bool reply_isComplete(reply_t *reply);
bool reply_hasErrors(reply_t *reply);
uint32_t reply_firstError(reply_t *reply);

bool reply_addObject(reply_t *reply, object_t *object);
bool reply_addNotification(reply_t *reply, notification_t *object);
bool reply_addError(reply_t *reply, uint32_t error, const char *description, const char *info);
bool reply_addFunctionReturn(reply_t *reply, variant_t *retval, argument_value_list_t *returnArgs);

void reply_item_destroy(reply_item_t *item);
reply_item_t *reply_item_take(reply_item_t *item);
reply_item_type_t reply_item_type(reply_item_t *item);

object_t *reply_item_object(reply_item_t *item);
notification_t *reply_item_notification(reply_item_t *item);

uint32_t reply_item_error(reply_item_t *item);
const char *reply_item_errorDescription(reply_item_t *item);
const char *reply_item_errorInfo(reply_item_t *item);

const variant_t *reply_item_returnValue(reply_item_t *item);
argument_value_list_t *reply_item_returnArguments(reply_item_t *item);

#ifdef __cplusplus
}
#endif

#endif


