/****************************************************************************
**
** Copyright (C) 2011 SoftAtHome. All rights reserved.
**
** SoftAtHome reserves all rights not expressly granted herein.
**
** - DISCLAIMER OF WARRANTY -
**
** THIS FILE IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND, EITHER
** EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO, THE IMPLIED
** WARRANTIES OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR
** PURPOSE.
**
** THE ENTIRE RISK AS TO THE QUALITY AND PERFORMANCE OF THE SOURCE
** CODE IS WITH YOU. SHOULD THE SOURCE CODE PROVE DEFECTIVE, YOU
** ASSUME THE COST OF ALL NECESSARY SERVICING, REPAIR OR CORRECTION.
**
** - LIMITATION OF LIABILITY -
**
** IN NO EVENT UNLESS REQUIRED BY APPLICABLE LAW OR AGREED TO IN
** WRITING WILL ANY COPYRIGHT HOLDER, OR ANY OTHER PARTY WHO MODIFIES
** AND/OR DISTRIBUTES THE SOURCE CODE, BE LIABLE TO YOU FOR DAMAGES,
** INCLUDING ANY GENERAL, SPECIAL, INCIDENTAL OR CONSEQUENTIAL DAMAGES
** ARISING OUT OF THE USE OR INABILITY TO USE THE SOURCE CODE
** (INCLUDING BUT NOT LIMITED TO LOSS OF DATA OR DATA BEING RENDERED
** INACCURATE OR LOSSES SUSTAINED BY YOU OR THIRD PARTIES OR A FAILURE
** OF THE SOURCE CODE TO OPERATE WITH ANY OTHER PROGRAM), EVEN IF SUCH
** HOLDER OR OTHER PARTY HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH
** DAMAGES.
**
****************************************************************************/

#ifndef ACL_H
#define ACL_H

#include <pcb/utils/linked_list.h>

#ifdef __cplusplus
extern "C"
{
#endif

/**
*/
typedef enum _acl_flags {
    acl_execute      = 0x0001,
    acl_read_value   = 0x0001,
    acl_read         = 0x0002,
    acl_write        = 0x0004,
    acl_group_id     = 0x1000,
} acl_flags_t;

typedef struct _ACL_info ACL_t;

#define acl_for_each(acl, acllist) \
    for(acl = acl_first(acllist); acl; acl = acl_next(acl))

void acl_list_destroy(llist_t *list);

ACL_t *acl_first(const llist_t *list);
ACL_t *acl_next(ACL_t *acl);

uint32_t acl_id(ACL_t *acl);
uint16_t acl_flags(ACL_t *acl);

bool acl_canRead(ACL_t *acl);
bool acl_canWrite(ACL_t *acl);
bool acl_canExecute(ACL_t *acl);
bool acl_isGroup(ACL_t *acl);


#ifdef __cplusplus
}
#endif

#endif // ACL_H
