/****************************************************************************
* File:         $Workfile$
* Revision:     $Revision: 1.3 $
* Date:         $Date: 2009-05-26 05:47:43 $
*
* Overview:     
* Functions:
*
* Author:       Ian Tsao
* 
* -- Metanoia Copyright Notice --
*
* (C) Copyright 2005 Metanoia, Inc. All rights reserved.
* 
* Metanoia reserves the right to change specifications without notice. 
* Copyright 2005 Metanoia, Inc. All rights reserved. Preliminary Data-Sheet 
* indicates this product is in design and the specification may change. 
* Electrical parametrics have not been analyzed and are not specified. Do not 
* use this data sheet as a design reference document. Please contact Metanoia 
* for a current data sheet that may be used as a design reference. All 
* contents of this document are protected by copyright law and may not be 
* reproduced without the express written consent of Metanoia, Inc. Metanoia, 
* the Metanoia logo, and combinations thereof are trademarks of Metanoia, Inc. 
* Other product names used in this publication are for identification purposes 
* only and may be trademarks or registered trademarks of their respective 
* companies. The contents of this document are provided in connection with 
* Metanoia, Inc. products. Metanoia, Inc. has made best efforts to ensure that 
* the information contained herein is accurate and reliable. However, Metanoia, 
* Inc. makes no warranties, express or implied, as to the accuracy or 
* completeness of the contents of this publication and is providing this 
* publication 'as is'. Metanoia, Inc. reserves the right to make changes to 
* specifications and product descriptions at any time without notice, and to 
* discontinue or make changes to its products at any time without notice. 
* Metanoia, Inc. does not assume any liability arising out of the application 
* or use of any product or circuit, and specifically disclaims any and all 
* liability, including without limitation special, consequential, or 
* incidental damages.
* 
****************************************************************************/
#include "dsl.h"


mt_ret dump_history(void)
{
	int i, j, k, l;
	mt_uint8 ibyte, ibit;

	for(i=0;i<MAX_PORTS;i++)
	{
		PRINTD("portid=%i\n",i);
		PRINTD("inv15_cur=%i\ninv15_exist=",port_info[i].inv15_cur);
		for(j=0;j<(MT_INV_MAX15-1)/8+1;j++)
		{
			PRINTD("%02x ",port_info[i].inv15_exist[j]);
		}
		

		for(k=0;k<MT_INV_MAX15;k++)		
		{
			ibyte = k/8;
			ibit = k-ibyte*8;
			if( port_info[i].inv15_exist[ibyte] & 1<<ibit )
			{
				PRINTD("\nperformance data for inv=%i:\n",k);
				for(j=0;j<MT_IDX_LINE;j++)
				{
					for(l=0;l<MT_LINE_SIZE15;l++)
					{
						PRINTD("%08x ",line15[i][j][k][l]);
					}
					PRINTD("\n");
				}
				
				PRINTD("chan data for inv=%i:\n",k);
				for(j=0;j<MT_IDX_CHAN;j++)
				{
					for(l=0;l<MT_CHAN_SIZE15;l++)
					{						
						PRINTD("%08x ",chan15[i][j][k][l]);
					}
					PRINTD("\n");
				}

			}
		}

		PRINTD("inv24_cur=%i\ninv24_exist=",port_info[i].inv24_cur);
		for(j=0;j<(MT_INV_MAX24-1)/8+1;j++)
		{
			PRINTD("%02x ",port_info[i].inv24_exist[j]);
		}		
		
		for(k=0;k<MT_INV_MAX24;k++)		
		{
			ibyte = k/8;
			ibit = k-ibyte*8;
			if( port_info[i].inv24_exist[ibyte] & 1<<ibit )
			{
				PRINTD("\nperformance data for inv=%i:\n",k);
				for(j=0;j<MT_IDX_LINE;j++)
				{
					for(l=0;l<MT_LINE_SIZE24;l++)
					{
						PRINTD("%08x ",line24[i][j][k][l]);
					}
					PRINTD("\n");
				}
				
				PRINTD("chan data for inv=%i:\n",k);
				for(j=0;j<MT_IDX_CHAN;j++)
				{
					for(l=0;l<MT_CHAN_SIZE24;l++)
					{						
						PRINTD("%08x ",chan24[i][j][k][l]);
					}
					PRINTD("\n");
				}

			}
		}


	}
	return MT_OK;
}
