/****************************************************************************
* File:         $Workfile$
* Revision:     $Revision: 1.18 $
* Date:         $Date: 2012-05-23 12:44:15 $
*
* Overview:     
* Functions:
*
* Author:       Ian Tsao
* 
* -- Metanoia Copyright Notice --
*
* (C) Copyright 2005 Metanoia, Inc. All rights reserved.
* 
* Metanoia reserves the right to change specifications without notice. 
* Copyright 2005 Metanoia, Inc. All rights reserved. Preliminary Data-Sheet 
* indicates this product is in design and the specification may change. 
* Electrical parametrics have not been analyzed and are not specified. Do not 
* use this data sheet as a design reference document. Please contact Metanoia 
* for a current data sheet that may be used as a design reference. All 
* contents of this document are protected by copyright law and may not be 
* reproduced without the express written consent of Metanoia, Inc. Metanoia, 
* the Metanoia logo, and combinations thereof are trademarks of Metanoia, Inc. 
* Other product names used in this publication are for identification purposes 
* only and may be trademarks or registered trademarks of their respective 
* companies. The contents of this document are provided in connection with 
* Metanoia, Inc. products. Metanoia, Inc. has made best efforts to ensure that 
* the information contained herein is accurate and reliable. However, Metanoia, 
* Inc. makes no warranties, express or implied, as to the accuracy or 
* completeness of the contents of this publication and is providing this 
* publication 'as is'. Metanoia, Inc. reserves the right to make changes to 
* specifications and product descriptions at any time without notice, and to 
* discontinue or make changes to its products at any time without notice. 
* Metanoia, Inc. does not assume any liability arising out of the application 
* or use of any product or circuit, and specifically disclaims any and all 
* liability, including without limitation special, consequential, or 
* incidental damages.
* 
****************************************************************************/
#ifndef _VDSLLIB_H_
#define _VDSLLIB_H_

#include "userdef.h"

/**
 * \file 
 * \brief API set that metanoia provide
 */
 
// -------------------------- System related  -----------------------

#define MT_OS_LINUX 

#if !defined(MT_OS_TYPE)
#	define MT_OS_TYPE MT_OS_LINUX
#endif


// -------------------------- Performance -----------------------
#define MT_LINE_SIZE_CURRTABLE 17
#define MT_LINEINIT_SIZE_CURRTABLE 14
#define MT_CHAN_SIZE_CURRTABLE 11
#define MT_LINE_SIZE15 9
#define MT_LINEINIT_SIZE15 7
#define MT_CHAN_SIZE15 6
#define MT_LINE_SIZE24 9
#define MT_LINEINIT_SIZE24 7
#define MT_CHAN_SIZE24 6

//< -------------------------- MIB -----------------------
// MT_MIB_VdslTerminal - bit fields
//Bit0(1-RT,0-OT) Bit1(1-Xenos/SMII,0-Award/MII) Bit2(1-HDLC,0-NOHDLC) Bit3(1-NeedConnect,0-NoNeedConnect) Bit4(1-with pacing signal,0-w/o pacing signal)
//Bit8 & Bit9(3-Showtime,2-Training,1-Handshake,0-Idle)
#define MT_MIB_RTOT										0
#define MT_MIB_XenosSMIIAwardMII						1
#define MT_MIB_HDLC										2
#define MT_MIB_NeedConnect								3
#define MT_MIB_PacingSignal								4
#define MT_MIB_HandshakeIdle							8
#define MT_MIB_ShowtimeTraining							9

// MT_MIB_VdslTerminal Bit8 & Bit9 representation
#define IDLE 0
#define HANDSHAKE 1
#define TRAINING 2
#define SHOWTIME 3

// -------------------------- Function declaration -----------------------
// following function implementation in if.c
//Init Function
mt_ret init_system(void);
mt_ret init_chip(mt_uint32 chipid, mt_uint32 firmwareID);
mt_ret init_modem(mt_uint32 chipid);
mt_ret reset_modem(mt_uint32 chipid);
mt_ret download_firmware(mt_uint8 chipid, mt_uint8 cmdID, mt_uint16 bufsize,mt_uint8* buffer);
//Port Function
mt_ret connect_port(mt_uint32 portid);
mt_ret disconnect_port(mt_uint32 portid);
mt_ret clear_port_stats(mt_uint32 portid);
//Shutdown Function
mt_ret shutdown_system(void);
mt_ret shutdown_chip(mt_uint32 chipid);
// following function implementation in vdsllib.c
// -------------------------- MIB  -----------------------
mt_ret get_port_mib(mt_uint32 portid, mt_uint8 *loid, mt_uint8 *strvalue);
mt_ret set_port_mib(mt_uint32 portid, mt_uint8 *loid, mt_uint8 *strvalue);
mt_ret get_phy_status(mt_uint32 portid, mt_uint8 *phy_status, mt_uint8 *conn_status);
mt_ret get_op_status(mt_uint32 portid,mt_uint8 *state);
// -------------------------- Statistic Routine -----------------------
mt_ret mt_perf_15min(void);
mt_ret mt_perf_24hour(void);
mt_ret clear_port_stats(mt_uint32 portid);
//#ifdef TR069
mt_ret reset_tr069_showtime_array(mt_uint32 portid, int type);
//#endif //TR069
// -------------------------- Misc -----------------------
mt_ret init_port_info(void);
#ifndef __KERNEL__
mt_ret get_version(mt_uint8 *buffer);
#endif	//__KERNEL__
// -------------------------- Timer -----------------------
#ifdef __KERNEL__
int statistic_thread_handler(void *dummy);
#ifdef KERNEL_2_6
#define MSLEEP msleep
#else
#define MSLEEP mysleep
#define CLONE_KERNEL (CLONE_FS | CLONE_FILES | CLONE_SIGHAND)
extern void mysleep(unsigned long msecs);
#endif //KERNEL_2_6
#define MYDELAY mdelay
//#define MYDELAY MSLEEP
#endif	//__KERNEL__

#endif //_VDSLLIB_H_
