/****************************************************************************
* File:         $Workfile$
* Revision:     $Revision: 1.11 $
* Date:         $Date: 2011-05-11 10:46:05 $
*
* Overview:     
* Functions:
*
* Author:       Ian Tsao
* 
* -- Metanoia Copyright Notice --
*
* (C) Copyright 2005 Metanoia, Inc. All rights reserved.
* 
* Metanoia reserves the right to change specifications without notice. 
* Copyright 2005 Metanoia, Inc. All rights reserved. Preliminary Data-Sheet 
* indicates this product is in design and the specification may change. 
* Electrical parametrics have not been analyzed and are not specified. Do not 
* use this data sheet as a design reference document. Please contact Metanoia 
* for a current data sheet that may be used as a design reference. All 
* contents of this document are protected by copyright law and may not be 
* reproduced without the express written consent of Metanoia, Inc. Metanoia, 
* the Metanoia logo, and combinations thereof are trademarks of Metanoia, Inc. 
* Other product names used in this publication are for identification purposes 
* only and may be trademarks or registered trademarks of their respective 
* companies. The contents of this document are provided in connection with 
* Metanoia, Inc. products. Metanoia, Inc. has made best efforts to ensure that 
* the information contained herein is accurate and reliable. However, Metanoia, 
* Inc. makes no warranties, express or implied, as to the accuracy or 
* completeness of the contents of this publication and is providing this 
* publication 'as is'. Metanoia, Inc. reserves the right to make changes to 
* specifications and product descriptions at any time without notice, and to 
* discontinue or make changes to its products at any time without notice. 
* Metanoia, Inc. does not assume any liability arising out of the application 
* or use of any product or circuit, and specifically disclaims any and all 
* liability, including without limitation special, consequential, or 
* incidental damages.
* 
****************************************************************************/
#ifndef _VDSLDRV_H_
#define _VDSLDRV_H_

#ifndef __KERNEL__
#define __KERNEL__
#endif
#ifndef MODULE
#define MODULE
#endif

#include <linux/sched.h>
#include <linux/init.h>
#include <linux/fs.h>
#include <linux/errno.h>
#include <linux/ioctl.h>
#include <linux/types.h>
#include <linux/proc_fs.h>
#include <asm/io.h>
#include <asm/uaccess.h>
#include "dsl.h"
#include "ioctlmeta.h"
#include "maketime.h"
#ifdef VITESS_VSC7501
#include <asm/arch/star_misc.h>
#include <asm/arch/star_smc.h>
#include <asm/arch/star_gpio.h>
#include <asm-arm/arch-grocx/star_intc.h>
#endif	//VITESS_VSC7501


#define DRIVERVERSION xDSL_VERSION

#ifndef NULL
#define NULL ((void *)0)
#endif

#if defined (ICPLUS_IP3210) || defined (ATHEROS_AR93XX) || defined (REALTEK_RTL8672)
#define __si_special(priv) \
        ((priv) ? SEND_SIG_PRIV : SEND_SIG_NOINFO)

int
kill_proc(pid_t pid, int sig, int priv)
{
        return kill_proc_info(sig, __si_special(priv), pid);
}
#endif

#endif	//_VDSLDRV_H_
