/****************************************************************************
* File:         $Workfile$
* Revision:     $Revision: 1.34 $
* Date:         $Date: 2012-05-09 05:14:41 $
*
* Overview:     
* Functions:
*
* Author:       Ian Tsao
* 
* -- Metanoia Copyright Notice --
*
* (C) Copyright 2005 Metanoia, Inc. All rights reserved.
* 
* Metanoia reserves the right to change specifications without notice. 
* Copyright 2005 Metanoia, Inc. All rights reserved. Preliminary Data-Sheet 
* indicates this product is in design and the specification may change. 
* Electrical parametrics have not been analyzed and are not specified. Do not 
* use this data sheet as a design reference document. Please contact Metanoia 
* for a current data sheet that may be used as a design reference. All 
* contents of this document are protected by copyright law and may not be 
* reproduced without the express written consent of Metanoia, Inc. Metanoia, 
* the Metanoia logo, and combinations thereof are trademarks of Metanoia, Inc. 
* Other product names used in this publication are for identification purposes 
* only and may be trademarks or registered trademarks of their respective 
* companies. The contents of this document are provided in connection with 
* Metanoia, Inc. products. Metanoia, Inc. has made best efforts to ensure that 
* the information contained herein is accurate and reliable. However, Metanoia, 
* Inc. makes no warranties, express or implied, as to the accuracy or 
* completeness of the contents of this publication and is providing this 
* publication 'as is'. Metanoia, Inc. reserves the right to make changes to 
* specifications and product descriptions at any time without notice, and to 
* discontinue or make changes to its products at any time without notice. 
* Metanoia, Inc. does not assume any liability arising out of the application 
* or use of any product or circuit, and specifically disclaims any and all 
* liability, including without limitation special, consequential, or 
* incidental damages.
* 
****************************************************************************/
#include "vdsldrv.h"
#include "global.h"

#define EOC_CMD_HEADER_SIZE 3
#define FW_HEADER_SIZE 4
#define FW_BINDRV_HEADER_SIZE 3
#define FW_FLASH_HEADER_SIZE 3
#define SPMA_HEADER_SIZE 4
#define SPMR_HEADER_SIZE 5


#ifdef OPENWRT
static DEFINE_SEMAPHORE(mr_sem_drv);
#else
static DECLARE_MUTEX(mr_sem_drv);
#endif	//OPENWRT
static int sem_ret;
int vdsl_major = VDSL_MAJOR;
int DELAY = 3000;
pid_t thread_pid;


int hpi_test(int portid)
{
/* While in star hardware, port number should be
   written to point out which port to be used
*/
	mt_uint8  *addr;
	mt_uint32 len = 8;
	mt_uint8  pframe_a[8]={0x00, 0x6c, 0x31, 0x00, 0x00, 0x00, 0x45, 0x71};	//response for this command should be "0x00 0x6c 0x31 0x01 0x01 0x00 0x41 0x32"
	mt_uint8  *pframe = pframe_a;
	mt_uint8  pbuf[MT_MAX_BUFFERSIZE];
	mt_uint32 i, j;

	printk("HPI test\n");

#ifdef XENOS
	addr = (mt_uint8 *)(falcon_port+(portid<<BUS_WIDTH_16_SHIFT));
#elif defined (HOPE)
	addr = (mt_uint8 *)(falcon_port+(portid<<BUS_WIDTH_32_SHIFT));
#elif defined (BOARD_A5)
	addr = (mt_uint8 *)falcon_port;
#endif

	//Write data
	for(i=0;i<len;i++) {
		*(mt_uint8 *)addr = pframe[i];
		for(j=0;j<w_delay;j++);
	}

	printk("Sent data:\n");
	for(i=0;i<len;i++) printk("%02x ",pframe[i]);
	printk("\n");

	for(i=0;i<rw_delay;i++);

	//Read data
	for(i=0;i<len;i++){
		pbuf[i] = *(mt_uint8 *)addr;
		for(j=0;j<r_delay;j++);
	}

	printk("Received data:\n");
	for(i=0;i<len;i++) printk("%02x ",pbuf[i]);
	printk("\n");

	return 0;
}


int hpi_test_read_only(int portid)
{
/* While in star hardware, port number should be
   written to point out which port to be used
*/
	mt_uint8  *addr;
	mt_uint32 len = 8;
	mt_uint8  pbuf[MT_MAX_BUFFERSIZE];
	mt_uint32 i, j;
	
	printk("HPI test\n");

	new_dsp_get(0, 0, 0, 0);
	return 0;


#ifdef XENOS
	addr = (mt_uint8 *)(falcon_port+(portid<<BUS_WIDTH_16_SHIFT));
#elif defined (HOPE)
	addr = (mt_uint8 *)(falcon_port+(portid<<BUS_WIDTH_32_SHIFT));
#elif defined (BOARD_A5)
	addr = (mt_uint8 *)falcon_port;
#endif

	//Read data
	for(i=0;i<len;i++){
		pbuf[i] = *(mt_uint8 *)addr;
		for(j=0;j<r_delay;j++);
	}

	printk("Received data:\n");
	for(i=0;i<len;i++) printk("%02x ",pbuf[i]);
	printk("\n");

	return 0;
}


int hpi_test_read_only_fixsize(int portid)
{
/* While in star hardware, port number should be
   written to point out which port to be used
*/
	mt_uint8  *addr;
	mt_uint8  pbuf[MT_MAX_BUFFERSIZE];
	mt_uint32 i, j, fixsize = 16;
	
	printk("hpi_test_read_only_fixsize: Reading %i bytes\n", fixsize);

#ifdef XENOS
	addr = (mt_uint8 *)(falcon_port+(portid<<BUS_WIDTH_16_SHIFT));
#elif defined (HOPE)
	addr = (mt_uint8 *)(falcon_port+(portid<<BUS_WIDTH_32_SHIFT));
#elif defined (BOARD_A5)
	addr = (mt_uint8 *)falcon_port;
#endif

	//Read data
	for(i=0;i<fixsize;i++){
		pbuf[i] = *(mt_uint8 *)addr;
		for(j=0;j<r_delay;j++);
	}

	printk("Received data:\n");
	for(i=0;i<fixsize;i++) printk("%02x ",pbuf[i]);
	printk("\n");

	return 0;
}


int hpi_test_write_only(int portid)
{
/* While in star hardware, port number should be
   written to point out which port to be used
*/
	mt_uint8  *addr;
	mt_uint32 len = 8;
	mt_uint8  pframe_a[8]={0x00, 0x6c, 0x31, 0x00, 0x00, 0x00, 0x45, 0x71};	//response for this command should be "0x00 0x6c 0x31 0x01 0x01 0x00 0x41 0x32"
	mt_uint8  *pframe = pframe_a;
	mt_uint32 i, j;

	printk("HPI test\n");

#ifdef XENOS
	addr = (mt_uint8 *)(falcon_port+(portid<<BUS_WIDTH_16_SHIFT));
#elif defined (HOPE)
	addr = (mt_uint8 *)(falcon_port+(portid<<BUS_WIDTH_32_SHIFT));
#elif defined (BOARD_A5)
	addr = (mt_uint8 *)falcon_port;
#endif

	//Write data
	for(i=0;i<len;i++) {
		*(mt_uint8 *)addr = pframe[i];
		for(j=0;j<w_delay;j++);
	}

	printk("Sent data:\n");
	for(i=0;i<len;i++) printk("%02x ",pframe[i]);
	printk("\n");

	return 0;
}


#ifdef OPENWRT
static long vdsl_ioctl(struct file * file, unsigned int cmd, unsigned long arg)
#else
static int vdsl_ioctl(struct inode * inode, struct file * file, unsigned int cmd, unsigned long arg)
#endif	//OPENWRT
{
	int ret = MT_OK;
	unsigned long *new_arg = NULL;
	mt_uint8 pdata[DMT_WORD];
	mt_uint8 *vdsl_arg;
	mt_uint8 *vdsl_firmware;
	mt_uint8 phy_status, conn_status, memtype;
	mt_uint16 bufsize, length;
	mt_uint32 chipid;
	//mt_uint32 firmwareid;
	mt_uint32 portid, cmdid;
	mt_uint32 address, lvl;
	mt_uint32 mibsize, mibtype;
	mt_uint8 oid[OID_MAX_LEN];

	sem_ret = down_interruptible(&mr_sem_drv);

	if ((vdsl_arg = (mt_uint8 *)kmalloc(SMALL_BUF_SIZE, GFP_KERNEL)) == NULL) return -ENOMEM;
	if ((vdsl_firmware = (mt_uint8 *)kmalloc(BUF_SIZE, GFP_KERNEL)) == NULL) return -ENOMEM;

	memset(pdata, 0, DMT_WORD);
	memset(vdsl_arg, 0, SMALL_BUF_SIZE);
	memset(vdsl_firmware, 0, BUF_SIZE);

	if (arg) {
		if ((new_arg = (unsigned long *)kmalloc(sizeof(unsigned long), GFP_KERNEL)) == NULL)
			return -ENOMEM;
	
		*new_arg = arg;
	
		if (copy_from_user(vdsl_arg, (void *)(*new_arg), SMALL_BUF_SIZE))
			return -EFAULT;
	}

	switch (cmd) {
		case VDSL_DOWNLOAD_FIRMWARE:
			chipid = vdsl_arg[0];
			cmdid = vdsl_arg[1];
			bufsize = (vdsl_arg[2] << 8 ) | vdsl_arg[3];

			if(chipid > MT_PORT_BroadCast)
				return MT_NO_SUCH_CHIP;

			copy_from_user(vdsl_firmware, (void *)(*new_arg)+FW_HEADER_SIZE, bufsize);
			ret = download_firmware(chipid, cmdid, bufsize, vdsl_firmware);
			break;

		case VDSL_LOAD_FIRMWARE_BINDRV:
			cmdid = vdsl_arg[0];
			bufsize = (vdsl_arg[1] << 8 ) | vdsl_arg[2];

			copy_from_user(vdsl_firmware, (void *)(*new_arg)+FW_BINDRV_HEADER_SIZE, bufsize);
			ret = load_firmware_bindrv(cmdid, bufsize, vdsl_firmware);
			break;

#if defined (SPI_ACCESS)
		case VDSL_FLASH_FIRMWARE:
			cmdid = vdsl_arg[0];
			bufsize = (vdsl_arg[1] << 8 ) | vdsl_arg[2];

			copy_from_user(vdsl_firmware, (void *)(*new_arg)+FW_FLASH_HEADER_SIZE, bufsize);
			ret = flash_firmware(cmdid, bufsize, vdsl_firmware);
			break;
#endif //defined (SPI_ACCESS)

			//Init Function
		case VDSL_INIT_MODEM:
			chipid = vdsl_arg[0];
			ret = init_modem(chipid);
			break;

		case VDSL_RESET_MODEM:
			chipid = vdsl_arg[0];
			ret = reset_modem(chipid);
			break;

		//Port Function
		case VDSL_CONNECT_PORT:
			portid = vdsl_arg[0];
			ret = connect_port(portid);
			break;

		case VDSL_DISCONNECT_PORT:
			portid = vdsl_arg[0];
			ret = disconnect_port(portid);
			break;

		case VDSL_CLEAR_PORT_STATS:
			portid = vdsl_arg[0];
			ret = clear_port_stats(portid);
			break;
			
		//Shutdown Function
		case VDSL_SHUTDOWN_SYSTEM:
			ret = shutdown_system();
			break;

		case VDSL_SHUTDOWN_CHIP:
			chipid = vdsl_arg[0];
			ret = shutdown_chip(chipid);
			break;

		// ------- Memory -------
		case VDSL_GET_PORT_MEM:
			portid = vdsl_arg[0];
			address = ((vdsl_arg[1]<<16)&0xff0000)|((vdsl_arg[2]<<8)&0x00ff00)|(vdsl_arg[3]&0x0000ff);
			memtype = vdsl_arg[4];
			ret = get_port_mem(portid, address, memtype, pdata);

			if(copy_to_user((void *)(*new_arg), pdata, DMT_WORD))
				return -EFAULT;

			break;

		case VDSL_SET_PORT_MEM:
			portid = vdsl_arg[0];
			address = ((vdsl_arg[1]<<16)&0xff0000)|((vdsl_arg[2]<<8)&0x00ff00)|(vdsl_arg[3]&0x0000ff);
			memtype = vdsl_arg[4];
			pdata[0]=vdsl_arg[5];
			pdata[1]=vdsl_arg[6];
			pdata[2]=vdsl_arg[7];
			ret = set_port_mem(portid, address, memtype, pdata);
			break;

		case VDSL_GET_PORT_MEM_REMOTE:
			portid = vdsl_arg[0];
			address = ((vdsl_arg[1]<<16)&0xff0000)|((vdsl_arg[2]<<8)&0x00ff00)|(vdsl_arg[3]&0x0000ff);
			length = ((vdsl_arg[4]<<8)&0x00ff00)|(vdsl_arg[5]&0x0000ff);
			ret = get_port_mem_remote(portid, address, length, vdsl_firmware);

			if(copy_to_user((void *)(*new_arg), vdsl_firmware, BUF_SIZE))
				return -EFAULT;

			break;

		/*case VDSL_SET_PORT_MEM_REMOTE:
			portid = vdsl_arg[0];
			address = ((vdsl_arg[1]<<16)&0xff0000)|((vdsl_arg[2]<<8)&0x00ff00)|(vdsl_arg[3]&0x0000ff);
			length = ((vdsl_arg[4]<<8)&0x00ff00)|(vdsl_arg[5]&0x0000ff);
			copy_from_user(vdsl_firmware, (void *)(*new_arg)+SPMR_HEADER_SIZE, length);
			ret = set_port_mem_remote(portid, address, length, vdsl_firmware);

			break;*/

		// the following functions implemented in vdsllib.c
		// ------- MIB -------
		case VDSL_GET_PORT_MIB:
			portid = vdsl_arg[0];
			if(strlen((void *)(*new_arg)+1) > OID_MAX_LEN)
				return -DSL_ERR_OIDTOOLONG;
			copy_from_user(oid, (void *)(*new_arg)+1, strlen((void *)(*new_arg)+1)+1);
			ret = get_port_mib(portid, oid, vdsl_firmware);

			if(copy_to_user((void *)(*new_arg), vdsl_firmware, BUF_SIZE))
				return -EFAULT;

			break;

		case VDSL_SET_PORT_MIB:
			portid = vdsl_arg[0];
			if(strlen((void *)(*new_arg)+1) > OID_MAX_LEN)
				return -DSL_ERR_OIDTOOLONG;
			copy_from_user(oid, (void *)(*new_arg)+1, strlen((void *)(*new_arg)+1)+1);
			copy_from_user(vdsl_firmware, (void *)(*new_arg)+1+strlen((void *)(*new_arg)+1)+1, strlen((void *)(*new_arg)+1+strlen((void *)(*new_arg)+1)+1)+1);
			ret = set_port_mib(portid, oid, vdsl_firmware);

			break;

#ifndef CHIP_F4
		case VDSL_GET_PORT_MIB_ARRAY:
			portid = vdsl_arg[0];
			groupid = vdsl_arg[1];
			tableid = vdsl_arg[2];
			idx = vdsl_arg[3];
			paramid = vdsl_arg[4];
			interval = vdsl_arg[5];
			count = vdsl_arg[6];
			pvalue = (mt_uint32 *)vdsl_firmware;
			ret = get_port_mib_array(portid, groupid, tableid, idx, paramid, interval, count, pvalue);

			if(copy_to_user((void *)(*new_arg), pvalue, count*sizeof(mt_uint32)))
				return -EFAULT;

			break;

		case VDSL_SET_PORT_MIB_ARRAY:
			portid = vdsl_arg[0];
			idx = vdsl_arg[1];
			count = ((vdsl_arg[2]<<8)&0xff00)|(vdsl_arg[3]&0x00ff);
			copy_from_user(vdsl_firmware, (void *)(*new_arg)+SPMA_HEADER_SIZE, count*sizeof(mib_value_set));
			ret = set_port_mib_array(portid, idx, count, (mib_value_set *)vdsl_firmware);

			break;
#endif
			
		case VDSL_GET_PORT_DATA:
			portid = vdsl_arg[0];
			if(strlen((void *)(*new_arg)+1) > OID_MAX_LEN)
				return -DSL_ERR_OIDTOOLONG;
			copy_from_user(oid, (void *)(*new_arg)+1, strlen((void *)(*new_arg)+1)+1);
			ret = get_port_data(portid, oid, vdsl_firmware);

			if(copy_to_user((void *)(*new_arg), vdsl_firmware, BUF_SIZE))
				return -EFAULT;

			break;

		case VDSL_SET_PORT_DATA:
			portid = vdsl_arg[0];
			if(strlen((void *)(*new_arg)+1) > OID_MAX_LEN)
				return -DSL_ERR_OIDTOOLONG;
			copy_from_user(oid, (void *)(*new_arg)+1, strlen((void *)(*new_arg)+1)+1);
			copy_from_user(vdsl_firmware, (void *)(*new_arg)+1+strlen((void *)(*new_arg)+1)+1, strlen((void *)(*new_arg)+1+strlen((void *)(*new_arg)+1)+1)+1);
			ret = set_port_data(portid, oid, vdsl_firmware);

			break;

		case VDSL_GET_PORT_DATA_LOGIC:
			portid = vdsl_arg[0];
			if(strlen((void *)(*new_arg)+1) > OID_MAX_LEN)
				return -DSL_ERR_OIDTOOLONG;
			copy_from_user(oid, (void *)(*new_arg)+1, strlen((void *)(*new_arg)+1)+1);
			ret = get_port_data_logic(portid, oid, vdsl_firmware);

			if(copy_to_user((void *)(*new_arg), vdsl_firmware, BUF_SIZE))
				return -EFAULT;

			break;

		case VDSL_SET_PORT_DATA_LOGIC:
			portid = vdsl_arg[0];
			if(strlen((void *)(*new_arg)+1) > OID_MAX_LEN)
				return -DSL_ERR_OIDTOOLONG;
			copy_from_user(oid, (void *)(*new_arg)+1, strlen((void *)(*new_arg)+1)+1);
			copy_from_user(vdsl_firmware, (void *)(*new_arg)+1+strlen((void *)(*new_arg)+1)+1, strlen((void *)(*new_arg)+1+strlen((void *)(*new_arg)+1)+1)+1);
			ret = set_port_data_logic(portid, oid, vdsl_firmware);

			break;

		case VDSL_GET_PHY_STATUS:
			portid = vdsl_arg[0];
			ret = get_phy_status(portid, &phy_status, &conn_status);
			vdsl_arg[0] = phy_status;
			vdsl_arg[1] = conn_status;
			
			if(copy_to_user((void *)(*new_arg), vdsl_arg, SMALL_BUF_SIZE))
				return -EFAULT;

			break;

		case VDSL_GET_OP_STATE:
			portid = vdsl_arg[0];
			ret = get_op_status(portid, &phy_status);

			if(copy_to_user((void *)(*new_arg), &phy_status, sizeof(phy_status)))
				return -EFAULT;

			break;

		case VDSL_GET_MIB2_INFO:
			if(strlen((void *)(*new_arg)) > OID_MAX_LEN)
				return -DSL_ERR_OIDTOOLONG;
			copy_from_user(oid, (void *)(*new_arg), strlen((void *)(*new_arg))+1);
			ret = get_mib2_info(oid, &address, &mibsize, &mibtype);

			if(copy_to_user((void *)(*new_arg), &address, sizeof(address)))
				return -EFAULT;
			if(copy_to_user((void *)(*new_arg)+4, &mibsize, sizeof(mibsize)))
				return -EFAULT;
			if(copy_to_user((void *)(*new_arg)+8, &mibtype, sizeof(mibtype)))
				return -EFAULT;

			break;
			
		// ------- Debug -------
		case VDSL_SET_DEBUG_LEVEL:
			lvl = ((vdsl_arg[0]<<24)&0xff000000)|((vdsl_arg[1]<<16)&0x00ff0000)|((vdsl_arg[2]<<8)&0x0000ff00)|(vdsl_arg[3]&0x000000ff);
			set_debug_level(lvl);
			break;

		case VDSL_GET_MIB2_HEADER:
			portid = vdsl_arg[0];
			ret = get_mib2_header(portid);
			break;

		case VDSL_HPI_TEST_RD:
			chipid = vdsl_arg[0];
			hpi_test_read_only(chipid);
			break;

		case VDSL_HPI_TEST_RD_FIXSIZE:
			chipid = vdsl_arg[0];
			hpi_test_read_only_fixsize(chipid);		
			break;

		case VDSL_HPI_TEST_WT:
			chipid = vdsl_arg[0];
			hpi_test_write_only(chipid);
			break;

		case VDSL_HPI_TEST:
			chipid = vdsl_arg[0];
			hpi_test(chipid);
			break;

		case VDSL_HPI_DELAY:
			DELAY = vdsl_arg[0];
			break;

		case VDSL_RESET:
			chipid = vdsl_arg[0];
			reset_chip(chipid);
			break;
			
		case VDSL_RESET_HIGH:
			chipid = vdsl_arg[0];
			reset_chip_high(chipid);
			break;
			
		case VDSL_RESET_LOW:
			chipid = vdsl_arg[0];
			reset_chip_low(chipid);
			break;

		case VDSL_AUTO_RESET:
			auto_reset = vdsl_arg[0];
			break;

		case VDSL_ENABLE_PACING:
#ifndef VIA_SAMSUNG
			*(falcon_port+(0x59<<BUS_WIDTH_8_SHIFT)) = 0x0;
#else
#if defined (XENOS)
			*(falcon_port+(0x59<<BUS_WIDTH_16_SHIFT)) = 0x0;
#elif defined (HOPE)
			*(falcon_port+(0x0A<<BUS_WIDTH_32_SHIFT)) = 0x0;
#endif
#endif
			break;

		case VDSL_DISABLE_PACING:
#ifndef VIA_SAMSUNG
			*(falcon_port+(0x5A<<BUS_WIDTH_8_SHIFT)) = 0x0;
#else
#if defined (XENOS)
			*(falcon_port+(0x5A<<BUS_WIDTH_16_SHIFT)) = 0x0;
#elif defined (HOPE)
			*(falcon_port+(0x0B<<BUS_WIDTH_32_SHIFT)) = 0x0;
#endif
#endif
			break;

			// ------- Misc -------
		case VDSL_GET_VERSION:
			sprintf((char *)vdsl_arg, "%s;%s", DRIVERVERSION, MAKETIME);

			if(copy_to_user((void *)(*new_arg), vdsl_arg, SMALL_BUF_SIZE))
				return -EFAULT;

			break;

		default:
			return -ENOTTY;
	}

	kfree(new_arg);
	kfree(vdsl_firmware);
	kfree(vdsl_arg);

	up(&mr_sem_drv);

	return ret;
}


static struct file_operations vdsl_fops = {
#ifdef OPENWRT
	unlocked_ioctl:	vdsl_ioctl,
#else
	ioctl:  vdsl_ioctl,
#endif	//OPENWRT
};


void vdsl_proc_msg(char *buf, int *len)
{
	*len += sprintf(buf+*len, "=== xDSL Driver Info ===\n");
	*len += sprintf(buf+*len, "Driver Version\t: %s - %s\n", DRIVERVERSION, MAKETIME);
	*len += sprintf(buf+*len, "rw_delay\t: %dus\nr_delay\t\t: %dus\nw_delay\t\t: %dus\n", rw_delay/200, r_delay/200, w_delay/200);
	*len += sprintf(buf+*len, "MAX_PORTS\t: %d\n", MAX_PORTS);
#ifndef SPI_ACCESS
#ifdef XENOS
	*len += sprintf(buf+*len, "XENOS_PORT\t: 0x%08x\n", XENOS_PORT);
#else
	*len += sprintf(buf+*len, "FALCON_PORT\t: 0x%08x\n", FALCON_PORT);
#endif
#endif	//SPI_ACCESS

	return;
}


int vdsl_init_module(void)
{
	int result;
	struct timeval tv;
#if defined (RALINK_RT3052) || defined (RALINK_RT3352) || defined (ICPLUS_IP3210) || defined (ATHEROS_AR93XX) || defined (REALTEK_RTL8672)
	mt_uint32 gpio_value;
	volatile mt_uint32 *gpio_addr;
#endif
#if defined (VITESS_VSC7501)
	u32 bank_timing_reg;
#endif

	/*
	 * Register your major, and accept a dynamic number
	 */
	result = register_chrdev(vdsl_major, "vdsl", &vdsl_fops);
	if (result < 0) {
		printk(KERN_WARNING "xDSL: Can't get major %d\n", vdsl_major);
		return result;
	}

	if (vdsl_major == 0) vdsl_major = result; /* dynamic */

#ifdef XENOS
#ifndef VIA_SAMSUNG
	falcon_port = (volatile mt_uint8 *)ioremap(XENOS_PORT, 0x600000);
#else
	falcon_port = (volatile mt_uint8 *)XENOS_PORT;
#endif	//VIA_SAMSUNG
#elif defined (HOPE)
#ifndef VIA_SAMSUNG
	falcon_port = (volatile mt_uint8 *)ioremap(FALCON_PORT, 0x300000);
#else
	falcon_port = (volatile mt_uint8 *)FALCON_PORT;
#endif	//VIA_SAMSUNG
#elif defined (BOARD_A5)
#ifndef SPI_ACCESS
	falcon_port = (volatile mt_uint8 *)ioremap(FALCON_PORT, 0x2);
#endif	//SPI_ACCESS

#if defined (RALINK_RT3052)
	// config selected pin assignment as GPIO mode
	gpio_addr = (volatile mt_uint32 *)ioremap(0x10000060, 0x2);
	gpio_value = *gpio_addr;
	gpio_value |= 0x0000001C;
	*gpio_addr = gpio_value;

	// config selected pin as output pin
	gpio_addr = (volatile mt_uint32 *)ioremap(0x10000624, 0x2);
	gpio_value = *gpio_addr;
	gpio_value |= RESET;
	*gpio_addr = gpio_value;

	// config FlashBank1 width and Chip Select and R/W Enable clock cycles
	gpio_addr = (volatile mt_uint32 *)ioremap(0x1000030C, 0x2);
	gpio_value = *gpio_addr;
	gpio_value = 0x921ffa1;
	*gpio_addr = gpio_value;

	databit_set = (volatile mt_uint32 *)ioremap(0x10000620, 0x2);
	databit_clr = (volatile mt_uint32 *)ioremap(0x10000620, 0x2);
#elif defined (RALINK_RT3352)
#if defined (SPI_ACCESS)
	// config selected pin assignment as GPIO mode
	gpio_addr = (volatile mt_uint32 *)ioremap(0x10000060, 0x2);
	gpio_value = *gpio_addr;
	gpio_value |= 0x00000040;	//force JTAG pin as GPIO mode
	gpio_value &= ~(0x00000200);	//force Gigabit Port pin as MII mode
	*gpio_addr = gpio_value;

	// force Gigabit Port connected with DMT to MII mode
	gpio_addr = (volatile mt_uint32 *)ioremap(0x10000014, 0x2);
	gpio_value = *gpio_addr;
	gpio_value |= 0x00001000;
	gpio_value &= ~(0x00002000);
	*gpio_addr = gpio_value;

	// config selected pin as DMT output/input pin
	gpio_addr = (volatile mt_uint32 *)ioremap(0x10000624, 0x2);
	gpio_value = *gpio_addr;
	gpio_value |= RESET | SCKB | SC2B | DMT_SRDB;	//output
	gpio_value &= ~(DMT_STDB);	//input
	*gpio_addr = gpio_value;

	data_gpio = (volatile mt_uint32 *)ioremap(0x10000620, 0x2);
	databit_set = (volatile mt_uint32 *)ioremap(0x10000620, 0x2);
	databit_clr = (volatile mt_uint32 *)ioremap(0x10000620, 0x2);
#else	//HPI_ACCESS
	// config selected pin assignment as GPIO mode
	gpio_addr = (volatile mt_uint32 *)ioremap(0x10000060, 0x2);
	gpio_value = *gpio_addr;
	gpio_value |= 0x0000001C;
	*gpio_addr = gpio_value;

	// config selected pin as output pin
	gpio_addr = (volatile mt_uint32 *)ioremap(0x10000624, 0x2);
	gpio_value = *gpio_addr;
	gpio_value |= RESET;
	*gpio_addr = gpio_value;

	databit_set = (volatile mt_uint32 *)ioremap(0x10000620, 0x2);
	databit_clr = (volatile mt_uint32 *)ioremap(0x10000620, 0x2);
#endif	//defined (SPI_ACCESS)
#elif defined (ICPLUS_IP3210)
#if defined (SPI_ACCESS)
	// config selected pin assignment as GPIO mode 
	gpio_addr = (volatile mt_uint32 *)ioremap(0xA3005010, 0x2);
	gpio_value = *gpio_addr;
	gpio_value |= COCPE | RESET | SCKB | SC2B | DMT_SRDB | DMT_STDB;
	*gpio_addr = gpio_value;

	// config selected pin as DMT output/input pin
	gpio_addr = (volatile mt_uint32 *)ioremap(0xA300500C, 0x2);
	gpio_value = *gpio_addr;
	gpio_value |= COCPE | RESET | SCKB | SC2B | DMT_SRDB;	//output
	gpio_value &= ~(DMT_STDB);	//input
	*gpio_addr = gpio_value;

	data_gpio = (volatile mt_uint32 *)ioremap(0xA3005000, 0x2);
	databit_set = (volatile mt_uint32 *)ioremap(0xA3005004, 0x2);
	databit_clr = (volatile mt_uint32 *)ioremap(0xA3005008, 0x2);
#else	//HPI_ACCESS
	// config selected pin assignment as GPIO mode
	gpio_addr = (volatile mt_uint32 *)ioremap(0xA3005010, 0x2);
	gpio_value = *gpio_addr;
	gpio_value |= RESET;
	*gpio_addr = gpio_value;

	// config selected pin as output pin
	gpio_addr = (volatile mt_uint32 *)ioremap(0xA300500C, 0x2);
	gpio_value = *gpio_addr;
	gpio_value |= RESET;
	*gpio_addr = gpio_value;

	databit_set = (volatile mt_uint32 *)ioremap(0xA3005004, 0x2);
	databit_clr = (volatile mt_uint32 *)ioremap(0xA3005008, 0x2);
#endif	//defined (SPI_ACCESS)
#elif defined (ATHEROS_AR93XX)
#if defined (SPI_ACCESS)
	// config selected pin assignment as GPIO mode
	gpio_addr = (volatile mt_uint32 *)ioremap(0x1804006C, 0x2);
	gpio_value = *gpio_addr;
	gpio_value |= 0x00000002;		// disable JTAG => enable GPIO0-GPIO3
	*gpio_addr = gpio_value;
	gpio_addr = (volatile mt_uint32 *)ioremap(0x1804002C, 0x2);
	*gpio_addr = 0x00000000;	// disable any signal MUX to GPIO0-GPIO3
	gpio_value = *gpio_addr;
	gpio_addr = (volatile mt_uint32 *)ioremap(0x18040030, 0x2);
	gpio_value = *gpio_addr;
	gpio_value &= 0xFFFFFF00;	// disable any signal MUX to GPIO4
	*gpio_addr = gpio_value;

	// enable MII connected with VDSL DMT
	gpio_addr = (volatile mt_uint32 *)ioremap(0x18070000, 0x2);
	// MII
	//*gpio_addr = 0x00002892;
	// RGMII
	*gpio_addr = 0x003C2881;
	//*gpio_addr = 0x00003000;

	// MUX ETH_LED with corresponding GPIO
	// config GPIO19-GPIO22 pin as output pin
	gpio_addr = (volatile mt_uint32 *)ioremap(0x18040000, 0x2);
	gpio_value = *gpio_addr;
	gpio_value &= ~(0x00780000);	//output
	*gpio_addr = gpio_value;
	gpio_value = *gpio_addr;
	printk("GPIO OE: 0x%08x\n", gpio_value);
	// MUX GPIO19 to LED_LINK[0]
	gpio_addr = (volatile mt_uint32 *)ioremap(0x1804003C, 0x2);
	*gpio_addr = 0x2900004D;
	gpio_value = *gpio_addr;
	printk("GPIO MUX 1: 0x%08x\n", gpio_value);
	// MUX GPIO20-GPIO22 to LED_LINK[1]-LED_LINK[3]
	gpio_addr = (volatile mt_uint32 *)ioremap(0x18040040, 0x2);
	*gpio_addr = 0x002C2B2A;
	gpio_value = *gpio_addr;
	printk("GPIO MUX 2: 0x%08x\n", gpio_value);

	// config selected pin as DMT output/input pin
	gpio_addr = (volatile mt_uint32 *)ioremap(0x18040000, 0x2);
	gpio_value = *gpio_addr;
	gpio_value &= ~(RESET | SCKB | SC2B | DMT_SRDB);	//output
	gpio_value |= DMT_STDB;	//input
	*gpio_addr = gpio_value;

	data_gpio = (volatile mt_uint32 *)ioremap(0x18040004, 0x2);
	databit_set = (volatile mt_uint32 *)ioremap(0x1804000C, 0x2);
	databit_clr = (volatile mt_uint32 *)ioremap(0x18040010, 0x2);
#else	//HPI_ACCESS
	// config selected pin as DMT output/input pin
	gpio_addr = (volatile mt_uint32 *)ioremap(0x18040000, 0x2);
	gpio_value = *gpio_addr;
	gpio_value &= ~(RESET);
	*gpio_addr = gpio_value;

	databit_set = (volatile mt_uint32 *)ioremap(0x1804000C, 0x2);
	databit_clr = (volatile mt_uint32 *)ioremap(0x18040010, 0x2);
#endif	//defined (SPI_ACCESS)
#elif defined (REALTEK_RTL8672)
#if defined (SPI_ACCESS)
	// config selected pin assignment as GPIO mode
	gpio_addr = (volatile mt_uint32 *)(0xB8003304);
	gpio_value = *gpio_addr;
	gpio_value &= ~(0x00800000); //set bit 23 as 0 to make GPIO D1 as GPIO mode
	*gpio_addr = gpio_value;
	gpio_addr = (volatile mt_uint32 *)(0xB8003504);
	gpio_value = *gpio_addr;
	gpio_value &= ~(RESET_PIN | SCKB_PIN | SC2B_PIN | DMT_SRDB_PIN | DMT_STDB_PIN);	//GPIO D5, D3, D2, D1, A5
	*gpio_addr = gpio_value;

	// config selected pin as DMT output/input pin
	gpio_addr = (volatile mt_uint32 *)(0xB8003508);
	gpio_value = *gpio_addr;
	gpio_value |= RESET_PIN | SCKB_PIN | SC2B_PIN | DMT_SRDB_PIN;	//output
	gpio_value &= ~(DMT_STDB_PIN);	//input
	*gpio_addr = gpio_value;

	// force reset to high
	gpioSet(RESET);

	data_gpio = (volatile mt_uint32 *)(0xB800350C);
	databit_set = (volatile mt_uint32 *)(0xB800350C);
	databit_clr = (volatile mt_uint32 *)(0xB800350C);
#else	//HPI_ACCESS
	// config selected pin assignment as GPIO mode
	gpio_addr = (volatile mt_uint32 *)ioremap(0xA3005010, 0x2);
	gpio_value = *gpio_addr;
	gpio_value |= RESET_PIN;
	*gpio_addr = gpio_value;

	// config selected pin as output pin
	gpio_addr = (volatile mt_uint32 *)ioremap(0xA300500C, 0x2);
	gpio_value = *gpio_addr;
	gpio_value |= RESET_PIN;
	*gpio_addr = gpio_value;

	databit_set = (volatile mt_uint32 *)ioremap(0xA3005004, 0x2);
	databit_clr = (volatile mt_uint32 *)ioremap(0xA3005008, 0x2);
#endif	//defined (SPI_ACCESS)
#elif defined (VITESS_VSC7501)
    HAL_MISC_ENABLE_SMC_CS3_PIN();
	SMC_MEM_BANK3_CONFIG_REG = 0x00000002; /* Bank enable - 8 bit */
	gpio_line_config(22, GPIO_NONE);
	HAL_GPIOA_SET_DIRECTION_OUTPUT((1 << 25));
	//Configure memory bank timing
	bank_timing_reg = SMC_MEM_BANK3_TIMING_REG;
#elif defined (STAR_STR9105)
	databit_set = (volatile mt_uint32 *)ioremap(0x7C000010, 0x2);
	databit_clr = (volatile mt_uint32 *)ioremap(0x7C000014, 0x2);
#endif	//defined (RALINK_RT3052)
#endif	//XENOS

	do_gettimeofday(&tv);
	if(__offtime((time_t *)&(tv.tv_sec), 0, &boottime) != MT_OK)
		printk("Time transform failed!\n");

	// starting vdsl statistic thread
	init_completion(&thread_exited);
	thread_pid = kernel_thread(statistic_thread_handler, NULL, CLONE_KERNEL | SIGCHLD);

	init_port_info();

	printk("\nxDSL Device Driver %s Initialized.\n", DRIVERVERSION);
	
	return 0; /* succeed */
}


void vdsl_cleanup_module( void )
{
#ifdef XENOS
	iounmap((void *)falcon_port);
#elif defined (HOPE)
	iounmap((void *)falcon_port);
#elif defined (BOARD_A5)
#ifndef SPI_ACCESS
	iounmap((void *)falcon_port);
#endif	//SPI_ACCESS
#if defined (RALINK_RT3052) || defined (RALINK_RT3352) || defined (ICPLUS_IP3210) || defined (REALTEK_RTL8672) || defined (STAR_STR9105)
	iounmap((void *)databit_set);
	iounmap((void *)databit_clr);
#endif	//defined (RALINK_RT3052)
#endif	//XENOS

	// cleaning up vdsl statistic thread
	kill_proc(thread_pid, SIGKILL, 1);
	wait_for_completion(&thread_exited);

	unregister_chrdev(vdsl_major, "vdsl");

	printk("\nxDSL Device Driver %s Uninitialized.\n", DRIVERVERSION);
}


module_init(vdsl_init_module);
module_exit(vdsl_cleanup_module);

MODULE_DESCRIPTION("xDSL Device Driver");
MODULE_AUTHOR("Ian");
MODULE_LICENSE("GPL");

EXPORT_SYMBOL(vdsl_proc_msg);
