#ifndef VDSL2LOID_H_
#define VDSL2LOID_H_

#include "vdsl2mib.h"

#define INDEX_REMOTE 128

#define xstr(s) str(s)
#define str(s) #s

#define xdsl2Banplan xstr(10.1.1.1)
#define xdsl2BanplanSYS xstr(10.1.1.2)
#define xdsl2BanplanBND xstr(10.1.1.3)
#define xdsl2BanplanVNS xstr(10.1.1.4)
#define xdsl2BanplanPSD xstr(10.1.1.5)
#define xdsl2BanplanRFI xstr(10.1.1.6)
#define xdsl2BanplanDpboEPsd xstr(10.1.1.7)
#define xdsl2BanplanIOT xstr(10.1.1.8)

//**yalee980521 temporary mib oid define for tr069 start**//
//#define xdsl2StatsShowtimeReceiveBlocks xstr(2.2.1)
//#define xdsl2StatsShowtimeTransmitBlocks xstr(2.2.2)
#define xdsl2StatsShowtimeLinkRetrain xstr(2.2.3)
#define xdsl2StatsShowtimeInitErrors xstr(2.2.4)
#define xdsl2StatsShowtimeInitTimeouts xstr(2.2.5)
#define xdsl2StatsShowtimeLossOfFraming xstr(2.2.6)
#define xdsl2StatsShowtimeErroredSecs xstr(2.2.7)
#define xdsl2StatsShowtimeATUCErroredSecs xstr(2.2.8)
#define xdsl2StatsShowtimeSeverelyErroredSecs xstr(2.2.9)
#define xdsl2StatsShowtimeATUCSeverelyErroredSecs xstr(2.2.10)
#define xdsl2StatsShowtimeFECErrors xstr(2.2.11)
#define xdsl2StatsShowtimeATUCFECErrors xstr(2.2.12)
#define xdsl2StatsShowtimeCRCErrors xstr(2.2.13)
#define xdsl2StatsShowtimeATUCCRCErrors xstr(2.2.14)
//#define xdsl2StatsLastShowtimeReceiveBlocks xstr(2.2.15)
//#define xdsl2StatsLastShowtimeTransmitBlocks xstr(2.2.16)
#define xdsl2StatsLastShowtimeLinkRetrain xstr(2.2.17)
#define xdsl2StatsLastShowtimeInitErrors xstr(2.2.18)
#define xdsl2StatsLastShowtimeInitTimeouts xstr(2.2.19)
#define xdsl2StatsLastShowtimeLossOfFraming xstr(2.2.20)
#define xdsl2StatsLastShowtimeErroredSecs xstr(2.2.21)
#define xdsl2StatsLastShowtimeATUCErroredSecs xstr(2.2.22)
#define xdsl2StatsLastShowtimeSeverelyErroredSecs xstr(2.2.23)
#define xdsl2StatsLastShowtimeATUCSeverelyErroredSecs xstr(2.2.24)
#define xdsl2StatsLastShowtimeFECErrors xstr(2.2.25)
#define xdsl2StatsLastShowtimeATUCFECErrors xstr(2.2.26)
#define xdsl2StatsLastShowtimeCRCErrors xstr(2.2.27)
#define xdsl2StatsLastShowtimeATUCCRCErrors xstr(2.2.28)
#define xdsl2StatsShowtimeOtTimeElapsed xstr(2.2.29)
#define xdsl2StatsShowtimeOtFecs xstr(2.2.30)
#define xdsl2StatsShowtimeOtLoss xstr(2.2.31)
#define xdsl2StatsShowtimeOtUas xstr(2.2.32)
#define xdsl2StatsShowtimeRtTimeElapsed xstr(2.2.33)
#define xdsl2StatsShowtimeRtFecs xstr(2.2.34)
#define xdsl2StatsShowtimeRtLoss xstr(2.2.35)
#define xdsl2StatsShowtimeRtUas xstr(2.2.36)
#define xdsl2StatsLastShowtimeRtLoss xstr(2.2.37)
//**yalee980521 temporary mib oid define for tr069 end**//

//**Ian1020406 temporary mib oid define for total statistics start**//
#define xdsl2StatsTotalFullInits xstr(2.2.38)
#define xdsl2StatsTotalFailedFullInits xstr(2.2.39)
//**Ian1020406 temporary mib oid define for total statistics end**//

// %XdslLineTable%
#define xdsl2LineCmndAutomodeColdStart xstr(MT_MIB_XdslGroup.MT_MIB_XdslLineTable.MT_MIB_xdsl2LineCmndAutomodeColdStart)    // 10
#define xdsl2LineStatusPwrMngState xstr(MT_MIB_XdslGroup.MT_MIB_XdslLineTable.MT_MIB_xdsl2LineStatusPwrMngState)    // 14
#define xdsl2LineStatusInitResult xstr(MT_MIB_XdslGroup.MT_MIB_XdslLineTable.MT_MIB_xdsl2LineStatusInitResult)    // 15
#define xdsl2LineStatusLastStateDs xstr(MT_MIB_XdslGroup.MT_MIB_XdslLineTable.MT_MIB_xdsl2LineStatusLastStateDs)    // 16
#define xdsl2LineStatusLastStateUs xstr(MT_MIB_XdslGroup.MT_MIB_XdslLineTable.MT_MIB_xdsl2LineStatusLastStateUs)    // 17
#define xdsl2LineStatusAttainableRateDs xstr(MT_MIB_XdslGroup.MT_MIB_XdslLineTable.MT_MIB_xdsl2LineStatusAttainableRateDs)	// 20
#define xdsl2LineStatusAttainableRateUs xstr(MT_MIB_XdslGroup.MT_MIB_XdslLineTable.MT_MIB_xdsl2LineStatusAttainableRateUs)	// 21
#define xdsl2LineStatusActPsdDs xstr(MT_MIB_XdslGroup.MT_MIB_XdslLineTable.MT_MIB_xdsl2LineStatusActPsdDs)    // 22
#define xdsl2LineStatusActPsdUs xstr(MT_MIB_XdslGroup.MT_MIB_XdslLineTable.MT_MIB_xdsl2LineStatusActPsdUs)    // 23
#define xdsl2LineStatusActAtpDs xstr(MT_MIB_XdslGroup.MT_MIB_XdslLineTable.MT_MIB_xdsl2LineStatusActAtpDs)    // 24
#define xdsl2LineStatusActAtpUs xstr(MT_MIB_XdslGroup.MT_MIB_XdslLineTable.MT_MIB_xdsl2LineStatusActAtpUs)    // 25
#define xdsl2LineStatusActProfile xstr(MT_MIB_XdslGroup.MT_MIB_XdslLineTable.MT_MIB_xdsl2LineStatusActProfile)	// 26
#define xdsl2LineStatusActSnrModeDs xstr(MT_MIB_XdslGroup.MT_MIB_XdslLineTable.MT_MIB_xdsl2LineStatusActSnrModeDs)    // 29
#define xdsl2LineStatusActSnrModeUs xstr(MT_MIB_XdslGroup.MT_MIB_XdslLineTable.MT_MIB_xdsl2LineStatusActSnrModeUs)    // 30
#define xdsl2LineStatusElectricalLength xstr(MT_MIB_XdslGroup.MT_MIB_XdslLineTable.MT_MIB_xdsl2LineStatusElectricalLength)   // 31
#define xdsl2LineStatusTssiDs xstr(MT_MIB_XdslGroup.MT_MIB_XdslLineTable.MT_MIB_xdsl2LineStatusTssiDs)    // 32
#define xdsl2LineStatusTssiUs xstr(MT_MIB_XdslGroup.MT_MIB_XdslLineTable.MT_MIB_xdsl2LineStatusTssiUs)    // 33
#define xdsl2LineStatusMrefPsdDs xstr(MT_MIB_XdslGroup.MT_MIB_XdslLineTable.MT_MIB_xdsl2LineStatusMrefPsdDs)    // 34
#define xdsl2LineStatusMrefPsdUs xstr(MT_MIB_XdslGroup.MT_MIB_XdslLineTable.MT_MIB_xdsl2LineStatusMrefPsdUs)   // 35
#define xdsl2LineStatusTrellisDs xstr(MT_MIB_XdslGroup.MT_MIB_XdslLineTable.MT_MIB_xdsl2LineStatusTrellisDs)    // 36
#define xdsl2LineStatusTrellisUs xstr(MT_MIB_XdslGroup.MT_MIB_XdslLineTable.MT_MIB_xdsl2LineStatusTrellisUs)    // 37
#define xdsl2LineStatusActualCe xstr(MT_MIB_XdslGroup.MT_MIB_XdslLineTable.MT_MIB_xdsl2LineStatusActualCe)    // 38

// %XdslLineBandTable%
#define xdsl2LineBand xstr(MT_MIB_XdslGroup.MT_MIB_XdslLineBandTable.MT_MIB_xdsl2LineBand)    // 1
#define xdsl2LineBandStatusLnAtten xstr(MT_MIB_XdslGroup.MT_MIB_XdslLineBandTable.MT_MIB_xdsl2LineBandStatusLnAtten)    // 2
#define xdsl2LineBandStatusSigAtten xstr(MT_MIB_XdslGroup.MT_MIB_XdslLineBandTable.MT_MIB_xdsl2LineBandStatusSigAtten)    // 3
#define xdsl2LineBandStatusSnrMargin xstr(MT_MIB_XdslGroup.MT_MIB_XdslLineBandTable.MT_MIB_xdsl2LineBandStatusSnrMargin)    // 4

#define xdsl2LineBandStatusLnAtten1 xstr(MT_MIB_XdslGroup.MT_MIB_XdslLineBandTable.MT_MIB_xdsl2LineBandStatusLnAtten.2)    // 2
#define xdsl2LineBandStatusSigAtten1 xstr(MT_MIB_XdslGroup.MT_MIB_XdslLineBandTable.MT_MIB_xdsl2LineBandStatusSigAtten.2)    // 3
#define xdsl2LineBandStatusSnrMargin1 xstr(MT_MIB_XdslGroup.MT_MIB_XdslLineBandTable.MT_MIB_xdsl2LineBandStatusSnrMargin.2)    // 4

#define xdsl2LineBandStatusLnAtten2 xstr(MT_MIB_XdslGroup.MT_MIB_XdslLineBandTable.MT_MIB_xdsl2LineBandStatusLnAtten.3)    // 2
#define xdsl2LineBandStatusSigAtten2 xstr(MT_MIB_XdslGroup.MT_MIB_XdslLineBandTable.MT_MIB_xdsl2LineBandStatusSigAtten.3)    // 3
#define xdsl2LineBandStatusSnrMargin2 xstr(MT_MIB_XdslGroup.MT_MIB_XdslLineBandTable.MT_MIB_xdsl2LineBandStatusSnrMargin.3)    // 4

#define xdsl2LineBandStatusLnAtten3 xstr(MT_MIB_XdslGroup.MT_MIB_XdslLineBandTable.MT_MIB_xdsl2LineBandStatusLnAtten.4)    // 2
#define xdsl2LineBandStatusSigAtten3 xstr(MT_MIB_XdslGroup.MT_MIB_XdslLineBandTable.MT_MIB_xdsl2LineBandStatusSigAtten.4)    // 3
#define xdsl2LineBandStatusSnrMargin3 xstr(MT_MIB_XdslGroup.MT_MIB_XdslLineBandTable.MT_MIB_xdsl2LineBandStatusSnrMargin.4)    // 4

#define xdsl2LineBandStatusLnAtten4 xstr(MT_MIB_XdslGroup.MT_MIB_XdslLineBandTable.MT_MIB_xdsl2LineBandStatusLnAtten.5)    // 2
#define xdsl2LineBandStatusSigAtten4 xstr(MT_MIB_XdslGroup.MT_MIB_XdslLineBandTable.MT_MIB_xdsl2LineBandStatusSigAtten.5)    // 3
#define xdsl2LineBandStatusSnrMargin4 xstr(MT_MIB_XdslGroup.MT_MIB_XdslLineBandTable.MT_MIB_xdsl2LineBandStatusSnrMargin.5)    // 4

#define xdsl2LineBandStatusLnAtten5 xstr(MT_MIB_XdslGroup.MT_MIB_XdslLineBandTable.MT_MIB_xdsl2LineBandStatusLnAtten.6)    // 2
#define xdsl2LineBandStatusSigAtten5 xstr(MT_MIB_XdslGroup.MT_MIB_XdslLineBandTable.MT_MIB_xdsl2LineBandStatusSigAtten.6)    // 3
#define xdsl2LineBandStatusSnrMargin5 xstr(MT_MIB_XdslGroup.MT_MIB_XdslLineBandTable.MT_MIB_xdsl2LineBandStatusSnrMargin.6)    // 4

#define xdsl2LineBandStatusLnAtten6 xstr(MT_MIB_XdslGroup.MT_MIB_XdslLineBandTable.MT_MIB_xdsl2LineBandStatusLnAtten.7)    // 2
#define xdsl2LineBandStatusSigAtten6 xstr(MT_MIB_XdslGroup.MT_MIB_XdslLineBandTable.MT_MIB_xdsl2LineBandStatusSigAtten.7)    // 3
#define xdsl2LineBandStatusSnrMargin6 xstr(MT_MIB_XdslGroup.MT_MIB_XdslLineBandTable.MT_MIB_xdsl2LineBandStatusSnrMargin.7)    // 4

#define xdsl2LineBandStatusLnAtten7 xstr(MT_MIB_XdslGroup.MT_MIB_XdslLineBandTable.MT_MIB_xdsl2LineBandStatusLnAtten.8)    // 2
#define xdsl2LineBandStatusSigAtten7 xstr(MT_MIB_XdslGroup.MT_MIB_XdslLineBandTable.MT_MIB_xdsl2LineBandStatusSigAtten.8)    // 3
#define xdsl2LineBandStatusSnrMargin7 xstr(MT_MIB_XdslGroup.MT_MIB_XdslLineBandTable.MT_MIB_xdsl2LineBandStatusSnrMargin.8)    // 4

#define xdsl2LineBandStatusLnAtten8 xstr(MT_MIB_XdslGroup.MT_MIB_XdslLineBandTable.MT_MIB_xdsl2LineBandStatusLnAtten.9)    // 2
#define xdsl2LineBandStatusSigAtten8 xstr(MT_MIB_XdslGroup.MT_MIB_XdslLineBandTable.MT_MIB_xdsl2LineBandStatusSigAtten.9)    // 3
#define xdsl2LineBandStatusSnrMargin8 xstr(MT_MIB_XdslGroup.MT_MIB_XdslLineBandTable.MT_MIB_xdsl2LineBandStatusSnrMargin.9)    // 4

#define xdsl2LineBandStatusLnAtten9 xstr(MT_MIB_XdslGroup.MT_MIB_XdslLineBandTable.MT_MIB_xdsl2LineBandStatusLnAtten.10)    // 2
#define xdsl2LineBandStatusSigAtten9 xstr(MT_MIB_XdslGroup.MT_MIB_XdslLineBandTable.MT_MIB_xdsl2LineBandStatusSigAtten.10)    // 3
#define xdsl2LineBandStatusSnrMargin9 xstr(MT_MIB_XdslGroup.MT_MIB_XdslLineBandTable.MT_MIB_xdsl2LineBandStatusSnrMargin.10)    // 4

#define xdsl2LineBandStatusLnAtten10 xstr(MT_MIB_XdslGroup.MT_MIB_XdslLineBandTable.MT_MIB_xdsl2LineBandStatusLnAtten.11)    // 2
#define xdsl2LineBandStatusSigAtten10 xstr(MT_MIB_XdslGroup.MT_MIB_XdslLineBandTable.MT_MIB_xdsl2LineBandStatusSigAtten.11)    // 3
#define xdsl2LineBandStatusSnrMargin10 xstr(MT_MIB_XdslGroup.MT_MIB_XdslLineBandTable.MT_MIB_xdsl2LineBandStatusSnrMargin.11)    // 4

// %Xdsl2ChannelStatusTable%
#define xdsl2ChStatusUnit xstr(MT_MIB_XdslGroup.MT_MIB_Xdsl2ChannelStatusTable.MT_MIB_xdsl2ChStatusUnit)    // 1
#define xdsl2ChStatusActDataRate xstr(MT_MIB_XdslGroup.MT_MIB_Xdsl2ChannelStatusTable.MT_MIB_xdsl2ChStatusActDataRate)    // 2
#define xdsl2ChStatusPrevDataRate xstr(MT_MIB_XdslGroup.MT_MIB_Xdsl2ChannelStatusTable.MT_MIB_xdsl2ChStatusPrevDataRate)    // 3
#define xdsl2ChStatusActDelay xstr(MT_MIB_XdslGroup.MT_MIB_Xdsl2ChannelStatusTable.MT_MIB_xdsl2ChStatusActDelay)    // 4
#define xdsl2ChStatusActInp xstr(MT_MIB_XdslGroup.MT_MIB_Xdsl2ChannelStatusTable.MT_MIB_xdsl2ChStatusActInp)    // 5
#define xdsl2ChStatusInpReport xstr(MT_MIB_XdslGroup.MT_MIB_Xdsl2ChannelStatusTable.MT_MIB_xdsl2ChStatusInpReport)    // 6
#define xdsl2ChStatusNFec xstr(MT_MIB_XdslGroup.MT_MIB_Xdsl2ChannelStatusTable.MT_MIB_xdsl2ChStatusNFec)    // 7
#define xdsl2ChStatusRFec xstr(MT_MIB_XdslGroup.MT_MIB_Xdsl2ChannelStatusTable.MT_MIB_xdsl2ChStatusRFec)   //  8
#define xdsl2ChStatusLSymb xstr(MT_MIB_XdslGroup.MT_MIB_Xdsl2ChannelStatusTable.MT_MIB_xdsl2ChStatusLSymb)    // 9
#define xdsl2ChStatusIntlvDepth xstr(MT_MIB_XdslGroup.MT_MIB_Xdsl2ChannelStatusTable.MT_MIB_xdsl2ChStatusIntlvDepth)    // 10
#define xdsl2ChStatusIntlvBlock xstr(MT_MIB_XdslGroup.MT_MIB_Xdsl2ChannelStatusTable.MT_MIB_xdsl2ChStatusIntlvBlock)    // 11
#define xdsl2ChStatusLPath xstr(MT_MIB_XdslGroup.MT_MIB_Xdsl2ChannelStatusTable.MT_MIB_xdsl2ChStatusLPath)    // 12
#define xdsl2ChStatusAtmStatus xstr(MT_MIB_XdslGroup.MT_MIB_Xdsl2ChannelStatusTable.MT_MIB_xdsl2ChStatusAtmStatus)    // 13
#define xdsl2ChStatusPtmStatus xstr(MT_MIB_XdslGroup.MT_MIB_Xdsl2ChannelStatusTable.MT_MIB_xdsl2ChStatusPtmStatus)    // 14

#define xdsl2ChStatusActDataRate2 xstr(MT_MIB_XdslGroup.MT_MIB_Xdsl2ChannelStatusTable.MT_MIB_xdsl2ChStatusActDataRate.3)    // 2
#define xdsl2ChStatusPrevDataRate2 xstr(MT_MIB_XdslGroup.MT_MIB_Xdsl2ChannelStatusTable.MT_MIB_xdsl2ChStatusPrevDataRate.3)    // 3
#define xdsl2ChStatusActDelay2 xstr(MT_MIB_XdslGroup.MT_MIB_Xdsl2ChannelStatusTable.MT_MIB_xdsl2ChStatusActDelay.3)    // 4
#define xdsl2ChStatusActInp2 xstr(MT_MIB_XdslGroup.MT_MIB_Xdsl2ChannelStatusTable.MT_MIB_xdsl2ChStatusActInp.3)    // 5
#define xdsl2ChStatusInpReport2 xstr(MT_MIB_XdslGroup.MT_MIB_Xdsl2ChannelStatusTable.MT_MIB_xdsl2ChStatusInpReport.3)    // 6
#define xdsl2ChStatusNFec2 xstr(MT_MIB_XdslGroup.MT_MIB_Xdsl2ChannelStatusTable.MT_MIB_xdsl2ChStatusNFec.3)    // 7
#define xdsl2ChStatusRFec2 xstr(MT_MIB_XdslGroup.MT_MIB_Xdsl2ChannelStatusTable.MT_MIB_xdsl2ChStatusRFec.3)   //  8
#define xdsl2ChStatusLSymb2 xstr(MT_MIB_XdslGroup.MT_MIB_Xdsl2ChannelStatusTable.MT_MIB_xdsl2ChStatusLSymb.3)    // 9
#define xdsl2ChStatusIntlvDepth2 xstr(MT_MIB_XdslGroup.MT_MIB_Xdsl2ChannelStatusTable.MT_MIB_xdsl2ChStatusIntlvDepth.3)    // 10
#define xdsl2ChStatusIntlvBlock2 xstr(MT_MIB_XdslGroup.MT_MIB_Xdsl2ChannelStatusTable.MT_MIB_xdsl2ChStatusIntlvBlock.3)    // 11
#define xdsl2ChStatusLPath2 xstr(MT_MIB_XdslGroup.MT_MIB_Xdsl2ChannelStatusTable.MT_MIB_xdsl2ChStatusLPath.3)    // 12

// %Xdsl2SCStatusTable%
#define xdsl2SCStatusDirection xstr(MT_MIB_XdslGroup.MT_MIB_Xdsl2SCStatusTable.MT_MIB_xdsl2SCStatusDirection)    // 1
#define xdsl2SCStatusLinScale xstr(MT_MIB_XdslGroup.MT_MIB_Xdsl2SCStatusTable.MT_MIB_xdsl2SCStatusLinScale)    // 2
#define xdsl2SCStatusLinScGroupSize xstr(MT_MIB_XdslGroup.MT_MIB_Xdsl2SCStatusTable.MT_MIB_xdsl2SCStatusLinScGroupSize)    // 3
#define xdsl2SCStatusLogMt xstr(MT_MIB_XdslGroup.MT_MIB_Xdsl2SCStatusTable.MT_MIB_xdsl2SCStatusLogMt)    // 4
#define xdsl2SCStatusLogScGroupSize xstr(MT_MIB_XdslGroup.MT_MIB_Xdsl2SCStatusTable.MT_MIB_xdsl2SCStatusLogScGroupSize)    // 5
#define xdsl2SCStatusQlnMt xstr(MT_MIB_XdslGroup.MT_MIB_Xdsl2SCStatusTable.MT_MIB_xdsl2SCStatusQlnMt)    // 6
#define xdsl2SCStatusQlnScGroupSize xstr(MT_MIB_XdslGroup.MT_MIB_Xdsl2SCStatusTable.MT_MIB_xdsl2SCStatusQlnScGroupSize)    // 7
#define xdsl2SCStatusSnrMtime xstr(MT_MIB_XdslGroup.MT_MIB_Xdsl2SCStatusTable.MT_MIB_xdsl2SCStatusSnrMtime)    // 8
#define xdsl2SCStatusSnrScGroupSize xstr(MT_MIB_XdslGroup.MT_MIB_Xdsl2SCStatusTable.MT_MIB_xdsl2SCStatusSnrScGroupSize)    // 9
#define xdsl2SCStatusRowStatus xstr(MT_MIB_XdslGroup.MT_MIB_Xdsl2SCStatusTable.MT_MIB_xdsl2SCStatusRowStatus)    // 10

#define xdsl2SCStatusLinScale1 xstr(MT_MIB_XdslGroup.MT_MIB_Xdsl2SCStatusTable.MT_MIB_xdsl2SCStatusLinScale.2)    // 2

// %Xdsl2SCStatusBandTable%
#define xdsl2SCStatusBand xstr(MT_MIB_XdslGroup.MT_MIB_Xdsl2SCStatusBandTable.MT_MIB_xdsl2SCStatusBand)    // 1
#define xdsl2SCStatusBandLnAtten xstr(MT_MIB_XdslGroup.MT_MIB_Xdsl2SCStatusBandTable.MT_MIB_xdsl2SCStatusBandLnAtten)    // 2
#define xdsl2SCStatusBandSigAtten xstr(MT_MIB_XdslGroup.MT_MIB_Xdsl2SCStatusBandTable.MT_MIB_xdsl2SCStatusBandSigAtten)    // 3

// %Xdsl2SCStatusSegmentTable%
#define xdsl2SCStatusSegment xstr(MT_MIB_XdslGroup.MT_MIB_Xdsl2SCStatusSegmentTable.MT_MIB_xdsl2SCStatusSegment)    // 1
#define xdsl2SCStatusSegmentLinReal xstr(MT_MIB_XdslGroup.MT_MIB_Xdsl2SCStatusSegmentTable.MT_MIB_xdsl2SCStatusSegmentLinReal)    // 2
#define xdsl2SCStatusSegmentLinImg xstr(MT_MIB_XdslGroup.MT_MIB_Xdsl2SCStatusSegmentTable.MT_MIB_xdsl2SCStatusSegmentLinImg)    // 3
#define xdsl2SCStatusSegmentLog xstr(MT_MIB_XdslGroup.MT_MIB_Xdsl2SCStatusSegmentTable.MT_MIB_xdsl2SCStatusSegmentLog)    // 4
#define xdsl2SCStatusSegmentQln xstr(MT_MIB_XdslGroup.MT_MIB_Xdsl2SCStatusSegmentTable.MT_MIB_xdsl2SCStatusSegmentQln)    // 5
#define xdsl2SCStatusSegmentSnr xstr(MT_MIB_XdslGroup.MT_MIB_Xdsl2SCStatusSegmentTable.MT_MIB_xdsl2SCStatusSegmentSnr)    // 6
#define xdsl2SCStatusSegmentBitsGainAlloc xstr(MT_MIB_XdslGroup.MT_MIB_Xdsl2SCStatusSegmentTable.MT_MIB_xdsl2SCStatusSegmentBitsGainAlloc)    // 7

// %Xdsl2LineInventoryTable%
#define xdsl2LInvUnit xstr(MT_MIB_XdslGroup.MT_MIB_Xdsl2LineInventoryTable.MT_MIB_xdsl2LInvUnit)
#define xdsl2LInvG994VendorId xstr(MT_MIB_XdslGroup.MT_MIB_Xdsl2LineInventoryTable.MT_MIB_xdsl2LInvG994VendorId)
#define xdsl2LInvSystemVendorId xstr(MT_MIB_XdslGroup.MT_MIB_Xdsl2LineInventoryTable.MT_MIB_xdsl2LInvSystemVendorId)
#define xdsl2LInvVersionNumber xstr(MT_MIB_XdslGroup.MT_MIB_Xdsl2LineInventoryTable.MT_MIB_xdsl2LInvVersionNumber)
#define xdsl2LInvSerialNumber xstr(MT_MIB_XdslGroup.MT_MIB_Xdsl2LineInventoryTable.MT_MIB_xdsl2LInvSerialNumber)
#define xdsl2LInvSelfTestResult xstr(MT_MIB_XdslGroup.MT_MIB_Xdsl2LineInventoryTable.MT_MIB_xdsl2LInvSelfTestResult) 
#define xdsl2LInvTransmissionCapabilities xstr(MT_MIB_XdslGroup.MT_MIB_Xdsl2LineInventoryTable.MT_MIB_xdsl2LInvTransmissionCapabilities)

#define xdsl2LInvG994VendorId1 xstr(MT_MIB_XdslGroup.MT_MIB_Xdsl2LineInventoryTable.MT_MIB_xdsl2LInvG994VendorId.2)
#define xdsl2LInvSystemVendorId1 xstr(MT_MIB_XdslGroup.MT_MIB_Xdsl2LineInventoryTable.MT_MIB_xdsl2LInvSystemVendorId.2)
#define xdsl2LInvVersionNumber1 xstr(MT_MIB_XdslGroup.MT_MIB_Xdsl2LineInventoryTable.MT_MIB_xdsl2LInvVersionNumber.2)
#define xdsl2LInvSerialNumber1 xstr(MT_MIB_XdslGroup.MT_MIB_Xdsl2LineInventoryTable.MT_MIB_xdsl2LInvSerialNumber.2)
#define xdsl2LInvSelfTestResult1 xstr(MT_MIB_XdslGroup.MT_MIB_Xdsl2LineInventoryTable.MT_MIB_xdsl2LInvSelfTestResult.2) 
#define xdsl2LInvTransmissionCapabilities1 xstr(MT_MIB_XdslGroup.MT_MIB_Xdsl2LineInventoryTable.MT_MIB_xdsl2LInvTransmissionCapabilities.2)

// %Xdsl2LineAlarmConfProfileTable%
#define xdsl2LineAlarmConfProfileXtucThresh15MinFecs xstr(MT_MIB_XdslGroup.MT_MIB_Xdsl2LineAlarmConfProfileTable.MT_MIB_xdsl2LineAlarmConfProfileXtucThresh15MinFecs)//2
#define xdsl2LineAlarmConfProfileXtucThresh15MinEs xstr(MT_MIB_XdslGroup.MT_MIB_Xdsl2LineAlarmConfProfileTable.MT_MIB_xdsl2LineAlarmConfProfileXtucThresh15MinEs)//3
#define xdsl2LineAlarmConfProfileXtucThresh15MinSes xstr(MT_MIB_XdslGroup.MT_MIB_Xdsl2LineAlarmConfProfileTable.MT_MIB_xdsl2LineAlarmConfProfileXtucThresh15MinSes)//4
#define xdsl2LineAlarmConfProfileXtucThresh15MinLoss xstr(MT_MIB_XdslGroup.MT_MIB_Xdsl2LineAlarmConfProfileTable.MT_MIB_xdsl2LineAlarmConfProfileXtucThresh15MinLoss)//5
#define xdsl2LineAlarmConfProfileXtucThresh15MinUas xstr(MT_MIB_XdslGroup.MT_MIB_Xdsl2LineAlarmConfProfileTable.MT_MIB_xdsl2LineAlarmConfProfileXtucThresh15MinUas)//6
#define xdsl2LineAlarmConfProfileXturThresh15MinFecs xstr(MT_MIB_XdslGroup.MT_MIB_Xdsl2LineAlarmConfProfileTable.MT_MIB_xdsl2LineAlarmConfProfileXturThresh15MinFecs)//7
#define xdsl2LineAlarmConfProfileXturThresh15MinEs xstr(MT_MIB_XdslGroup.MT_MIB_Xdsl2LineAlarmConfProfileTable.MT_MIB_xdsl2LineAlarmConfProfileXturThresh15MinEs)//8
#define xdsl2LineAlarmConfProfileXturThresh15MinSes xstr(MT_MIB_XdslGroup.MT_MIB_Xdsl2LineAlarmConfProfileTable.MT_MIB_xdsl2LineAlarmConfProfileXturThresh15MinSes)//9
#define xdsl2LineAlarmConfProfileXturThresh15MinLoss xstr(MT_MIB_XdslGroup.MT_MIB_Xdsl2LineAlarmConfProfileTable.MT_MIB_xdsl2LineAlarmConfProfileXturThresh15MinLoss)//10
#define xdsl2LineAlarmConfProfileXturThresh15MinUas xstr(MT_MIB_XdslGroup.MT_MIB_Xdsl2LineAlarmConfProfileTable.MT_MIB_xdsl2LineAlarmConfProfileXturThresh15MinUas)//11
#define xdsl2LineAlarmConfProfileThresh15MinFailedFullInt xstr(MT_MIB_XdslGroup.MT_MIB_Xdsl2LineAlarmConfProfileTable.MT_MIB_xdsl2LineAlarmConfProfileThresh15MinFailedFullInt)//12
#define xdsl2LineAlarmConfProfileThresh15MinFailedShrtInt xstr(MT_MIB_XdslGroup.MT_MIB_Xdsl2LineAlarmConfProfileTable.MT_MIB_xdsl2LineAlarmConfProfileThresh15MinFailedShrtInt)//13

// %Xdsl2ChAlarmConfProfileTable%
#define xdsl2ChAlarmConfProfileXtucThresh15MinCodingViolations xstr(MT_MIB_XdslGroup.MT_MIB_Xdsl2ChAlarmConfProfileTable.MT_MIB_xdsl2ChAlarmConfProfileXtucThresh15MinCodingViolations)//2
#define xdsl2ChAlarmConfProfileXtucThresh15MinCorrected xstr(MT_MIB_XdslGroup.MT_MIB_Xdsl2ChAlarmConfProfileTable.MT_MIB_xdsl2ChAlarmConfProfileXtucThresh15MinCorrected)//3
#define xdsl2ChAlarmConfProfileXturThresh15MinCodingViolations xstr(MT_MIB_XdslGroup.MT_MIB_Xdsl2ChAlarmConfProfileTable.MT_MIB_xdsl2ChAlarmConfProfileXturThresh15MinCodingViolations)//4
#define xdsl2ChAlarmConfProfileXturThresh15MinCorrected xstr(MT_MIB_XdslGroup.MT_MIB_Xdsl2ChAlarmConfProfileTable.MT_MIB_xdsl2ChAlarmConfProfileXturThresh15MinCorrected)//5

// %Xdsl2PMLineCurrTable%
#define xdsl2PMLCurr15MTimeElapsed xstr(MT_MIB_XdslGroup.MT_MIB_Xdsl2PMLineCurrTable.MT_MIB_xdsl2PMLCurr15MTimeElapsed)
#define xdsl2PMLCurr15MFecs xstr(MT_MIB_XdslGroup.MT_MIB_Xdsl2PMLineCurrTable.MT_MIB_xdsl2PMLCurr15MFecs)
#define xdsl2PMLCurr15MEs xstr(MT_MIB_XdslGroup.MT_MIB_Xdsl2PMLineCurrTable.MT_MIB_xdsl2PMLCurr15MEs)
#define xdsl2PMLCurr15MSes xstr(MT_MIB_XdslGroup.MT_MIB_Xdsl2PMLineCurrTable.MT_MIB_xdsl2PMLCurr15MSes)
#define xdsl2PMLCurr15MLoss xstr(MT_MIB_XdslGroup.MT_MIB_Xdsl2PMLineCurrTable.MT_MIB_xdsl2PMLCurr15MLoss)
#define xdsl2PMLCurr15MUas xstr(MT_MIB_XdslGroup.MT_MIB_Xdsl2PMLineCurrTable.MT_MIB_xdsl2PMLCurr15MUas)
#define xdsl2PMLCurr1DayTimeElapsed xstr(MT_MIB_XdslGroup.MT_MIB_Xdsl2PMLineCurrTable.MT_MIB_xdsl2PMLCurr1DayTimeElapsed)
#define xdsl2PMLCurr1DayFecs xstr(MT_MIB_XdslGroup.MT_MIB_Xdsl2PMLineCurrTable.MT_MIB_xdsl2PMLCurr1DayFecs)
#define xdsl2PMLCurr1DayEs xstr(MT_MIB_XdslGroup.MT_MIB_Xdsl2PMLineCurrTable.MT_MIB_xdsl2PMLCurr1DayEs)
#define xdsl2PMLCurr1DaySes xstr(MT_MIB_XdslGroup.MT_MIB_Xdsl2PMLineCurrTable.MT_MIB_xdsl2PMLCurr1DaySes)
#define xdsl2PMLCurr1DayLoss xstr(MT_MIB_XdslGroup.MT_MIB_Xdsl2PMLineCurrTable.MT_MIB_xdsl2PMLCurr1DayLoss)
#define xdsl2PMLCurr1DayUas xstr(MT_MIB_XdslGroup.MT_MIB_Xdsl2PMLineCurrTable.MT_MIB_xdsl2PMLCurr1DayUas)

#define xdsl2PMLCurr15MTimeElapsed1 xstr(MT_MIB_XdslGroup.MT_MIB_Xdsl2PMLineCurrTable.MT_MIB_xdsl2PMLCurr15MTimeElapsed.2)
#define xdsl2PMLCurr15MFecs1 xstr(MT_MIB_XdslGroup.MT_MIB_Xdsl2PMLineCurrTable.MT_MIB_xdsl2PMLCurr15MFecs.2)
#define xdsl2PMLCurr15MEs1 xstr(MT_MIB_XdslGroup.MT_MIB_Xdsl2PMLineCurrTable.MT_MIB_xdsl2PMLCurr15MEs.2)
#define xdsl2PMLCurr15MSes1 xstr(MT_MIB_XdslGroup.MT_MIB_Xdsl2PMLineCurrTable.MT_MIB_xdsl2PMLCurr15MSes.2)
#define xdsl2PMLCurr15MLoss1 xstr(MT_MIB_XdslGroup.MT_MIB_Xdsl2PMLineCurrTable.MT_MIB_xdsl2PMLCurr15MLoss.2)
#define xdsl2PMLCurr15MUas1 xstr(MT_MIB_XdslGroup.MT_MIB_Xdsl2PMLineCurrTable.MT_MIB_xdsl2PMLCurr15MUas.2)
#define xdsl2PMLCurr1DayTimeElapsed1 xstr(MT_MIB_XdslGroup.MT_MIB_Xdsl2PMLineCurrTable.MT_MIB_xdsl2PMLCurr1DayTimeElapsed.2)
#define xdsl2PMLCurr1DayFecs1 xstr(MT_MIB_XdslGroup.MT_MIB_Xdsl2PMLineCurrTable.MT_MIB_xdsl2PMLCurr1DayFecs.2)
#define xdsl2PMLCurr1DayEs1 xstr(MT_MIB_XdslGroup.MT_MIB_Xdsl2PMLineCurrTable.MT_MIB_xdsl2PMLCurr1DayEs.2)
#define xdsl2PMLCurr1DaySes1 xstr(MT_MIB_XdslGroup.MT_MIB_Xdsl2PMLineCurrTable.MT_MIB_xdsl2PMLCurr1DaySes.2)
#define xdsl2PMLCurr1DayLoss1 xstr(MT_MIB_XdslGroup.MT_MIB_Xdsl2PMLineCurrTable.MT_MIB_xdsl2PMLCurr1DayLoss.2)
#define xdsl2PMLCurr1DayUas1 xstr(MT_MIB_XdslGroup.MT_MIB_Xdsl2PMLineCurrTable.MT_MIB_xdsl2PMLCurr1DayUas.2)

// %Xdsl2PMLineInitCurrTable%
#define xdsl2PMLInitCurr15MValidIntervals xstr(MT_MIB_XdslGroup.MT_MIB_Xdsl2PMLineInitCurrTable.MT_MIB_xdsl2PMLInitCurr15MValidIntervals)    // 1
#define xdsl2PMLInitCurr15MInvalidIntervals xstr(MT_MIB_XdslGroup.MT_MIB_Xdsl2PMLineInitCurrTable.MT_MIB_xdsl2PMLInitCurr15MInvalidIntervals)    // 2
#define xdsl2PMLInitCurr15MTimeElapsed xstr(MT_MIB_XdslGroup.MT_MIB_Xdsl2PMLineInitCurrTable.MT_MIB_xdsl2PMLInitCurr15MTimeElapsed)    // 3
#define xdsl2PMLInitCurr15MFullInits xstr(MT_MIB_XdslGroup.MT_MIB_Xdsl2PMLineInitCurrTable.MT_MIB_xdsl2PMLInitCurr15MFullInits)    // 4
#define xdsl2PMLInitCurr15MFailedFullInits xstr(MT_MIB_XdslGroup.MT_MIB_Xdsl2PMLineInitCurrTable.MT_MIB_xdsl2PMLInitCurr15MFailedFullInits)    // 5
#define xdsl2PMLInitCurr15MShortInits xstr(MT_MIB_XdslGroup.MT_MIB_Xdsl2PMLineInitCurrTable.MT_MIB_xdsl2PMLInitCurr15MShortInits)    // 6
#define xdsl2PMLInitCurr15MFailedShortInits xstr(MT_MIB_XdslGroup.MT_MIB_Xdsl2PMLineInitCurrTable.MT_MIB_xdsl2PMLInitCurr15MFailedShortInits)    // 7
#define xdsl2PMLInitCurr1DayValidIntervals xstr(MT_MIB_XdslGroup.MT_MIB_Xdsl2PMLineInitCurrTable.MT_MIB_xdsl2PMLInitCurr1DayValidIntervals)    // 8
#define xdsl2PMLInitCurr1DayInvalidIntervals xstr(MT_MIB_XdslGroup.MT_MIB_Xdsl2PMLineInitCurrTable.MT_MIB_xdsl2PMLInitCurr1DayInvalidIntervals)   //  9
#define xdsl2PMLInitCurr1DayTimeElapsed xstr(MT_MIB_XdslGroup.MT_MIB_Xdsl2PMLineInitCurrTable.MT_MIB_xdsl2PMLInitCurr1DayTimeElapsed)    // 10
#define xdsl2PMLInitCurr1DayFullInits xstr(MT_MIB_XdslGroup.MT_MIB_Xdsl2PMLineInitCurrTable.MT_MIB_xdsl2PMLInitCurr1DayFullInits)    // 11
#define xdsl2PMLInitCurr1DayFailedFullInits xstr(MT_MIB_XdslGroup.MT_MIB_Xdsl2PMLineInitCurrTable.MT_MIB_xdsl2PMLInitCurr1DayFailedFullInits)    // 12
#define xdsl2PMLInitCurr1DayShortInits xstr(MT_MIB_XdslGroup.MT_MIB_Xdsl2PMLineInitCurrTable.MT_MIB_xdsl2PMLInitCurr1DayShortInits)    // 13
#define xdsl2PMLInitCurr1DayFailedShortInits xstr(MT_MIB_XdslGroup.MT_MIB_Xdsl2PMLineInitCurrTable.MT_MIB_xdsl2PMLInitCurr1DayFailedShortInits)    // 14

// %Xdsl2PMLineHist15MinTable%
#define xdsl2PMLHist15MUnit xstr(MT_MIB_XdslGroup.MT_MIB_Xdsl2PMLineHist15MinTable.MT_MIB_xdsl2PMLHist15MUnit)    // 1
#define xdsl2PMLHist15MInterval xstr(MT_MIB_XdslGroup.MT_MIB_Xdsl2PMLineHist15MinTable.MT_MIB_xdsl2PMLHist15MInterval)    // 2
#define xdsl2PMLHist15MMonitoredTime xstr(MT_MIB_XdslGroup.MT_MIB_Xdsl2PMLineHist15MinTable.MT_MIB_xdsl2PMLHist15MMonitoredTime)    // 3
#define xdsl2PMLHist15MFecs xstr(MT_MIB_XdslGroup.MT_MIB_Xdsl2PMLineHist15MinTable.MT_MIB_xdsl2PMLHist15MFecs)    // 4
#define xdsl2PMLHist15MEs xstr(MT_MIB_XdslGroup.MT_MIB_Xdsl2PMLineHist15MinTable.MT_MIB_xdsl2PMLHist15MEs)    // 5
#define xdsl2PMLHist15MSes xstr(MT_MIB_XdslGroup.MT_MIB_Xdsl2PMLineHist15MinTable.MT_MIB_xdsl2PMLHist15MSes)    // 6
#define xdsl2PMLHist15MLoss xstr(MT_MIB_XdslGroup.MT_MIB_Xdsl2PMLineHist15MinTable.MT_MIB_xdsl2PMLHist15MLoss)    // 7
#define xdsl2PMLHist15MUas xstr(MT_MIB_XdslGroup.MT_MIB_Xdsl2PMLineHist15MinTable.MT_MIB_xdsl2PMLHist15MUas)    // 8
#define xdsl2PMLHist15MValidInterval xstr(MT_MIB_XdslGroup.MT_MIB_Xdsl2PMLineHist15MinTable.MT_MIB_xdsl2PMLHist15MValidInterval)    // 9

// %Xdsl2PMLineHist1DayTable%
#define xdsl2PMLHist1DUnit xstr(MT_MIB_XdslGroup.MT_MIB_Xdsl2PMLineHist1DayTable.MT_MIB_xdsl2PMLHist1DUnit)    // 1
#define xdsl2PMLHist1DInterval xstr(MT_MIB_XdslGroup.MT_MIB_Xdsl2PMLineHist1DayTable.MT_MIB_xdsl2PMLHist1DInterval)    // 2
#define xdsl2PMLHist1DMonitoredTime xstr(MT_MIB_XdslGroup.MT_MIB_Xdsl2PMLineHist1DayTable.MT_MIB_xdsl2PMLHist1DMonitoredTime)    // 3
#define xdsl2PMLHist1DFecs xstr(MT_MIB_XdslGroup.MT_MIB_Xdsl2PMLineHist1DayTable.MT_MIB_xdsl2PMLHist1DFecs)    // 4
#define xdsl2PMLHist1DEs xstr(MT_MIB_XdslGroup.MT_MIB_Xdsl2PMLineHist1DayTable.MT_MIB_xdsl2PMLHist1DEs)    // 5
#define xdsl2PMLHist1DSes xstr(MT_MIB_XdslGroup.MT_MIB_Xdsl2PMLineHist1DayTable.MT_MIB_xdsl2PMLHist1DSes)    // 6
#define xdsl2PMLHist1DLoss xstr(MT_MIB_XdslGroup.MT_MIB_Xdsl2PMLineHist1DayTable.MT_MIB_xdsl2PMLHist1DLoss)    // 7
#define xdsl2PMLHist1DUas xstr(MT_MIB_XdslGroup.MT_MIB_Xdsl2PMLineHist1DayTable.MT_MIB_xdsl2PMLHist1DUas)    // 8
#define xdsl2PMLHist1DValidInterval xstr(MT_MIB_XdslGroup.MT_MIB_Xdsl2PMLineHist1DayTable.MT_MIB_xdsl2PMLHist1DValidInterval)    // 9

// %Xdsl2PMLineInitHist15MinTable%
#define xdsl2PMLHistInit15MInterval xstr(MT_MIB_XdslGroup.MT_MIB_Xdsl2PMLineInitHist15MinTable.MT_MIB_xdsl2PMLHistInit15MInterval)    // 1
#define xdsl2PMLHistInit15MMonitoredTime xstr(MT_MIB_XdslGroup.MT_MIB_Xdsl2PMLineInitHist15MinTable.MT_MIB_xdsl2PMLHistInit15MMonitoredTime)    // 2
#define xdsl2PMLHistInit15MFullInits xstr(MT_MIB_XdslGroup.MT_MIB_Xdsl2PMLineInitHist15MinTable.MT_MIB_xdsl2PMLHistInit15MFullInits)    // 3
#define xdsl2PMLHistInit15MFailedFullInits xstr(MT_MIB_XdslGroup.MT_MIB_Xdsl2PMLineInitHist15MinTable.MT_MIB_xdsl2PMLHistInit15MFailedFullInits)    // 4
#define xdsl2PMLHistInit15MShortInits xstr(MT_MIB_XdslGroup.MT_MIB_Xdsl2PMLineInitHist15MinTable.MT_MIB_xdsl2PMLHistInit15MShortInits)    // 5
#define xdsl2PMLHistInit15MFailedShortInits xstr(MT_MIB_XdslGroup.MT_MIB_Xdsl2PMLineInitHist15MinTable.MT_MIB_xdsl2PMLHistInit15MFailedShortInits)    // 6
#define xdsl2PMLHistInit15MValidInterval xstr(MT_MIB_XdslGroup.MT_MIB_Xdsl2PMLineInitHist15MinTable.MT_MIB_xdsl2PMLHistInit15MValidInterval)    // 7

// %Xdsl2PMLineInitHist1DayTable%
#define xdsl2PMLHistInit1DInterval xstr(MT_MIB_XdslGroup.MT_MIB_Xdsl2PMLineInitHist1DayTable.MT_MIB_xdsl2PMLHistInit1DInterval)    // 1
#define xdsl2PMLHistInit1DMonitoredTime xstr(MT_MIB_XdslGroup.MT_MIB_Xdsl2PMLineInitHist1DayTable.MT_MIB_xdsl2PMLHistInit1DMonitoredTime)    // 2
#define xdsl2PMLHistInit1DFullInits xstr(MT_MIB_XdslGroup.MT_MIB_Xdsl2PMLineInitHist1DayTable.MT_MIB_xdsl2PMLHistInit1DFullInits)    // 3
#define xdsl2PMLHistInit1DFailedFullInits xstr(MT_MIB_XdslGroup.MT_MIB_Xdsl2PMLineInitHist1DayTable.MT_MIB_xdsl2PMLHistInit1DFailedFullInits)    // 4
#define xdsl2PMLHistInit1DShortInits xstr(MT_MIB_XdslGroup.MT_MIB_Xdsl2PMLineInitHist1DayTable.MT_MIB_xdsl2PMLHistInit1DShortInits)    // 5
#define xdsl2PMLHistInit1DFailedShortInits xstr(MT_MIB_XdslGroup.MT_MIB_Xdsl2PMLineInitHist1DayTable.MT_MIB_xdsl2PMLHistInit1DFailedShortInits)    // 6
#define xdsl2PMLHistInit1DValidInterval xstr(MT_MIB_XdslGroup.MT_MIB_Xdsl2PMLineInitHist1DayTable.MT_MIB_xdsl2PMLHistInit1DValidInterval)    // 7

// %Xdsl2PMChCurrTable%
#define xdsl2PMChCurrUnit xstr(MT_MIB_XdslGroup.MT_MIB_Xdsl2PMChCurrTable.MT_MIB_xdsl2PMChCurrUnit)    // 1
#define xdsl2PMChCurr15MValidIntervals xstr(MT_MIB_XdslGroup.MT_MIB_Xdsl2PMChCurrTable.MT_MIB_xdsl2PMChCurr15MValidIntervals)    // 2
#define xdsl2PMChCurr15MInvalidIntervals xstr(MT_MIB_XdslGroup.MT_MIB_Xdsl2PMChCurrTable.MT_MIB_xdsl2PMChCurr15MInvalidIntervals)    // 3
#define xdsl2PMChCurr15MTimeElapsed xstr(MT_MIB_XdslGroup.MT_MIB_Xdsl2PMChCurrTable.MT_MIB_xdsl2PMChCurr15MTimeElapsed)    // 4
#define xdsl2PMChCurr15MCodingViolations xstr(MT_MIB_XdslGroup.MT_MIB_Xdsl2PMChCurrTable.MT_MIB_xdsl2PMChCurr15MCodingViolations)
#define xdsl2PMChCurr15MCorrectedBlocks xstr(MT_MIB_XdslGroup.MT_MIB_Xdsl2PMChCurrTable.MT_MIB_xdsl2PMChCurr15MCorrectedBlocks)
#define xdsl2PMChCurr1DayValidIntervals xstr(MT_MIB_XdslGroup.MT_MIB_Xdsl2PMChCurrTable.MT_MIB_xdsl2PMChCurr1DayValidIntervals)    // 7
#define xdsl2PMChCurr1DayInvalidIntervals xstr(MT_MIB_XdslGroup.MT_MIB_Xdsl2PMChCurrTable.MT_MIB_xdsl2PMChCurr1DayInvalidIntervals)    // 8
#define xdsl2PMChCurr1DayTimeElapsed xstr(MT_MIB_XdslGroup.MT_MIB_Xdsl2PMChCurrTable.MT_MIB_xdsl2PMChCurr1DayTimeElapsed)    // 9
#define xdsl2PMChCurr1DayCodingViolations xstr(MT_MIB_XdslGroup.MT_MIB_Xdsl2PMChCurrTable.MT_MIB_xdsl2PMChCurr1DayCodingViolations)
#define xdsl2PMChCurr1DayCorrectedBlocks xstr(MT_MIB_XdslGroup.MT_MIB_Xdsl2PMChCurrTable.MT_MIB_xdsl2PMChCurr1DayCorrectedBlocks)

#define xdsl2PMChCurr15MCodingViolations1 xstr(MT_MIB_XdslGroup.MT_MIB_Xdsl2PMChCurrTable.MT_MIB_xdsl2PMChCurr15MCodingViolations.2)
#define xdsl2PMChCurr15MCorrectedBlocks1 xstr(MT_MIB_XdslGroup.MT_MIB_Xdsl2PMChCurrTable.MT_MIB_xdsl2PMChCurr15MCorrectedBlocks.2)
#define xdsl2PMChCurr1DayCodingViolations1 xstr(MT_MIB_XdslGroup.MT_MIB_Xdsl2PMChCurrTable.MT_MIB_xdsl2PMChCurr1DayCodingViolations.2)
#define xdsl2PMChCurr1DayCorrectedBlocks1 xstr(MT_MIB_XdslGroup.MT_MIB_Xdsl2PMChCurrTable.MT_MIB_xdsl2PMChCurr1DayCorrectedBlocks.2)

#define xdsl2PMChCurr15MCodingViolations2 xstr(MT_MIB_XdslGroup.MT_MIB_Xdsl2PMChCurrTable.MT_MIB_xdsl2PMChCurr15MCodingViolations.3)
#define xdsl2PMChCurr15MCorrectedBlocks2 xstr(MT_MIB_XdslGroup.MT_MIB_Xdsl2PMChCurrTable.MT_MIB_xdsl2PMChCurr15MCorrectedBlocks.3)
#define xdsl2PMChCurr1DayCodingViolations2 xstr(MT_MIB_XdslGroup.MT_MIB_Xdsl2PMChCurrTable.MT_MIB_xdsl2PMChCurr1DayCodingViolations.3)
#define xdsl2PMChCurr1DayCorrectedBlocks2 xstr(MT_MIB_XdslGroup.MT_MIB_Xdsl2PMChCurrTable.MT_MIB_xdsl2PMChCurr1DayCorrectedBlocks.3)

// %Xdsl2PMChHist15MinTable%
#define xdsl2PMChHist15MUnit xstr(MT_MIB_XdslGroup.MT_MIB_Xdsl2PMChHist15MinTable.MT_MIB_xdsl2PMChHist15MUnit)    // 1
#define xdsl2PMChHist15MInterval xstr(MT_MIB_XdslGroup.MT_MIB_Xdsl2PMChHist15MinTable.MT_MIB_xdsl2PMChHist15MInterval)    // 2
#define xdsl2PMChHist15MMonitoredTime xstr(MT_MIB_XdslGroup.MT_MIB_Xdsl2PMChHist15MinTable.MT_MIB_xdsl2PMChHist15MMonitoredTime)    // 3
#define xdsl2PMChHist15MCodingViolations xstr(MT_MIB_XdslGroup.MT_MIB_Xdsl2PMChHist15MinTable.MT_MIB_xdsl2PMChHist15MCodingViolations)    // 4
#define xdsl2PMChHist15MCorrectedBlocks xstr(MT_MIB_XdslGroup.MT_MIB_Xdsl2PMChHist15MinTable.MT_MIB_xdsl2PMChHist15MCorrectedBlocks)    // 5
#define xdsl2PMChHist15MValidInterval xstr(MT_MIB_XdslGroup.MT_MIB_Xdsl2PMChHist15MinTable.MT_MIB_xdsl2PMChHist15MValidInterval)    // 6

// %Xdsl2PMChHist1DTable%
#define xdsl2PMChHist1DUnit xstr(MT_MIB_XdslGroup.MT_MIB_Xdsl2PMChHist1DTable.MT_MIB_xdsl2PMChHist1DUnit)    // 1
#define xdsl2PMChHist1DInterval xstr(MT_MIB_XdslGroup.MT_MIB_Xdsl2PMChHist1DTable.MT_MIB_xdsl2PMChHist1DInterval)    // 2
#define xdsl2PMChHist1DMonitoredTime xstr(MT_MIB_XdslGroup.MT_MIB_Xdsl2PMChHist1DTable.MT_MIB_xdsl2PMChHist1DMonitoredTime)    // 3
#define xdsl2PMChHist1DCodingViolations xstr(MT_MIB_XdslGroup.MT_MIB_Xdsl2PMChHist1DTable.MT_MIB_xdsl2PMChHist1DCodingViolations)    // 4
#define xdsl2PMChHist1DCorrectedBlocks xstr(MT_MIB_XdslGroup.MT_MIB_Xdsl2PMChHist1DTable.MT_MIB_xdsl2PMChHist1DCorrectedBlocks)    // 5
#define xdsl2PMChHist1DValidInterval xstr(MT_MIB_XdslGroup.MT_MIB_Xdsl2PMChHist1DTable.MT_MIB_xdsl2PMChHist1DValidInterval)    // 6

// %Xdsl2LineConfProfTable%
#define xdsl2LConfProfVdsl2CarMask xstr(MT_MIB_XdslGroup.MT_MIB_Xdsl2LineConfProfTable.MT_MIB_xdsl2LConfProfVdsl2CarMask)//4
#define xdsl2LConfProfRfiBands xstr(MT_MIB_XdslGroup.MT_MIB_Xdsl2LineConfProfTable.MT_MIB_xdsl2LConfProfRfiBands)//5
#define xdsl2LConfProfRaModeDs xstr(MT_MIB_XdslGroup.MT_MIB_Xdsl2LineConfProfTable.MT_MIB_xdsl2LConfProfRaModeDs)//6
#define xdsl2LConfProfRaModeUs xstr(MT_MIB_XdslGroup.MT_MIB_Xdsl2LineConfProfTable.MT_MIB_xdsl2LConfProfRaModeUs)//7
#define xdsl2LConfProfRaUsNrmDs xstr(MT_MIB_XdslGroup.MT_MIB_Xdsl2LineConfProfTable.MT_MIB_xdsl2LConfProfRaUsNrmDs)//8
#define xdsl2LConfProfRaUsNrmUs xstr(MT_MIB_XdslGroup.MT_MIB_Xdsl2LineConfProfTable.MT_MIB_xdsl2LConfProfRaUsNrmUs)//9
#define xdsl2LConfProfRaUsTimeDs xstr(MT_MIB_XdslGroup.MT_MIB_Xdsl2LineConfProfTable.MT_MIB_xdsl2LConfProfRaUsTimeDs)//10
#define xdsl2LConfProfRaUsTimeUs xstr(MT_MIB_XdslGroup.MT_MIB_Xdsl2LineConfProfTable.MT_MIB_xdsl2LConfProfRaUsTimeUs)//11
#define xdsl2LConfProfRaDsNrmDs xstr(MT_MIB_XdslGroup.MT_MIB_Xdsl2LineConfProfTable.MT_MIB_xdsl2LConfProfRaDsNrmDs)//12
#define xdsl2LConfProfRaDsNrmUs xstr(MT_MIB_XdslGroup.MT_MIB_Xdsl2LineConfProfTable.MT_MIB_xdsl2LConfProfRaDsNrmUs)//13
#define xdsl2LConfProfRaDsTimeDs xstr(MT_MIB_XdslGroup.MT_MIB_Xdsl2LineConfProfTable.MT_MIB_xdsl2LConfProfRaDsTimeDs)//14
#define xdsl2LConfProfRaDsTimeUs xstr(MT_MIB_XdslGroup.MT_MIB_Xdsl2LineConfProfTable.MT_MIB_xdsl2LConfProfRaDsTimeUs)//15
#define xdsl2LConfProfTargetSnrmDs xstr(MT_MIB_XdslGroup.MT_MIB_Xdsl2LineConfProfTable.MT_MIB_xdsl2LConfProfTargetSnrmDs)//16
#define xdsl2LConfProfTargetSnrmUs xstr(MT_MIB_XdslGroup.MT_MIB_Xdsl2LineConfProfTable.MT_MIB_xdsl2LConfProfTargetSnrmUs)//17
#define xdsl2LConfProfMaxSnrmDs xstr(MT_MIB_XdslGroup.MT_MIB_Xdsl2LineConfProfTable.MT_MIB_xdsl2LConfProfMaxSnrmDs)//18
#define xdsl2LConfProfMaxSnrmUs xstr(MT_MIB_XdslGroup.MT_MIB_Xdsl2LineConfProfTable.MT_MIB_xdsl2LConfProfMaxSnrmUs)//19
#define xdsl2LConfProfMinSnrmDs xstr(MT_MIB_XdslGroup.MT_MIB_Xdsl2LineConfProfTable.MT_MIB_xdsl2LConfProfMinSnrmDs)//20
#define xdsl2LConfProfMinSnrmUs xstr(MT_MIB_XdslGroup.MT_MIB_Xdsl2LineConfProfTable.MT_MIB_xdsl2LConfProfMinSnrmUs)//21
#define xdsl2LConfProfSnrModeDs xstr(MT_MIB_XdslGroup.MT_MIB_Xdsl2LineConfProfTable.MT_MIB_xdsl2LConfProfSnrModeDs)//25
#define xdsl2LConfProfSnrModeUs xstr(MT_MIB_XdslGroup.MT_MIB_Xdsl2LineConfProfTable.MT_MIB_xdsl2LConfProfSnrModeUs)//26
#define xdsl2LConfProfTxRefVnDs xstr(MT_MIB_XdslGroup.MT_MIB_Xdsl2LineConfProfTable.MT_MIB_xdsl2LConfProfTxRefVnDs)    // 27
#define xdsl2LConfProfTxRefVnUs xstr(MT_MIB_XdslGroup.MT_MIB_Xdsl2LineConfProfTable.MT_MIB_xdsl2LConfProfTxRefVnUs)    // 28
#define xdsl2LConfProfProfiles xstr(MT_MIB_XdslGroup.MT_MIB_Xdsl2LineConfProfTable.MT_MIB_xdsl2LConfProfProfiles)//35
#define xdsl2LConfProfDpboEPsd xstr(MT_MIB_XdslGroup.MT_MIB_Xdsl2LineConfProfTable.MT_MIB_xdsl2LConfProfDpboEPsd)//36
#define xdsl2LConfProfDpboEsEL xstr(MT_MIB_XdslGroup.MT_MIB_Xdsl2LineConfProfTable.MT_MIB_xdsl2LConfProfDpboEsEL)//37
#define xdsl2LConfProfDpboEsCableModelA xstr(MT_MIB_XdslGroup.MT_MIB_Xdsl2LineConfProfTable.MT_MIB_xdsl2LConfProfDpboEsCableModelA)//38
#define xdsl2LConfProfDpboEsCableModelB xstr(MT_MIB_XdslGroup.MT_MIB_Xdsl2LineConfProfTable.MT_MIB_xdsl2LConfProfDpboEsCableModelB)//39
#define xdsl2LConfProfDpboEsCableModelC xstr(MT_MIB_XdslGroup.MT_MIB_Xdsl2LineConfProfTable.MT_MIB_xdsl2LConfProfDpboEsCableModelC)//40

#define xdsl2LConfProfDpboMus xstr(MT_MIB_XdslGroup.MT_MIB_Xdsl2LineConfProfTable.MT_MIB_xdsl2LConfProfDpboMus) //41
#define xdsl2LConfProfDpboFMin xstr(MT_MIB_XdslGroup.MT_MIB_Xdsl2LineConfProfTable.MT_MIB_xdsl2LConfProfDpboFMin) //42
#define xdsl2LConfProfDpboFMax xstr(MT_MIB_XdslGroup.MT_MIB_Xdsl2LineConfProfTable.MT_MIB_xdsl2LConfProfDpboFMax) //43
#define xdsl2LConfProfUpboKL xstr(MT_MIB_XdslGroup.MT_MIB_Xdsl2LineConfProfTable.MT_MIB_xdsl2LConfProfUpboKL) //44
#define xdsl2LConfProfUpboKLF xstr(MT_MIB_XdslGroup.MT_MIB_Xdsl2LineConfProfTable.MT_MIB_xdsl2LConfProfUpboKLF) //45
#define xdsl2LConfProfUs0Mask xstr(MT_MIB_XdslGroup.MT_MIB_Xdsl2LineConfProfTable.MT_MIB_xdsl2LConfProfUs0Mask)    // 46

// %Xdsl2ChConfProfileTable%
#define xdsl2ChConfProfMinDataRateDs xstr(MT_MIB_XdslGroup.MT_MIB_Xdsl2ChConfProfileTable.MT_MIB_xdsl2ChConfProfMinDataRateDs)//2
#define xdsl2ChConfProfMinDataRateDs1 xstr(MT_MIB_XdslGroup.MT_MIB_Xdsl2ChConfProfileTable.MT_MIB_xdsl2ChConfProfMinDataRateDs.2)//2
#define xdsl2ChConfProfMinDataRateUs xstr(MT_MIB_XdslGroup.MT_MIB_Xdsl2ChConfProfileTable.MT_MIB_xdsl2ChConfProfMinDataRateUs)//3
#define xdsl2ChConfProfMinDataRateUs1 xstr(MT_MIB_XdslGroup.MT_MIB_Xdsl2ChConfProfileTable.MT_MIB_xdsl2ChConfProfMinDataRateUs.2)//3
#define xdsl2ChConfProfMaxDataRateDs xstr(MT_MIB_XdslGroup.MT_MIB_Xdsl2ChConfProfileTable.MT_MIB_xdsl2ChConfProfMaxDataRateDs)//6
#define xdsl2ChConfProfMaxDataRateDs1 xstr(MT_MIB_XdslGroup.MT_MIB_Xdsl2ChConfProfileTable.MT_MIB_xdsl2ChConfProfMaxDataRateDs.2)//6
#define xdsl2ChConfProfMaxDataRateUs xstr(MT_MIB_XdslGroup.MT_MIB_Xdsl2ChConfProfileTable.MT_MIB_xdsl2ChConfProfMaxDataRateUs)//7
#define xdsl2ChConfProfMaxDataRateUs1 xstr(MT_MIB_XdslGroup.MT_MIB_Xdsl2ChConfProfileTable.MT_MIB_xdsl2ChConfProfMaxDataRateUs.2)//7
#define xdsl2ChConfProfMaxDelayDs xstr(MT_MIB_XdslGroup.MT_MIB_Xdsl2ChConfProfileTable.MT_MIB_xdsl2ChConfProfMaxDelayDs)//10
#define xdsl2ChConfProfMaxDelayDs1 xstr(MT_MIB_XdslGroup.MT_MIB_Xdsl2ChConfProfileTable.MT_MIB_xdsl2ChConfProfMaxDelayDs.2)//10
#define xdsl2ChConfProfMaxDelayUs xstr(MT_MIB_XdslGroup.MT_MIB_Xdsl2ChConfProfileTable.MT_MIB_xdsl2ChConfProfMaxDelayUs)//11
#define xdsl2ChConfProfMaxDelayUs1 xstr(MT_MIB_XdslGroup.MT_MIB_Xdsl2ChConfProfileTable.MT_MIB_xdsl2ChConfProfMaxDelayUs.2)//11
#define xdsl2ChConfProfMinProtectionDs xstr(MT_MIB_XdslGroup.MT_MIB_Xdsl2ChConfProfileTable.MT_MIB_xdsl2ChConfProfMinProtectionDs)//12
#define xdsl2ChConfProfMinProtectionDs1 xstr(MT_MIB_XdslGroup.MT_MIB_Xdsl2ChConfProfileTable.MT_MIB_xdsl2ChConfProfMinProtectionDs.2)//12
#define xdsl2ChConfProfMinProtectionUs xstr(MT_MIB_XdslGroup.MT_MIB_Xdsl2ChConfProfileTable.MT_MIB_xdsl2ChConfProfMinProtectionUs)//13
#define xdsl2ChConfProfMinProtectionUs1 xstr(MT_MIB_XdslGroup.MT_MIB_Xdsl2ChConfProfileTable.MT_MIB_xdsl2ChConfProfMinProtectionUs.2)//13
#define xdsl2ChConfProfMinProtection8Ds xstr(MT_MIB_XdslGroup.MT_MIB_Xdsl2ChConfProfileTable.MT_MIB_xdsl2ChConfProfMinProtection8Ds)//14
#define xdsl2ChConfProfMinProtection8Ds1 xstr(MT_MIB_XdslGroup.MT_MIB_Xdsl2ChConfProfileTable.MT_MIB_xdsl2ChConfProfMinProtection8Ds.2)//14
#define xdsl2ChConfProfMinProtection8Us xstr(MT_MIB_XdslGroup.MT_MIB_Xdsl2ChConfProfileTable.MT_MIB_xdsl2ChConfProfMinProtection8Us)//15
#define xdsl2ChConfProfMinProtection8Us1 xstr(MT_MIB_XdslGroup.MT_MIB_Xdsl2ChConfProfileTable.MT_MIB_xdsl2ChConfProfMinProtection8Us.2)//15

// %Xdsl2LineConfProfModeSpecTable%
#define xdsl2LConfProfMaxNomPsdDs xstr(MT_MIB_XdslGroup.MT_MIB_Xdsl2LineConfProfModeSpecTable.MT_MIB_xdsl2LConfProfMaxNomPsdDs)//2
#define xdsl2LConfProfMaxNomPsdUs xstr(MT_MIB_XdslGroup.MT_MIB_Xdsl2LineConfProfModeSpecTable.MT_MIB_xdsl2LConfProfMaxNomPsdUs)//3
#define xdsl2LConfProfMaxNomAtpDs xstr(MT_MIB_XdslGroup.MT_MIB_Xdsl2LineConfProfModeSpecTable.MT_MIB_xdsl2LConfProfMaxNomAtpDs)//4
#define xdsl2LConfProfMaxNomAtpUs xstr(MT_MIB_XdslGroup.MT_MIB_Xdsl2LineConfProfModeSpecTable.MT_MIB_xdsl2LConfProfMaxNomAtpUs)//5
#define xdsl2LConfProfPsdMaskDs xstr(MT_MIB_XdslGroup.MT_MIB_Xdsl2LineConfProfModeSpecTable.MT_MIB_xdsl2LConfProfPsdMaskDs)//7
#define xdsl2LConfProfPsdMaskUs xstr(MT_MIB_XdslGroup.MT_MIB_Xdsl2LineConfProfModeSpecTable.MT_MIB_xdsl2LConfProfPsdMaskUs)//8
#define xdsl2LConfProfLimitMask xstr(MT_MIB_XdslGroup.MT_MIB_Xdsl2LineConfProfModeSpecTable.MT_MIB_xdsl2LConfProfLimitMask)    // 11
#define xdsl2LConfProfUs0Disable xstr(MT_MIB_XdslGroup.MT_MIB_Xdsl2LineConfProfModeSpecTable.MT_MIB_xdsl2LConfProfUs0Disable)    // 12

// %Xdsl2LineConfProfModeSpecBandUsTable%
#define xdsl2LConfProfUpboPsdA0 xstr(MT_MIB_XdslGroup.MT_MIB_Xdsl2LineConfProfModeSpecBandUsTable.MT_MIB_xdsl2LConfProfUpboPsdA.1)//2
#define xdsl2LConfProfUpboPsdA1 xstr(MT_MIB_XdslGroup.MT_MIB_Xdsl2LineConfProfModeSpecBandUsTable.MT_MIB_xdsl2LConfProfUpboPsdA.2)
#define xdsl2LConfProfUpboPsdA2 xstr(MT_MIB_XdslGroup.MT_MIB_Xdsl2LineConfProfModeSpecBandUsTable.MT_MIB_xdsl2LConfProfUpboPsdA.3)
#define xdsl2LConfProfUpboPsdA3 xstr(MT_MIB_XdslGroup.MT_MIB_Xdsl2LineConfProfModeSpecBandUsTable.MT_MIB_xdsl2LConfProfUpboPsdA.4)
#define xdsl2LConfProfUpboPsdB0 xstr(MT_MIB_XdslGroup.MT_MIB_Xdsl2LineConfProfModeSpecBandUsTable.MT_MIB_xdsl2LConfProfUpboPsdB.1)//3
#define xdsl2LConfProfUpboPsdB1 xstr(MT_MIB_XdslGroup.MT_MIB_Xdsl2LineConfProfModeSpecBandUsTable.MT_MIB_xdsl2LConfProfUpboPsdB.2)
#define xdsl2LConfProfUpboPsdB2 xstr(MT_MIB_XdslGroup.MT_MIB_Xdsl2LineConfProfModeSpecBandUsTable.MT_MIB_xdsl2LConfProfUpboPsdB.3)
#define xdsl2LConfProfUpboPsdB3 xstr(MT_MIB_XdslGroup.MT_MIB_Xdsl2LineConfProfModeSpecBandUsTable.MT_MIB_xdsl2LConfProfUpboPsdB.4)
#define xdsl2LConfProfBandUpboKL0 xstr(MT_MIB_XdslGroup.MT_MIB_Xdsl2LineConfProfModeSpecBandUsTable.MT_MIB_xdsl2LConfProfBandUpboKL.1)//4
#define xdsl2LConfProfBandUpboKL1 xstr(MT_MIB_XdslGroup.MT_MIB_Xdsl2LineConfProfModeSpecBandUsTable.MT_MIB_xdsl2LConfProfBandUpboKL.2)
#define xdsl2LConfProfBandUpboKL2 xstr(MT_MIB_XdslGroup.MT_MIB_Xdsl2LineConfProfModeSpecBandUsTable.MT_MIB_xdsl2LConfProfBandUpboKL.3)
#define xdsl2LConfProfBandUpboKL3 xstr(MT_MIB_XdslGroup.MT_MIB_Xdsl2LineConfProfModeSpecBandUsTable.MT_MIB_xdsl2LConfProfBandUpboKL.4)

// %XdslGhsConfTable%
#define xdslGhsConfOtCarrierSet xstr(MT_MIB_XdslGhsGroup.MT_MIB_XdslGhsConfTable.MT_MIB_xdslGhsConfOtCarrierSet) //1
#define xdslGhsConfRtCarrierSet xstr(MT_MIB_XdslGhsGroup.MT_MIB_XdslGhsConfTable.MT_MIB_xdslGhsConfRtCarrierSet) //2
#define xdslGhsOtVendorId xstr(MT_MIB_XdslGhsGroup.MT_MIB_XdslGhsTable.MT_MIB_xdslGhsOtVendorId)
#define xdslGhsStdSPar1 xstr(MT_MIB_XdslGhsGroup.MT_MIB_XdslGhsTable.MT_MIB_xdslGhsStdSPar1)
#define xdslGhsConfAutomodeLength xstr(MT_MIB_XdslGhsGroup.MT_MIB_XdslGhsConfTable.MT_MIB_xdslGhsConfAutomodeLength) //93

// %XdslMetanoiaTable%
#define xdslFirmwareVer xstr(MT_MIB_XdslMetanoiaGroup.MT_MIB_XdslMetanoiaTable.MT_MIB_xdslFirmwareVer)    //1
#define xdslFirmwareDate xstr(MT_MIB_XdslMetanoiaGroup.MT_MIB_XdslMetanoiaTable.MT_MIB_xdslFirmwareDate)    //2
#define xdslFirmwareTime xstr(MT_MIB_XdslMetanoiaGroup.MT_MIB_XdslMetanoiaTable.MT_MIB_xdslFirmwareTime)    //3
#define xdslBoardType xstr(MT_MIB_XdslMetanoiaGroup.MT_MIB_XdslMetanoiaTable.MT_MIB_xdslBoardType)    //4
#define xdslTerminal xstr(MT_MIB_XdslMetanoiaGroup.MT_MIB_XdslMetanoiaTable.MT_MIB_xdslTerminal)   //5
#define xdslFifteenMinCnt xstr(MT_MIB_XdslMetanoiaGroup.MT_MIB_XdslMetanoiaTable.MT_MIB_xdslFifteenMinCnt)   //13
#define xdslOneDayCnt xstr(MT_MIB_XdslMetanoiaGroup.MT_MIB_XdslMetanoiaTable.MT_MIB_xdslOneDayCnt)   //14
#define xdslTwConfig xstr(MT_MIB_XdslMetanoiaGroup.MT_MIB_XdslMetanoiaTable.MT_MIB_xdslTwConfig)   //9
#define xdslHostCommand xstr(MT_MIB_XdslMetanoiaGroup.MT_MIB_XdslMetanoiaTable.MT_MIB_xdslHostCommand)   //7
#define xdslHostCommandStatus xstr(MT_MIB_XdslMetanoiaGroup.MT_MIB_XdslMetanoiaTable.MT_MIB_xdslHostCommandStatus)   //8
#define CfgM2Qosfr xstr(MT_MIB_XdslMetanoiaGroup.MT_MIB_XdslMetanoiaTable.MT_MIB_CfgM2Qosfr)   //48
#define xdslLineDiagTrn xstr(MT_MIB_XdslMetanoiaGroup.MT_MIB_XdslMetanoiaTable.MT_MIB_xdslLineDiagTrn)   //57
#define xdslLineDiagTrnD xstr(MT_MIB_XdslMetanoiaGroup.MT_MIB_XdslMetanoiaTable.MT_MIB_xdslLineDiagTrnD)   //58
#define xdslLineDiagTrnDD xstr(MT_MIB_XdslMetanoiaGroup.MT_MIB_XdslMetanoiaTable.MT_MIB_xdslLineDiagTrnDD)   //59
#define ModemErrBuf xstr(MT_MIB_XdslMetanoiaGroup.MT_MIB_XdslMetanoiaTable.MT_MIB_ModemErrBuf)   //136
#define CfgSarSegProcP0 xstr(MT_MIB_XdslMetanoiaGroup.MT_MIB_XdslMetanoiaTable.MT_MIB_CfgSarSegProcP0)   //147
#define CfgSarSegMapperP0 xstr(MT_MIB_XdslMetanoiaGroup.MT_MIB_XdslMetanoiaTable.MT_MIB_CfgSarSegMapperP0)   //155
#define CfgSarSegTransP0 xstr(MT_MIB_XdslMetanoiaGroup.MT_MIB_XdslMetanoiaTable.MT_MIB_CfgSarSegTransP0)   //163
#define CfgSarReamMapperP0 xstr(MT_MIB_XdslMetanoiaGroup.MT_MIB_XdslMetanoiaTable.MT_MIB_CfgSarReamMapperP0)   //171
#define CfgSarReamProcP0 xstr(MT_MIB_XdslMetanoiaGroup.MT_MIB_XdslMetanoiaTable.MT_MIB_CfgSarReamProcP0)   //179
#define CfgSarfr xstr(MT_MIB_XdslMetanoiaGroup.MT_MIB_XdslMetanoiaTable.MT_MIB_CfgSarfr)   //215
#define xdslMetanoiaAtmService0 xstr(MT_MIB_XdslMetanoiaGroup.MT_MIB_XdslMetanoiaTable.MT_MIB_xdslMetanoiaAtmService0)   //216
#define xdslMetanoiaAtmTfcParam0 xstr(MT_MIB_XdslMetanoiaGroup.MT_MIB_XdslMetanoiaTable.MT_MIB_xdslMetanoiaAtmTfcParam0)   //224

// %XdslMetanoia2Table%
#define xdslMetanoiaOtCurrLineRate xstr(MT_MIB_XdslMetanoia2Group.MT_MIB_XdslMetanoia2Table.MT_MIB_xdslMetanoiaOtCurrLineRate)  //8
#define xdslMetanoiaOtPhysCurrStatus xstr(MT_MIB_XdslMetanoia2Group.MT_MIB_XdslMetanoia2Table.MT_MIB_xdslMetanoiaOtPhysCurrStatus)  //10
#define xdslMetanoiaOtRxPktCntr xstr(MT_MIB_XdslMetanoia2Group.MT_MIB_XdslMetanoia2Table.MT_MIB_xdslMetanoiaOtRxPktCntr)   //11
#define xdslMetanoiaOtTxPktCntr xstr(MT_MIB_XdslMetanoia2Group.MT_MIB_XdslMetanoia2Table.MT_MIB_xdslMetanoiaOtTxPktCntr)   //12
#define xdslMetanoiaOtAmend xstr(MT_MIB_XdslMetanoia2Group.MT_MIB_XdslMetanoia2Table.MT_MIB_xdslMetanoiaOtAmend)   //39
#define xdslMetanoiaOtMedley0Us xstr(MT_MIB_XdslMetanoia2Group.MT_MIB_XdslMetanoia2Table.MT_MIB_xdslMetanoiaOtMedley0Us)   //45
#define xdslMetanoiaRtMedley0Ds xstr(MT_MIB_XdslMetanoia2Group.MT_MIB_XdslMetanoia2Table.MT_MIB_xdslMetanoiaOtMedley0Us.2)
#define xdslMetanoiaOtMedley1Us xstr(MT_MIB_XdslMetanoia2Group.MT_MIB_XdslMetanoia2Table.MT_MIB_xdslMetanoiaOtMedley1Us)   //46
#define xdslMetanoiaRtMedley1Ds xstr(MT_MIB_XdslMetanoia2Group.MT_MIB_XdslMetanoia2Table.MT_MIB_xdslMetanoiaOtMedley1Us.2)
#define xdslMetanoiaOtMedley2Us xstr(MT_MIB_XdslMetanoia2Group.MT_MIB_XdslMetanoia2Table.MT_MIB_xdslMetanoiaOtMedley2Us)   //47
#define xdslMetanoiaRtMedley2Ds xstr(MT_MIB_XdslMetanoia2Group.MT_MIB_XdslMetanoia2Table.MT_MIB_xdslMetanoiaOtMedley2Us.2)
#define xdslMetanoiaOtMedley3Us xstr(MT_MIB_XdslMetanoia2Group.MT_MIB_XdslMetanoia2Table.MT_MIB_xdslMetanoiaOtMedley3Us)   //48
#define xdslMetanoiaRtMedley3Ds xstr(MT_MIB_XdslMetanoia2Group.MT_MIB_XdslMetanoia2Table.MT_MIB_xdslMetanoiaOtMedley3Us.2)
#define xdslMetanoiaOtMedley4Us xstr(MT_MIB_XdslMetanoia2Group.MT_MIB_XdslMetanoia2Table.MT_MIB_xdslMetanoiaOtMedley4Us)   //49
#define xdslMetanoiaRtMedley4Ds xstr(MT_MIB_XdslMetanoia2Group.MT_MIB_XdslMetanoia2Table.MT_MIB_xdslMetanoiaOtMedley4Us.2)

// %XdslMetanoia3Table%
#define xdsl2MetanoiaOtCorrectedBlocks0 xstr(MT_MIB_XdslMetanoia2Group.MT_MIB_XdslMetanoia3Table.MT_MIB_xdslMetanoiaOtCorrectedBlocks0)    // 1
#define xdsl2MetanoiaOtCodingViolations0 xstr(MT_MIB_XdslMetanoia2Group.MT_MIB_XdslMetanoia3Table.MT_MIB_xdslMetanoiaOtCodingViolations0)    // 2
#define xdsl2MetanoiaOtFecs0 xstr(MT_MIB_XdslMetanoia2Group.MT_MIB_XdslMetanoia3Table.MT_MIB_xdslMetanoiaOtFecs0)    // 3
#define xdsl2MetanoiaOtEs0 xstr(MT_MIB_XdslMetanoia2Group.MT_MIB_XdslMetanoia3Table.MT_MIB_xdslMetanoiaOtEs0)    // 4
#define xdsl2MetanoiaOtSes0 xstr(MT_MIB_XdslMetanoia2Group.MT_MIB_XdslMetanoia3Table.MT_MIB_xdslMetanoiaOtSes0)    // 5
#define xdsl2MetanoiaOtLoss0 xstr(MT_MIB_XdslMetanoia2Group.MT_MIB_XdslMetanoia3Table.MT_MIB_xdslMetanoiaOtLoss0)    // 6
#define xdsl2MetanoiaOtUas0 xstr(MT_MIB_XdslMetanoia2Group.MT_MIB_XdslMetanoia3Table.MT_MIB_xdslMetanoiaOtUas0)    // 7
#define xdsl2MetanoiaOtCurrCorrectedBlocks0 xstr(MT_MIB_XdslMetanoia2Group.MT_MIB_XdslMetanoia3Table.MT_MIB_xdslMetanoiaOtCurrCorrectedBlocks0)   // 8
#define xdsl2MetanoiaOtCurrCodingViolation0 xstr(MT_MIB_XdslMetanoia2Group.MT_MIB_XdslMetanoia3Table.MT_MIB_xdslMetanoiaOtCurrCodingViolations0)   //  9
#define xdsl2MetanoiaOtCurrFecs0 xstr(MT_MIB_XdslMetanoia2Group.MT_MIB_XdslMetanoia3Table.MT_MIB_xdslMetanoiaOtCurrFecs0)   //  10
#define xdsl2MetanoiaOtCurrEs0 xstr(MT_MIB_XdslMetanoia2Group.MT_MIB_XdslMetanoia3Table.MT_MIB_xdslMetanoiaOtCurrEs0)    // 11
#define xdsl2MetanoiaOtCurrSes0 xstr(MT_MIB_XdslMetanoia2Group.MT_MIB_XdslMetanoia3Table.MT_MIB_xdslMetanoiaOtCurrSes0)   //  12
#define xdsl2MetanoiaOtCurrLoss0 xstr(MT_MIB_XdslMetanoia2Group.MT_MIB_XdslMetanoia3Table.MT_MIB_xdslMetanoiaOtCurrLoss0)   //  13
#define xdsl2MetanoiaOtCurrUas0 xstr(MT_MIB_XdslMetanoia2Group.MT_MIB_XdslMetanoia3Table.MT_MIB_xdslMetanoiaOtCurrUas0)    // 14

#define xdsl2MetanoiaOtCorrectedBlocks01 xstr(MT_MIB_XdslMetanoia2Group.MT_MIB_XdslMetanoia3Table.MT_MIB_xdslMetanoiaOtCorrectedBlocks0.2)    // 1
#define xdsl2MetanoiaOtCodingViolations01 xstr(MT_MIB_XdslMetanoia2Group.MT_MIB_XdslMetanoia3Table.MT_MIB_xdslMetanoiaOtCodingViolations0.2)    // 2
#define xdsl2MetanoiaOtFecs01 xstr(MT_MIB_XdslMetanoia2Group.MT_MIB_XdslMetanoia3Table.MT_MIB_xdslMetanoiaOtFecs0.2)    // 3
#define xdsl2MetanoiaOtEs01 xstr(MT_MIB_XdslMetanoia2Group.MT_MIB_XdslMetanoia3Table.MT_MIB_xdslMetanoiaOtEs0.2)    // 4
#define xdsl2MetanoiaOtSes01 xstr(MT_MIB_XdslMetanoia2Group.MT_MIB_XdslMetanoia3Table.MT_MIB_xdslMetanoiaOtSes0.2)    // 5
#define xdsl2MetanoiaOtLoss01 xstr(MT_MIB_XdslMetanoia2Group.MT_MIB_XdslMetanoia3Table.MT_MIB_xdslMetanoiaOtLoss0.2)    // 6
#define xdsl2MetanoiaOtUas01 xstr(MT_MIB_XdslMetanoia2Group.MT_MIB_XdslMetanoia3Table.MT_MIB_xdslMetanoiaOtUas0.2)    // 7
#define xdsl2MetanoiaOtCurrCorrectedBlocks01 xstr(MT_MIB_XdslMetanoia2Group.MT_MIB_XdslMetanoia3Table.MT_MIB_xdslMetanoiaOtCurrCorrectedBlocks0.2)   // 8
#define xdsl2MetanoiaOtCurrCodingViolation01 xstr(MT_MIB_XdslMetanoia2Group.MT_MIB_XdslMetanoia3Table.MT_MIB_xdslMetanoiaOtCurrCodingViolations0.2)   //  9
#define xdsl2MetanoiaOtCurrFecs01 xstr(MT_MIB_XdslMetanoia2Group.MT_MIB_XdslMetanoia3Table.MT_MIB_xdslMetanoiaOtCurrFecs0.2)   //  10
#define xdsl2MetanoiaOtCurrEs01 xstr(MT_MIB_XdslMetanoia2Group.MT_MIB_XdslMetanoia3Table.MT_MIB_xdslMetanoiaOtCurrEs0.2)    // 11
#define xdsl2MetanoiaOtCurrSes01 xstr(MT_MIB_XdslMetanoia2Group.MT_MIB_XdslMetanoia3Table.MT_MIB_xdslMetanoiaOtCurrSes0.2)   //  12
#define xdsl2MetanoiaOtCurrLoss01 xstr(MT_MIB_XdslMetanoia2Group.MT_MIB_XdslMetanoia3Table.MT_MIB_xdslMetanoiaOtCurrLoss0.2)   //  13
#define xdsl2MetanoiaOtCurrUas01 xstr(MT_MIB_XdslMetanoia2Group.MT_MIB_XdslMetanoia3Table.MT_MIB_xdslMetanoiaOtCurrUas0.2)    // 14

// %VmeSourceTable%
#define VmeDummyCmd xstr(MT_MIB_XdslMetanoiaGroup.MT_MIB_XdslMetanoiaTable.MT_MIB_VmeDummyCmd)   // 1
#define VmeEocCmd xstr(MT_MIB_XdslMetanoiaGroup.MT_MIB_XdslMetanoiaTable.MT_MIB_VmeEocCmd)    // 2
#define VmeNsfCmd xstr(MT_MIB_XdslMetanoiaGroup.MT_MIB_XdslMetanoiaTable.MT_MIB_VmeNsfCmd)    // 3
#define VmeDslCmd xstr(MT_MIB_XdslMetanoiaGroup.MT_MIB_XdslMetanoiaTable.MT_MIB_VmeDslCmd)    // 4
#define VmeHostCmd xstr(MT_MIB_XdslMetanoiaGroup.MT_MIB_XdslMetanoiaTable.MT_MIB_VmeHostCmd)    // 5
#define VmeNearEndCmd xstr(MT_MIB_XdslMetanoiaGroup.MT_MIB_XdslMetanoiaTable.MT_MIB_VmeNearEndCmd)    // 6
#define VmeSourceCmdDummy xstr(MT_MIB_XdslMetanoiaGroup.MT_MIB_XdslMetanoiaTable.MT_MIB_VmeSourceCmdDummy)    // 7

// %VmeCmdRegTable%
#define VmeDslCmdReg xstr(MT_MIB_XdslMetanoiaGroup.MT_MIB_XdslMetanoiaTable.MT_MIB_VmeDslCmdReg)    // 1
#define VmeHostCmdReg xstr(MT_MIB_XdslMetanoiaGroup.MT_MIB_XdslMetanoiaTable.MT_MIB_VmeHostCmdReg)    // 2
#define VmeNearCmdReg xstr(MT_MIB_XdslMetanoiaGroup.MT_MIB_XdslMetanoiaTable.MT_MIB_VmeNearCmdReg)    // 3
#define VmeNsfCmdReg xstr(MT_MIB_XdslMetanoiaGroup.MT_MIB_XdslMetanoiaTable.MT_MIB_VmeNsfCmdReg)    // 4
#define VmeRxNsfRdId xstr(MT_MIB_XdslMetanoiaGroup.MT_MIB_XdslMetanoiaTable.MT_MIB_VmeRxNsfRdId)    // 5
#define VmeOtTimeHMS xstr(MT_MIB_XdslMetanoiaGroup.MT_MIB_XdslMetanoiaTable.MT_MIB_VmeOtTimeHMS)    // 6
#define VmeRtTimeHMS xstr(MT_MIB_XdslMetanoiaGroup.MT_MIB_XdslMetanoiaTable.MT_MIB_VmeRtTimeHMS)    // 7
#define CfgParamsTempBuf xstr(MT_MIB_XdslMetanoiaGroup.MT_MIB_XdslMetanoiaTable.MT_MIB_CfgParamsTempBuf)    // 8
#define xdsl2LineStatusActAtpUs2 xstr(MT_MIB_XdslMetanoiaGroup.MT_MIB_XdslMetanoiaTable.MT_MIB_xdsl2LineStatusActAtpUs2)    // 9
#define xdsl2LineStatusActAtpDs2 xstr(MT_MIB_XdslMetanoiaGroup.MT_MIB_XdslMetanoiaTable.MT_MIB_xdsl2LineStatusActAtpDs2)    // 10


#endif /*VDSL2LOID_H_*/
