/****************************************************************************
* File:         $Workfile$
* Revision:     $Revision: 1.2 $
* Date:         $Date: 2009-05-21 09:40:22 $
*
* Overview:     
* Functions:
*
* Author:       Ian Tsao
* 
* -- Metanoia Copyright Notice --
*
* (C) Copyright 2005 Metanoia, Inc. All rights reserved.
* 
* Metanoia reserves the right to change specifications without notice. 
* Copyright 2005 Metanoia, Inc. All rights reserved. Preliminary Data-Sheet 
* indicates this product is in design and the specification may change. 
* Electrical parametrics have not been analyzed and are not specified. Do not 
* use this data sheet as a design reference document. Please contact Metanoia 
* for a current data sheet that may be used as a design reference. All 
* contents of this document are protected by copyright law and may not be 
* reproduced without the express written consent of Metanoia, Inc. Metanoia, 
* the Metanoia logo, and combinations thereof are trademarks of Metanoia, Inc. 
* Other product names used in this publication are for identification purposes 
* only and may be trademarks or registered trademarks of their respective 
* companies. The contents of this document are provided in connection with 
* Metanoia, Inc. products. Metanoia, Inc. has made best efforts to ensure that 
* the information contained herein is accurate and reliable. However, Metanoia, 
* Inc. makes no warranties, express or implied, as to the accuracy or 
* completeness of the contents of this publication and is providing this 
* publication 'as is'. Metanoia, Inc. reserves the right to make changes to 
* specifications and product descriptions at any time without notice, and to 
* discontinue or make changes to its products at any time without notice. 
* Metanoia, Inc. does not assume any liability arising out of the application 
* or use of any product or circuit, and specifically disclaims any and all 
* liability, including without limitation special, consequential, or 
* incidental damages.
* 
****************************************************************************/
/**
 * \file 
 * \brief user customized definition
 */
#ifndef _MNUSERDEF_H_
#define _MNUSERDEF_H_

/* this header must be modify by user to satify user enviroment */

#define _MN_OS_TYPE _MN_OS_LINUX

/* Compile Flag */
/**
 * Enable Debug Feature 
 * Function: 
 * 		more detail message.
 */
#define MT_DEBUG
/*
#define MN_USE_VDSL
#define MN_USE_ADSL
#define MN_USE_DEBUG
*/


/**
 * Port ID define,0-MAX_PORTS-1: normal port, MAX_PORTS: broadcast ,MAX_PORTS+1->MAX_PORTS+MT_PORT_GroupCount: group port id, 
 * 
 */

#define BOARD_HOPE 0
#define BOARD_AWARD 1

#ifdef BOARD_A2
	#define BOARD_NAME "BOARD_A2"
	// The same function in all Award
	#define AWARD
	// There's only one falcon on Award board
	#define MAX_CHIPS 1
	/// the port count in the board
	#define MAX_PORTS 1
#elif defined(BOARD_A3)
	#define BOARD_NAME "BOARD_A3"
	// The same function in all Award
	#define AWARD
	// There's only one falcon on Award board
	#define MAX_CHIPS 1
	/// the port count in the board
	#define MAX_PORTS 1
#elif defined (BOARD_A5)
	#define BOARD_NAME "BOARD_A5"
	// There's only one falcon on A5 board
	#define MAX_CHIPS 1
	/// the port count in the board
	#define MAX_PORTS 1
#elif defined (HOPE)
	#define BOARD_NAME "HOPE"
	// There're eight falcons on HOPE board
	#define MAX_CHIPS 8
	/// the port count in the board
	#define MAX_PORTS 8
#elif defined (XENOS)
	#define BOARD_NAME "XENOS"
	// There're twenty-four falcons on XENOS board
	#define MAX_CHIPS 24
	/// the port count in the board
	#define MAX_PORTS 24
#endif

#define MT_AVAILABLE_PORT	0x00ffffff

/// broadcast port id, it is the legal max port
#define MT_PORT_BroadCast MAX_PORTS
/// Config profile Max Count
#define MT_MIB_ConfMaxCount 20
/// Profile Name's Max Length,must >= sizeof(profile_name_prefix)+2+1
#define MT_MIB_ConfProfileNameMaxLength 8

/// Hardcode profile name prefix, profile name will be fix with format profile_name_prefix+xx, xx is 2 digit portid
#define MT_PROFILE_PREFIX "VDSL"

// Performance history buffer setting, if don't need history, setup it as 0
#define MT_INV_MAX15 96 ///< history of 15mins performance max interval value
#define MT_INV_MAX24 30 ///< history of 24hrs performance max interval value

// Used for CPE eoc data exchange mechanism
#define EOC_COMM_PORT 0
 
#endif //_MNUSERDEF_H_
