/****************************************************************************
* File:         $Workfile$
* Revision:     $Revision: 1.4 $
* Date:         $Date: 2010-04-13 08:04:46 $
*
* Overview:     
* Functions:
*
* Author:       Ian Tsao
* 
* -- Metanoia Copyright Notice --
*
* (C) Copyright 2005 Metanoia, Inc. All rights reserved.
* 
* Metanoia reserves the right to change specifications without notice. 
* Copyright 2005 Metanoia, Inc. All rights reserved. Preliminary Data-Sheet 
* indicates this product is in design and the specification may change. 
* Electrical parametrics have not been analyzed and are not specified. Do not 
* use this data sheet as a design reference document. Please contact Metanoia 
* for a current data sheet that may be used as a design reference. All 
* contents of this document are protected by copyright law and may not be 
* reproduced without the express written consent of Metanoia, Inc. Metanoia, 
* the Metanoia logo, and combinations thereof are trademarks of Metanoia, Inc. 
* Other product names used in this publication are for identification purposes 
* only and may be trademarks or registered trademarks of their respective 
* companies. The contents of this document are provided in connection with 
* Metanoia, Inc. products. Metanoia, Inc. has made best efforts to ensure that 
* the information contained herein is accurate and reliable. However, Metanoia, 
* Inc. makes no warranties, express or implied, as to the accuracy or 
* completeness of the contents of this publication and is providing this 
* publication 'as is'. Metanoia, Inc. reserves the right to make changes to 
* specifications and product descriptions at any time without notice, and to 
* discontinue or make changes to its products at any time without notice. 
* Metanoia, Inc. does not assume any liability arising out of the application 
* or use of any product or circuit, and specifically disclaims any and all 
* liability, including without limitation special, consequential, or 
* incidental damages.
* 
****************************************************************************/
#include "mttypes.h"
#include "mterror.h"
#include "userdef.h"
#include "if.h"
#include "debugp.h"
#include "vdsl2mib.h"


/**
 * validate paramters,we only check parameter in the interface with user.
 * \param iType
 * 		MT_PAR_*
 * \param iCond
 * 		in what condition to check the value, use 0 if there is no special condition
 * \param value
 * 		value in user view, for ex: portid( 1-24 )
 * \return
 * 	- 0 : success
 * 	- < 0 : error code 
 */
mt_ret check_param(mt_uint8 type, mt_uint8 cond, mt_uint32 value)
{
	switch(type){
		case MT_PAR_CHIP: // currently chip is the same with port
			//one port board no need broadcast port
			if(MAX_PORTS == 1 && value >= MAX_PORTS) {
				PRINTL(DBG_LVL_LIB, "Invalid portid=%i\n", value);
				return -DSL_ERR_NOCHIP;	
			}
			else if(value > MAX_PORTS) {
				PRINTL(DBG_LVL_LIB, "Invalid portid=%i\n", value);
				return -DSL_ERR_NOCHIP;	
			}

			break;

		case MT_PAR_PORT: // 1-MAXPORT
			//one port board no need broadcast port
			if(MAX_PORTS == 1 && value >= MAX_PORTS) {
				PRINTL(DBG_LVL_LIB, "Invalid portid=%i\n", value);
				return -MT_NO_SUCH_PORT;	
			}
			else if(value > MAX_PORTS) {
				PRINTL(DBG_LVL_LIB, "Invalid portid=%i\n", value);
				return -MT_NO_SUCH_PORT;	
			}			

			break;

		case MT_PAR_GROUP: // 0 - 4
			if(value < 0 || value > 4) {
				PRINTL(DBG_LVL_LIB, "Invalid groupid=%i\n", value);
				return -DSL_ERR_NOGROUP;
			}

			break;

		/*case MT_PAR_TABLE: // need effort to check correctly
			// cond is GroupID
			// 0 - MT_MIB_XdslGroup
			// 1 - MT_MIB_XdslGhsGroup
			// 2 - MT_MIB_XdslMetanoiaGroup
			// 3 - MT_MIB_XdslMetanoia2Group
			// 4 - MT_MIB_XdslNotifications
			switch(cond){
				case MT_MIB_XdslGroup:
					if(value > MT_MIB_XdslGroupTableMax) {
						PRINTL(DBG_LVL_LIB,"Table ID out of range\n");
						return DSL_ERR_NOTABLE;
					}

					break;

				case MT_MIB_XdslGhsGroup:
					if(value > MT_MIB_XdslGhsGroupTableMax) {
 						PRINTL(DBG_LVL_LIB,"Table ID out of range\n");
 						return DSL_ERR_NOTABLE;
					}

					break;

				case MT_MIB_XdslMetanoiaGroup:
					if(value > MT_MIB_XdslMetanoiaGroupTableMax) {
						PRINTL(DBG_LVL_LIB,"Table ID out of range\n");
						return DSL_ERR_NOTABLE;
					}

					break;

				case MT_MIB_XdslMetanoia2Group:
					if(value > MT_MIB_XdslMetanoiaGroupTableMax) {
						PRINTL(DBG_LVL_LIB,"Table ID out of range\n");
						return DSL_ERR_NOTABLE;
					}

					break;

				case MT_MIB_XdslNotifications:
					if(value > MT_MIB_XdslNotificationsGroupTableMax) {
						PRINTL(DBG_LVL_LIB,"Table ID out of range\n");
						return DSL_ERR_NOTABLE;
					}

					break;

				default:
					return -DSL_ERR_NOTABLE;
			}

			break;*/

		default:
			return -DSL_ERR_NOPARAM;
	}

	return MT_OK;
}


#if 0
/**
 * check param parameter value
 */
mt_ret check_param_param(mt_uint8 groupid,mt_uint8 tableid, mt_uint8 value)
{
	if(value == 0) {
		PRINTL(DBG_LVL_LIB, "Invalid param=%i\n", value);
		return -DSL_ERR_NOPARAM;	
	}

	switch(groupid)
	{
		case MT_MIB_XdslGroup:
			if(value > xdsl_table[tableid-1].entry_count) {
				PRINTL(DBG_LVL_LIB,"Param ID out of range\n");
				return -DSL_ERR_NOPARAM;	
			}

			break;

		case MT_MIB_XdslGhsGroup:
			if(value > xdsl_ghs_table[tableid-1].entry_count) {
				PRINTL(DBG_LVL_LIB,"Param ID out of range\n");
				return -DSL_ERR_NOPARAM;	
			}

			break;

		case MT_MIB_XdslMetanoiaGroup:
			if(value > xdsl_meta_table[tableid-1].entry_count) {
				PRINTL(DBG_LVL_LIB,"Param ID out of range\n");
				return -DSL_ERR_NOPARAM;	
			}

			break;

		case MT_MIB_XdslMetanoia2Group:
			if(value > xdsl_meta2_table[tableid-1].entry_count) {
				PRINTL(DBG_LVL_LIB,"Param ID out of range\n");
				return -DSL_ERR_NOPARAM;
			}

			break;

		case MT_MIB_XdslNotificationsGroup:
			if(value > xdsl_notif_table[tableid-1].entry_count) {
				PRINTL(DBG_LVL_LIB,"Param ID out of range\n");
				return -DSL_ERR_NOPARAM;
			}

			break;

		default:
			return -DSL_ERR_NOTABLE;
	}

	return MT_OK;
}


/**
 * check idx parameter value
 */
mt_ret check_param_idx(mt_uint8 groupid, mt_uint8 tableid, mt_uint8 value)
{
	mt_uint8 idxcount=0;

	if(value >= MT_IDX_MAX) {	//need to check max of index, security issue
		PRINTL(DBG_LVL_LIB, "Invalid idx=%i\n", value);
		return -DSL_ERR_NOINDEX;
	}
	
	idxcount=1;
	if(groupid == MT_MIB_XdslGroup) {
		if((tableid == MT_MIB_VdslPhysTable) || 
			(tableid == MT_MIB_VdslPerfDataTable) || 
			(tableid == MT_MIB_VdslPerfIntervalTable) ||					
			(tableid == MT_MIB_VdslPerf1DayIntervalTable)){
				idxcount=2;
		}

		if((tableid == MT_MIB_VdslChanTable) ||
			(tableid == MT_MIB_VdslChanPerfDataTable) || 
			(tableid == MT_MIB_VdslChanIntervalTable) || 
			(tableid == MT_MIB_VdslChan1DayIntervalTable)) {
				idxcount=4;
		}																
	}	
	
	if(groupid == MT_MIB_XdslGhsGroup) {
		if( (tableid == MT_MIB_VdslLineMCMConfProfileTxBandTable) || 
			(tableid == MT_MIB_VdslLineMCMConfProfileRxBandTable) || 
			(tableid == MT_MIB_VdslLineMCMConfProfileTxPSDTable) ||					
			(tableid == MT_MIB_VdslLineMCMConfProfileMaxTxPSDTable) ||										
			(tableid == MT_MIB_VdslLineMCMConfProfileMaxRxPSDTable)){
				idxcount=4;
		}
	}
	
	if(groupid == MT_MIB_XdslMetanoiaGroup) {
		if( tableid == MT_MIB_VdslMetanoiaTable2 ) {
				idxcount=2;
		}
	}

	if(value >= idxcount) {
		PRINTL(DBG_LVL_LIB,"Invalid idx, groupid=%i, tableid=%i, value=%i\n", groupid, tableid, value);
		return -DSL_ERR_NOINDEX;	
	}
	else {
		return MT_OK;		
	}	
}
#endif
