/*
 * (C) Copyright 2001, 2002
 * Wolfgang Denk, DENX Software Engineering, wd@denx.de.
 *
 * See file CREDITS for list of people who contributed to this
 * project.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307 USA
 *
 * This has been changed substantially by Gerald Van Baren, Custom IDEAS,
 * vanbaren@cideas.com.  It was heavily influenced by LiMon, written by
 * Neil Russell.
 */

//#include <config.h>
//#ifdef	CONFIG_MPC8260			/* only valid for MPC8260 */
//#include <ioports.h>
//#endif
//#ifdef CONFIG_AT91RM9200DK		/* need this for the at91rm9200dk */
//#include <asm/io.h>
//#include <asm/arch/hardware.h>
//#endif
//#include <types.h>
//#include <i2c.h>
#if 1
#include <asm/arch-str9100/hardware.h>
#include <asm/arch-str9100/str9100/star_gpio.h>
#endif

#define I2C_ACTIVE		((GPIO_PIN_DIR) |= (0x1<<11))
#define I2C_TRISTATE	((GPIO_PIN_DIR) &= ~(0x1<<11))
#define I2C_READ	(GPIO_DATA_IN & (0x1 << 11))?1:0
#define I2C_SDA(bit)	if(bit) ((GPIO_DATA_SET) |= (0x1<<11)); \
			else    ((GPIO_DATA_CLEAR) |= (0x1<<11))
#define I2C_SCL(bit)	if(bit) ((GPIO_DATA_SET) |= (0x1<<10)); \
			else    ((GPIO_DATA_CLEAR) |= (0x1<<10))
#define I2C_DELAY	{int ii; for (ii=0; ii<100; ii++); }//udelay(1)	/* 1/4 I2C clock duration */


typedef unsigned char		uchar;
typedef unsigned short		ushort;
typedef unsigned int			uint;
typedef unsigned long		ulong;


//#if defined(CONFIG_SOFT_I2C)

#define	DEBUG_I2C


/*-----------------------------------------------------------------------
 * Definitions
 */

#define RETRIES		0


#define I2C_ACK		0		/* PD_SDA level to ack a byte */
#define I2C_NOACK	1		/* PD_SDA level to noack a byte */


#ifdef DEBUG_I2C
#define PRINTD(fmt,args...)	printf(fmt ,##args);
#else
#define PRINTD(fmt,args...)
#endif

/*-----------------------------------------------------------------------
 * Local functions
 */
static void  send_reset	(void);
void  send_start	(void);
void  send_stop	(void);
void  send_ack	(int);
int   write_byte	(uchar byte);
uchar read_byte	(int);


/*-----------------------------------------------------------------------
 * Send a reset sequence consisting of 9 clocks with the data signal high
 * to clock any confused device back into an idle state.  Also send a
 * <stop> at the end of the sequence for belts & suspenders.
 */
static void send_reset(void)
{
#ifdef	CONFIG_MPC8260
	volatile ioport_t *iop = ioport_addr((immap_t *)CFG_IMMR, I2C_PORT);
#endif
#ifdef	CONFIG_8xx
	volatile immap_t *immr = (immap_t *)CFG_IMMR;
#endif
	int j;

	I2C_SCL(1);
	I2C_SDA(1);
#ifdef	I2C_INIT
	I2C_INIT;
#endif
	I2C_TRISTATE;
	for(j = 0; j < 9; j++) {
		I2C_SCL(0);
		I2C_DELAY;
		I2C_DELAY;
		I2C_SCL(1);
		I2C_DELAY;
		I2C_DELAY;
	}
	send_stop();
	I2C_TRISTATE;
}

void static idle(void)
{
#if 1 // 8051 style

	I2C_ACTIVE;
	I2C_SCL(1);
	I2C_SDA(1);
	I2C_DELAY;
	I2C_DELAY;
	I2C_DELAY;
	I2C_DELAY;
	I2C_DELAY;
#else
	I2C_ACTIVE;
	I2C_SCL(1);
	I2C_SDA(1);
	I2C_DELAY;
	I2C_DELAY;
	I2C_DELAY;
	I2C_DELAY;
#endif	
}


/*-----------------------------------------------------------------------
 * START: High -> Low on SDA while SCL is High
 */
void send_start(void)
{
#if 1 // 8051 style
	I2C_ACTIVE;
	I2C_SCL(0);
	I2C_SDA(1);
	I2C_DELAY;
	I2C_SCL(1);
	I2C_DELAY;
	I2C_SDA(0);	
	I2C_DELAY;
///--	I2C_SCL(0);
//	I2C_DELAY;

/*
	P1=SCL_0_SDA_1;
	for(i=0;i<HOLDTIME;i++);
	P1=SCL_1_SDA_1;
	for(i=0;i<HOLDTIME;i++);
	P1=SCL_1_SDA_0;
	for(i=0;i<HOLDTIME;i++);
	P1=SCL_0_SDA_0;
//    	for(i=0;i<HOLDTIME;i++);
*/

#elif 0 //refer form sample
#ifdef	CONFIG_MPC8260
	volatile ioport_t *iop = ioport_addr((immap_t *)CFG_IMMR, I2C_PORT);
#endif
#ifdef	CONFIG_8xx
	volatile immap_t *immr = (immap_t *)CFG_IMMR;
#endif


    I2C_ACTIVE;	
	I2C_SDA(1);	
	I2C_SCL(0);
	I2C_DELAY;
	I2C_SCL(1);
	I2C_DELAY;
	I2C_SDA(0);
	I2C_DELAY;	
#elif 0 // suggest from mail
//idle
    I2C_ACTIVE;	
	I2C_SCL(1);
	I2C_SDA(1);
	I2C_DELAY;
	I2C_DELAY;
	I2C_DELAY;
	I2C_DELAY;
	
	I2C_SCL(0);
	I2C_DELAY;
	I2C_SCL(1);
	I2C_DELAY;
	I2C_SDA(0);
	I2C_DELAY;	
#else
	I2C_DELAY;
	I2C_SDA(1);
	I2C_ACTIVE;
	I2C_DELAY;
	I2C_SCL(1);
	I2C_DELAY;
	I2C_SDA(0);
	I2C_DELAY;
#endif
}

/*-----------------------------------------------------------------------
 * STOP: Low -> High on SDA while SCL is High
 */
void send_stop(void)
{

#if 1 // 8051 style
    I2C_ACTIVE;	
	I2C_SCL(0);
	I2C_SDA(0);
	I2C_DELAY;
	I2C_DELAY;
	I2C_SCL(1);
	I2C_DELAY;
	I2C_SDA(1);
	I2C_DELAY;
	
	I2C_SCL(0);
	I2C_DELAY;
	I2C_DELAY;
	I2C_SCL(1);
/*	
	P1=SCL_0_SDA_0;
	for(i=0;i<HOLDTIME;i++);
	P1=SCL_1_SDA_0;
	for(i=0;i<HOLDTIME;i++);
	P1=SCL_1_SDA_1;
	for(i=0;i<HOLDTIME;i++);
	P1=SCL_0_SDA_1;
	for(i=0;i<HOLDTIME;i++);
	P1=SCL_1_SDA_1;
*/
#elif 0 //refer form sample


#ifdef	CONFIG_MPC8260
	volatile ioport_t *iop = ioport_addr((immap_t *)CFG_IMMR, I2C_PORT);
#endif
#ifdef	CONFIG_8xx
	volatile immap_t *immr = (immap_t *)CFG_IMMR;
#endif

	I2C_ACTIVE;
	I2C_SCL(0);	
	I2C_SDA(0);	
	I2C_DELAY;
	I2C_SCL(1);
	I2C_DELAY;
	I2C_SDA(1);
	I2C_DELAY;
	I2C_SCL(0);
	I2C_DELAY;
#elif 0 // work
	I2C_ACTIVE;
	I2C_SCL(0);	
	I2C_SDA(0);	
	I2C_DELAY;
	I2C_DELAY;	
	I2C_SCL(1);
	I2C_DELAY;
	I2C_SDA(1);
	I2C_DELAY;
#else
	I2C_ACTIVE;
	I2C_SCL(0);	
	I2C_SDA(0);	
	I2C_DELAY;
	I2C_SCL(1);
	I2C_DELAY;
	I2C_SDA(1);
	I2C_DELAY;
	I2C_SCL(0);
	I2C_DELAY;
	I2C_SCL(1);
#endif	
}


/*-----------------------------------------------------------------------
 * ack should be I2C_ACK or I2C_NOACK
 */
void send_ack(int ack)
{
#if 1 // 8051 style
	I2C_ACTIVE;
	I2C_SCL(0);	
	I2C_SDA(ack);	
	I2C_DELAY;
	I2C_SCL(1);
	I2C_DELAY;
	I2C_SCL(1);	
	I2C_DELAY;
	I2C_SCL(0);	
//	I2C_DELAY;

/*	
	P1=SCL_0_SDA_1;
	for(i=0;i<HOLDTIME;i++);
	P1=SCL_1_SDA_1;
	for(i=0;i<HOLDTIME;i++);
	P1=SCL_1_SDA_1;
	for(i=0;i<HOLDTIME;i++);
	P1=SCL_0_SDA_1;
//    	for(i=0;i<HOLDTIME;i++);
*/

#else
#ifdef	CONFIG_MPC8260
	volatile ioport_t *iop = ioport_addr((immap_t *)CFG_IMMR, I2C_PORT);
#endif
#ifdef	CONFIG_8xx
	volatile immap_t *immr = (immap_t *)CFG_IMMR;
#endif

	I2C_ACTIVE;
	I2C_SCL(0);
	I2C_SDA(ack);
	I2C_DELAY;
	I2C_SCL(1);
	I2C_DELAY;
	I2C_SCL(1);
	I2C_DELAY;
	I2C_SCL(0);
#endif	
}


static int check_ack(void)
{
	int nack;
	/*
	 * Look for an <ACK>(negative logic) and return it.
	 */		
	I2C_TRISTATE;
	I2C_SCL(0);
	I2C_DELAY;
	I2C_DELAY;
	I2C_SCL(1);
	I2C_DELAY;
	nack = I2C_READ;	
	I2C_DELAY;
//	I2C_SCL(0);
//	I2C_ACTIVE;
//	I2C_DELAY;

	return nack;

/*
	P1=SCL_0_SDA_1;
	for(i=0;i<HOLDTIME;i++);
	SCK=1;//P1=SCL_1_SDA_1;
	for(i=0;i<HOLDTIME;i++);
	ack = SDA;
	SCK=1;//P1=SCL_1_SDA_1;
	for(i=0;i<HOLDTIME;i++);
	SCK=0;//P1=SCL_0_SDA_1;
//    	for(i=0;i<HOLDTIME;i++);
	return ack;
*/

}

/*-----------------------------------------------------------------------
 * Send 8 bits and look for an acknowledgement.
 */
int write_byte(uchar data)
{

#if 1 // 8051 style
	int j;

    
//	I2C_ACTIVE;
	I2C_SDA(0);
	I2C_ACTIVE;
	I2C_SDA(0);    
//	I2C_SDA(data & 0x80);		
	for(j = 0; j < 8; j++) {
		I2C_SCL(0);
		I2C_DELAY;
		I2C_SDA(data & 0x80);		
		I2C_DELAY;
		I2C_SCL(1);
		I2C_DELAY;
		I2C_DELAY;
///--		I2C_SCL(0);
//		I2C_DELAY;

		data <<= 1;
	}
/*	
	P1=SCL_0_SDA_0;
	for(i=0;i<HOLDTIME;i++);
	P1=SCL_1_SDA_0;
	for(i=0;i<HOLDTIME;i++);
	P1=SCL_1_SDA_0;
	for(i=0;i<HOLDTIME;i++);
	P1=SCL_0_SDA_0;
//    	for(i=0;i<HOLDTIME;i++);
*/	

	return data;
#else

#ifdef	CONFIG_MPC8260
	volatile ioport_t *iop = ioport_addr((immap_t *)CFG_IMMR, I2C_PORT);
#endif
#ifdef	CONFIG_8xx
	volatile immap_t *immr = (immap_t *)CFG_IMMR;
#endif
	int j;
	int nack;

	I2C_ACTIVE;
	for(j = 0; j < 8; j++) {
		I2C_SCL(0);
		I2C_DELAY;
		I2C_SDA(data & 0x80);
		I2C_DELAY;
		I2C_SCL(1);
		I2C_DELAY;
		I2C_DELAY;
		//I2C_SCL(0);
//		I2C_DELAY;

		data <<= 1;
	}

	/*
	 * Look for an <ACK>(negative logic) and return it.
	 */	
	I2C_TRISTATE; 
//	I2C_DELAY;
	I2C_SCL(0);
	//	I2C_SDA(1);	
	I2C_DELAY;	
	I2C_DELAY;
	I2C_SCL(1);
	I2C_DELAY;
	nack = I2C_READ;	
	I2C_DELAY;

	I2C_ACTIVE;
	I2C_SDA(0);
//	I2C_SCL(0);

/*
	I2C_SCL(0);
    I2C_DELAY;
	I2C_DELAY;
	I2C_SCL(1);
    I2C_DELAY;
	I2C_DELAY;
	I2C_SCL(0);
    I2C_DELAY;
	I2C_DELAY;
	I2C_SCL(1);
    I2C_DELAY;
	I2C_DELAY;
	I2C_SCL(0);
*/


	return(nack);	/* not a nack is an ack */
#endif


}


/*-----------------------------------------------------------------------
 * if ack == I2C_ACK, ACK the byte so can continue reading, else
 * send I2C_NOACK to end the read.
 */
uchar read_byte(int ack)
{

#if 1 // 8051 style

	int  data;
	int  j;

	/*
	 * Read 8 bits, MSB first.
	 */
	data = 0;
	for(j = 0; j < 8; j++) {
		//I2C_ACTIVE;
		I2C_SCL(0);
		//I2C_SDA(1);
		I2C_TRISTATE;
		I2C_DELAY;
		data <<= 1;		
		I2C_SCL(1);
		I2C_DELAY;
		data |= I2C_READ;		
		I2C_SCL(1);
		I2C_DELAY;
		I2C_SCL(0);
		I2C_DELAY;
	}
	return(data);


/*
	// from MSB to LSB 
	for(j=8;j>0;j--) {
		P1=SCL_0_SDA_1;
		for(i=0;i<HOLDTIME;i++);
		InData <<= 1;
		SCK=1;//P1=SCL_1_SDA_1;   	
		for(i=0;i<HOLDTIME;i++);
		InData |= SDA;	
		SCK=1;//P1=SCL_1_SDA_1;
		for(i=0;i<HOLDTIME;i++);
		SCK=0;//P1=SCL_0_SDA_1;
		for(i=0;i<HOLDTIME;i++);
	}
*/
#else
#ifdef	CONFIG_MPC8260
	volatile ioport_t *iop = ioport_addr((immap_t *)CFG_IMMR, I2C_PORT);
#endif
#ifdef	CONFIG_8xx
	volatile immap_t *immr = (immap_t *)CFG_IMMR;
#endif
	int  data;
	int  j;

	/*
	 * Read 8 bits, MSB first.
	 */
	I2C_TRISTATE;
	data = 0;
	for(j = 0; j < 8; j++) {
		I2C_SCL(0);
		I2C_DELAY;
		I2C_SCL(1);
		I2C_DELAY;
		data <<= 1;
		data |= I2C_READ;
		I2C_DELAY;
	}
	send_ack(ack);

	return(data);
#endif	
}

/*=====================================================================*/
/*                         Public Functions                            */
/*=====================================================================*/

/*-----------------------------------------------------------------------
 * Initialization
 */
void i2c_init (int speed, int slaveaddr)
{
	/*
	 * WARNING: Do NOT save speed in a static variable: if the
	 * I2C routines are called before RAM is initialized (to read
	 * the DIMM SPD, for instance), RAM won't be usable and your
	 * system will crash.
	 */
	send_reset ();
}

/*-----------------------------------------------------------------------
 * Probe to see if a chip is present.  Also good for checking for the
 * completion of EEPROM writes since the chip stops responding until
 * the write completes (typically 10mSec).
 */
int i2c_probe(uchar addr)
{
	int rc;

	/* perform 1 byte read transaction */
	send_start();
	rc = write_byte ((addr << 1) | 0);
	send_stop();

	return (rc ? 1 : 0);
}

/*-----------------------------------------------------------------------
 * Read bytes
 */
int  i2c_read(uchar chip, uint addr, int alen, uchar *buffer, int len)
{
#if 1 // 8051 style
	unsigned char i;
	unsigned char ByteCount;
	int ack;
	
	ByteCount=len;
	
	for(i=0;i<10;i++)//��MPU check��ACK=1�A��ܻPRTL8326��handshake���ѡC��������
	{
		//printf("press %d\n",i);
		//getc();
		
		idle();
    	send_start();

		write_byte(0xA9);//1010_100(4:RTL8326, 0:EEPROM24C02)_1(1=read, 0=write)
		ack=check_ack();
		if(ack)
		{ 
			send_stop();			
			continue;
		}
		
		//printf("%d, ma, ",i);
    	write_byte( (unsigned char)(addr) );
		ack=check_ack();
		if(ack) { 
			send_stop();			
			continue;
		}

		//printf("%d, la, ",i);
   		write_byte( (unsigned char)(addr>>8) );
		ack=check_ack();
		if(ack) {
			send_stop();
			continue;
		}
		
		break;
	}
	//if (i<10) printf("\n great!! \n");
	//else printf("\n handshaking fail!! \n");
	
    //Read RTL8326 register
    while(ByteCount>0)
    {
    	buffer[len-ByteCount]=read_byte(0);
    	ByteCount--;
    	if(ByteCount>0)//ACK(bit0) 
    		send_ack(0);
    }
    send_ack(1);//MPU must send ACK=1 after read last byte
    send_stop();

	return 0;

#elif 0///-- rtl8310p
	int shift, i, ilen;
	PRINTD("i2c_read: chip %02X addr %02X alen %d buffer %p len %d\n",
		chip, addr, alen, buffer, len);
	/*
	 * Do the addressing portion of a write cycle to set the
	 * chip's address pointer.  If the address length is zero,
	 * don't do the normal write cycle to set the address pointer,
	 * there is no address pointer in this chip.
	 */

	//��MPU check��ACK=1�A��ܻPRTL8326��handshake���ѡC��������	 
//	for(i=0;i<10;i++) {
		//ilen = alen;
		idle();
		send_start();
		if(write_byte((chip << 1) | 1)) {	/* read cycle */
			send_stop();
			PRINTD("i2c_read, no chip responded %02X\n", chip);
			return(1);
		}	
		if(write_byte(addr >> 8)) {
			send_stop();
			PRINTD("i2c_read, address not <ACK>ed\n");
			return(1);
		}
		if(write_byte(addr)) {
			send_stop();
			PRINTD("i2c_read, address not <ACK>ed\n");
			return(1);
		}
		
/*		
		if(ilen > 0) {
			shift = (ilen-1) * 8;
			while(ilen-- > 0) {
				if(write_byte(addr >> shift)) {
					send_stop();
					PRINTD("i2c_read, address not <ACK>ed\n");
					if (i==9)return(1);else continue;
				}
				shift -= 8;
			}
		}
*/		
//		break;
//	}	
	/*
	 * Send the chip address again, this time for a read cycle.
	 * Then read the data.  On the last byte, we do a NACK instead
	 * of an ACK(len == 0) to terminate the read.
	 */	
	while(len-- > 0) {
		*buffer++ = read_byte(len == 0);
	}
	send_stop();
	return(0);


#else
	int shift;
	PRINTD("i2c_read: chip %02X addr %02X alen %d buffer %p len %d\n",
		chip, addr, alen, buffer, len);

#ifdef CFG_I2C_EEPROM_ADDR_OVERFLOW
	/*
	 * EEPROM chips that implement "address overflow" are ones
	 * like Catalyst 24WC04/08/16 which has 9/10/11 bits of
	 * address and the extra bits end up in the "chip address"
	 * bit slots. This makes a 24WC08 (1Kbyte) chip look like
	 * four 256 byte chips.
	 *
	 * Note that we consider the length of the address field to
	 * still be one byte because the extra address bits are
	 * hidden in the chip address.
	 */
	chip |= ((addr >> (alen * 8)) & CFG_I2C_EEPROM_ADDR_OVERFLOW);

	PRINTD("i2c_read: fix addr_overflow: chip %02X addr %02X\n",
		chip, addr);
#endif

	/*
	 * Do the addressing portion of a write cycle to set the
	 * chip's address pointer.  If the address length is zero,
	 * don't do the normal write cycle to set the address pointer,
	 * there is no address pointer in this chip.
	 */
	send_start();
	if(alen > 0) {
		if(write_byte(chip << 1)) {	/* write cycle */
			send_stop();
			PRINTD("i2c_read, no chip responded %02X\n", chip);
			return(1);
		}
		shift = (alen-1) * 8;
		while(alen-- > 0) {
			if(write_byte(addr >> shift)) {
				PRINTD("i2c_read, address not <ACK>ed\n");
				return(1);
			}
			shift -= 8;
		}
		send_stop();	/* reportedly some chips need a full stop */
		send_start();
	}
	/*
	 * Send the chip address again, this time for a read cycle.
	 * Then read the data.  On the last byte, we do a NACK instead
	 * of an ACK(len == 0) to terminate the read.
	 */
	write_byte((chip << 1) | 1);	/* read cycle */
	while(len-- > 0) {
		*buffer++ = read_byte(len == 0);
	}
	send_stop();
	return(0);
#endif	
}

/*-----------------------------------------------------------------------
 * Write bytes
 */
int  i2c_write(uchar chip, uint addr, int alen, uchar *buffer, int len)
{
#if 1 //8051
	unsigned char i;
	unsigned char ByteCount;
	int ack;
	
	ByteCount=len;

	for(i=0;i<100;i++)//��MPU check��ACK=1�A��ܻPRTL8326��handshake���ѡC��������
	{
		idle();
    	send_start();

		write_byte(0xA8);//1010_100(4:RTL8326, 0:EEPROM24C02)_0(1=read, 0=write)
		ack=check_ack();
		if(ack) { 
			send_stop();			
			continue;
		}

		write_byte(addr);
		ack=check_ack();
		if(ack) { 
			send_stop();
			continue;
		}

		write_byte(addr>>8);
		ack=check_ack();
		if(ack) { 
			send_stop();
			continue;
		}

		break;
	}
   	//Write RTL8326 register
   	while(ByteCount>0) {
   	 	write_byte(buffer[len-ByteCount]);
    	ack=check_ack();    	
    	ByteCount--;
    }
	send_stop();

	return 0;
	
#else
	int shift, failures = 0;

	PRINTD("i2c_write: chip %02X addr %02X alen %d buffer %p len %d\n",
		chip, addr, alen, buffer, len);

	send_start();
	if(write_byte(chip << 1)) {	/* write cycle */
		send_stop();
		PRINTD("i2c_write, no chip responded %02X\n", chip);
		return(1);
	}
	shift = (alen-1) * 8;
	while(alen-- > 0) {
		if(write_byte(addr >> shift)) {
			PRINTD("i2c_write, address not <ACK>ed\n");
			return(1);
		}
		shift -= 8;
	}

	while(len-- > 0) {
		if(write_byte(*buffer++)) {
			failures++;
		}
	}
	send_stop();
	return(failures);
#endif	
}
#if 0
/*-----------------------------------------------------------------------
 * Read a register
 */
uchar i2c_reg_read(uchar i2c_addr, uchar reg)
{
	uchar buf;

	i2c_read(i2c_addr, reg, 1, &buf, 1);

	return(buf);
}

/*-----------------------------------------------------------------------
 * Write a register
 */
void i2c_reg_write(uchar i2c_addr, uchar reg, uchar val)
{
	i2c_write(i2c_addr, reg, 1, &val, 1);
}
#endif

//#endif	/* CONFIG_SOFT_I2C */

EXPORT_SYMBOL(i2c_read);
EXPORT_SYMBOL(i2c_write);
