#ifndef _OFFTIME_H_
#define _OFFTIME_H_

#include <linux/time.h>

# define __isleap(year) \
  ((year) % 4 == 0 && ((year) % 100 != 0 || (year) % 400 == 0))

static const unsigned short int __mon_yday[2][13] =
{
	/* Normal years.  */
	{ 0, 31, 59, 90, 120, 151, 181, 212, 243, 273, 304, 334, 365 },
	/* Leap years.  */
	{ 0, 31, 60, 91, 121, 152, 182, 213, 244, 274, 305, 335, 366 }
};

#ifndef OPENWRT
struct tm {
	int     tm_sec;         /* seconds */
	int     tm_min;         /* minutes */
	int     tm_hour;        /* hours */
	int     tm_mday;        /* day of the month */
	int     tm_mon;         /* month */
	int     tm_year;        /* year */
	int     tm_wday;        /* day of the week */
	int     tm_yday;        /* day in the year */
	int     tm_isdst;       /* daylight saving time */
};
#endif	//OPENWRT

extern int __offtime (const time_t *t, long int offset, struct tm *tp);

#endif //_OFFTIME_H_
