/****************************************************************************
* File:         $Workfile$
* Revision:     $Revision: 1.1 $
* Date:         $Date: 2009-03-18 02:59:02 $
*
* Overview:     
* Functions:
*
* Author:       Ian Tsao
* 
* -- Metanoia Copyright Notice --
*
* (C) Copyright 2005 Metanoia, Inc. All rights reserved.
* 
* Metanoia reserves the right to change specifications without notice. 
* Copyright 2005 Metanoia, Inc. All rights reserved. Preliminary Data-Sheet 
* indicates this product is in design and the specification may change. 
* Electrical parametrics have not been analyzed and are not specified. Do not 
* use this data sheet as a design reference document. Please contact Metanoia 
* for a current data sheet that may be used as a design reference. All 
* contents of this document are protected by copyright law and may not be 
* reproduced without the express written consent of Metanoia, Inc. Metanoia, 
* the Metanoia logo, and combinations thereof are trademarks of Metanoia, Inc. 
* Other product names used in this publication are for identification purposes 
* only and may be trademarks or registered trademarks of their respective 
* companies. The contents of this document are provided in connection with 
* Metanoia, Inc. products. Metanoia, Inc. has made best efforts to ensure that 
* the information contained herein is accurate and reliable. However, Metanoia, 
* Inc. makes no warranties, express or implied, as to the accuracy or 
* completeness of the contents of this publication and is providing this 
* publication 'as is'. Metanoia, Inc. reserves the right to make changes to 
* specifications and product descriptions at any time without notice, and to 
* discontinue or make changes to its products at any time without notice. 
* Metanoia, Inc. does not assume any liability arising out of the application 
* or use of any product or circuit, and specifically disclaims any and all 
* liability, including without limitation special, consequential, or 
* incidental damages.
* 
****************************************************************************/
#ifndef _MIBEQU_H_
#define _MIBEQU_H_
//VdslLineConfProfileEntry
// configuration parameters
// VDSL MIB PARAM DEFINES

// ifType
#define MT_MIB_IFTYPE_VDSL				97
#define MT_MIB_IFTYPE_INTERLEAVED			124
#define MT_MIB_IFTYPE_FAST				125

// #define MT_MIB_VdslLineCoding
#define MT_MIB_OTHER					1
#define MT_MIB_MCM					2
#define MT_MIB_SCM					3

// #define MT_MIB_VdslLineType
#define MT_MIB_NO_CHANNEL				1
#define MT_MIB_FAST_ONLY				2
#define MT_MIB_INTERLEAVED_ONLY				3
#define MT_MIB_FAST_OR_INTERLEAVED			4
#define MT_MIB_FAST_AND_INTERLEAVED			5

// #define MT_MIB_VdslPhysSide
#define MT_MIB_VTUC					1
#define MT_MIB_VTUR					2

// #define MT_MIB_VdslPhysCurrStatus
#define MT_MIB_NO_DEFECT				0
#define MT_MIB_LOSS_OF_FRAMING				1
#define MT_MIB_LOSS_OF_SIGNAL				2
#define MT_MIB_LOSS_OF_POWER				3
#define MT_MIB_LOSS_OF_SIGNAL_QUALITY			4
#define MT_MIB_LOSS_OF_LINK				5
#define MT_MIB_DATA_INIT_FAILURE			6
#define MT_MIB_CONFIG_INIT_FAILURE			7
#define MT_MIB_PROTOCOL_INIT_FAILURE			8
#define MT_MIB_NO_PEER_VTU_PRESENT			9

// #define MT_MIB_VdslLineConfDownRateMode, #define MT_MIB_VdslLineConfUpRateMode
#define MT_MIB_MANUAL					1
#define MT_MIB_ADAPT_AT_INIT				2

// #define MT_MIB_VdslLineConfDownPboControl, #define MT_MIB_VdslLineConfUpPboControl
#define MT_MIB_DISABLED					1
#define MT_MIB_AUTO					2
#define MT_MIB_DS_PBO_MANUAL				3

// #define MT_MIB_VdslLineConfDeploymentScenario
#define MT_MIB_FTTCAB					1
#define MT_MIB_FTTEX					2
#define MT_MIB_DS_OTHER					3

// #define MT_MIB_VdslLineConfAdslPresence
#define MT_MIB_NONE					1
#define MT_MIB_ADSL_OVER_POTS				2
#define MT_MIB_ADSL_OVER_ISDN				3

// #define MT_MIB_VdslLineConfApplicableStandard
#define MT_MIB_ANSI					1
#define MT_MIB_ETSI					2
#define MT_MIB_ITU					3
#define MT_MIB_AS_OTHER					4

// #define MT_MIB_VdslLineConfBandPlan
#define MT_MIB_BANDPLAN997				1
#define MT_MIB_BANDPLAN998				2
#define MT_MIB_BANDPLANFX				3
#define MT_MIB_BP_OTHER					4

// #define MT_MIB_VdslLineConfBandOptUsage
#define MT_MIB_UNUSED					1
#define MT_MIB_UPSTREAM					2
#define MT_MIB_DOWNSTREAM				3	// US0 band downstream not supported - efb

// #define MT_MIB_VdslLineConfUpPsdTemplate, #define MT_MIB_VdslLineConfDownPsdTemplate
#define MT_MIB_TEMPLATEMASK1				1
#define MT_MIB_TEMPLATEMASK2				2

// #define MT_MIB_VdslLineConfHamBandMask
#define MT_MIB_CUSTOM_Notch1				0
#define MT_MIB_CUSTOM_Notch2				1
#define MT_MIB_AMATEUR_BAND_30m				2
#define MT_MIB_AMATEUR_BAND_40m				3
#define MT_MIB_AMATEUR_BAND_80m				4
#define MT_MIB_AMATEUR_BAND_160m			5
#define MT_MIB_AMATEUR_BAND_20m				6
#define MT_MIB_AMATEUR_BAND_17m				7
#define MT_MIB_AMATEUR_BAND_15m				8
#define MT_MIB_AMATEUR_BAND_12m				9
#define MT_MIB_AMATEUR_BAND_10m				10

// Additional defines
#define MT_MIB_SIX_DB_SNR_MGN				24				//(4*6) in units of 0.25 dB
#define MT_MIB_DS_FAST_MAX_RATE				131072			//(4096*32) in units of 1Kbps
#define MT_MIB_DS_FAST_MIN_RATE				256				//(8*32) in units of 1Kbps
#define MT_MIB_DS_SLOW_MAX_RATE				131072			//(4096*32) in units of 1Kbps
#define MT_MIB_DS_SLOW_MIN_RATE				256				//(8*32) in units of 1Kbps
#define MT_MIB_US_FAST_MAX_RATE				131072			//(4096*32) in units of 1Kbps
#define MT_MIB_US_FAST_MIN_RATE				256				//(8*32) in units of 1Kbps
#define MT_MIB_US_SLOW_MAX_RATE				131072			//(4096*32) in units of 1Kbps
#define MT_MIB_US_SLOW_MIN_RATE				256				//(8*32) in units of 1Kbps
#define MT_MIB_50_PERCENT				50
#define MT_MIB_DS_MAX_INT_DLY				10				// in ms
#define MT_MIB_US_MAX_INT_DLY				10				// in ms
#define MT_MIB_DS_TARG_SLOW_BURST			250				// in us
#define MT_MIB_US_TARG_SLOW_BURST			250				// in us
#define MT_MIB_8_PERCENT				8
#define MT_MIB_DOWN_MAX_POWER				58				// (14.5*4) units of 0.25dBm
#define MT_MIB_UP_MAX_POWER				58				// (14.5*4)

#define MT_MIB_ALARM_THRESH_15MIN_LOFS 			120
#define MT_MIB_ALARM_THRESH_15MIN_LOSS 			120
#define MT_MIB_ALARM_THRESH_15MIN_LPRS 			120
#define MT_MIB_ALARM_THRESH_15MIN_LOLS 			120
#define MT_MIB_ALARM_THRESH_15MIN_ESS 			120
#define MT_MIB_ALARM_THRESH_15MIN_SESS 			120
#define MT_MIB_ALARM_THRESH_15MIN_UASS 			120

#define VDSL_LINE_CONF_ProfileName			0							// SnmpAdminString
#define VDSL_LINE_CONF_DownRateMode			MT_MIB_ADAPT_AT_INIT		// INTEGER, manual(1), adaptAtInit(2)
#define VDSL_LINE_CONF_UpRateMode			MT_MIB_ADAPT_AT_INIT		// INTEGER, manual(1), adaptAtInit(2)
#define VDSL_LINE_CONF_DownMaxPwr			MT_MIB_DOWN_MAX_POWER		// Unsigned32, (0..58), "0.25dBm"
#define VDSL_LINE_CONF_UpMaxPwr				MT_MIB_UP_MAX_POWER			// Unsigned32, (0..58), "0.25dBm"
#define VDSL_LINE_CONF_DownMaxSnrMgn			MT_MIB_SIX_DB_SNR_MGN		// Unsigned32, (0..127), "0.25dBm"
#define VDSL_LINE_CONF_DownMinSnrMgn			0							// Unsigned32, (0..127), "0.25dBm"
#define VDSL_LINE_CONF_DownTargetSnrMgn			MT_MIB_SIX_DB_SNR_MGN		// Unsigned32, (0..127), "0.25dBm"
#define VDSL_LINE_CONF_UpMaxSnrMgn			MT_MIB_SIX_DB_SNR_MGN		// Unsigned32, (0..127), "0.25dBm"
#define VDSL_LINE_CONF_UpMinSnrMgn			0							// Unsigned32, (0..127), "0.25dBm"
#define VDSL_LINE_CONF_UpTargetSnrMgn			MT_MIB_SIX_DB_SNR_MGN		// Unsigned32, (0..127), "0.25dBm"
#define VDSL_LINE_CONF_DownFastMaxDataRate		MT_MIB_DS_FAST_MAX_RATE		// Unsigned32, (0..127), "0.25dBm"
#define VDSL_LINE_CONF_DownFastMinDataRate		MT_MIB_DS_FAST_MIN_RATE		// Unsigned32, "kbps"
#define VDSL_LINE_CONF_DownSlowMaxDataRate		MT_MIB_DS_SLOW_MAX_RATE		// Unsigned32, "kbps"
#define VDSL_LINE_CONF_DownSlowMinDataRate		0							// Unsigned32, "kbps"
#define VDSL_LINE_CONF_UpFastMaxDataRate		MT_MIB_US_FAST_MAX_RATE		// Unsigned32, "kbps"
#define VDSL_LINE_CONF_UpFastMinDataRate		MT_MIB_US_FAST_MIN_RATE		// Unsigned32, "kbps"
#define VDSL_LINE_CONF_UpSlowMaxDataRate		MT_MIB_US_SLOW_MAX_RATE		// Unsigned32, "kbps"
#define VDSL_LINE_CONF_UpSlowMinDataRate		0							// Unsigned32, "kbps"
#define VDSL_LINE_CONF_DownRateRatio			MT_MIB_50_PERCENT			// Unsigned32, (0..100)"percent"
#define VDSL_LINE_CONF_UpRateRatio			MT_MIB_50_PERCENT			// Unsigned32, (0..100)"percent"
#define VDSL_LINE_CONF_DownMaxInterDelay		MT_MIB_DS_MAX_INT_DLY		// Unsigned32, (0..255), ms
#define VDSL_LINE_CONF_UpMaxInterDelay			MT_MIB_US_MAX_INT_DLY		// Unsigned32, (0..255), ms
#define VDSL_LINE_CONF_DownPboControl			MT_MIB_DISABLED				// INTEGER, disabled(1), auto(2), manual(3)
#define VDSL_LINE_CONF_UpPboControl			MT_MIB_DISABLED				// INTEGER, disabled(1), auto(2), manual(3)
#define VDSL_LINE_CONF_DownPboLevel			0							// Unsigned32, (0..160), "0.25dB"
#define VDSL_LINE_CONF_UpPboLevel			0							// Unsigned32, (0..160), "0.25dB"
#define VDSL_LINE_CONF_DeploymentScenario		0							// INTEGER, fttCab(1), fttEx(2), other(3)
#define VDSL_LINE_CONF_AdslPresence			0							// INTEGER, none(1), adslOverPots(2), adslOverISDN(3)
#define VDSL_LINE_CONF_ApplicableStandard		0							// INTEGER, ansi(1), etsi(2), itu(3), other(4)
#define VDSL_LINE_CONF_BandPlan				MT_MIB_BANDPLAN998			// INTEGER, bandPlan997(1), bandPlan998(2), bandPlanFx(3), other(4) 
#define VDSL_LINE_CONF_BandPlanFx			0							// Unsigned32, (3750..12000) "kHz"
#define VDSL_LINE_CONF_BandOptUsage			0							// INTEGER, unused(1), upstream(2), downstream(3)
#define VDSL_LINE_CONF_UpPsdTemplae			0							// INTEGER, templateMask1(1), templateMask2(2)
#define VDSL_LINE_CONF_DownPsdTemplate			0							// INTEGER, templateMask1(1), templateMask2(2)
#define VDSL_LINE_CONF_HamBandMask			0
#define VDSL_LINE_CONF_CustomNotch1Start		0							// Unsigned32, "kHz"
#define VDSL_LINE_CONF_CustomNotch1Stop			0							// Unsigned32, "kHz"
#define VDSL_LINE_CONF_CustomNotch2Start		0							// Unsigned32, "kHz"
#define VDSL_LINE_CONF_CustomNotch2Stop			0							// Unsigned32, "kHz"
#define VDSL_LINE_CONF_DownTargetSlowBurst		MT_MIB_DS_TARG_SLOW_BURST	// Unsigned32, (0..1275) "microseconds"
#define VDSL_LINE_CONF_UpTargetSlowBurst		MT_MIB_US_TARG_SLOW_BURST	// Unsigned32, (0..1275) "microseconds"
#define VDSL_LINE_CONF_DownMaxFastFec			MT_MIB_8_PERCENT			// Unsigned32, (0..50) "%"
#define VDSL_LINE_CONF_UpMaxFastFec			MT_MIB_8_PERCENT			// Unsigned32, (0..50) "%"
#define VDSL_LINE_CONF_LineType				MT_MIB_INTERLEAVED_ONLY		// INTEGER, noChannel(1), fastOnly(2), interleavedOnly(3), fastOrInterleaved(4), fastAndInterleaved(5)
#define VDSL_LINE_CONF_ProfRowStatus			0							// RowStatus,


// VdslLineAlarmConfProfileEntry
#define VDSL_LINE_ALARM_CONF_ProfileName		0								// SnmpAdminString,
#define VDSL_LINE_ALARM_CONF_Thresh15MinLofs		MT_MIB_ALARM_THRESH_15MIN_LOFS	// HCPerfIntervalThreshold, "seconds"
#define VDSL_LINE_ALARM_CONF_Thresh15MinLoss		MT_MIB_ALARM_THRESH_15MIN_LOSS	// HCPerfIntervalThreshold, "seconds"
#define VDSL_LINE_ALARM_CONF_Thresh15MinLprs		MT_MIB_ALARM_THRESH_15MIN_LPRS	// HCPerfIntervalThreshold, "seconds"
#define VDSL_LINE_ALARM_CONF_Thresh15MinLols		MT_MIB_ALARM_THRESH_15MIN_LOLS	// HCPerfIntervalThreshold, "seconds"
#define VDSL_LINE_ALARM_CONF_Thresh15MinESs		MT_MIB_ALARM_THRESH_15MIN_ESS	// HCPerfIntervalThreshold, "seconds"
#define VDSL_LINE_ALARM_CONF_Thresh15MinSESs		MT_MIB_ALARM_THRESH_15MIN_SESS	// HCPerfIntervalThreshold, "seconds"
#define VDSL_LINE_ALARM_CONF_Thresh15MinUASs		MT_MIB_ALARM_THRESH_15MIN_UASS	// HCPerfIntervalThreshold, "seconds"
#define VDSL_LINE_ALARM_CONF_InitFailure		0								// TruthValue, indicate vdslInitFailureNotification notification generated if init failure occurs
#define VDSL_LINE_ALARM_CONF_ProfRowStatus		0								// RowStatus,

// VdslMetanoiaTable
	#ifdef MII_DATA_EN
#define VDSL_LINE_CONF_MutMode				2
#define VDSL_LINE_CONF_UtpFastChUs			0
#define VDSL_LINE_CONF_UtpSlowChUs			0
#define VDSL_LINE_CONF_UtpFastChDs			0
#define VDSL_LINE_CONF_UtpSlowChDs			0
#define VDSL_LINE_CONF_UtpIdlePrm0			0
#define VDSL_LINE_CONF_UtpIdlePrm1			0
#define VDSL_LINE_CONF_UtpTxWmk				0
#define VDSL_LINE_CONF_UtpRxWmk				0
#define VDSL_LINE_CONF_UtpCfgReg			0
#define VDSL_LINE_CONF_UtpCtlReg			0
#define VDSL_LINE_CONF_MiiCtlInitReg			0x030308
#define VDSL_LINE_CONF_MiiCfgInitReg			0x000ca0
#define VDSL_LINE_CONF_MiiTxThresh			0x0039e6
#define VDSL_LINE_CONF_MiiCtlReg			0x030318
#define VDSL_LINE_CONF_UtpCtlSyncReg			0x000010
#define VDSL_LINE_CONF_MiiCfgReg			0x000ce0
	#endif

	#ifdef SMII_DATA_EN
#define VDSL_LINE_CONF_MutMode				4
#define VDSL_LINE_CONF_UtpFastChUs			0
#define VDSL_LINE_CONF_UtpSlowChUs			0
#define VDSL_LINE_CONF_UtpFastChDs			0
#define VDSL_LINE_CONF_UtpSlowChDs			0
#define VDSL_LINE_CONF_UtpIdlePrm0			0
#define VDSL_LINE_CONF_UtpIdlePrm1			0
#define VDSL_LINE_CONF_UtpTxWmk				0
#define VDSL_LINE_CONF_UtpRxWmk				0
#define VDSL_LINE_CONF_UtpCfgReg			0x400000
#define VDSL_LINE_CONF_UtpCtlReg			0
#define VDSL_LINE_CONF_MiiCtlInitReg			0x030308
#define VDSL_LINE_CONF_MiiCfgInitReg			0x000ca0
#define VDSL_LINE_CONF_MiiTxThresh			0x0039e6
#define VDSL_LINE_CONF_MiiCtlReg			0x030338
#define VDSL_LINE_CONF_UtpCtlSyncReg			0x000010
#define VDSL_LINE_CONF_MiiCfgReg			0x000ce0
	#endif

	#ifdef UTP_DATA_EN
#define VDSL_LINE_CONF_MutMode				1
#define VDSL_LINE_CONF_UtpFastChUs			1
#define VDSL_LINE_CONF_UtpSlowChUs			9
#define VDSL_LINE_CONF_UtpFastChDs			1
#define VDSL_LINE_CONF_UtpSlowChDs			9
#define VDSL_LINE_CONF_UtpIdlePrm0			0
#define VDSL_LINE_CONF_UtpIdlePrm1			0x6a7701
#define VDSL_LINE_CONF_UtpTxWmk				0x001fad
#define VDSL_LINE_CONF_UtpRxWmk				0x001fad
#define VDSL_LINE_CONF_UtpCfgReg			0x307dd8
#define VDSL_LINE_CONF_UtpCtlReg			0x7c0002
#define VDSL_LINE_CONF_MiiCtlInitReg			0
#define VDSL_LINE_CONF_MiiCfgInitReg			0x0000c0
#define VDSL_LINE_CONF_MiiTxThresh			0
#define VDSL_LINE_CONF_MiiCtlReg			0
#define VDSL_LINE_CONF_UtpCtlSyncReg			0
#define VDSL_LINE_CONF_MiiCfgReg			0x0000c0
	#endif
#endif //_MIBEQU_H
