/****************************************************************************
* File:         $Workfile$
* Revision:     $Revision: 1.25 $
* Date:         $Date: 2012-05-23 12:44:15 $
*
* Overview:     
* Functions:
*
* Author:       Ian Tsao
* 
* -- Metanoia Copyright Notice --
*
* (C) Copyright 2005 Metanoia, Inc. All rights reserved.
* 
* Metanoia reserves the right to change specifications without notice. 
* Copyright 2005 Metanoia, Inc. All rights reserved. Preliminary Data-Sheet 
* indicates this product is in design and the specification may change. 
* Electrical parametrics have not been analyzed and are not specified. Do not 
* use this data sheet as a design reference document. Please contact Metanoia 
* for a current data sheet that may be used as a design reference. All 
* contents of this document are protected by copyright law and may not be 
* reproduced without the express written consent of Metanoia, Inc. Metanoia, 
* the Metanoia logo, and combinations thereof are trademarks of Metanoia, Inc. 
* Other product names used in this publication are for identification purposes 
* only and may be trademarks or registered trademarks of their respective 
* companies. The contents of this document are provided in connection with 
* Metanoia, Inc. products. Metanoia, Inc. has made best efforts to ensure that 
* the information contained herein is accurate and reliable. However, Metanoia, 
* Inc. makes no warranties, express or implied, as to the accuracy or 
* completeness of the contents of this publication and is providing this 
* publication 'as is'. Metanoia, Inc. reserves the right to make changes to 
* specifications and product descriptions at any time without notice, and to 
* discontinue or make changes to its products at any time without notice. 
* Metanoia, Inc. does not assume any liability arising out of the application 
* or use of any product or circuit, and specifically disclaims any and all 
* liability, including without limitation special, consequential, or 
* incidental damages.
* 
****************************************************************************/
#ifndef _IF_H_
#define _IF_H_

#define CONNECT_PORT "3"
#define DISCONNECT_PORT "4"
#define SHUTDOWN_CHIP "0"
#define INIT_MODEM "0"
#define RESET_MODEM "0"

#define MT_FIRMWARE_START 1
#define MT_FIRMWARE_CONT 2
#define MT_FIRMWARE_END 3
#define EOC_COMMAND 4

//#define dsl_er(r) ({mt_ret dsl_coderr =r; if(dsl_coderr!=MT_OK) return(dsl_coderr);})
#define dsl_er(r) ({mt_ret dsl_coderr = r; if(dsl_coderr != MT_OK) {PRINTL(DBG_LVL_IF|DBG_LVL_XML, "Error Code = %i", dsl_coderr); return DSL_ERR_NOTOK;}})
#define dsl_status(chipid) ({if(port_info[chipid].status == MT_OPSTATE_DISABLE) {PRINTL(DBG_LVL_IF|DBG_LVL_XML, "Port %i: Port disabled\n", chipid); return DSL_ERR_NOTOK;}})

#if defined (ICPLUS_IP3210) || defined (ATHEROS_AR93XX) || defined (REALTEK_RTL8672)
#define GET_PKG_INT(VALUE) (((VALUE & 0x000000ff) << 24) | ((VALUE & 0x0000ff00) << 8) | ((VALUE & 0x00ff0000) >> 8) | ((VALUE & 0xff000000) >> 24))	// transform integer value from little-endian to big-endian
#else
#define GET_PKG_INT(VALUE) (VALUE)	// transform integer value from little-endian to little-endian
#endif	//defined (ICPLUS_IP3210) || defined (ATHEROS_AR93XX) || defined (REALTEK_RTL8672)

typedef struct
{
	mt_uint32 total_chips;
//	fw_name fw[8];
//	mt_uint32 *pmap;
	mt_uint32 system_up;
}sys_info_struct;

typedef struct 
{
	mt_uint32 alarm_id;
}alarm_struct;

// -------------------------- Notification -----------------------
// OpState define
#define MT_OPSTATE_DISABLE		1
#define MT_OPSTATE_IDLE			2 ///< port enabled but not in other state
#define MT_OPSTATE_HANDSHAKE	3
#define MT_OPSTATE_TRAINING		4
#define MT_OPSTATE_SHOWTIME		5
#define MT_OPSTATE_ERROR		6
#define MT_OPSTATE_OTHER		7 // should not happen

/// parameter type, used in CheckParam
#define MT_PAR_PORT		1 
#define MT_PAR_GROUP	2
#define MT_PAR_TABLE	3
#define MT_PAR_IDX		4
#define MT_PAR_PARAM	5 
#define MT_PAR_CHIP		6

// GetPortMIB, SetPortMIB, ... index value
#define MT_IDX_OT		1
#define MT_IDX_RT		2
#define MT_IDX_LINE		2
#define MT_IDX_CHAN		4
#define MT_IDX_MAX		4

// fwinfo bit definition
#define MT_FW_TERMINAL 00000001 // 0-OT,1-RT 

// VDSL2 MIB minimum MIB variable size
#define DMT_WORD 3	// DMT word = 3 bytes = 24 bits
// VDSL2 MIB minimum MIB variable size
#define SMALL_BUF_SIZE 64
// VDSL2 MIB array medium size
#define BUF_SIZE 1080
// VDSL2 MIB array medium DMY WORD size
#define BUF_SIZE_DMT_WORD (BUF_SIZE/6)	// (1080/6) = 180, 1 DMT word = 3 bytes = 24 bits, we need 6 character to represent one DMT word in string format  
// VDSL2 MIB maximum MIB variable size
#define LARGE_BUF_SIZE (4096*3)
// VDSL2 MIB maximum OID length
#define OID_MAX_LEN 512
// VDSL2 MIB maximum Logic MIB table
#define MAXOID 30
// VDSL2 MIB maximum MIB variable size
#define MIBSTRSIZE 2048


// port struct
typedef struct
{
//	mt_uint32 fwinfo; // firmware information 
	mt_uint8 status; ///< value is MT_OPSTATE_* 
	mt_uint32 inv15_cur;
	mt_uint8 inv15_exist[(MT_INV_MAX15-1)/8 + 1]; // each bit present one interval is exist or not. Dividend minus 1 that's because if the dividend can be divided by divisor with no remainder than the quotient plus 1 will be "1" greater than the result we expected 
	mt_uint32 inv24_cur;
	mt_uint8 inv24_exist[(MT_INV_MAX24-1)/8 + 1]; // each bit present one interval is exist or not. 
}port_info_struct;

typedef enum {
	FALSE = 0,
	TRUE = 1
} truth_t;

extern port_info_struct port_info[MAX_PORTS];

//yalee981030 for tr069 showtime log value used
enum TR069_ShowTime_Log{
	TR069_SHOWTIME,                                                
	TR069_LAST_SHOWTIME,
	TR069_INIT_SHOWTIME,
	TR069_HISTORY_SHOWTIME,
	TR069_SIZE_SHOWTIME
};

enum TR069_ShowTime_Mib_Array{
	TR069_LinkRetrain,
	TR069_InitErrors,
	TR069_InitTimeouts,
	TR069_ErroredSecs,
	TR069_ATUCErroredSecs,
	TR069_SeverelyErroredSecs,
	TR069_ATUCSeverelyErroredSecs,
	TR069_FECErrors,
	TR069_ATUCFECErrors,
	TR069_CRCErrors,
	TR069_ATUCCRCErrors,
	TR069_OtTimeElapsed,
	TR069_OtFecs,
	TR069_OtLoss,
	TR069_OtUas,
	TR069_RtTimeElapsed,
	TR069_RtFecs,
	TR069_RtLoss,
	TR069_RtUas,
	TR069_ARRAY_SIZE
};


#ifndef __KERNEL__
extern mt_ret get_lib_version(mt_uint8 *version);
#endif	//__KERNEL__
extern mt_ret download_firmware(mt_uint8 chipid, mt_uint8 cmdID, mt_uint16 bufsize,mt_uint8* buffer);
extern mt_ret load_firmware_bindrv(mt_uint8 cmdID, mt_uint16 bufsize, mt_uint8* buffer);
extern mt_ret time_calibrate(void);
#if defined (SPI_ACCESS)
extern mt_ret flash_firmware(mt_uint8 cmdID, mt_uint16 bufsize, mt_uint8* buffer);
#endif //defined (SPI_ACCESS)
extern mt_ret connect_port(mt_uint32 portid);
extern mt_ret disconnect_port(mt_uint32 portid);
extern mt_ret set_port_data(mt_uint32 portid, mt_uint8 *oid, mt_uint8 *strvalue);
extern mt_ret set_port_data_logic(mt_uint32 portid, mt_uint8 *loid, mt_uint8 *strvalue);
extern mt_ret get_port_data(mt_uint32 portid, mt_uint8 *oid, mt_uint8 *strvalue);
extern mt_ret get_port_data_logic(mt_uint32 portid, mt_uint8 *loid, mt_uint8 *strvalue);
extern mt_ret get_port_data_logic_value_array(mt_uint32 portid, mt_uint8 *loid, mt_uint32 count, mt_uint32 *pvalue);
extern mt_ret set_port_mem(mt_uint32 portid, mt_uint32 address, mt_uint8 memtype, mt_uint8 *pdata);
//extern mt_ret set_port_mem_remote(mt_uint32 portid, mt_uint32 address, mt_uint32 length, mt_uint8 *pdata);
extern mt_ret get_port_mem(mt_uint32 portid, mt_uint32 address, mt_uint8 memtype, mt_uint8 *pdata);
extern mt_ret get_port_mem_remote(mt_uint32 portid, mt_uint32 address, mt_uint32 length, mt_uint8 *pdata);
#ifndef DOXYGEN
extern mt_ret check_param(mt_uint8 iType,mt_uint8 iCond,mt_uint32 value);
extern mt_ret oid2gtip(mt_uint8 *oid, mt_uint32 *groupid, mt_uint32 *tableid, mt_uint32 *paramid, mt_uint32 *idx, mt_uint32 *interval);
extern mt_ret spdl_body(mt_uint32 portid, mt_uint8 *loid, mt_uint8 *strvalue);
extern mt_ret gpdl_body(mt_uint32 portid, mt_uint8 *loid, mt_uint8 *strvalue);
extern mt_ret gpmr_body(mt_uint32 portid, mt_uint32 address, mt_uint32 length, mt_uint8 *pdata);
extern mt_ret new_dsp_set(mt_uint32 portid, mt_uint32 address, mt_uint8 memtype, mt_uint8 *pdata);
extern mt_ret new_dsp_get(mt_uint32 portid, mt_uint32 address, mt_uint8 memtype, mt_uint8 *pdata);
extern mt_ret get_mib2_header(mt_uint32 portid);
extern mt_ret get_mib2_info(mt_uint8 *loid, mt_uint32 *address, mt_uint32 *mibsize, mt_uint32 *mibtype);
#endif	//DOXYGEN
#endif	//_IF_H_
