#ifndef _GLOBAL_H_
#define _GLOBAL_H_

#include "vdsllib.h"
#ifdef __KERNEL__
#include <linux/completion.h>
#include "offtime.h"
#endif

//===vdsldrv.c===
#ifdef __KERNEL__
extern struct completion thread_exited;
#endif

//===mapper.c===
extern mt_uint32 map[MAX_CHIPS];

//===vdsllib.c===
#ifdef __KERNEL__
extern struct tm boottime;
#endif

extern mt_uint32 line15[MAX_PORTS][MT_IDX_LINE][MT_INV_MAX15][MT_LINE_SIZE15];
extern mt_uint32 lineinit15[MAX_PORTS][MT_IDX_LINE][MT_INV_MAX15][MT_LINEINIT_SIZE15];
extern mt_uint32 chan15[MAX_PORTS][MT_IDX_CHAN][MT_INV_MAX15][MT_CHAN_SIZE15];
extern mt_uint32 line24[MAX_PORTS][MT_IDX_LINE][MT_INV_MAX24][MT_LINE_SIZE24];
extern mt_uint32 lineinit24[MAX_PORTS][MT_IDX_LINE][MT_INV_MAX24][MT_LINEINIT_SIZE24];
extern mt_uint32 chan24[MAX_PORTS][MT_IDX_CHAN][MT_INV_MAX24][MT_CHAN_SIZE24];

//yalee980519 for tr069 
//#ifdef TR069
extern mt_uint32 gShowTimeLog[MAX_PORTS][TR069_ARRAY_SIZE][TR069_SIZE_SHOWTIME];
//#endif //TR069

//===chip.c===
extern int manuallen;
extern int readdsp;
extern chip_t chips[MAX_CHIPS];

//===if.c===
extern mt_uint8 connect_status;
extern mt_uint8 auto_reset;
extern mt_uint8 board_type;
extern unsigned long atomic_ops;
extern port_info_struct port_info[MAX_PORTS];
extern int add_start[100];
extern int bd[(16/4)*1024];

//===dsprw.c===
extern unsigned int rw_delay;
extern unsigned int r_delay;
extern unsigned int w_delay;
extern unsigned int trans_delay;
extern mt_uint8 err_recovery[MAX_PORTS];
extern port_t port[MAX_PORTS];

//===awardm.c===
#ifdef XENOS
extern volatile mt_uint8 *falcon_port;
#endif
#ifdef HOPE
extern volatile mt_uint8 *falcon_port;
#endif
#ifdef BOARD_A5
extern volatile mt_uint8 *falcon_port;
extern volatile mt_uint32 *databit_set;
extern volatile mt_uint32 *databit_clr;
#if defined (SPI_ACCESS)
extern volatile mt_uint32 *data_gpio;
extern mt_uint8 spibuf[60];
extern mt_uint8 buf_count;
#endif	//defined (SPI_ACCESS)
#endif

#endif	//_GLOBAL_H_
