#include "dsl.h"

//===vdsldrv.c===
#ifdef __KERNEL__
struct completion thread_exited;
#endif

//===mapper.c===
mt_uint32 map[MAX_CHIPS];

//===vdsllib.c===
#ifdef __KERNEL__
struct tm boottime;
#endif

mt_uint32 line15[MAX_PORTS][MT_IDX_LINE][MT_INV_MAX15][MT_LINE_SIZE15];
mt_uint32 lineinit15[MAX_PORTS][MT_IDX_LINE][MT_INV_MAX15][MT_LINEINIT_SIZE15];
mt_uint32 chan15[MAX_PORTS][MT_IDX_CHAN][MT_INV_MAX15][MT_CHAN_SIZE15];
mt_uint32 line24[MAX_PORTS][MT_IDX_LINE][MT_INV_MAX24][MT_LINE_SIZE24];
mt_uint32 lineinit24[MAX_PORTS][MT_IDX_LINE][MT_INV_MAX24][MT_LINEINIT_SIZE24];
mt_uint32 chan24[MAX_PORTS][MT_IDX_CHAN][MT_INV_MAX24][MT_CHAN_SIZE24];							
//yalee980519 for tr069 
//[MAX_PORTS][ArraySize][level];level:0.showtime 1.lastshowtime 2.init 3,history
//define in if.h
//#ifdef TR069
mt_uint32 gShowTimeLog[MAX_PORTS][TR069_ARRAY_SIZE][TR069_SIZE_SHOWTIME];
//#endif //TR069

//===chip.c===
int manuallen=0;
int readdsp=1;
chip_t chips[MAX_CHIPS];

//===if.c===
mt_uint8 connect_status = 0;
mt_uint8 auto_reset = 1;
mt_uint8 board_type = BOARD_HOPE;
unsigned long atomic_ops = FALSE;
port_info_struct port_info[MAX_PORTS];
int add_start[100];
int bd[(16/4)*1024];	//the space of 16K bytes equal to (16/4)*1024 integer

//===dsprw.c===
#ifdef XENOS
unsigned int w_delay = 0;			//0us under samsung
unsigned int rw_delay = 20000;		//600us under samsung
unsigned int r_delay = 0;			//0us under samsung
unsigned int trans_delay = 20000;	//600us under samsung, using busy waiting
//unsigned int trans_delay = 4;		//4ms under samsung, using non-busy waiting
//unsigned int trans_delay = 1;		//1ms under samsung, using non-busy waiting
#elif defined (HOPE)
unsigned int w_delay = 0;			//0us under samsung
unsigned int rw_delay = 20000;		//600us under samsung
unsigned int r_delay = 0;			//0us under samsung
unsigned int trans_delay = 20000;	//600us under samsung, using busy waiting
//unsigned int trans_delay = 4;		//4ms under samsung, using non-busy waiting
//unsigned int trans_delay = 1;		//1ms under samsung, using non-busy waiting
#elif defined (BOARD_A5)
#if defined (ICPLUS_IP3210)
unsigned int w_delay = 0;			//0us under icplus
unsigned int rw_delay = 30000;		//300us under icplus
unsigned int r_delay = 0;			//0us under icplus
unsigned int trans_delay = 30000;	//4ms under icplus, using busy waiting
//unsigned int trans_delay = 4;		//4ms under icplus, using non-busy waiting
//unsigned int trans_delay = 0;		//0ms under icplus, using non-busy waiting
#elif defined (ATHEROS_AR93XX)
unsigned int w_delay = 0;			//0us under atheros
unsigned int rw_delay = 30000;		//300us under atheros
unsigned int r_delay = 0;			//0us under atheros
unsigned int trans_delay = 30000;	//4ms under atheros, using busy waiting
//unsigned int trans_delay = 4;		//4ms under atheros, using non-busy waiting
//unsigned int trans_delay = 0;		//0ms under atheros, using non-busy waiting
#elif defined (REALTEK_RTL8672)
unsigned int w_delay = 0;			//0us under realtek
unsigned int rw_delay = 30000;		//300us under realtek
unsigned int r_delay = 0;			//0us under realtek
unsigned int trans_delay = 30000;	//4ms under realtek, using busy waiting
//unsigned int trans_delay = 4;		//4ms under realtek, using non-busy waiting
//unsigned int trans_delay = 0;		//0ms under realtek, using non-busy waiting
#elif defined (VITESS_VSC7501)
unsigned int w_delay = 0;			//0us under vitess
unsigned int rw_delay = 1000000;		//300us under vitess
unsigned int r_delay = 0;			//0us under vitess
unsigned int trans_delay = 1000000;	//4ms under vitess, using busy waiting
//unsigned int trans_delay = 4;		//4ms under vitess, using non-busy waiting
//unsigned int trans_delay = 0;		//0ms under vitess, using non-busy waiting
#elif defined (RALINK_RT3052) || defined (RALINK_RT3352)
unsigned int w_delay = 0;			//0us under ralink
unsigned int rw_delay = 30000;		//300us under ralink
unsigned int r_delay = 0;			//0us under ralink
unsigned int trans_delay = 30000;	//4ms under ralink, using busy waiting
//unsigned int trans_delay = 4;		//4ms under ralink, using non-busy waiting
//unsigned int trans_delay = 0;		//0ms under ralink, using non-busy waiting
#endif	//defined (ICPLUS_IP3210)
#else
unsigned int w_delay = 0;
unsigned int rw_delay = 0;
unsigned int r_delay = 0;
unsigned int trans_delay = 0;
#endif
mt_uint8 err_recovery[MAX_PORTS];
port_t port[MAX_PORTS];

//===awardm.c===
#ifdef XENOS
volatile mt_uint8 *falcon_port;
#endif	//XENOS
#ifdef HOPE
volatile mt_uint8 *falcon_port;
#endif	//HOPE
#ifdef BOARD_A5
volatile mt_uint8 *falcon_port;
volatile mt_uint32 *databit_set;
volatile mt_uint32 *databit_clr;
#if defined (SPI_ACCESS)
volatile mt_uint32 *data_gpio;
mt_uint8 spibuf[60];
mt_uint8 buf_count = 0;
#endif	//defined (SPI_ACCESS)
#endif	//BOARD_A5
