#include <linux/kernel.h>
#include <linux/module.h>
#include <linux/netdevice.h>
#include <linux/etherdevice.h>
#include <linux/time.h>
#include <linux/if.h>
#include <asm/bitops.h>
#include "dsl.h"

#define DRIVER "vdsl%d"
#define DELAYTIME 5

#define GIGA_PORT_0_LINK_STATUS_UP 0x10

int chain_rx_value(int port);
int chain_tx_value(int port);

static struct net_device *vdsl_dev[9];
static int ports = MAX_PORTS;
//static char *type = "award5";
//MODULE_PARM(type , "s");

typedef struct fakevdsl_private {
	struct net_device_stats stats;
	unsigned int iff_status;
	unsigned int last_time[8];
	unsigned int current_time[8];
//	void *mmio_addr; /* memory mapped IO addr */
//	unsigned long regs_len; /* length of IO or MMIO region */
}fakevdsl_private;

extern mt_ret get_phy_status(mt_uint32 portid, mt_uint8 *phy_status, mt_uint8 *conn_status);


static int fakevdsl_open(struct net_device *dev)
{
	int portid;
	
	portid = simple_strtoul( &dev->name[4], NULL, 0);
	connect_port(portid);
	((fakevdsl_private *)(dev->priv))->iff_status = 1;
	//printk("OPEN!!\n");
	
	return 0;
}

static int fakevdsl_stop(struct net_device *dev)
{
	int portid;
	
	portid = simple_strtoul( &dev->name[4], NULL, 0);
	disconnect_port(portid);
	((fakevdsl_private *)(dev->priv))->iff_status = 0;
	//printk("CLOSE!!\n");
	
	return 0;
}

static struct net_device_stats* fakevdsl_get_stats(struct net_device *dev)
{
	mt_uint8 phy_status;
	int ret;
	int portid;
	fakevdsl_private *tp = dev->priv;
	struct timeval tv;

	portid = simple_strtoul( &dev->name[4], NULL, 0);
#if defined (HOPE) || defined (XENOS)
	if(!strncmp(dev->name , "vdsl", 4)) { /* dev->name is vdsl */
		do_gettimeofday(&tv);
		tp->current_time[portid] = tv.tv_sec;
		//printk("<1>curr_time_%d=%d\n",portid,tp->current_time[portid]);
		if( (tp->current_time[portid] - tp->last_time[portid]) >= DELAYTIME){
			ret = get_phy_status(portid, &phy_status, NULL);
			do_gettimeofday(&tv);
			tp->last_time[portid] = tv.tv_sec;
			//printk("<1>last_time_%d=%d\n",portid,tp->last_time[portid]);

			//printk("<1>ret P%d=%d\n",portid,ret);
			//printk("<1>Status P%d=%d\n",portid,phy_status);
			//printk("<1>OP_Status P%d=%d\n",portid,op_status);

			if(tp->iff_status) {
				if(phy_status == MT_OPSTATE_SHOWTIME){ /* Showtime */
					set_bit(__LINK_STATE_START, &vdsl_dev[portid]->state);
					vdsl_dev[portid]->flags |= IFF_UP;
				}else if(phy_status == MT_OPSTATE_IDLE || phy_status == MT_OPSTATE_HANDSHAKE || phy_status == MT_OPSTATE_TRAINING){ /* Idle Handshake Traning */
					set_bit(__LINK_STATE_START, &vdsl_dev[portid]->state);
					vdsl_dev[portid]->flags |= IFF_UP;
				}else{
					if(phy_status == MT_OPSTATE_DISABLE){ /* Disable */
						clear_bit(__LINK_STATE_START, &vdsl_dev[portid]->state);
						vdsl_dev[portid]->flags &= (~IFF_UP);
					}else{
						printk("WARRING!!: get_phy_status error!!\n");
					}
				}
			}
			else {
				clear_bit(__LINK_STATE_START, &vdsl_dev[portid]->state);
				vdsl_dev[portid]->flags &= (~IFF_UP);
			}
		}

		//Reading byte counter from MIB
		tp->stats.rx_bytes = chain_rx_value(portid);
		tp->stats.tx_bytes = chain_tx_value(portid);
	}
#elif defined (BOARD_A5)
	if( !strncmp(dev->name , "vdsl", 4) ) { /* dev->name is vdsl */
		do_gettimeofday(&tv);
		tp->current_time[portid] = tv.tv_sec;
		//printk("<1>curr_time_4=%d\n",tp->current_time[4]);
		if( (tp->current_time[portid] - tp->last_time[portid]) >= DELAYTIME){
			ret = get_phy_status(0, &phy_status, NULL);

			do_gettimeofday(&tv);
			tp->last_time[portid] = tv.tv_sec;
			//printk("<1>last_time_0=%d\n",tp->last_time[0]);

			if(tp->iff_status) {
				if(phy_status == MT_OPSTATE_SHOWTIME){ /* Showtime */
					set_bit(__LINK_STATE_START, &vdsl_dev[0]->state);
					vdsl_dev[0]->flags |= IFF_UP;
				}else if(phy_status == MT_OPSTATE_IDLE || phy_status == MT_OPSTATE_HANDSHAKE || phy_status == MT_OPSTATE_TRAINING){ /* Idle Handshake Traning */
					set_bit(__LINK_STATE_START, &vdsl_dev[0]->state);
					vdsl_dev[0]->flags |= IFF_UP;
				}else{
					if(phy_status == MT_OPSTATE_DISABLE){ /* Disable */
						clear_bit(__LINK_STATE_START, &vdsl_dev[0]->state);
						vdsl_dev[0]->flags &= (~IFF_UP);
					}else{
						printk("WARRING!!: get_phy_status error!!\n");
					}
				}
			}
			else {
				clear_bit(__LINK_STATE_START, &vdsl_dev[portid]->state);
				vdsl_dev[portid]->flags &= (~IFF_UP);
			}
		}

		//Reading byte counter from MIB
		tp->stats.rx_bytes = chain_rx_value(portid);
		tp->stats.tx_bytes = chain_tx_value(portid);
	}
#endif

	return &(tp->stats);
}

static int fakevdsl_ioctl(struct net_device *dev, struct ifreq *ifr, int cmd)
{
	return -EINVAL;
}

int chain_rx_value(int port)
{
	mt_uint8 tmp[7];
	mt_uint8 buf[BUF_SIZE];
	mt_uint32 value;
	mt_ret ret;

	ret = get_port_mib(port, xdslMetanoiaOtRxPktCntr, buf);
	memset(tmp, 0, sizeof(tmp));
	memcpy(tmp, buf+2, 6);
	value = simple_strtoul(tmp, NULL, 16);

	return value;
}

int chain_tx_value(int port)
{
	mt_uint8 tmp[7];
	mt_uint8 buf[BUF_SIZE];
	mt_uint32 value;
	mt_ret ret;

	ret = get_port_mib(port, xdslMetanoiaOtTxPktCntr, buf);
	memset(tmp, 0, sizeof(tmp));
	memcpy(tmp, buf+2, 6);
	value = simple_strtoul(tmp, NULL, 16);

	return value;
}

int init_fakevdsl(void)
{
	int i;

	/* 
	 * alloc_etherdev allocates memory for dev and dev->priv.
	 * dev->priv shall have sizeof(fakevdsl_private) memory
	 * allocated.
	*/
	for(i=0;i<ports;i++) {
		vdsl_dev[i] = alloc_etherdev(sizeof(fakevdsl_private));
		if(!vdsl_dev[i]) {
			printk("<1>Could not allocate vdsl%d etherdev\n",i);
			return -1;
		}
		((fakevdsl_private *)(vdsl_dev[i]->priv))->iff_status = 1;
	}

#if defined (BOARD_A5)
	memcpy(vdsl_dev[0]->name, "vdsl", sizeof(DRIVER)); /* Device Name */
#elif defined (HOPE) || defined (XENOS)
	for( i=0 ; i<ports ; i++ ){
		memcpy(vdsl_dev[i]->name, DRIVER, sizeof(DRIVER)); /* Device Name */
	}
	//set_bit(__LINK_STATE_START, &vdsl_dev[8]->state);
#endif

	for( i=0 ; i<ports ;i++){
		vdsl_dev[i]->open	= fakevdsl_open;
		vdsl_dev[i]->stop	= fakevdsl_stop;
		vdsl_dev[i]->do_ioctl	= fakevdsl_ioctl;
		vdsl_dev[i]->get_stats	= fakevdsl_get_stats;
	}

	for( i=0 ; i<ports ;i++){
		if(register_netdev(vdsl_dev[i])) {
			printk("<1>Could not register netdevice vdsl%d\n",i);
		}
	}


	return 0;
}

void cleanup_fakevdsl_module(void)
{
	int i=0;

	for( i=0 ; i < ports ; i++){
		unregister_netdev(vdsl_dev[i]);
	}

	printk("<1>Unregister all devices\n");
}
