/****************************************************************************
* File:         $Workfile$
* Revision:     $Revision: 1.6 $
* Date:         $Date: 2010-04-14 08:32:36 $
*
* Overview:     
* Functions:
*
* Author:       Ian Tsao
* 
* -- Metanoia Copyright Notice --
*
* (C) Copyright 2005 Metanoia, Inc. All rights reserved.
* 
* Metanoia reserves the right to change specifications without notice. 
* Copyright 2005 Metanoia, Inc. All rights reserved. Preliminary Data-Sheet 
* indicates this product is in design and the specification may change. 
* Electrical parametrics have not been analyzed and are not specified. Do not 
* use this data sheet as a design reference document. Please contact Metanoia 
* for a current data sheet that may be used as a design reference. All 
* contents of this document are protected by copyright law and may not be 
* reproduced without the express written consent of Metanoia, Inc. Metanoia, 
* the Metanoia logo, and combinations thereof are trademarks of Metanoia, Inc. 
* Other product names used in this publication are for identification purposes 
* only and may be trademarks or registered trademarks of their respective 
* companies. The contents of this document are provided in connection with 
* Metanoia, Inc. products. Metanoia, Inc. has made best efforts to ensure that 
* the information contained herein is accurate and reliable. However, Metanoia, 
* Inc. makes no warranties, express or implied, as to the accuracy or 
* completeness of the contents of this publication and is providing this 
* publication 'as is'. Metanoia, Inc. reserves the right to make changes to 
* specifications and product descriptions at any time without notice, and to 
* discontinue or make changes to its products at any time without notice. 
* Metanoia, Inc. does not assume any liability arising out of the application 
* or use of any product or circuit, and specifically disclaims any and all 
* liability, including without limitation special, consequential, or 
* incidental damages.
* 
****************************************************************************/
#include "dsll2.h"

#define HOST_PAB_00 0xA5
#define HOST_PAB_01 0x5A

//static DECLARE_MUTEX(mr_sem_dsprw);

mt_uint32 dsp_frame_exchange(mt_uint32 portid, mt_uint8 *pframe)
{
	int i, j;
	static mt_uint32 counter[8] = {0,0,0,0,0,0,0,0};
	static mt_uint32 access[8] = {0,0,0,0,0,0,0,0}, access_cnt[8] = {0,0,0,0,0,0,0,0};
	mt_uint8 *pbuf;
	mt_uint16 fcs;
	//mt_uint32 count;
	volatile mt_uint32* gpio_mode = (mt_uint32*) 0xF0030000;//yalee990419 test
	volatile mt_uint32* gpio_pcon = (mt_uint32*) 0xF0030008;//yalee990419 test
	volatile mt_uint32* gpio_data = (mt_uint32*) 0xF003001C;//yalee990419 test

	//down_interruptible(&mr_sem_dsprw);

start_exchange:
	//delay for gap of two transactions and also for IRQ trigger delay
	//for(i=0;i<trans_delay;i++);
	access[portid] = access[portid] + 1;
	if(access[portid] == 50000) {
		access[portid] = 0;
		access_cnt[portid] = access_cnt[portid] + 1;
		printk("50000 access happens: %d\n", access_cnt[portid]);
		printk("Port%d CRC counter: %d\n", portid, counter[portid]);
	}
	MSLEEP(trans_delay);

	pbuf = &chips[portid].buf[0];
	memset(pbuf, 0, sizeof(chips[portid].buf));

	/*printk("Write Data: ");
	for(j=0;j<8;j++) {
		printk("%02x ", pframe[j]);
	}
	printk("\n");*/

//transaction:
	for(j=0;j<8;j++) {
		write_hpi_8(portid, pframe[j]);
		for(i=0;i<w_delay;i++);
	}
		
	for(i=0;i<rw_delay;i++);

	/*while(1) {
		pbuf[0] = read_hpi_8(portid);
		for(i=0;i<r_delay;i++);
		pbuf[1] = read_hpi_8(portid);
		for(i=0;i<r_delay;i++);
		//printf("%02x ", pbuf[0]);
		//printf("%02x ", pbuf[1]);
		if(	pbuf[0] != HOST_PAB_00 || pbuf[1] != HOST_PAB_01) {	// DMT no respond, issue error recovery
			error_recovery();
			goto transaction;
		}
		else
			break;
	}*/

	for(j=0;j<8;j++) {
		pbuf[j] = read_hpi_8(portid);
		for(i=0;i<r_delay;i++);
	}

	/*printk("Read Data: ");
	for(j=0;j<8;j++) {
		printk("%02x ", pbuf[j]);
	}
	printk("\n");*/

	/*if(!data_check())
		goto transaction;*/ 

	//ctrl_payload_frame
	fcs = HDLC_FCS_INIT;
	for(i=0;i<6;i++) {
		fcs = fcs_update(pbuf[i], fcs);
	}
	fcs = ~fcs;

	if((fcs & 0x00ff) != pbuf[6] || ((fcs & 0xff00) >> 8) != pbuf[7]) {
		counter[portid] = counter[portid] + 1;
		printk("Port%d CRC counter: %d\n", portid, counter[portid]);
		printk("yalee portid %d\n", portid);
		if(portid == 1){
			*gpio_mode &= 0xfffffffc;//yalee990419 test
			*gpio_pcon |= 0x00000003;//yalee990419 test maybe not need set
			printk("yalee test mode %x pcon %x\n", *gpio_mode, *gpio_pcon);
			*gpio_data &= 0xfffffffc;//yalee990419 test
			printk("yalee test %x \n", *gpio_data);
			*gpio_data |= 0x00000003;//yalee990419 test
			printk("yalee test %x \n", *gpio_data);
		}

		if(err_recovery == 5) {
			printk("Port%d HPI CAN NOT be recovered from error status!!\n", portid);
			//err_recovery = 0;
		}
		else {
			err_recovery++;

			PRINTL(DBG_LVL_IF, "Write Data: ");
			for(j=0;j<8;j++) {
				PRINTL(DBG_LVL_IF, "%02x ", pframe[j]);
			}
			PRINTL(DBG_LVL_IF, "\n");

			PRINTL(DBG_LVL_IF, "Read Data: ");
			for(j=0;j<8;j++) {
				PRINTL(DBG_LVL_IF, "%02x ", pbuf[j]);
			}
			PRINTL(DBG_LVL_IF, "\n");

			PRINTL(DBG_LVL_IF, "Port%d CRC(0x%04x) error!!\n", portid, fcs);

			PRINTL(DBG_LVL_IF, "Clearing HPI read buffer...\n");
			//delay for waiting to clear HPI read buffer
			for(i=0;i<trans_delay;i++);
			PRINTL(DBG_LVL_IF, "Read Data: ");
			for(j=0;j<8;j++) {
				pbuf[j] = read_hpi_8(portid);
				PRINTL(DBG_LVL_IF, "%02x ", pbuf[j]);
				for(i=0;i<r_delay;i++);
			}
			PRINTL(DBG_LVL_IF, "\n");
			PRINTL(DBG_LVL_IF, "Done!!\n");

			goto start_exchange;
		}
	}
	else {
		err_recovery = 0;
	}

	//up(&mr_sem_dsprw);

	return MT_OK;
}


mt_ret new_dsp_set (mt_uint32 portid, mt_uint32 address, mt_uint8 memtype, mt_uint8 *pdata)
{
	mt_uint16 fcs;
	mt_uint8 i;
	mt_uint8 cbuf[8];

	//send_frame_port
	port[portid].lastcmdid++;
	if(port[portid].lastcmdid >= 8)
		port[portid].lastcmdid = 0;

	cbuf[0] = (portid & 0x00ff) << 6 | 0x20 | (memtype << 3) | port[portid].lastcmdid;	//portid | write_cmd | memtype | SEQ_NUMBER
	
	cbuf[1] = (address & 0x00ff00) >> 8;
	cbuf[2] = address & 0x0000ff;
	cbuf[3] = pdata[0];
	cbuf[4] = pdata[1];
	cbuf[5] = pdata[2];

	//ctrl_payload_frame
	fcs = HDLC_FCS_INIT;
	for(i=0;i<6;i++) {
		fcs = fcs_update(cbuf[i], fcs);
	}
	fcs = ~fcs;

	cbuf[6] = fcs & 0x00ff;
	cbuf[7] = (fcs & 0xff00) >> 8;
	
	//dsp_frame_exchange should check the correctness of each transaction and issue error recovery if error occured
	return  dsp_frame_exchange(portid, cbuf);
}

mt_ret new_dsp_get (mt_uint32 portid, mt_uint32 address, mt_uint8 memtype, mt_uint8 *pdata)
{
	mt_ret ret;
	mt_uint16 fcs;
	mt_uint8 i;
	mt_uint8 cbuf[8];

	//send_frame_port
	port[portid].lastcmdid++;
	if(port[portid].lastcmdid >= 8)
		port[portid].lastcmdid = 0;

	cbuf[0] = (portid & 0x00ff) << 6 | 0x00 | (memtype << 3) | port[portid].lastcmdid;	//portid | read_cmd | memtype | SEQ_NUMBER
	
	cbuf[1] = (address & 0x00ff00) >> 8;
	cbuf[2] = address & 0x0000ff;
	cbuf[3] = 0x00;
	cbuf[4] = 0x00;
	cbuf[5] = 0x00;

	//ctrl_payload_frame
	fcs = HDLC_FCS_INIT;
	for(i=0;i<6;i++) {
		fcs = fcs_update(cbuf[i], fcs);
	}
	fcs = ~fcs;

	cbuf[6] = fcs & 0x00ff;
	cbuf[7] = (fcs & 0xff00) >> 8;	
	
	//dsp_frame_exchange should check the correctness of each transaction and issue error recovery if error occured
	ret = dsp_frame_exchange(portid, cbuf);

	if(ret != MT_OK) return ret;

	get_port_buffer(portid, pdata);
	
	return MT_OK;
}
