/****************************************************************************
* File:         $Workfile$
* Revision:     $Revision: 1.16 $
* Date:         $Date: 2012-01-05 09:07:27 $
*
* Overview:     
* Functions:
*
* Author:       Ian Tsao
* 
* -- Metanoia Copyright Notice --
*
* (C) Copyright 2005 Metanoia, Inc. All rights reserved.
* 
* Metanoia reserves the right to change specifications without notice. 
* Copyright 2005 Metanoia, Inc. All rights reserved. Preliminary Data-Sheet 
* indicates this product is in design and the specification may change. 
* Electrical parametrics have not been analyzed and are not specified. Do not 
* use this data sheet as a design reference document. Please contact Metanoia 
* for a current data sheet that may be used as a design reference. All 
* contents of this document are protected by copyright law and may not be 
* reproduced without the express written consent of Metanoia, Inc. Metanoia, 
* the Metanoia logo, and combinations thereof are trademarks of Metanoia, Inc. 
* Other product names used in this publication are for identification purposes 
* only and may be trademarks or registered trademarks of their respective 
* companies. The contents of this document are provided in connection with 
* Metanoia, Inc. products. Metanoia, Inc. has made best efforts to ensure that 
* the information contained herein is accurate and reliable. However, Metanoia, 
* Inc. makes no warranties, express or implied, as to the accuracy or 
* completeness of the contents of this publication and is providing this 
* publication 'as is'. Metanoia, Inc. reserves the right to make changes to 
* specifications and product descriptions at any time without notice, and to 
* discontinue or make changes to its products at any time without notice. 
* Metanoia, Inc. does not assume any liability arising out of the application 
* or use of any product or circuit, and specifically disclaims any and all 
* liability, including without limitation special, consequential, or 
* incidental damages.
* 
****************************************************************************/
#include <linux/proc_fs.h>
#include "dsll2.h"


#if defined (SPI_ACCESS)
/*mt_ret new_dsp_get(mt_uint32 portid, mt_uint32 address, mt_uint8 memtype, mt_uint8 *pdata)
{
	mt_uint32 gpio_value;
	volatile mt_uint32 *gpio_addr;
	mt_uint8 buffer[256];
	mt_uint8 i;
	mt_uint32 j;

	// config selected pin as SPI output/input pin
	gpio_addr = (volatile mt_uint32 *)ioremap(0xA300500C, 0x2);
	gpio_value = *gpio_addr;
	gpio_value |= COCPE | RESET | SCKB | SC2B | SPI_SRDB;	//output
	gpio_value &= ~(SPI_STDB);	//input
	*gpio_addr = gpio_value;

	//Pull DMT RESET
	*databit_clr = RESET;

	//00 00 00 00 02 1d 30 6d 25 3d da 00 be 00 00 00
	for(j=0;j<600000;j++);

	//Read Flash
	spi_read_data(0x00000000, 8, buffer);
	for(i=0;i<8;i++) {
		printk("%02x", buffer[i]);
		if (((i+1) % 16) == 0) printk("\n");
	}
	printk("\n");

	buffer[0] = 0x00;
	buffer[1] = 0x01;
	buffer[2] = 0x02;
	buffer[3] = 0x03;
	buffer[4] = 0x04;
	buffer[5] = 0x05;
	buffer[6] = 0x06;
	buffer[7] = 0x07;
	spi_erase_block(0);
	spi_write_data(0x00000000, 8, buffer);

	//Read Flash
	spi_read_data(0x00000000, 8, buffer);
	for(i=0;i<8;i++) {
		printk("%02x", buffer[i]);
		if (((i+1) % 8) == 0) printk("\n");
	}
	printk("\n");

	buffer[0] = 0x00;
	buffer[1] = 0x00;
	buffer[2] = 0x00;
	buffer[3] = 0x00;
	buffer[4] = 0x02;
	buffer[5] = 0x1d;
	buffer[6] = 0x30;
	buffer[7] = 0x6d;
	spi_erase_block(0);
	spi_write_data(0x00000000, 8, buffer);

	//Read Flash
	spi_read_data(0x00000000, 8, buffer);
	for(i=0;i<8;i++) {
		printk("%02x", buffer[i]);
		if (((i+1) % 16) == 0) printk("\n");
	}
	printk("\n");

	//Release DMT RESET
	*databit_set = RESET;

	// config selected pin as DMT output/input pin
	gpio_addr = (volatile mt_uint32 *)ioremap(0xA300500C, 0x2);
	gpio_value = *gpio_addr;
	gpio_value |= COCPE | RESET | SCKB | SC2B | DMT_SRDB;	//output
	gpio_value &= ~(DMT_STDB);	//input
	*gpio_addr = gpio_value;

	return MT_OK;
}*/
mt_ret new_dsp_set(mt_uint32 portid, mt_uint32 address, mt_uint8 memtype, mt_uint8 *pdata)
{
	mt_uint8 i, j;

	if(memtype == MT_MEMTYPE_X) memtype = SPI_MEMTYPE_X;
	else if(memtype == MT_MEMTYPE_Y) memtype = SPI_MEMTYPE_Y;
	else if(memtype == MT_MEMTYPE_P) memtype = SPI_MEMTYPE_P;
	else {
		return DSL_ERR_NOTOK;
	}

	for(i=0;i<5;i++) {
		write_spi_9(address, memtype, pdata);
		for(j=0;j<10;j++) {
			write_spi_null();
			if(spibuf[2] == 0x12) {
				write_spi_null();
				if(spibuf[2] == 0xe0) {
					return MT_OK;
				}
				else {
					break;
				}
			}
			else {
				continue;
			}
		}
	}

	return DSL_ERR_NOTOK;
}


mt_ret new_dsp_get(mt_uint32 portid, mt_uint32 address, mt_uint8 memtype, mt_uint8 *pdata)
{
	mt_uint8 i, j;

	if(memtype == MT_MEMTYPE_X) memtype = SPI_MEMTYPE_X;
	else if(memtype == MT_MEMTYPE_Y) memtype = SPI_MEMTYPE_Y;
	else if(memtype == MT_MEMTYPE_P) memtype = SPI_MEMTYPE_P;
	else {
		return DSL_ERR_NOTOK;
	}

	for(i=0;i<5;i++) {
		read_spi_3(address, memtype);
		for(j=0;j<10;j++) {
			write_spi_null();
			if(spibuf[2] == 0x1a) {
				pdata[0] = spibuf[0];
				pdata[1] = spibuf[1];
				write_spi_null();
				if(spibuf[2] == 0x1c) {
					pdata[2] = spibuf[0];
					return MT_OK;
				}
				else {
					break;
				}
			}
			else {
				continue;
			}
		}
	}

	return DSL_ERR_NOTOK;
}
#else	//HPI_ACCESS
#define RECOVERY_THRESHOLD 10
#ifdef OPENWRT
static DEFINE_SEMAPHORE(mr_sem_dsprw);
#else
static DECLARE_MUTEX(mr_sem_dsprw);
#endif	//OPENWRT


mt_uint32 dsp_frame_exchange(mt_uint32 portid, mt_uint8 *pframe)
{
	static int sem_ret;
	mt_uint8 *pbuf;
	mt_uint16 fcs;
	mt_uint32 i, j;

	if(err_recovery[portid] == RECOVERY_THRESHOLD) {
		PRINTL(DBG_LVL_IF, "Port%d HPI CAN NOT be recovered from error status!!\n", portid);
		return DSL_ERR_NOTOK;
	}

	sem_ret = down_interruptible(&mr_sem_dsprw);

start_exchange:
	//delay for gap of two transactions and also for IRQ trigger delay
#ifdef VITESS_VSC7501
	mdelay(1);
#else
	for(i=0;i<trans_delay;i++);
	//MSLEEP(trans_delay);
#endif

	pbuf = &chips[portid].buf[0];
	memset(pbuf, 0, sizeof(chips[portid].buf));

	/*printk("Write Data: ");
	for(j=0;j<8;j++) {
		printk("%02x ", pframe[j]);
	}
	printk("\n");*/

//transaction:
	for(j=0;j<8;j++) {
		write_hpi_8(portid, pframe[j]);
		for(i=0;i<w_delay;i++);
	}

#ifdef VITESS_VSC7501
	mdelay(1);
#else
	for(i=0;i<rw_delay;i++);
#endif

	/*while(1) {
		pbuf[0] = read_hpi_8(portid);
		for(i=0;i<r_delay;i++);
		pbuf[1] = read_hpi_8(portid);
		for(i=0;i<r_delay;i++);
		//printf("%02x ", pbuf[0]);
		//printf("%02x ", pbuf[1]);
		if(	pbuf[0] != HOST_PAB_00 || pbuf[1] != HOST_PAB_01) {	// DMT no respond, issue error recovery
			error_recovery();
			goto transaction;
		}
		else
			break;
	}*/

	for(j=0;j<8;j++) {
		pbuf[j] = read_hpi_8(portid);
		for(i=0;i<r_delay;i++);
	}

	/*printk("Read Data: ");
	for(j=0;j<8;j++) {
		printk("%02x ", pbuf[j]);
	}
	printk("\n");*/

	/*if(!data_check())
		goto transaction;*/ 

	//ctrl_payload_frame
	fcs = HDLC_FCS_INIT;
	for(i=0;i<6;i++) {
		fcs = fcs_update(pbuf[i], fcs);
	}
	fcs = ~fcs;

	if((fcs & 0x00ff) != pbuf[6] || ((fcs & 0xff00) >> 8) != pbuf[7]) {
		if(err_recovery[portid] == RECOVERY_THRESHOLD) {
			PRINTL(DBG_LVL_IF, "Port%d HPI CAN NOT be recovered from error status!!\n", portid);
			//err_recovery[portid] = 0;
		}
		else {
			err_recovery[portid]++;

			PRINTL(DBG_LVL_IF, "Write Data: ");
			for(j=0;j<8;j++) {
				PRINTL(DBG_LVL_IF, "%02x ", pframe[j]);
			}
			PRINTL(DBG_LVL_IF, "\n");

			PRINTL(DBG_LVL_IF, "Read Data: ");
			for(j=0;j<8;j++) {
				PRINTL(DBG_LVL_IF, "%02x ", pbuf[j]);
			}
			PRINTL(DBG_LVL_IF, "\n");

			PRINTL(DBG_LVL_IF, "Port%d CRC(0x%04x) error!!\n", portid, fcs);

			goto start_exchange;
		}
	}
	else {
		err_recovery[portid] = 0;
	}

	up(&mr_sem_dsprw);

	return MT_OK;
}


void get_port_buffer(mt_uint32 portid, mt_uint8 *pdata)
{
	pdata[0] = chips[portid].buf[F4_PEEK_CMD_OFFSET];
	pdata[1] = chips[portid].buf[F4_PEEK_CMD_OFFSET+1];
	pdata[2] = chips[portid].buf[F4_PEEK_CMD_OFFSET+2];
}


mt_ret new_dsp_set(mt_uint32 portid, mt_uint32 address, mt_uint8 memtype, mt_uint8 *pdata)
{
	mt_uint16 fcs;
	mt_uint8 i;
	mt_uint8 cbuf[8];
	//send_frame_port
	port[portid].lastcmdid++;
	if(port[portid].lastcmdid >= 8)
		port[portid].lastcmdid = 0;

	cbuf[0] = (portid & 0x00ff) << 6 | 0x20 | (memtype << 3) | port[portid].lastcmdid;	//portid | write_cmd | memtype | SEQ_NUMBER

	cbuf[1] = (address & 0x00ff00) >> 8;
	cbuf[2] = address & 0x0000ff;
	cbuf[3] = pdata[0];
	cbuf[4] = pdata[1];
	cbuf[5] = pdata[2];

	//ctrl_payload_frame
	fcs = HDLC_FCS_INIT;
	for(i=0;i<6;i++) {
		fcs = fcs_update(cbuf[i], fcs);
	}
	fcs = ~fcs;

	cbuf[6] = fcs & 0x00ff;
	cbuf[7] = (fcs & 0xff00) >> 8;

	//dsp_frame_exchange should check the correctness of each transaction and issue error recovery if error occured
	return  dsp_frame_exchange(portid, cbuf);
}


mt_ret new_dsp_get(mt_uint32 portid, mt_uint32 address, mt_uint8 memtype, mt_uint8 *pdata)
{
	mt_ret ret;
	mt_uint16 fcs;
	mt_uint8 i;
	mt_uint8 cbuf[8];

	//send_frame_port
	port[portid].lastcmdid++;
	if(port[portid].lastcmdid >= 8)
		port[portid].lastcmdid = 0;

	cbuf[0] = (portid & 0x00ff) << 6 | 0x00 | (memtype << 3) | port[portid].lastcmdid;	//portid | read_cmd | memtype | SEQ_NUMBER
	
	cbuf[1] = (address & 0x00ff00) >> 8;
	cbuf[2] = address & 0x0000ff;
	cbuf[3] = 0x00;
	cbuf[4] = 0x00;
	cbuf[5] = 0x00;

	//ctrl_payload_frame
	fcs = HDLC_FCS_INIT;
	for(i=0;i<6;i++) {
		fcs = fcs_update(cbuf[i], fcs);
	}
	fcs = ~fcs;

	cbuf[6] = fcs & 0x00ff;
	cbuf[7] = (fcs & 0xff00) >> 8;	
	
	//dsp_frame_exchange should check the correctness of each transaction and issue error recovery if error occured
	ret = dsp_frame_exchange(portid, cbuf);

	if(ret != MT_OK) return ret;

	get_port_buffer(portid, pdata);
	
	return MT_OK;
}
#endif	//defined (SPI_ACCESS)
