/****************************************************************************
* File:         $Workfile$
* Revision:     $Revision: 1.3 $
* Date:         $Date: 2012-05-23 12:44:15 $
*
* Overview:     
* Functions:
*
* Author:       Ian Tsao
* 
* -- Metanoia Copyright Notice --
*
* (C) Copyright 2005 Metanoia, Inc. All rights reserved.
* 
* Metanoia reserves the right to change specifications without notice. 
* Copyright 2005 Metanoia, Inc. All rights reserved. Preliminary Data-Sheet 
* indicates this product is in design and the specification may change. 
* Electrical parametrics have not been analyzed and are not specified. Do not 
* use this data sheet as a design reference document. Please contact Metanoia 
* for a current data sheet that may be used as a design reference. All 
* contents of this document are protected by copyright law and may not be 
* reproduced without the express written consent of Metanoia, Inc. Metanoia, 
* the Metanoia logo, and combinations thereof are trademarks of Metanoia, Inc. 
* Other product names used in this publication are for identification purposes 
* only and may be trademarks or registered trademarks of their respective 
* companies. The contents of this document are provided in connection with 
* Metanoia, Inc. products. Metanoia, Inc. has made best efforts to ensure that 
* the information contained herein is accurate and reliable. However, Metanoia, 
* Inc. makes no warranties, express or implied, as to the accuracy or 
* completeness of the contents of this publication and is providing this 
* publication 'as is'. Metanoia, Inc. reserves the right to make changes to 
* specifications and product descriptions at any time without notice, and to 
* discontinue or make changes to its products at any time without notice. 
* Metanoia, Inc. does not assume any liability arising out of the application 
* or use of any product or circuit, and specifically disclaims any and all 
* liability, including without limitation special, consequential, or 
* incidental damages.
* 
****************************************************************************/
/**
 * \file 
 * \brief major header
 */
#ifndef _DSL_H_
#define _DSL_H_

/**
 * Enable internal debug feature. should be undefine in release mode
 */
#define MT_TRACE 

// include L2 header
#include "dsll2.h"

// include L3 header
#include "dsltype.h"
#include "mibequ.h"
#include "vdsllib.h"

/* include debug function
 *  library */
#ifdef MT_DEBUG
#include "vdsllibdebug.h"
#endif

#endif //_DSL_H_

/**
 * 
 * 
 * \mainpage
 * 
 * \section Overview
 * The functionality of important files
 * - cli / dslcli.h   : Command Line Interface for manipulating the Metanoia APIs
 * - cli / clitr069.h : API set that Metanoia provide for TR-069 integration
 * - driver / vdsllib.h : API set that Metanoia provide
 * - driver / if.h      : Communication module interface API
 * - driver / if2.h     : Functional communication module interface
 * - driver / dsl.h     : The only header user need to include
 * - driver / userdef.h : User customization definition
 *  
 * \section software_structure Software Structure
 * \image html vdslapi.png
 * \section License
 * Metanoia reserves the right to change specifications without notice.  Copyright 2005 Metanoia, Inc.  All rights reserved.  All contents of this document are protected by copyright law and may not be reproduced without the express written consent of Metanoia, Inc.  Metanoia, the Metanoia logo, and combinations thereof are trademarks of Metanoia, Inc.  Other product names used in this publication are for identification purposes only and may be trademarks or registered trademarks of their respective companies.  The contents of this document are provided in connection with Metanoia, Inc. products.  Metanoia, Inc. has made best efforts to ensure that the information contained herein is accurate and reliable.  However, Metanoia, Inc. makes no warranties, express or implied, as to the accuracy or completeness of the contents of this publication and is providing this publication 'as is'.  Metanoia, Inc. reserves the right to make changes to specifications and product descriptions at any time without notice, and to discontinue or make changes to its products at any time without notice.  
 * 
 * 
 * 
 */
