/****************************************************************************
* File:         $Workfile$
* Revision:     $Revision: 1.9 $
* Date:         $Date: 2011-05-02 10:34:39 $
*
* Overview:     
* Functions:
*
* Author:       Ian Tsao
* 
* -- Metanoia Copyright Notice --
*
* (C) Copyright 2005 Metanoia, Inc. All rights reserved.
* 
* Metanoia reserves the right to change specifications without notice. 
* Copyright 2005 Metanoia, Inc. All rights reserved. Preliminary Data-Sheet 
* indicates this product is in design and the specification may change. 
* Electrical parametrics have not been analyzed and are not specified. Do not 
* use this data sheet as a design reference document. Please contact Metanoia 
* for a current data sheet that may be used as a design reference. All 
* contents of this document are protected by copyright law and may not be 
* reproduced without the express written consent of Metanoia, Inc. Metanoia, 
* the Metanoia logo, and combinations thereof are trademarks of Metanoia, Inc. 
* Other product names used in this publication are for identification purposes 
* only and may be trademarks or registered trademarks of their respective 
* companies. The contents of this document are provided in connection with 
* Metanoia, Inc. products. Metanoia, Inc. has made best efforts to ensure that 
* the information contained herein is accurate and reliable. However, Metanoia, 
* Inc. makes no warranties, express or implied, as to the accuracy or 
* completeness of the contents of this publication and is providing this 
* publication 'as is'. Metanoia, Inc. reserves the right to make changes to 
* specifications and product descriptions at any time without notice, and to 
* discontinue or make changes to its products at any time without notice. 
* Metanoia, Inc. does not assume any liability arising out of the application 
* or use of any product or circuit, and specifically disclaims any and all 
* liability, including without limitation special, consequential, or 
* incidental damages.
* 
****************************************************************************/
#ifndef _DEBUGP_H_
#define _DEBUGP_H_


#define DBG_LVL_IF		0x00000001
#define DBG_LVL_SNMPT	0x00000002
#define DBG_LVL_EOC		0x00000004
#define DBG_LVL_LIB		0x00000008	///< in vdsllib lib level
#define DBG_LVL_PORT	0x00000010
#define DBG_LVL_HDLC	0x00000020
#define DBG_LVL_MAPPER	0x00000040
#define DBG_LVL_CHIP	0x00000080
#define DBG_LVL_BOARD	0x00000100
#define DBG_LVL_MISC	0x00000200
#define DBG_LVL_CLI		0x00000400
#define DBG_LVL_SETUP	0x00000800
#define DBG_LVL_CLIDBG	0x00001000
#define DBG_LVL_STATUS	0x00002000
#define DBG_LVL_OPTION	0x00004000
#define DBG_LVL_XML		0x80000000	///< special flag for silent mode to return xml tags
#define DBG_LVL_ALWAYS	0x7fffffff  ///< show it in any level
#define DBG_LVL_NONE	0x00000000

#ifdef __KERNEL__
#define PRINTD printk
#define FREE kfree
#else
#define PRINTD printf
#define FREE free
#endif

#define SPI_MEMTYPE_P 0x00
#define SPI_MEMTYPE_X 0x40
#define SPI_MEMTYPE_Y 0x80

#define MT_MEMTYPE_X 0x00
#define MT_MEMTYPE_Y 0x01
#define MT_MEMTYPE_P 0x02

#define MT_X_MEM_BOUND 0xffff
#define MT_Y_MEM_BOUND 0xffff
#define MT_P_MEM_BOUND 0xffff

#define MSG_BUFFER_SIZE 16384

#ifndef __KERNEL__
extern char msg_buf[MSG_BUFFER_SIZE];
#endif
extern mt_uint32 debug_level;

#ifdef IOCTL_INTRFCE
extern mt_ret set_debug_level(mt_uint32 lvl);
#else
extern void set_debug_level(mt_uint32 lvl);
#endif
extern void get_debug_level(mt_uint32 *lvl);
extern void PRINTL(mt_uint32 level,const char *fmt, ...);

#endif	//_DEBUGP_H_
