/****************************************************************************
* File:         $Workfile$
* Revision:     $Revision: 1.2 $
* Date:         $Date: 2010-05-19 02:21:47 $
*
* Overview:     
* Functions:
*
* Author:       Ian Tsao
* 
* -- Metanoia Copyright Notice --
*
* (C) Copyright 2005 Metanoia, Inc. All rights reserved.
* 
* Metanoia reserves the right to change specifications without notice. 
* Copyright 2005 Metanoia, Inc. All rights reserved. Preliminary Data-Sheet 
* indicates this product is in design and the specification may change. 
* Electrical parametrics have not been analyzed and are not specified. Do not 
* use this data sheet as a design reference document. Please contact Metanoia 
* for a current data sheet that may be used as a design reference. All 
* contents of this document are protected by copyright law and may not be 
* reproduced without the express written consent of Metanoia, Inc. Metanoia, 
* the Metanoia logo, and combinations thereof are trademarks of Metanoia, Inc. 
* Other product names used in this publication are for identification purposes 
* only and may be trademarks or registered trademarks of their respective 
* companies. The contents of this document are provided in connection with 
* Metanoia, Inc. products. Metanoia, Inc. has made best efforts to ensure that 
* the information contained herein is accurate and reliable. However, Metanoia, 
* Inc. makes no warranties, express or implied, as to the accuracy or 
* completeness of the contents of this publication and is providing this 
* publication 'as is'. Metanoia, Inc. reserves the right to make changes to 
* specifications and product descriptions at any time without notice, and to 
* discontinue or make changes to its products at any time without notice. 
* Metanoia, Inc. does not assume any liability arising out of the application 
* or use of any product or circuit, and specifically disclaims any and all 
* liability, including without limitation special, consequential, or 
* incidental damages.
* 
****************************************************************************/
#include "mttypes.h"
#include "debugp.h"

#ifdef __KERNEL__
#include <linux/kernel.h>
#include <linux/slab.h>
#else
#include <stdarg.h>
#include <stdio.h>
#endif

#ifdef IOCTL_INTRFCE
#include "ioctlmeta.h"
#include <fcntl.h>
#include <sys/ioctl.h>
#include <sys/types.h>
#include <sys/stat.h>

#define OPEN_VDSL(vdslfd) ({vdslfd=open("/dev/vdsl", O_RDWR);if(vdslfd == -1){printf("vdsl device open failed.\n");return -1;}})

int vdslfd;
char ioctl_buf[64];
mt_ret ret;
#endif

#define PMEM_SIZE 100

#ifndef __KERNEL__
char msg_buf[MSG_BUFFER_SIZE];
#endif
#ifdef MT_DEBUG
mt_uint32 debug_level = 0xffffffff;
#else
mt_uint32 debug_level = 0x0;
#endif

#ifdef IOCTL_INTRFCE
/**
 * 
 * We maintain two different debug_level in user space and kernel space
 * then sync them through IOCTL here. Change function prototype of 
 * set_debug_level() from void to mt_ret is generalizng all the APIs
 * through IOCTL to one.
 * 
 */
mt_ret set_debug_level(mt_uint32 lvl)
{
	debug_level = lvl;

	OPEN_VDSL(vdslfd);
	ioctl_buf[0]=(lvl & 0xff000000)>>24;
	ioctl_buf[1]=(lvl & 0x00ff0000)>>16;
	ioctl_buf[2]=(lvl & 0x0000ff00)>>8;
	ioctl_buf[3]=lvl & 0x000000ff;
	ret = ioctl(vdslfd, VDSL_SET_DEBUG_LEVEL, ioctl_buf);
	close(vdslfd);

	return ret;
}
#else
void set_debug_level(mt_uint32 lvl)
{
	debug_level = lvl;
}
#endif


/**
 * GetDebugLevel
 */
void get_debug_level(mt_uint32 *lvl)
{
	*lvl = debug_level;
}


void PRINTL(mt_uint32 level,const char *fmt, ...)
{
	// Guess we need no more than 100 bytes. 
	int n, size = PMEM_SIZE;
	char *p, *np;
	va_list ap;
     
	if(!(debug_level & level)) return;

#ifdef __KERNEL__
	if ((p = (char *)kmalloc(size,GFP_KERNEL)) == NULL) return ;
#else
	if ((p = (char *)malloc(size)) == NULL) return ;
#endif

	while (1) {
		// Try to print in the allocated space. 
		va_start(ap, fmt);
		n = vsnprintf (p, size, fmt, ap);
		va_end(ap);
		// If that worked, return the string. 
		if (n > -1 && n < size)
			break;
		// Else try again with more space. 
		if (n > -1)    // glibc 2.1 
			size = n+1; // precisely what is needed 
		else           // glibc 2.0 
			size *= 2;  // twice the old size 
           
#ifdef __KERNEL__
		if ((np = (char *)kmalloc(size,GFP_KERNEL)) == NULL) {
			FREE(p);
			return ;
		} 
		else {
			memcpy(np, p, PMEM_SIZE);
			FREE(p);
			p = np;
		}
#else
		if ((np = (char *)realloc (p, size)) == NULL) {
			FREE(p);
			return ;
		} 
		else {
			p = np;
		}
#endif
	}

#ifdef __KERNEL__
	PRINTD(p);
#else
	if(debug_level & DBG_LVL_XML) {
		strcat(msg_buf, p);
	}
	else {
		PRINTD(p);
		PRINTD("\n");
	}
#endif
     
	if(p) FREE(p);
}
