/****************************************************************************
* File:         $Workfile$
* Revision:     $Revision: 1.3 $
* Date:         $Date: 2010-08-02 07:00:22 $
*
* Overview:     
* Functions:
*
* Author:       Ian Tsao
* 
* -- Metanoia Copyright Notice --
*
* (C) Copyright 2005 Metanoia, Inc. All rights reserved.
* 
* Metanoia reserves the right to change specifications without notice. 
* Copyright 2005 Metanoia, Inc. All rights reserved. Preliminary Data-Sheet 
* indicates this product is in design and the specification may change. 
* Electrical parametrics have not been analyzed and are not specified. Do not 
* use this data sheet as a design reference document. Please contact Metanoia 
* for a current data sheet that may be used as a design reference. All 
* contents of this document are protected by copyright law and may not be 
* reproduced without the express written consent of Metanoia, Inc. Metanoia, 
* the Metanoia logo, and combinations thereof are trademarks of Metanoia, Inc. 
* Other product names used in this publication are for identification purposes 
* only and may be trademarks or registered trademarks of their respective 
* companies. The contents of this document are provided in connection with 
* Metanoia, Inc. products. Metanoia, Inc. has made best efforts to ensure that 
* the information contained herein is accurate and reliable. However, Metanoia, 
* Inc. makes no warranties, express or implied, as to the accuracy or 
* completeness of the contents of this publication and is providing this 
* publication 'as is'. Metanoia, Inc. reserves the right to make changes to 
* specifications and product descriptions at any time without notice, and to 
* discontinue or make changes to its products at any time without notice. 
* Metanoia, Inc. does not assume any liability arising out of the application 
* or use of any product or circuit, and specifically disclaims any and all 
* liability, including without limitation special, consequential, or 
* incidental damages.
* 
****************************************************************************/
#ifndef _CHIP_H_
#define _CHIP_H_

#define MT_MAX_BUFFERSIZE 512

typedef struct chip_struct
{
	int	chip_nr;
	mt_uint8 buf[MT_MAX_BUFFERSIZE];
}chip_t;

extern void set_status_idle_chip(mt_uint32 chipid);
extern mt_uint32 boot_chip(mt_uint32 chipid, mt_uint32 firmwareID);
extern mt_uint32 init_chip_chip(mt_uint32 chipid, mt_uint32 firmwareID);
//extern mt_uint32 init_system_chip(mt_uint32 firmwareID);
extern mt_uint32 new_frame_exchange(mt_uint32 chipid, mt_uint32 len, mt_uint8 *pframe);
extern mt_uint32 send_frame_chip(mt_uint32 chipid, mt_uint32 len, mt_uint8 *pframe);
#ifndef SPI_ACCESS
extern mt_uint32 download_chip(mt_uint32 chipid,mt_uint32 bufsize,mt_uint8* buffer);
#endif	//SPI_ACCESS
#ifdef XENOS
extern void vdsl_reset(int port);
extern void vdsl_reset_high(int port);
extern void vdsl_reset_low(int port);
extern void set_dsl_led(int port,int led);
//port:0-23,led:0-dark,1-red,2-green
#endif


#endif	//_CHIP_H_
