/****************************************************************************
* File:         $Workfile$
* Revision:     $Revision: 1.5 $
* Date:         $Date: 2010-08-02 07:00:22 $
*
* Overview:     
* Functions:
*
* Author:       Ian Tsao
* 
* -- Metanoia Copyright Notice --
*
* (C) Copyright 2005 Metanoia, Inc. All rights reserved.
* 
* Metanoia reserves the right to change specifications without notice. 
* Copyright 2005 Metanoia, Inc. All rights reserved. Preliminary Data-Sheet 
* indicates this product is in design and the specification may change. 
* Electrical parametrics have not been analyzed and are not specified. Do not 
* use this data sheet as a design reference document. Please contact Metanoia 
* for a current data sheet that may be used as a design reference. All 
* contents of this document are protected by copyright law and may not be 
* reproduced without the express written consent of Metanoia, Inc. Metanoia, 
* the Metanoia logo, and combinations thereof are trademarks of Metanoia, Inc. 
* Other product names used in this publication are for identification purposes 
* only and may be trademarks or registered trademarks of their respective 
* companies. The contents of this document are provided in connection with 
* Metanoia, Inc. products. Metanoia, Inc. has made best efforts to ensure that 
* the information contained herein is accurate and reliable. However, Metanoia, 
* Inc. makes no warranties, express or implied, as to the accuracy or 
* completeness of the contents of this publication and is providing this 
* publication 'as is'. Metanoia, Inc. reserves the right to make changes to 
* specifications and product descriptions at any time without notice, and to 
* discontinue or make changes to its products at any time without notice. 
* Metanoia, Inc. does not assume any liability arising out of the application 
* or use of any product or circuit, and specifically disclaims any and all 
* liability, including without limitation special, consequential, or 
* incidental damages.
* 
****************************************************************************/
#include "dsll2.h"
#include "ioctlmeta.h"

#ifdef __KERNEL__
//semaphore used to control hpi r/w throhgh IOCTL
//static DECLARE_MUTEX(mr_sem_chip);
#endif


void set_status_idle_chip(mt_uint32 chipid)
{
	mt_uint32 chip;

	if(chipid == MT_PORT_BroadCast) {
		for(chip = 0; chip < MAX_CHIPS; chip++)
			port_info[chip].status = MT_OPSTATE_IDLE;
	}
	else
		port_info[chipid].status = MT_OPSTATE_IDLE;
}


#ifndef SPI_ACCESS
mt_uint32 download_chip(mt_uint32 chipid,mt_uint32 bufsize,mt_uint8* buffer)
{
	mt_uint32 i;
	mt_uint8 ret;
	int j;

	for(i = 0; i < bufsize; i++) {
		ret = write_hpi_8(chipid, buffer[i]);
		if(ret != MT_OK) return ret;

		if(i%100 == 0) PRINTL(DBG_LVL_CHIP, ".");

		for(j=0;j<1000;j++);
	}

	return MT_OK;	
}
#endif	//SPI_ACCESS
