#ifndef _BOARDDRV_H_
#define _BOARDDRV_H_

#ifndef __KERNEL__
#define __KERNEL__
#endif
#ifndef MODULE
#define MODULE
#endif

#include <linux/module.h>
#include <linux/version.h>
#include <linux/init.h>
#include <linux/kernel.h>
#include <linux/fs.h>
#include <linux/errno.h>
#include <linux/ioctl.h>
#include <linux/types.h>
#include <linux/proc_fs.h>
#include <asm/io.h>
#include <asm/uaccess.h>

#include "boardioctl.h"

#ifdef HOPE
#include "rtl8310p_sw.h"
#elif defined BOARD_A5
#endif

#ifndef NULL
#define NULL ((void *)0)
#endif

#define FLASH_CFG_ADDR  0x10020000
#define FLASH_CFG_SIZE  0x20000

#if !defined (ICPLUS_IP3210) && !defined (ATHEROS_AR93XX) && !defined (REALTEK_RTL8672)
extern int init_fakevdsl(void);
extern void cleanup_fakevdsl_module(void);
extern void vdsl_proc_msg(char *buf, int *len);
//extern void switch_proc_msg(char *buf, int *len);

#ifdef BOARD_A5
extern int smi_read(unsigned int addr, unsigned int* data);
extern int smi_write(unsigned int addr,unsigned short data);
#endif	//BOARD_A5
#endif	//!defined (ICPLUS_IP3210) && !defined (ATHEROS_AR93XX) && !defined (REALTEK_RTL8672)

#endif	//_BOARDDRV_H_
