/****************************************************************************
* File:         $Workfile$
* Revision:     $Revision: 1.8 $
* Date:         $Date: 2011-05-11 10:46:05 $
*
* Overview:     
* Functions:
*
* Author:       Ian Tsao
* 
* -- Metanoia Copyright Notice --
*
* (C) Copyright 2005 Metanoia, Inc. All rights reserved.
* 
* Metanoia reserves the right to change specifications without notice. 
* Copyright 2005 Metanoia, Inc. All rights reserved. Preliminary Data-Sheet 
* indicates this product is in design and the specification may change. 
* Electrical parametrics have not been analyzed and are not specified. Do not 
* use this data sheet as a design reference document. Please contact Metanoia 
* for a current data sheet that may be used as a design reference. All 
* contents of this document are protected by copyright law and may not be 
* reproduced without the express written consent of Metanoia, Inc. Metanoia, 
* the Metanoia logo, and combinations thereof are trademarks of Metanoia, Inc. 
* Other product names used in this publication are for identification purposes 
* only and may be trademarks or registered trademarks of their respective 
* companies. The contents of this document are provided in connection with 
* Metanoia, Inc. products. Metanoia, Inc. has made best efforts to ensure that 
* the information contained herein is accurate and reliable. However, Metanoia, 
* Inc. makes no warranties, express or implied, as to the accuracy or 
* completeness of the contents of this publication and is providing this 
* publication 'as is'. Metanoia, Inc. reserves the right to make changes to 
* specifications and product descriptions at any time without notice, and to 
* discontinue or make changes to its products at any time without notice. 
* Metanoia, Inc. does not assume any liability arising out of the application 
* or use of any product or circuit, and specifically disclaims any and all 
* liability, including without limitation special, consequential, or 
* incidental damages.
* 
****************************************************************************/
#include <asm/io.h>
#include <asm/uaccess.h>
#include <linux/slab.h>
#include "boarddrv.h"

int board_major = BOARD_MAJOR;

/******************************************************************************
  * proc
  */
static DECLARE_MUTEX(mr_sem_proc);
static int sem_ret;
static u8 *remap_ori;

void flash_env_info(char *buf, int *len)
{
	int null_catch = 0;
	int i = 0;

	volatile u8 *remap;

	remap = remap_ori;

	remap += 4;

	for(i=0 ; i<=10000 ; i++){
		if ( (*remap >= 65 && *remap <= 90) || ( *remap >= 97 && *remap <= 122) ){
			break;
		}else if( i == 10000){
			//printk("Flash not ready\n");
			return;
		}
	}

	for(i=0; i < 2000 ;i++)
    {
#if 0  /* Error debug code... */
		if( i == 999){ 
			printk("Warring:Loop at 999\n");
			//printk("%x %x %x\n",*remap_ori,*(remap_ori+1),*(remap_ori+2) );
		}
#endif
		if( (*remap <= 0x7f)&&(*remap >= 0x21) ){
			*len += sprintf(buf+*len, "%c", *remap);
			//printk("MM=%x\n",*remap);
			null_catch=0;
		}else if( (*remap > 0x7f) || ( *remap == 0) ){
			null_catch++;
			if(null_catch != 2){
				*len += sprintf(buf+*len, "\n");
			}else 
				break;
		}

        remap++;
    }


    return;
}


int board_read_setting(char *buf, char **start, off_t offset, int count, int *eof, void *data)
{
	int len = 0;    /* when messages are too big, remember to limit len less than count */

	sem_ret = down_interruptible(&mr_sem_proc);
	flash_env_info(buf, &len);
	up(&mr_sem_proc);   

	*eof = 1;

	return len;
}


int board_read_debuginfo(char *buf, char **start, off_t offset, int count, int *eof, void *data)
{
	int len = 0;	/* when messages are too big, remember to limit len less than count */

	sem_ret = down_interruptible(&mr_sem_proc);

#if !defined (ICPLUS_IP3210) && !defined (ATHEROS_AR93XX) && !defined (REALTEK_RTL8672)
	vdsl_proc_msg(buf, &len);
	//switch_proc_msg(buf, &len);
#endif	//!defined (ICPLUS_IP3210) && !defined (ATHEROS_AR93XX) && !defined (REALTEK_RTL8672)

	up(&mr_sem_proc);

	*eof = 1;

	return len;
}


/******************************************************************************
  * board driver
  */
static int board_ioctl(struct inode * inode, struct file * file,
		   unsigned int cmd, unsigned long arg)
{
	int ret = 0;
	unsigned long *new_arg=NULL;
	unsigned char board_arg[64];
#ifndef VIA_SAMSUNG
	unsigned int addr;
	unsigned int value;
	unsigned short value_16;
#endif


//       printk("board_ioctl function running...\n");

	if (arg) {
		if ((new_arg = (unsigned long *)kmalloc(sizeof(unsigned long),GFP_KERNEL)) == NULL)
			return -ENOMEM;
	
		*new_arg=arg;
	
		if (copy_from_user(board_arg, (void *)(*new_arg), sizeof(board_arg)))
			return -EFAULT;
	}

	switch (cmd) {
#ifndef VIA_SAMSUNG
#ifdef HOPE
		case RTL8310_READ_REG:
			memcpy(&addr, &board_arg[0], sizeof(addr));
			// set rtl8310p
			//value = 0x2fbf;
			//i2c_write(0x54, 0x615, 2, (unsigned char *)&value, 2);
			memset(&value, 0x0, sizeof(value));
			if (addr>=0x0700 && addr<0x0800) {
				i2c_read(0x54, addr, 2, (unsigned char *)&value, 4);
			} else {			
			       value_16=value;
				i2c_read(0x54, addr, 2, (unsigned char *)&value_16, 2);
				value = value_16;
			}	
                     memcpy(&board_arg[0], &value, sizeof(value));
			if(copy_to_user((void *)(*new_arg), board_arg, sizeof(value)))
				return -EFAULT;					 
			
			//printk("drv :: read => addr = 0x%x, value = 0x%x\n", addr, value);

			break;

		case RTL8310_WRITE_REG:
			memcpy(&addr, &board_arg[0], sizeof(addr));
			memcpy(&value, &board_arg[4], sizeof(value));
			value_16=value;
			// set rtl8310p
			i2c_write(0x54, addr, 2, (unsigned char *)&value_16, 2);
			//i2c_read(0x54, addr, 2, (unsigned char *)&value, 2);
			//printk("drv :: write => addr = 0x%x, value = 0x%x\n", addr, value_16);
			break;
#elif defined BOARD_A5
		case ADM6996M_READ_REG:
			memcpy(&addr, &board_arg[0], sizeof(addr));
			memset(&value, 0x0, sizeof(value));
			
#ifndef KERNEL_2_6
			smi_read(addr, &value);		
#endif
			memcpy(&board_arg[0], &value, sizeof(value));
					 
			if(copy_to_user((void *)(*new_arg), board_arg, sizeof(value)))
				return -EFAULT;					 
			
			//printk("drv :: read => addr = 0x%x, value = 0x%x\n", addr, value);
			break;

		case ADM6996M_WRITE_REG:
			memcpy(&addr, &board_arg[0], sizeof(addr));
			memcpy(&value, &board_arg[4], sizeof(value));
			value_16=value;
#ifndef KERNEL_2_6
			smi_write(addr, value_16);
#endif
			//printk("drv :: write => addr = 0x%x, value = 0x%x\n", addr, value_16);
			break;
#endif
#endif	//VIA_SAMSUNG
		default:
			return -ENOTTY;
	}

	kfree(new_arg);

	return ret;
}

static struct file_operations board_fops = {
	ioctl:	board_ioctl,
};

int board_init_module(void)
{
	/***
	  * board driver
	  */
	int result;	
	//int i = 0;

	/*
	 * Register your major, and accept a dynamic number
	 */
	result = register_chrdev(board_major, "board", &board_fops);
	if (result < 0) {
		printk(KERN_WARNING "BOARD: Can't get major %d\n", board_major);
		return result;
	}
	if (board_major == 0) board_major = result; /* dynamic */
	
	printk("\nBoard Device Driver Initialized.\n");

#if !defined (ICPLUS_IP3210) && !defined (ATHEROS_AR93XX) && !defined (REALTEK_RTL8672)
	/***
	 * proc area
	 */

	if (proc_mkdir("board", NULL)) {
		create_proc_read_entry("board/debuginfo",
					0 /* default access mode (0x444) */,
					NULL /* base */,
					board_read_debuginfo,
					NULL);
		create_proc_read_entry("board/setting",
					0 /* default access mode (0x444) */,
					NULL /* base */,
					board_read_setting,
					NULL);
	}

	remap_ori = ioremap(FLASH_CFG_ADDR, FLASH_CFG_SIZE);
	printk("remap_ori=%08x\n",(unsigned int)remap_ori);
	if( remap_ori == NULL){
		printk("ERROR:IOREMAP Fail...\n");
	}

	//for(i=0;i<50000000;i++);
#ifndef XENOS
#ifndef KERNEL_2_6
	init_fakevdsl();
#endif	//KERNEL_2_6
#endif	//XENOS
#endif	//!defined (ICPLUS_IP3210) && !defined (ATHEROS_AR93XX) && !defined (REALTEK_RTL8672)

	printk("\nGeneral Board Interface Module Initialized.\n");
	
	return 0; /* succeed */
}


void board_cleanup_module( void )
{
	/***
	  * proc area
	  */
#if !defined (ICPLUS_IP3210) && !defined (ATHEROS_AR93XX) && !defined (REALTEK_RTL8672)
	remove_proc_entry("board/setting", NULL);
	remove_proc_entry("board/debuginfo", NULL);
	remove_proc_entry("board", NULL);

	iounmap(remap_ori);
#endif	//!defined (ICPLUS_IP3210) && !defined (ATHEROS_AR93XX) && !defined (REALTEK_RTL8672)

	printk("\nGeneral Board Interface Module Uninitialized.\n");

	/***
	  * board driver area
	  */
	unregister_chrdev(board_major, "board");

#ifndef XENOS
#ifndef KERNEL_2_6
	cleanup_fakevdsl_module();
#endif
#endif

	printk("\nBOARD Device Driver Uninitialized.\n");
}


module_init(board_init_module);
module_exit(board_cleanup_module);

MODULE_DESCRIPTION("General Board Interface Module");
MODULE_AUTHOR("Ian");
MODULE_LICENSE("GPL");
