/****************************************************************************
* File:         $Workfile$
* Revision:     $Revision: 1.3 $
* Date:         $Date: 2010-05-14 08:45:27 $
*
* Overview:     
* Functions:
*
* Author:       Ian Tsao
* 
* -- Metanoia Copyright Notice --
*
* (C) Copyright 2005 Metanoia, Inc. All rights reserved.
* 
* Metanoia reserves the right to change specifications without notice. 
* Copyright 2005 Metanoia, Inc. All rights reserved. Preliminary Data-Sheet 
* indicates this product is in design and the specification may change. 
* Electrical parametrics have not been analyzed and are not specified. Do not 
* use this data sheet as a design reference document. Please contact Metanoia 
* for a current data sheet that may be used as a design reference. All 
* contents of this document are protected by copyright law and may not be 
* reproduced without the express written consent of Metanoia, Inc. Metanoia, 
* the Metanoia logo, and combinations thereof are trademarks of Metanoia, Inc. 
* Other product names used in this publication are for identification purposes 
* only and may be trademarks or registered trademarks of their respective 
* companies. The contents of this document are provided in connection with 
* Metanoia, Inc. products. Metanoia, Inc. has made best efforts to ensure that 
* the information contained herein is accurate and reliable. However, Metanoia, 
* Inc. makes no warranties, express or implied, as to the accuracy or 
* completeness of the contents of this publication and is providing this 
* publication 'as is'. Metanoia, Inc. reserves the right to make changes to 
* specifications and product descriptions at any time without notice, and to 
* discontinue or make changes to its products at any time without notice. 
* Metanoia, Inc. does not assume any liability arising out of the application 
* or use of any product or circuit, and specifically disclaims any and all 
* liability, including without limitation special, consequential, or 
* incidental damages.
* 
****************************************************************************/
#include "dsll2.h"
#ifdef BOARD_A5
#include <asm/io.h>
#endif

#ifdef __KERNEL__
//semaphore used to control hpi r/w throhgh IOCTL
//static DECLARE_MUTEX(mr_sem);
//spinlock_t mr_lock = SPIN_LOCK_UNLOCKED;
#endif


mt_uint32 reset_chip(mt_uint32 chipid)
{
#ifdef AWARD	
	mt_uint32 i;
	//volatile mt_uint32* p_gpio_en = (mt_uint32*) GPIO_EN;
	//volatile mt_uint32* p_gpio_ben = (mt_uint32*) GPIO_BEN;
	//volatile mt_uint32* p_gpio_dir = (mt_uint32*) GPIO_DIR;
	volatile mt_uint32* p_gpio_data = (mt_uint32*) GPIO_DATA;

	// Award modem holds only one Falcon chip
	if(chipid > MT_PORT_BroadCast)
		return MT_NO_SUCH_CHIP;

	port_info[chipid].status = MT_OPSTATE_DISABLE;

	// Set the boot mode and activate reset
	// RST_N is active low
	*p_gpio_data = (*p_gpio_data & ~FALCON_MASK) | BOOT_MODE;
	PRINTL(DBG_LVL_LIB,"reset_chip:FALCON_MASK=%x,GPIO_DATA=%08x.\n", FALCON_MASK,p_gpio_data);
	
	//*p_gpio_data &= ~0x00000800 ;
       
	//PRINTD("TestGPIO:in2\n");

	//*p_gpio_en |= 0x00000800  ;
	//*p_gpio_dir |= 0x00000800 ; 
	//*p_gpio_ben |= 0x00000800 ;
	//*p_gpio_data &= ~0x00000800 ;
	
	for(i=0;i<300;i++);
	// Turn of the reset, RST_N goes high
	*p_gpio_data = (*p_gpio_data & ~FALCON_MASK) | BOOT_MODE | RST_N;

	set_resp_rdy_to_input();
#endif
#ifdef XENOS
	mt_uint32 i;
	mt_uint8 chip;

	// Award modem holds only one Falcon chip
	if(chipid > MT_PORT_BroadCast)
		return MT_NO_SUCH_CHIP;

	//printk("\nreset address: %x\n", falcon_port+((0x20+chipid)<<BUS_WIDTH_16_SHIFT));
	//printk("reset address: %x\n", falcon_port+((0x40+chipid)<<BUS_WIDTH_16_SHIFT));

	*(falcon_port+((0x20+chipid)<<BUS_WIDTH_16_SHIFT)) = 0x0;

	for(i=0;i<100000;i++);

	*(falcon_port+((0x40+chipid)<<BUS_WIDTH_16_SHIFT)) = 0x0;

	if(chipid == MT_PORT_BroadCast)
	{
		for(chip = 0; chip < MAX_CHIPS; chip++)
			port_info[chip].status = MT_OPSTATE_DISABLE;
	}
	else
		port_info[chipid].status = MT_OPSTATE_DISABLE;
#endif
#ifdef HOPE
	mt_uint32 i;
	mt_uint8 chip;

	// Award modem holds only one Falcon chip
	if(chipid > MT_PORT_BroadCast)
		return MT_NO_SUCH_CHIP;

	*(falcon_port+((0x10+chipid)<<BUS_WIDTH_32_SHIFT)) = 0x0;

	for(i=0;i<100000;i++);

	*(falcon_port+((0x20+chipid)<<BUS_WIDTH_32_SHIFT)) = 0x0;

	if(chipid == MT_PORT_BroadCast)
	{
		for(chip = 0; chip < MAX_CHIPS; chip++)
			port_info[chip].status = MT_OPSTATE_DISABLE;
	}
	else
		port_info[chipid].status = MT_OPSTATE_DISABLE;
#endif
#ifdef BOARD_A5
	mt_uint32 i;

	// Award modem holds only one Falcon chip
	if(chipid > MT_PORT_BroadCast)
		return MT_NO_SUCH_CHIP;

	*databit_set = 0x1000;

	*databit_set = 0x2000;
	for(i=0;i<1000;i++);
	*databit_clr = 0x2000;
	for(i=0;i<1000;i++);
	*databit_set = 0x2000;

	port_info[chipid].status = MT_OPSTATE_DISABLE;
#endif

	return MT_OK;
}


mt_uint32 reset_chip_high(mt_uint32 chipid)
{
#ifdef XENOS
	mt_uint8 chip;

	//printk("\nreset address: %x\n", falcon_port+((0x40+chipid)<<BUS_WIDTH_16_SHIFT));
	*(falcon_port+((0x40+chipid)<<BUS_WIDTH_16_SHIFT)) = 0x0;

	if(chipid == MT_PORT_BroadCast)
	{
		for(chip = 0; chip < MAX_CHIPS; chip++)
			port_info[chip].status = MT_OPSTATE_DISABLE;
	}
	else
		port_info[chipid].status = MT_OPSTATE_DISABLE;
#endif
#ifdef HOPE
	mt_uint8 chip;

	*(falcon_port+((0x20+chipid)<<BUS_WIDTH_32_SHIFT)) = 0x0;

	if(chipid == MT_PORT_BroadCast)
	{
		for(chip = 0; chip < MAX_CHIPS; chip++)
			port_info[chip].status = MT_OPSTATE_DISABLE;
	}
	else
		port_info[chipid].status = MT_OPSTATE_DISABLE;
#endif
#ifdef BOARD_A5
	*databit_set = 0x2000;

	port_info[chipid].status = MT_OPSTATE_DISABLE;
#endif

	return MT_OK;
}


mt_uint32 reset_chip_low(mt_uint32 chipid)
{
#ifdef XENOS
	mt_uint8 chip;

	//printk("\nreset address: %x\n", falcon_port+((0x20+chipid)<<BUS_WIDTH_16_SHIFT));
	*(falcon_port+((0x20+chipid)<<BUS_WIDTH_16_SHIFT)) = 0x0;

	if(chipid == MT_PORT_BroadCast)
	{
		for(chip = 0; chip < MAX_CHIPS; chip++)
			port_info[chip].status = MT_OPSTATE_DISABLE;
	}
	else
		port_info[chipid].status = MT_OPSTATE_DISABLE;
#endif
#ifdef HOPE
	mt_uint8 chip;

	*(falcon_port+((0x10+chipid)<<BUS_WIDTH_32_SHIFT)) = 0x0;

	if(chipid == MT_PORT_BroadCast)
	{
		for(chip = 0; chip < MAX_CHIPS; chip++)
			port_info[chip].status = MT_OPSTATE_DISABLE;
	}
	else
		port_info[chipid].status = MT_OPSTATE_DISABLE;
#endif
#ifdef BOARD_A5
	*databit_clr = 0x2000;

	port_info[chipid].status = MT_OPSTATE_DISABLE;
#endif

	return MT_OK;
}


mt_uint8 write_hpi_8(mt_uint8 chipid, mt_uint8 data)
{
	if(chipid > MT_PORT_BroadCast)
		return MT_NO_SUCH_CHIP;

#ifdef __KERNEL__
//semaphore control
	//down_interruptible(&mr_sem);
	//spin_lock(&mr_lock);
#endif

#ifdef XENOS
	*(falcon_port+(chipid<<BUS_WIDTH_16_SHIFT)) = data;
#endif
#ifdef HOPE
	*(falcon_port+(chipid<<BUS_WIDTH_32_SHIFT)) = data;
#endif
#ifdef BOARD_A5
	*falcon_port = data;
#endif
#ifdef AWARD
	*(mt_uint8*) FALCON_PORT = data;
#endif

#ifdef __KERNEL__
//semaphore control
	//up(&mr_sem);
	//spin_unlock(&mr_lock);
#endif

	return MT_OK;
}

mt_uint8 read_hpi_8(mt_uint8 chipid)
{
	mt_uint8 retval;
/*#ifdef BOARD_A5
	volatile mt_uint32 *addr;
#endif*/

	if(chipid > MT_PORT_BroadCast)
		return MT_NO_SUCH_CHIP;

#ifdef __KERNEL__
//semaphore control
	//down_interruptible(&mr_sem);
	//spin_lock(&mr_lock);
#endif

#ifdef XENOS
	retval = *(falcon_port+(chipid<<BUS_WIDTH_16_SHIFT));
#endif
#ifdef HOPE
	retval = *(falcon_port+(chipid<<BUS_WIDTH_32_SHIFT));
#endif
#ifdef BOARD_A5
	/*(volatile void *)addr = ioremap(FALCON_PORT, 0x2);
	retval = *(volatile mt_uint8 *)addr;
	iounmap((void *)addr);*/
	retval = *falcon_port;
#endif
#ifdef AWARD
	retval = *(mt_uint8*) FALCON_PORT;
#endif

#ifdef __KERNEL__
//semaphore control
	//up(&mr_sem);
	//spin_unlock(&mr_lock);
#endif

	return retval;
}
