/****************************************************************************
* File:         $Workfile$
* Revision:     $Revision: 1.11 $
* Date:         $Date: 2011-11-03 05:37:58 $
*
* Overview:     
* Functions:
*
* Author:       Ian Tsao
* 
* -- Metanoia Copyright Notice --
*
* (C) Copyright 2005 Metanoia, Inc. All rights reserved.
* 
* Metanoia reserves the right to change specifications without notice. 
* Copyright 2005 Metanoia, Inc. All rights reserved. Preliminary Data-Sheet 
* indicates this product is in design and the specification may change. 
* Electrical parametrics have not been analyzed and are not specified. Do not 
* use this data sheet as a design reference document. Please contact Metanoia 
* for a current data sheet that may be used as a design reference. All 
* contents of this document are protected by copyright law and may not be 
* reproduced without the express written consent of Metanoia, Inc. Metanoia, 
* the Metanoia logo, and combinations thereof are trademarks of Metanoia, Inc. 
* Other product names used in this publication are for identification purposes 
* only and may be trademarks or registered trademarks of their respective 
* companies. The contents of this document are provided in connection with 
* Metanoia, Inc. products. Metanoia, Inc. has made best efforts to ensure that 
* the information contained herein is accurate and reliable. However, Metanoia, 
* Inc. makes no warranties, express or implied, as to the accuracy or 
* completeness of the contents of this publication and is providing this 
* publication 'as is'. Metanoia, Inc. reserves the right to make changes to 
* specifications and product descriptions at any time without notice, and to 
* discontinue or make changes to its products at any time without notice. 
* Metanoia, Inc. does not assume any liability arising out of the application 
* or use of any product or circuit, and specifically disclaims any and all 
* liability, including without limitation special, consequential, or 
* incidental damages.
* 
****************************************************************************/
#ifndef _AWARDM_H_
#define _AWARDM_H_


// bus width DMT address shift
#define BUS_WIDTH_8_SHIFT 16
#define BUS_WIDTH_16_SHIFT 17
#define BUS_WIDTH_32_SHIFT 18


#if defined (AWARD)
// GPIO_EN is the address at which controller enables/disables GPIO pin
#define GPIO_EN 0x40000010
// GPIO_BEN is the address at which controller sets GPIO bit enable
#define GPIO_BEN 0x40700004
// GPIO_DIR is the address at which controller sets GPIO directions
#define GPIO_DIR 0x40700008

// GPIO_DATA is the address at which controller accesses other Falcon
// interface pins (IRQA-D, RST_N, ...)
#define GPIO_DATA 0x40700000

#define EBI_RDY 0x40100028
#define EBI_BCR2 0x40100008

// Eth reset
#define ETH_RESET 0x40000000

// FALCON_PORT is the address at which controller sees HPI port
#define FALCON_PORT 0x22000000

// GPIO bit # for RESP_RDY access
#define RESP_RDY_BIT 0x1000000 
// IRQA-D lines are connected to bits 21-18 of GTX GPIO port
#define BOOT_MODE 0x1c0000	// Falcon is in HPI slave boot mode
// Cfg register for memory bank #2, connected to falcon
// FALCON_MASK - these are all GPIO bits connected to Falcon
#define FALCON_MASK 0x3f0000
// GPIO bit connected to Falcon reset
#define RST_N 0x10000
// GPIO bit # for IRQA access
#define IRQA_BIT 0x40000 
// switch PIN Setting
#define SMI_EECS 0x00000020
#define SMI_EESK 0x00000010
#define SMI_EDI  0x00000080
#define SMI_EDO  0x00000040		
#endif	//defined (AWARD)

#if defined (XENOS)
// GPIO_EN is the address at which controller enables/disables GPIO pin
#define GPIO_EN 0x40000010
// GPIO_BEN is the address at which controller sets GPIO bit enable
#define GPIO_BEN 0x40700004
// GPIO_DIR is the address at which controller sets GPIO directions
#define GPIO_DIR 0x40700008

// GPIO_DATA is the address at which controller accesses other Falcon
// interface pins (IRQA-D, RST_N, ...)
#define GPIO_DATA 0x40700000

#define EBI_RDY 0x40100028
#define EBI_BCR2 0x40100008

// Eth reset
#define ETH_RESET 0x40000000

// XENOS_PORT is the address at which controller sees HPI port
#ifndef VIA_SAMSUNG
#define XENOS_PORT 0x18000000
#else
#define XENOS_PORT 0x82000000
#endif

// GPIO bit # for RESP_RDY access
#define RESP_RDY_BIT 0x1000000 
// IRQA-D lines are connected to bits 21-18 of GTX GPIO port
#define BOOT_MODE 0x1c0000	// Falcon is in HPI slave boot mode
// Cfg register for memory bank #2, connected to falcon
// FALCON_MASK - these are all GPIO bits connected to Falcon
#define FALCON_MASK 0x3f0000
// GPIO bit connected to Falcon reset
#define RST_N 0x10000
// GPIO bit # for IRQA access
#define IRQA_BIT 0x40000 
// switch PIN Setting
#define SMI_EECS 0x00000020
#define SMI_EESK 0x00000010
#define SMI_EDI  0x00000080
#define SMI_EDO  0x00000040		
#endif	//defined (XENOS)

#if defined (BOARD_A3)
// GPIO_EN is the address at which controller enables/disables GPIO pin
#define GPIO_EN 0x40000010
// GPIO_BEN is the address at which controller sets GPIO bit enable
#define GPIO_BEN 0x40700004
// GPIO_DIR is the address at which controller sets GPIO directions
#define GPIO_DIR 0x40700008

// GPIO_DATA is the address at which controller accesses other Falcon
// interface pins (IRQA-D, RST_N, ...)
#define GPIO_DATA 0x40700000

#define EBI_RDY 0x40100028
#define EBI_BCR2 0x40100008

// Eth reset
#define ETH_RESET 0x40000000

#ifdef AWARD
// FALCON_PORT is the address at which controller sees HPI port
#define FALCON_PORT 0x22000000
#endif
   
// IRQA-D lines are connected to bits 21-18 of GTX GPIO port
#define BOOT_MODE 0x0A000200	// Falcon is in HPI slave boot mode
// Cfg register for memory bank #2, connected to falcon
// FALCON_MASK - these are all GPIO bits connected to Falcon
#define FALCON_MASK 0x1E000F0F
// GPIO bit connected to Falcon reset
#define RST_N 0x800
// GPIO bit # for IRQA access
#define IRQA_BIT 0x200 
// GPIO bit # for RESP_RDY access
#define RESP_RDY_BIT 0x4000000 	
// switch PIN Setting

#define SMI_EECS 0x00000002
#define SMI_EESK 0x00000004
#define SMI_EDI  0x00000001
#define SMI_EDO  0x00000008	

// switch register definition
#define SMI_ADDRESS_TABLE_CONTROL0 0x11A
#define SMI_ADDRESS_TABLE_CONTROL1 0x11B
#define SMI_ADDRESS_TABLE_CONTROL2 0x11C
#define SMI_ADDRESS_TABLE_CONTROL3 0x11D
#define SMI_ADDRESS_TABLE_CONTROL4 0x11E
#define SMI_ADDRESS_TABLE_CONTROL5 0x11F

#define SMI_ADDRESS_TABLE_STATUS0 0x120						
#define SMI_ADDRESS_TABLE_STATUS1 0x121						
#define SMI_ADDRESS_TABLE_STATUS2 0x122						
#define SMI_ADDRESS_TABLE_STATUS3 0x123						
#define SMI_ADDRESS_TABLE_STATUS4 0x124						
#define SMI_ADDRESS_TABLE_STATUS5 0x125												
#endif	//defined (BOARD_A3)

#if defined (HOPE)
// GPIO_EN is the address at which controller enables/disables GPIO pin
#define GPIO_EN 0x40000010
// GPIO_BEN is the address at which controller sets GPIO bit enable
#define GPIO_BEN 0x40700004
// GPIO_DIR is the address at which controller sets GPIO directions
#define GPIO_DIR 0x40700008

// GPIO_DATA is the address at which controller accesses other Falcon
// interface pins (IRQA-D, RST_N, ...)
#define GPIO_DATA 0x40700000

#define EBI_RDY 0x40100028
#define EBI_BCR2 0x40100008

// Eth reset
#define ETH_RESET 0x40000000

// FALCON_PORT is the address at which controller sees HPI port
#ifndef VIA_SAMSUNG
#define FALCON_PORT 0x18000000
#else
#define FALCON_PORT 0x82000000
#endif

// GPIO bit # for RESP_RDY access
#define RESP_RDY_BIT 0x1000000 
// IRQA-D lines are connected to bits 21-18 of GTX GPIO port
#define BOOT_MODE 0x1c0000	// Falcon is in HPI slave boot mode
// Cfg register for memory bank #2, connected to falcon
// FALCON_MASK - these are all GPIO bits connected to Falcon
#define FALCON_MASK 0x3f0000
// GPIO bit connected to Falcon reset
#define RST_N 0x10000
// GPIO bit # for IRQA access
#define IRQA_BIT 0x40000 
// switch PIN Setting
#define SMI_EECS 0x00000020
#define SMI_EESK 0x00000010
#define SMI_EDI  0x00000080
#define SMI_EDO  0x00000040		
#endif	//defined (HOPE)

#if defined (BOARD_A5)
// GPIO_EN is the address at which controller enables/disables GPIO pin
#define GPIO_EN				0x40000010
// GPIO_BEN is the address at which controller sets GPIO bit enable
#define GPIO_BEN			0x40700004
// GPIO_DIR is the address at which controller sets GPIO directions
#define GPIO_DIR			0x7c000008

// GPIO_DATA is the address at which controller accesses other Falcon
// interface pins (IRQA-D, RST_N, ...)
#define GPIO_DATA			0x7c000000
#define GPIO_DATA_INPUT		0x7c000004

#define EBI_RDY 0x40100028
#define EBI_BCR2 0x40100008

// Eth reset
#define ETH_RESET 0x40000000

#if defined (ICPLUS_IP3210)
#define RESET		0x00001000
#if defined (SPI_ACCESS)
#define COCPE		0x00000800
#define SCKB		0x00004000
#define SC2B		0x00008000
#define DMT_SRDB	0x00010000
#define DMT_STDB	0x00002000
#define SPI_SRDB	0x00002000
#define SPI_STDB	0x00010000
#else	//HPI_ACCESS
// FALCON_PORT is the address at which controller sees HPI port
#define FALCON_PORT 0xBF000000
#endif	//defined (SPI_ACCESS)
#elif defined (ATHEROS_AR93XX)
#define RESET		0x00000010
#if defined (SPI_ACCESS)
//#define COCPE		0x00000800
#define SCKB		0x00000001
#define SC2B		0x00000008
#define DMT_SRDB	0x00000004
#define DMT_STDB	0x00000002
#define SPI_SRDB	0x00000002
#define SPI_STDB	0x00000004
#else	//HPI_ACCESS
// FALCON_PORT is the address at which controller sees HPI port
#define FALCON_PORT 0xBF000000
#endif	//defined (SPI_ACCESS)
#elif defined (REALTEK_RTL8672)
#define RESET_PIN		0x20000000
#define RESET			29
#if defined (SPI_ACCESS)
//#define COCPE		0x00000800
#define SCKB_PIN		0x04000000
#define SC2B_PIN		0x02000000
#define DMT_SRDB_PIN	0x08000000
#define DMT_STDB_PIN	0x00000020
#define SPI_SRDB_PIN	0x00000020
#define SPI_STDB_PIN	0x08000000
#define SCKB			26
#define SC2B			25
#define DMT_SRDB		27
#define DMT_STDB		5
#define SPI_SRDB		5
#define SPI_STDB		27
#else	//HPI_ACCESS
// FALCON_PORT is the address at which controller sees HPI port
#define FALCON_PORT 0xBF000000
#endif	//defined (SPI_ACCESS)
#elif defined (RALINK_RT3052)
#define RESET	0x00000100
// FALCON_PORT is the address at which controller sees HPI port
#define FALCON_PORT 0x1B000000
#elif defined (RALINK_RT3352)
#define RESET	0x00200000
#if defined (SPI_ACCESS)
//#define COCPE		0x00000800
#define SCKB		0x00100000
#define SC2B		0x00040000
#define DMT_SRDB	0x00020000
#define DMT_STDB	0x00080000
#define SPI_SRDB	0x00080000
#define SPI_STDB	0x00020000

#define SPI_CMD_WREN	0x06	// SPI write enable
#define SPI_CMD_CE		0xc7	// SPI chip erase
#define SPI_CMD_BE		0xd8	// SPI block erase
#define SPI_CMD_RDSR	0x05	// SPI read status
#define SPI_CMD_PP		0x02	// SPI page program
#define SPI_CMD_READ	0x03	// SPI read data

#define HALFPAGE	0x80	// Half page length
#define ONEPAGE		0x100	// One page length
#else	//HPI_ACCESS
#define FALCON_PORT 0x1B000000
#endif	//defined (SPI_ACCESS)
#elif defined (VITESS_VSC7501)
#define RESET	0x00000000
// FALCON_PORT is the address at which controller sees HPI port
#define FALCON_PORT 0x13000000
#elif defined (STAR_STR9105)
#define RESET	0x00002000
// FALCON_PORT is the address at which controller sees HPI port
#define FALCON_PORT 0x18800000
#endif  //defined (ICPLUS_IP3210)

// GPIO bit # for RESP_RDY access
#define RESP_RDY_BIT 0x1000000 
// IRQA-D lines are connected to bits 21-18 of GTX GPIO port
#define BOOT_MODE 0x1C0000	// Falcon is in HPI slave boot mode
// Cfg register for memory bank #2, connected to falcon
// FALCON_MASK - these are all GPIO bits connected to Falcon
#define FALCON_MASK 0x3F0000
// GPIO bit connected to Falcon reset
#define RST_N 0x10000
// GPIO bit # for IRQA access
#define IRQA_BIT 0x40000 
// switch PIN Setting
#define SMI_EECS (0x1<<14)
#define SMI_EESK (0x1<<15)
#define SMI_EDI   (0x1<<17)
#define SMI_EDO  (0x1<<16)
#endif	//defined (BOARD_A5)

#if defined (SPI_ACCESS)
#define SPI_CMD_WREN	0x06	// SPI write enable
#define SPI_CMD_CE		0xc7	// SPI chip erase
#define SPI_CMD_BE		0xd8	// SPI block erase
#define SPI_CMD_RDSR	0x05	// SPI read status
#define SPI_CMD_PP		0x02	// SPI page program
#define SPI_CMD_READ	0x03	// SPI read data

#define HALFPAGE	0x80	// Half page length
#define ONEPAGE		0x100	// One page length
#endif	//defined (SPI_ACCESS)

#define BIT_31		0x80000000
#define BIT_30		0x40000000
#define BIT_29		0x20000000
#define BIT_28		0x10000000
#define BIT_27		0x08000000
#define BIT_26		0x04000000
#define BIT_25		0x02000000
#define BIT_24		0x01000000
#define BIT_23		0x00800000
#define BIT_22		0x00400000
#define BIT_21		0x00200000
#define BIT_20		0x00100000
#define BIT_19		0x00080000
#define BIT_18		0x00040000
#define BIT_17		0x00020000
#define BIT_16		0x00010000
#define BIT_15		0x00008000
#define BIT_14		0x00004000
#define BIT_13		0x00002000
#define BIT_12		0x00001000
#define BIT_11		0x00000800
#define BIT_10		0x00000400
#define BIT_09		0x00000200
#define BIT_08		0x00000100
#define BIT_07		0x00000080
#define BIT_06		0x00000040
#define BIT_05		0x00000020
#define BIT_04		0x00000010
#define BIT_03		0x00000008
#define BIT_02		0x00000004
#define BIT_01		0x00000002
#define BIT_00		0x00000001

extern mt_uint32 get_max_chips(void);
extern mt_uint32 init_system_board(void);
extern mt_uint32 check_response_rdy(void);
extern mt_uint32 reset_chip(mt_uint32 chipid);
extern mt_uint32 reset_chip_high(mt_uint32 chipid);
extern mt_uint32 reset_chip_low(mt_uint32 chipid);
extern void trigger_irq(void);
extern void set_rdy_pin(void);
extern void MT_GPIO_SET(mt_uint32 gpio_pins);
extern void MT_GPIO_CLR(mt_uint32 gpio_pins);
#if defined (SPI_ACCESS)
//DMT SPI API
extern void write_spi_9(mt_uint32 address, mt_uint8 memtype, mt_uint8 *pdata);
extern void read_spi_3(int address, int memtype);
extern void write_spi_null(void);
//SPI API
extern void spi_write_data(mt_uint32 address, mt_uint16 length, mt_uint8 *pdata);
extern void spi_read_data(mt_uint32 address, mt_uint16 length, mt_uint8 *pdata);
extern mt_uint8 spi_check_data(mt_uint32 address, mt_uint16 length, mt_uint8 *pdata);
extern mt_uint8 spi_erase_block(mt_uint8 block);
extern mt_uint8 spi_erase_all(void);
#if defined (REALTEK_RTL8672)
//REALTEK GPIO API
extern void gpioSet(int gpio);
extern void gpioClear(int gpio);
#endif	//defined (REALTEK_RTL8672)
#else	//HPI_ACCESS
extern mt_uint8 write_hpi_8(mt_uint8 chipid, mt_uint8 data);
extern mt_uint8 read_hpi_8(mt_uint8 chipid);
#endif	//defined (SPI_ACCESS)

#endif	//_AWARDM_H_
