/****************************************************************************
* File:         $Workfile$
* Revision:     $Revision: 1.12 $
* Date:         $Date: 2011-11-03 05:37:58 $
*
* Overview:     
* Functions:
*
* Author:       Ian Tsao
* 
* -- Metanoia Copyright Notice --
*
* (C) Copyright 2005 Metanoia, Inc. All rights reserved.
* 
* Metanoia reserves the right to change specifications without notice. 
* Copyright 2005 Metanoia, Inc. All rights reserved. Preliminary Data-Sheet 
* indicates this product is in design and the specification may change. 
* Electrical parametrics have not been analyzed and are not specified. Do not 
* use this data sheet as a design reference document. Please contact Metanoia 
* for a current data sheet that may be used as a design reference. All 
* contents of this document are protected by copyright law and may not be 
* reproduced without the express written consent of Metanoia, Inc. Metanoia, 
* the Metanoia logo, and combinations thereof are trademarks of Metanoia, Inc. 
* Other product names used in this publication are for identification purposes 
* only and may be trademarks or registered trademarks of their respective 
* companies. The contents of this document are provided in connection with 
* Metanoia, Inc. products. Metanoia, Inc. has made best efforts to ensure that 
* the information contained herein is accurate and reliable. However, Metanoia, 
* Inc. makes no warranties, express or implied, as to the accuracy or 
* completeness of the contents of this publication and is providing this 
* publication 'as is'. Metanoia, Inc. reserves the right to make changes to 
* specifications and product descriptions at any time without notice, and to 
* discontinue or make changes to its products at any time without notice. 
* Metanoia, Inc. does not assume any liability arising out of the application 
* or use of any product or circuit, and specifically disclaims any and all 
* liability, including without limitation special, consequential, or 
* incidental damages.
* 
****************************************************************************/
#include "dsll2.h"
#ifdef BOARD_A5
#include <asm/io.h>
#endif

#ifdef __KERNEL__
//semaphore used to control hpi r/w throhgh IOCTL
//static DECLARE_MUTEX(mr_sem);
//spinlock_t mr_lock = SPIN_LOCK_UNLOCKED;
#endif


mt_uint32 reset_chip(mt_uint32 chipid)
{
#ifdef AWARD	
	volatile mt_uint32 i;
	//volatile mt_uint32* p_gpio_en = (mt_uint32*) GPIO_EN;
	//volatile mt_uint32* p_gpio_ben = (mt_uint32*) GPIO_BEN;
	//volatile mt_uint32* p_gpio_dir = (mt_uint32*) GPIO_DIR;
	volatile mt_uint32* p_gpio_data = (mt_uint32*) GPIO_DATA;

	// Award modem holds only one Falcon chip
	if(chipid > MT_PORT_BroadCast)
		return MT_NO_SUCH_CHIP;

	port_info[chipid].status = MT_OPSTATE_DISABLE;

	// Set the boot mode and activate reset
	// RST_N is active low
	*p_gpio_data = (*p_gpio_data & ~FALCON_MASK) | BOOT_MODE;
	PRINTL(DBG_LVL_LIB,"reset_chip:FALCON_MASK=%x,GPIO_DATA=%08x.\n", FALCON_MASK,p_gpio_data);
	
	//*p_gpio_data &= ~0x00000800 ;
       
	//PRINTD("TestGPIO:in2\n");

	//*p_gpio_en |= 0x00000800  ;
	//*p_gpio_dir |= 0x00000800 ; 
	//*p_gpio_ben |= 0x00000800 ;
	//*p_gpio_data &= ~0x00000800 ;
	
	for(i=0;i<300;i++);
	// Turn of the reset, RST_N goes high
	*p_gpio_data = (*p_gpio_data & ~FALCON_MASK) | BOOT_MODE | RST_N;

	set_resp_rdy_to_input();
#endif	//AWARD

#ifdef XENOS
	mt_uint8 chip;
	volatile mt_uint32 i;

	// Award modem holds only one Falcon chip
	if(chipid > MT_PORT_BroadCast)
		return MT_NO_SUCH_CHIP;

	*(falcon_port+((0x40+chipid)<<BUS_WIDTH_8_SHIFT)) = 0x0;

	for(i=0;i<100000;i++);

	*(falcon_port+((0x20+chipid)<<BUS_WIDTH_8_SHIFT)) = 0x0;

	if(chipid == MT_PORT_BroadCast) {
		for(chip = 0; chip < MAX_CHIPS; chip++)
			port_info[chip].status = MT_OPSTATE_DISABLE;
	}
	else
		port_info[chipid].status = MT_OPSTATE_DISABLE;
#endif	//XENOS

#ifdef HOPE
	mt_uint8 chip;
	volatile mt_uint32 i;

	// Award modem holds only one Falcon chip
	if(chipid > MT_PORT_BroadCast)
		return MT_NO_SUCH_CHIP;

	*(falcon_port+((0x10+chipid)<<BUS_WIDTH_8_SHIFT)) = 0x0;

	for(i=0;i<100000;i++);

	*(falcon_port+((0x20+chipid)<<BUS_WIDTH_8_SHIFT)) = 0x0;

	if(chipid == MT_PORT_BroadCast) {
		for(chip = 0; chip < MAX_CHIPS; chip++)
			port_info[chip].status = MT_OPSTATE_DISABLE;
	}
	else
		port_info[chipid].status = MT_OPSTATE_DISABLE;
#endif	//HOPE

#ifdef BOARD_A5
#ifdef SPI_ACCESS
	mt_uint8 loop;
	mt_uint32 gpio_value;
	volatile mt_uint32 *gpio_addr;
#endif	//SPI_ACCESS

	// Award modem holds only one Falcon chip
	if(chipid > MT_PORT_BroadCast)
		return MT_NO_SUCH_CHIP;

#ifdef SPI_ACCESS
	// force GPIO as input mode to prevent DMT SPI from accessing violation with CPU GPIO signal
	// config selected pin as input
#if defined (ICPLUS_IP3210)
	gpio_addr = (volatile mt_uint32 *)ioremap(0xA300500C, 0x2);
	gpio_value = *gpio_addr;
	gpio_value &= ~(SCKB | SC2B | DMT_SRDB);	//input
#elif defined (RALINK_RT3352)
	gpio_addr = (volatile mt_uint32 *)ioremap(0x10000624, 0x2);
	gpio_value = *gpio_addr;
	gpio_value &= ~(SCKB | SC2B | DMT_SRDB);	//input
#elif defined (ATHEROS_AR93XX)
	gpio_addr = (volatile mt_uint32 *)ioremap(0x18040000, 0x2);
	gpio_value = *gpio_addr;
	gpio_value |= SCKB | SC2B | DMT_SRDB;	//input
#elif defined (REALTEK_RTL8672)
	gpio_addr = (volatile mt_uint32 *)(0xB8003508);
	gpio_value = *gpio_addr;
	gpio_value &= ~(SCKB_PIN | SC2B_PIN | DMT_SRDB_PIN);	//input
#endif	//defined (ICPLUS_IP3210)
	*gpio_addr = gpio_value;
#endif	//SPI_ACCESS

	MT_GPIO_SET(RESET);	// pull high
	MYDELAY(1);
	MT_GPIO_CLR(RESET);	// pull low
	MYDELAY(1);
	MT_GPIO_SET(RESET);	// pull high

	//delay for waiting reset complete
#ifdef SPI_ACCESS
	for(loop=0;loop<5;loop++)	// MT2301 SPI access need to wait about 1.5 seconds for DMT loading firmware, we use 2.5 seconds delay here
		MYDELAY(500);
#else	//HPI_ACCESS
	MYDELAY(500);
#endif	//SPI_ACCESS

#ifdef SPI_ACCESS
	// config selected pin as output
	gpio_value = *gpio_addr;
#if defined (ICPLUS_IP3210)
	gpio_value |= SCKB | SC2B | DMT_SRDB;	//output
#elif defined (RALINK_RT3352)
	gpio_value |= SCKB | SC2B | DMT_SRDB;	//output
#elif defined (ATHEROS_AR93XX)
	gpio_value &= ~(SCKB | SC2B | DMT_SRDB);	//output
#elif defined (REALTEK_RTL8672)
	gpio_value |= SCKB_PIN | SC2B_PIN | DMT_SRDB_PIN;	//output
#endif	//defined (ICPLUS_IP3210)
	*gpio_addr = gpio_value;
#endif	//SPI_ACCESS

	port_info[chipid].status = MT_OPSTATE_DISABLE;
#endif	//BOARD_A5

	return MT_OK;
}


mt_uint32 reset_chip_high(mt_uint32 chipid)
{
#ifdef XENOS
	mt_uint8 chip;

	*(falcon_port+((0x20+chipid)<<BUS_WIDTH_8_SHIFT)) = 0x0;

	if(chipid == MT_PORT_BroadCast) {
		for(chip = 0; chip < MAX_CHIPS; chip++)
			port_info[chip].status = MT_OPSTATE_DISABLE;
	}
	else
		port_info[chipid].status = MT_OPSTATE_DISABLE;
#endif	//XENOS

#ifdef HOPE
	mt_uint8 chip;

	*(falcon_port+((0x20+chipid)<<BUS_WIDTH_8_SHIFT)) = 0x0;

	if(chipid == MT_PORT_BroadCast) {
		for(chip = 0; chip < MAX_CHIPS; chip++)
			port_info[chip].status = MT_OPSTATE_DISABLE;
	}
	else
		port_info[chipid].status = MT_OPSTATE_DISABLE;
#endif	//HOPE

#ifdef BOARD_A5
	// Award modem holds only one Falcon chip
	if(chipid > MT_PORT_BroadCast)
		return MT_NO_SUCH_CHIP;

	MT_GPIO_SET(RESET);

	port_info[chipid].status = MT_OPSTATE_DISABLE;
#endif	//BOARD_A5

	return MT_OK;
}


mt_uint32 reset_chip_low(mt_uint32 chipid)
{
#ifdef XENOS
	mt_uint8 chip;

	*(falcon_port+((0x40+chipid)<<BUS_WIDTH_8_SHIFT)) = 0x0;

	if(chipid == MT_PORT_BroadCast) {
		for(chip = 0; chip < MAX_CHIPS; chip++)
			port_info[chip].status = MT_OPSTATE_DISABLE;
	}
	else
		port_info[chipid].status = MT_OPSTATE_DISABLE;
#endif	//XENOS

#ifdef HOPE
	mt_uint8 chip;

	*(falcon_port+((0x10+chipid)<<BUS_WIDTH_8_SHIFT)) = 0x0;

	if(chipid == MT_PORT_BroadCast) {
		for(chip = 0; chip < MAX_CHIPS; chip++)
			port_info[chip].status = MT_OPSTATE_DISABLE;
	}
	else
		port_info[chipid].status = MT_OPSTATE_DISABLE;
#endif	//HOPE

#ifdef BOARD_A5
	// Award modem holds only one Falcon chip
	if(chipid > MT_PORT_BroadCast)
		return MT_NO_SUCH_CHIP;

	MT_GPIO_CLR(RESET);

	port_info[chipid].status = MT_OPSTATE_DISABLE;
#endif	//BOARD_A5

	return MT_OK;
}


/*set GPIO pins on*/
void MT_GPIO_SET(mt_uint32 gpio_pins)
{
#if defined (RALINK_RT3052) || defined (RALINK_RT3352)
	*databit_set |= gpio_pins;
#elif defined (ICPLUS_IP3210)
	*databit_set = gpio_pins;
#elif defined (ATHEROS_AR93XX)
	*databit_set = gpio_pins;
#elif defined (REALTEK_RTL8672)
	gpioSet(gpio_pins);
#elif defined (STAR_STR9105)
	*databit_set = gpio_pins;
#endif	//defined (RALINK_RT3052) || defined (RALINK_RT3352)
}


/*set GPIO pins off*/
void MT_GPIO_CLR(mt_uint32 gpio_pins)
{
#if defined (RALINK_RT3052) || defined (RALINK_RT3352)
	*databit_clr &= ~(gpio_pins);	// pull low
#elif defined (ICPLUS_IP3210)
	*databit_clr = gpio_pins;
#elif defined (ATHEROS_AR93XX)
	*databit_clr = gpio_pins;
#elif defined (REALTEK_RTL8672)
	gpioClear(gpio_pins);
#elif defined (STAR_STR9105)
	*databit_clr = gpio_pins;
#endif	//defined (RALINK_RT3052) || defined (RALINK_RT3352)
}


#if defined (SPI_ACCESS)
#define _nop_() ({mt_uint32 n; for(n=0;n<1000;n++);})

static mt_uint8 c, r = 0;
static mt_uint16 null_count = 0;
static mt_uint32 fs_delay = 2000;


void null_byte(void)
{
	mt_uint8 i;

	for(i=0;i<8;i++) {
		//Write bit
		MT_GPIO_CLR(DMT_SRDB);

		MT_GPIO_CLR(SCKB);	// Clock low
		_nop_();
		MT_GPIO_SET(SCKB);	// Clock high
		_nop_();
	}
}


void exchange_byte(void)
{
	mt_uint8 i;
	mt_uint32 value;

	for(i=0;i<8;i++) {
		//Write bit
		if( ( c & 0x80 ) == 0 )		// Drive data, MSB first
			MT_GPIO_CLR(DMT_SRDB);
		else
			MT_GPIO_SET(DMT_SRDB);

		MT_GPIO_CLR(SCKB);			// Clock low
		_nop_();

		c <<= 1;
		value = *data_gpio;

		MT_GPIO_SET(SCKB);			// Clock high
		_nop_();

		//Read bit
		r <<= 1;

		//printk("%d ", value);
#if defined (ICPLUS_IP3210) || defined (RALINK_RT3352) || defined (ATHEROS_AR93XX)
		if((value & DMT_STDB) == 0)
#elif defined (REALTEK_RTL8672)
		if((value & DMT_STDB_PIN) == 0)
#endif
		  r &= 0xfe;
		else
		  r |= 0x01;
	}
}


void write_spi_9(mt_uint32 address, mt_uint8 memtype, mt_uint8 *pdata)
{
	mt_uint32 i;

	// First Word
	// one byte in the front
	//Write 0x00
	null_byte();

	//CSLow
	_nop_();
	MT_GPIO_CLR(SC2B);
	for(i=0;i<fs_delay;i++);	// Delay before FS, used in F4

	c = (address & 0x00ff0000) >> 16;
	exchange_byte();
	spibuf[buf_count++] = r;

	c = (address & 0x0000ff00) >> 8;
	exchange_byte();
	spibuf[buf_count++] = r;

	c = 0x02 | memtype;
	exchange_byte();
	spibuf[buf_count++] = r;

	//CSHigh
	_nop_();
	MT_GPIO_SET(SC2B);
	for(i=0;i<fs_delay;i++);	// Delay before FS, used in F4

	//Write 0x00
	null_byte();

	// Second Word
	// one byte in the front
	//Write 0x00
	null_byte();

	//CSLow
	_nop_();
	MT_GPIO_CLR(SC2B);
	for(i=0;i<fs_delay;i++);	// Delay before FS, used in F4

	c = (address & 0x000000ff);
	exchange_byte();
	spibuf[buf_count++] = r;

	c = pdata[2];
	exchange_byte();
	spibuf[buf_count++] = r;

	c = 0x04;
	exchange_byte();
	spibuf[buf_count++] = r;

	//CSHigh
	_nop_();
	MT_GPIO_SET(SC2B);
	for(i=0;i<fs_delay;i++);	// Delay before FS, used in F4

	//Write 0x00
	null_byte();

	// Third Word
	// one byte in the front
	//Write 0x00
	null_byte();

	//CSLow
	_nop_();
	MT_GPIO_CLR(SC2B);
	for(i=0;i<fs_delay;i++);	// Delay before FS, used in F4

	c = pdata[0];
	exchange_byte();
	spibuf[buf_count++] = r;

	c = pdata[1];
	exchange_byte();
	spibuf[buf_count++] = r;

	c = 0x06 | (0<<5); //0000 1100
	exchange_byte();
	spibuf[buf_count++] = r;

	//CSHigh
	_nop_();
	MT_GPIO_SET(SC2B);
	for(i=0;i<fs_delay;i++);	// Delay before FS, used in F4

	//Write 0x00
	null_byte();
}


void read_spi_3(int address, int memtype)
{
	mt_uint32 i;

	// First Word
	// one byte in the front
	//Write 0x00
	null_byte();

	//CSLow
	_nop_();
	MT_GPIO_CLR(SC2B);
	for(i=0;i<fs_delay;i++);	// Delay before FS, used in F4

	c = (address & 0x00ff0000) >> 16;
	exchange_byte();
	spibuf[buf_count++] = r;

	c = (address & 0x0000ff00) >> 8;
	exchange_byte();
	spibuf[buf_count++] = r;

	c = memtype | 0x0A; //0000 1010;
	exchange_byte();
	spibuf[buf_count++] = r;

	//CSHigh
	_nop_();
	MT_GPIO_SET(SC2B);
	for(i=0;i<fs_delay;i++);	// Delay before FS, used in F4

	//Write 0x00
	null_byte();

	// Second Word
	// one byte in the front
	//Write 0x00
	null_byte();

	//CSLow
	_nop_();
	MT_GPIO_CLR(SC2B);
	for(i=0;i<fs_delay;i++);	// Delay before FS, used in F4

	c = (address & 0x000000ff);
	exchange_byte();
	spibuf[buf_count++] = r;

	c = 0x00;
	exchange_byte();
	spibuf[buf_count++] = r;

	c = 0x0C | (0<<5); //0000 1100
	exchange_byte();
	spibuf[buf_count++] = r;

	//CSHigh
	_nop_();
	MT_GPIO_SET(SC2B);
	for(i=0;i<fs_delay;i++);	// Delay before FS, used in F4

	//Write 0x00
	null_byte();
}


void write_spi_null(void)
{
	mt_uint32 i;

	buf_count = 0;

	null_count++;
	// one byte in the front
	//Write 0x00
	null_byte();

	//CSLow
	_nop_();
	MT_GPIO_CLR(SC2B);
	for(i=0;i<fs_delay;i++);	// Delay before FS, used in F4

	c = (char)((null_count >> 8)& 0xFF);
	//c = 0x00;
	exchange_byte();
	spibuf[buf_count++] = r;

	c = (char)(null_count & 0xFF);
	//c = 0x00;
	exchange_byte();
	spibuf[buf_count++] = r;

	c = 0xe0;
	exchange_byte();
	spibuf[buf_count++] = r;

	//CSHigh
	_nop_();
	MT_GPIO_SET(SC2B);
	for(i=0;i<fs_delay;i++);	// Delay before FS, used in F4

	// one byte in the end
	//Write 0x00
	null_byte();
}


void spi_write_byte(mt_uint8 w)
{
	mt_uint8 i;

	for(i=0;i<8;i++) {
		MT_GPIO_CLR(SCKB);			// Clock low

		if( ( w & 0x80 ) == 0 )		// Drive data, MSB first
			MT_GPIO_CLR(SPI_SRDB);
		else
			MT_GPIO_SET(SPI_SRDB);

		w <<= 1;
		_nop_();

		MT_GPIO_SET(SCKB);			// Clock high
	}
}


mt_uint8 spi_read_byte(void)
{
	mt_uint8 i;
	mt_uint32 value;

	for(i=0;i<8;i++) {
		r <<= 1;

		MT_GPIO_CLR(SCKB);		// Clock low
		_nop_();				// Allow SPI slave device to drive data
		MT_GPIO_SET(SCKB);		// Clock high

		value = *data_gpio;		// Acquire data, MSB first
#if defined (ICPLUS_IP3210) || defined (RALINK_RT3352) || defined (ATHEROS_AR93XX)
		if((value & SPI_STDB) == 0)
#elif defined (REALTEK_RTL8672)
		if((value & SPI_STDB_PIN) == 0)
#endif
		  r &= 0xfe;
		else
		  r |= 0x01;
	}

	return (r);
}


mt_uint8 get_spi_status(void)
{
#if defined (REALTEK_RTL8672)
	c = 0;
	MYDELAY(10);
#else
	MT_GPIO_CLR(SC2B);				// Enable SPI CS
	spi_write_byte(SPI_CMD_RDSR);	// Send RDSR command
	c = spi_read_byte();
	MT_GPIO_SET(SC2B);
#endif

	return (c);
}


void spi_write_data(mt_uint32 address, mt_uint16 length, mt_uint8 *pdata)
{
	mt_uint16 i, j = 0;

	while(length) {
		MT_GPIO_CLR(SC2B);					// Enable SPI CS
		spi_write_byte(SPI_CMD_WREN);		// Send WREN, Write enable
		MT_GPIO_SET(SC2B);
		_nop_();

		MT_GPIO_CLR(SC2B);					// Enable SPI CS

		spi_write_byte(SPI_CMD_PP);			// Send Page program command
		spi_write_byte((mt_uint8)((address>>16) & 0x00ff));	// Send adress bit 23-16
		spi_write_byte((mt_uint8)((address>>8) & 0x00ff));	// Send address bit 15-8
		spi_write_byte((mt_uint8)(address & 0x00ff));		// Address bit 7-0

		for(i=0;i<(ONEPAGE - (address & 0x00ff));i++) {
			spi_write_byte(pdata[j++]);
			if(--length == 0) break;
		}

		MT_GPIO_SET(SC2B);

		// Warning, deadlock loop. Need timeout code later
		while((get_spi_status() && 0x01) != 0); 		// Wait write in progress bit

		address &= 0xffffff00;
		address += ONEPAGE;
	}
}


void spi_read_data(mt_uint32 address, mt_uint16 length, mt_uint8 *pdata)
{
	mt_uint16 i;

	MT_GPIO_CLR(SC2B);									// Enable SPI CS

	spi_write_byte(SPI_CMD_READ);						// Send Read Data command
	spi_write_byte((mt_uint8)((address>>16) & 0x00ff));	// Send address bit 23-16
	spi_write_byte((mt_uint8)((address>>8) & 0x00ff));	// Send address bit 15-8
	spi_write_byte((mt_uint8)(address & 0x00ff));		// Address bit 7-0 are always zero

	for(i=0;i<length;i++) {
		pdata[i] = spi_read_byte();
	}

	MT_GPIO_SET(SC2B);
}


mt_uint8 spi_check_data(mt_uint32 address, mt_uint16 length, mt_uint8 *pdata)
{
	mt_uint8 status = MT_OK;
	mt_uint32 i;

	MT_GPIO_CLR(SC2B);									// Enable SPI CS
	spi_write_byte(SPI_CMD_READ);						// Send Read Data program command
	spi_write_byte((mt_uint8)((address>>16) & 0x00ff));	// Send adress bit 23-16
	spi_write_byte((mt_uint8)((address>>8) & 0x00ff)); 	// Send address bit 15-8
	spi_write_byte((mt_uint8)(address & 0x00ff));		// Address bit 7-0 are always zero

	for(i=0;i<length;i++) {
		if(pdata[i] != spi_read_byte()){
			status = DSL_ERR_NOTOK;
			break;
		}
	}

	MT_GPIO_SET(SC2B);

	return status;
}


// Erase one block on the serial EEPROM
mt_uint8 spi_erase_block(mt_uint8 block)
{
	MT_GPIO_CLR(SC2B);						// Enable SPI CS
	spi_write_byte(SPI_CMD_WREN);			// Send WREN, Write enable
	MT_GPIO_SET(SC2B);
	_nop_();

	MT_GPIO_CLR(SC2B);						// Enable SPI CS
	spi_write_byte(SPI_CMD_BE);				// Send CE, Chip erase
	spi_write_byte( block );				// Send adress bit 23-16
	spi_write_byte(0);  					// Send address bit 15-8
	spi_write_byte(0);						// Address bit 7-0 are always zero
	MT_GPIO_SET(SC2B);

	// Warning, deadlock loop. Need timeout code later
	while((get_spi_status() && 0x01) != 0);		// Wait write in progress bit

	return 0;
}


// Erase all blocks on the serial EEPROM
mt_uint8 spi_erase_all(void)
{
	MT_GPIO_CLR(SC2B);						// Enable SPI CS
	spi_write_byte(SPI_CMD_WREN);			// Send WREN, Write enable
	MT_GPIO_SET(SC2B);
	_nop_();

	MT_GPIO_CLR(SC2B);						// Enable SPI CS
	spi_write_byte(SPI_CMD_CE);				// Send CE, Chip erase
	MT_GPIO_SET(SC2B);

	// Warning, deadlock loop. Need timeout code later
	while((get_spi_status() && 0x01) != 0);		// Wait erase in progress bit

	return 0;
}
#else	//HPI_ACCESS
mt_uint8 write_hpi_8(mt_uint8 chipid, mt_uint8 data)
{
	if(chipid > MT_PORT_BroadCast)
		return MT_NO_SUCH_CHIP;

#ifdef __KERNEL__
	//semaphore control
	//down_interruptible(&mr_sem);
	//spin_lock(&mr_lock);
#endif

#if defined (XENOS)
	*(falcon_port+(chipid<<BUS_WIDTH_8_SHIFT)) = data;
#elif defined (HOPE)
	*(falcon_port+(chipid<<BUS_WIDTH_8_SHIFT)) = data;
#elif defined (BOARD_A5)
	*falcon_port = data;
#elif defined (AWARD)
	*(mt_uint8*)(FALCON_PORT) = data;
#endif	//defined (XENOS)

#ifdef __KERNEL__
	//semaphore control
	//up(&mr_sem);
	//spin_unlock(&mr_lock);
#endif

	return MT_OK;
}

mt_uint8 read_hpi_8(mt_uint8 chipid)
{
	mt_uint8 retval;

	if(chipid > MT_PORT_BroadCast)
		return MT_NO_SUCH_CHIP;

#ifdef __KERNEL__
	//semaphore control
	//down_interruptible(&mr_sem);
	//spin_lock(&mr_lock);
#endif

#if defined (XENOS)
	retval = *(falcon_port+(chipid<<BUS_WIDTH_8_SHIFT));
#elif defined (HOPE)
	retval = *(falcon_port+(chipid<<BUS_WIDTH_8_SHIFT));
#elif defined (BOARD_A5)
	retval = *falcon_port;
#elif defined (AWARD)
	retval = *(mt_uint8*)(FALCON_PORT);
#endif	//defined (XENOS)

#ifdef __KERNEL__
	//semaphore control
	//up(&mr_sem);
	//spin_unlock(&mr_lock);
#endif

	return retval;
}
#endif	//defined (SPI_ACCESS)
