#include <linux/module.h>
#include <asm-arm/arch-str9100/hardware.h>
#include <asm-arm/arch-str9100/str9100/star_gpio.h>

#define SMI_EEDI_ACTIVE		GPIO_PIN_DIR = GPIO_PIN_DIR | ((0x1<<17)|(0x1<<15)|(0x1<<14))
#define SMI_EEDI_TRISTATE	((GPIO_PIN_DIR) &= ~(0x1<<17))
#define SMI_EEDI_READ	(GPIO_DATA_IN & (0x1 << 17))?1:0
#define SMI_EEDI(bit)		if(bit) ((GPIO_DATA_SET) |= (0x1<<17)); \
						else    ((GPIO_DATA_CLEAR) |= (0x1<<17))
#define SMI_EESK(bit)		if(bit) ((GPIO_DATA_SET) |= (0x1<<15)); \
						else    ((GPIO_DATA_CLEAR) |= (0x1<<15))
#define SMI_EECS(bit)		if(bit) ((GPIO_DATA_SET) |= (0x1<<14)); \
						else    ((GPIO_DATA_CLEAR) |= (0x1<<14))					
#define SMI_DELAY	{int ii; for (ii=0; ii<1000; ii++); }


//#define PRIND prink 

/**
 * SMI Interface Read
 */
int smi_read(unsigned int addr, unsigned int* data)
{
#if 0
	SMI_EEDI_ACTIVE;

	if (addr==0) {
		SMI_EESK(0);
		printk("SMI_EESK(0)\n");
	} else {
		SMI_EESK(1);
		printk("SMI_EESK(1)\n");
	}
#elif 1
	unsigned int i;
	unsigned int data_read;
	unsigned int buffer;
	//volatile unsigned int* p_gpio_data = (unsigned int*) GPIO_DATA;
	//volatile unsigned int* p_gpio_dir = (unsigned int*) GPIO_DIR;
	//unsigned int ldelay=100; //min=50

	//normal EDI DIR
	//*p_gpio_dir = *p_gpio_dir | SMI_EDI;
	SMI_EEDI_ACTIVE;
	// EECS low
	//*p_gpio_data = *p_gpio_data & (~SMI_EECS);    
	SMI_EECS(0);
	
	// SMI Preamble 32 bit 1	
	for (i=0; i<32; i++) {
		//*p_gpio_data = *p_gpio_data | SMI_EESK;
		SMI_EESK(1);
		SMI_DELAY;	//for(j=0;j<ldelay;j++);						
		//*p_gpio_data = *p_gpio_data & (~SMI_EESK) | SMI_EDI;
		SMI_EEDI(1);
		SMI_EESK(0);
		SMI_DELAY;	//for(j=0;j<ldelay;j++);						
	}

	// SMI read
	// EESK High
	//*p_gpio_data = *p_gpio_data | SMI_EESK;	
	SMI_EESK(1);
	SMI_DELAY;	//for(j=0;j<ldelay;j++);				

	data_read = 0x60000000 | addr << 18;
	for(i=0;i<14;i++)
	{
	// EESK Low
		if( data_read & (1<<(31-i))) // data is 1
		{
			//*p_gpio_data = *p_gpio_data & (~SMI_EESK) | SMI_EDI;
			SMI_EESK(0);
			SMI_EEDI(1);
		}else // data is 0
		{
			//*p_gpio_data = *p_gpio_data & ~(SMI_EESK | SMI_EDI);
			SMI_EESK(0);
			SMI_EEDI(0);
		}
		SMI_DELAY;	//for(j=0;j<ldelay;j++);	
		// EESK High
		//*p_gpio_data = *p_gpio_data | SMI_EESK;
		SMI_EESK(1);
		SMI_DELAY;	//for(j=0;j<ldelay;j++);			
		
	}
	//reverse EDI
	//*p_gpio_dir = *p_gpio_dir & (~SMI_EDI);
	SMI_EEDI_TRISTATE;
	// read data
	buffer=0;
	for (i=0; i<18; i++) {
		//*p_gpio_data = *p_gpio_data & (~SMI_EESK) | SMI_EDI;
		SMI_EESK(0);
		SMI_EEDI(1);		
		SMI_DELAY;	//for(j=0;j<ldelay;j++);	
		//if( *p_gpio_data & SMI_EDI )
		if (SMI_EEDI_READ) {
			buffer |= 1 << (17-i);
		}			
		// EESK High
		//*p_gpio_data = *p_gpio_data | SMI_EESK;
		SMI_EESK(1);
		SMI_DELAY;	//for(j=0;j<ldelay;j++);			
		
	}    

	// one more clock
	//*p_gpio_data = *p_gpio_data & (~SMI_EESK);
	SMI_EESK(0);
	SMI_DELAY;	//for(j=0;j<ldelay;j++);				
	//*p_gpio_data = *p_gpio_data | SMI_EESK;	
	SMI_EESK(1);
	*data = buffer & 0x0000ffff;
	
	//printk("Read Addr=%08x,ReadCmd=%08x,Data=%04x\n",addr,data_read,*data);

	return 0;
#else
	unsigned int loop,i,j,k;
	unsigned int data_read;
	unsigned int buffer;
	volatile unsigned int* p_gpio_data = (unsigned int*) GPIO_DATA;
	volatile unsigned int* p_gpio_dir = (unsigned int*) GPIO_DIR;
	unsigned int ldelay=100; //min=50

	//normal EDI DIR
    *p_gpio_dir = *p_gpio_dir | SMI_EDI;			
	// EECS low
	*p_gpio_data = *p_gpio_data & (~SMI_EECS);    

	// SMI Preamble 32 bit 1	
	for(i=0;i<32;i++)
	{
		*p_gpio_data = *p_gpio_data | SMI_EESK;		
		for(j=0;j<ldelay;j++);						
		*p_gpio_data = *p_gpio_data & (~SMI_EESK) | SMI_EDI;					
		for(j=0;j<ldelay;j++);						
	}

	// SMI read
	// EESK High
	*p_gpio_data = *p_gpio_data | SMI_EESK;	
	for(j=0;j<ldelay;j++);				

	data_read = 0x60000000 | addr << 18;
	for(i=0;i<14;i++)
	{
	// EESK Low
		if( data_read & (1<<(31-i))) // data is 1
		{
			*p_gpio_data = *p_gpio_data & (~SMI_EESK) | SMI_EDI;			
		}else // data is 0
		{
			*p_gpio_data = *p_gpio_data & ~(SMI_EESK | SMI_EDI);

		}
		for(j=0;j<ldelay;j++);	
		// EESK High
		*p_gpio_data = *p_gpio_data | SMI_EESK;
		for(j=0;j<ldelay;j++);			
		
	}
	//reverse EDI
    *p_gpio_dir = *p_gpio_dir & (~SMI_EDI);		
    // read data
    buffer=0;
	for(i=0;i<18;i++)
	{
		*p_gpio_data = *p_gpio_data & (~SMI_EESK) | SMI_EDI;			
		for(j=0;j<ldelay;j++);	
		if( *p_gpio_data & SMI_EDI )
		{
			buffer |= 1 << (17-i);
		}			
		// EESK High
		*p_gpio_data = *p_gpio_data | SMI_EESK;
		for(j=0;j<ldelay;j++);			
		
	}    

	// one more clock
	*p_gpio_data = *p_gpio_data & (~SMI_EESK);				
	for(j=0;j<ldelay;j++);				
	*p_gpio_data = *p_gpio_data | SMI_EESK;	
	
	*data = buffer & 0x0000ffff;
	
	PRINTD("Read Addr=%08x,ReadCmd=%08x,Data=%04x\n",addr,data_read,*data);
#endif	
}


/**
 * SMI Interface Write
 */
int smi_write(unsigned int addr,unsigned short data)
{

#if 0
	SMI_EEDI_ACTIVE;
	if (addr==0) {
		SMI_EEDI(0);
		printk("SMI_EEDI(0)\n");
	} else {
		SMI_EEDI(1);
		printk("SMI_EEDI(1)\n");
	}
#elif 1
	unsigned int i;
	unsigned int data_rw;
	//unsigned int buffer;
	//volatile unsigned int* p_gpio_data = (unsigned int*) GPIO_DATA;
	//volatile unsigned int* p_gpio_dir = (unsigned int*) GPIO_DIR;
	//unsigned int ldelay=100; //min=50

	//normal EDI DIR
	//*p_gpio_dir = *p_gpio_dir | SMI_EDI;
	SMI_EEDI_ACTIVE;
	// EECS low
	//*p_gpio_data = *p_gpio_data & (~SMI_EECS);    
	SMI_EECS(0);
	
	// SMI Preamble 32 bit 1	
	for(i=0;i<32;i++)
	{
		//*p_gpio_data = *p_gpio_data | SMI_EESK;
		SMI_EESK(1);
		SMI_DELAY;	//for(j=0;j<ldelay;j++);						
		//*p_gpio_data = *p_gpio_data & (~SMI_EESK) | SMI_EDI;
		SMI_EESK(0);
		SMI_EEDI(1);
		SMI_DELAY;	//for(j=0;j<ldelay;j++);						
	}

	// SMI read
	// EESK High
	//*p_gpio_data = *p_gpio_data | SMI_EESK;
	SMI_EESK(1);	
	SMI_DELAY;	//for(j=0;j<ldelay;j++);				

	data_rw = 0x50000000 | addr << 18 | data;
	for(i=0;i<32;i++)
	{
	// EESK Low
		if( data_rw & (1<<(31-i))) // data is 1
		{
			//*p_gpio_data = *p_gpio_data & (~SMI_EESK) | SMI_EDI;
			SMI_EESK(0);
			SMI_EEDI(1);
		}else // data is 0
		{
			//*p_gpio_data = *p_gpio_data & ~(SMI_EESK | SMI_EDI);
			SMI_EESK(0);
			SMI_EEDI(0);
		}
		SMI_DELAY;	//for(j=0;j<ldelay;j++);	
		// EESK High
		//*p_gpio_data = *p_gpio_data | SMI_EESK;
		SMI_EESK(1);
		SMI_DELAY;	//for(j=0;j<ldelay;j++);			
		
	}

	// one more clock
	//*p_gpio_data = *p_gpio_data & (~SMI_EESK);
	SMI_EESK(0);
	SMI_DELAY;	//for(j=0;j<ldelay;j++);				
	//*p_gpio_data = *p_gpio_data | SMI_EESK;
	SMI_EESK(1);
	
	//printk("Write Addr=%08x,WriteCmd=%08x,Data=%04x\n",addr,data_rw,data);

	return 0;

#else
	unsigned int loop,i,j,k;
	unsigned int data_rw;
	unsigned int buffer;
	volatile unsigned int* p_gpio_data = (unsigned int*) GPIO_DATA;
	volatile unsigned int* p_gpio_dir = (unsigned int*) GPIO_DIR;
	unsigned int ldelay=100; //min=50

	//normal EDI DIR
    *p_gpio_dir = *p_gpio_dir | SMI_EDI;			
	// EECS low
	*p_gpio_data = *p_gpio_data & (~SMI_EECS);    

	// SMI Preamble 32 bit 1	
	for(i=0;i<32;i++)
	{
		*p_gpio_data = *p_gpio_data | SMI_EESK;		
		for(j=0;j<ldelay;j++);						
		*p_gpio_data = *p_gpio_data & (~SMI_EESK) | SMI_EDI;					
		for(j=0;j<ldelay;j++);						
	}

	// SMI read
	// EESK High
	*p_gpio_data = *p_gpio_data | SMI_EESK;	
	for(j=0;j<ldelay;j++);				

	data_rw = 0x50000000 | addr << 18 | data;
	for(i=0;i<32;i++)
	{
	// EESK Low
		if( data_rw & (1<<(31-i))) // data is 1
		{
			*p_gpio_data = *p_gpio_data & (~SMI_EESK) | SMI_EDI;			
		}else // data is 0
		{
			*p_gpio_data = *p_gpio_data & ~(SMI_EESK | SMI_EDI);			

		}
		for(j=0;j<ldelay;j++);	
		// EESK High
		*p_gpio_data = *p_gpio_data | SMI_EESK;
		for(j=0;j<ldelay;j++);			
		
	}

	// one more clock
	*p_gpio_data = *p_gpio_data & (~SMI_EESK);				
	for(j=0;j<ldelay;j++);				
	*p_gpio_data = *p_gpio_data | SMI_EESK;	
	
	PRINTD("Write Addr=%08x,WriteCmd=%08x,Data=%04x\n",addr,data_rw,data); 	
#endif	
}


EXPORT_SYMBOL(smi_read);
EXPORT_SYMBOL(smi_write);
